{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- @PangoFontsetSimple@ is a implementation of the abstract
-- @PangoFontset@ base class as an array of fonts.
-- 
-- When creating a @PangoFontsetSimple@, you have to provide
-- the array of fonts that make up the fontset.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Pango.Objects.FontsetSimple
    ( 

-- * Exported types
    FontsetSimple(..)                       ,
    IsFontsetSimple                         ,
    toFontsetSimple                         ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [append]("GI.Pango.Objects.FontsetSimple#g:method:append"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [foreach]("GI.Pango.Objects.Fontset#g:method:foreach"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [size]("GI.Pango.Objects.FontsetSimple#g:method:size"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getFont]("GI.Pango.Objects.Fontset#g:method:getFont"), [getMetrics]("GI.Pango.Objects.Fontset#g:method:getMetrics"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveFontsetSimpleMethod              ,
#endif

-- ** append #method:append#

#if defined(ENABLE_OVERLOADING)
    FontsetSimpleAppendMethodInfo           ,
#endif
    fontsetSimpleAppend                     ,


-- ** new #method:new#

    fontsetSimpleNew                        ,


-- ** size #method:size#

#if defined(ENABLE_OVERLOADING)
    FontsetSimpleSizeMethodInfo             ,
#endif
    fontsetSimpleSize                       ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.HarfBuzz.Structs.FeatureT as HarfBuzz.FeatureT
import qualified GI.Pango.Callbacks as Pango.Callbacks
import {-# SOURCE #-} qualified GI.Pango.Enums as Pango.Enums
import {-# SOURCE #-} qualified GI.Pango.Flags as Pango.Flags
import {-# SOURCE #-} qualified GI.Pango.Objects.Context as Pango.Context
import {-# SOURCE #-} qualified GI.Pango.Objects.Coverage as Pango.Coverage
import {-# SOURCE #-} qualified GI.Pango.Objects.Font as Pango.Font
import {-# SOURCE #-} qualified GI.Pango.Objects.FontFace as Pango.FontFace
import {-# SOURCE #-} qualified GI.Pango.Objects.FontFamily as Pango.FontFamily
import {-# SOURCE #-} qualified GI.Pango.Objects.FontMap as Pango.FontMap
import {-# SOURCE #-} qualified GI.Pango.Objects.Fontset as Pango.Fontset
import {-# SOURCE #-} qualified GI.Pango.Structs.FontDescription as Pango.FontDescription
import {-# SOURCE #-} qualified GI.Pango.Structs.FontMetrics as Pango.FontMetrics
import {-# SOURCE #-} qualified GI.Pango.Structs.Language as Pango.Language
import {-# SOURCE #-} qualified GI.Pango.Structs.Matrix as Pango.Matrix
import {-# SOURCE #-} qualified GI.Pango.Structs.Rectangle as Pango.Rectangle

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Pango.Objects.Font as Pango.Font
import {-# SOURCE #-} qualified GI.Pango.Objects.Fontset as Pango.Fontset
import {-# SOURCE #-} qualified GI.Pango.Structs.Language as Pango.Language

#endif

-- | Memory-managed wrapper type.
newtype FontsetSimple = FontsetSimple (SP.ManagedPtr FontsetSimple)
    deriving (Eq)

instance SP.ManagedPtrNewtype FontsetSimple where
    toManagedPtr (FontsetSimple p) = p

foreign import ccall "pango_fontset_simple_get_type"
    c_pango_fontset_simple_get_type :: IO B.Types.GType

instance B.Types.TypedObject FontsetSimple where
    glibType = c_pango_fontset_simple_get_type

instance B.Types.GObject FontsetSimple

-- | Type class for types which can be safely cast to t'FontsetSimple', for instance with `toFontsetSimple`.
class (SP.GObject o, O.IsDescendantOf FontsetSimple o) => IsFontsetSimple o
instance (SP.GObject o, O.IsDescendantOf FontsetSimple o) => IsFontsetSimple o

instance O.HasParentTypes FontsetSimple
type instance O.ParentTypes FontsetSimple = '[Pango.Fontset.Fontset, GObject.Object.Object]

-- | Cast to t'FontsetSimple', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toFontsetSimple :: (MIO.MonadIO m, IsFontsetSimple o) => o -> m FontsetSimple
toFontsetSimple = MIO.liftIO . B.ManagedPtr.unsafeCastTo FontsetSimple

-- | Convert t'FontsetSimple' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe FontsetSimple) where
    gvalueGType_ = c_pango_fontset_simple_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr FontsetSimple)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr FontsetSimple)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject FontsetSimple ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveFontsetSimpleMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveFontsetSimpleMethod "append" o = FontsetSimpleAppendMethodInfo
    ResolveFontsetSimpleMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveFontsetSimpleMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveFontsetSimpleMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveFontsetSimpleMethod "foreach" o = Pango.Fontset.FontsetForeachMethodInfo
    ResolveFontsetSimpleMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveFontsetSimpleMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveFontsetSimpleMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveFontsetSimpleMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveFontsetSimpleMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveFontsetSimpleMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveFontsetSimpleMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveFontsetSimpleMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveFontsetSimpleMethod "size" o = FontsetSimpleSizeMethodInfo
    ResolveFontsetSimpleMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveFontsetSimpleMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveFontsetSimpleMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveFontsetSimpleMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveFontsetSimpleMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveFontsetSimpleMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveFontsetSimpleMethod "getFont" o = Pango.Fontset.FontsetGetFontMethodInfo
    ResolveFontsetSimpleMethod "getMetrics" o = Pango.Fontset.FontsetGetMetricsMethodInfo
    ResolveFontsetSimpleMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveFontsetSimpleMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveFontsetSimpleMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveFontsetSimpleMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveFontsetSimpleMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveFontsetSimpleMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveFontsetSimpleMethod t FontsetSimple, O.OverloadedMethod info FontsetSimple p) => OL.IsLabel t (FontsetSimple -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveFontsetSimpleMethod t FontsetSimple, O.OverloadedMethod info FontsetSimple p, R.HasField t FontsetSimple p) => R.HasField t FontsetSimple p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveFontsetSimpleMethod t FontsetSimple, O.OverloadedMethodInfo info FontsetSimple) => OL.IsLabel t (O.MethodProxy info FontsetSimple) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList FontsetSimple
type instance O.AttributeList FontsetSimple = FontsetSimpleAttributeList
type FontsetSimpleAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList FontsetSimple = FontsetSimpleSignalList
type FontsetSimpleSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method FontsetSimple::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "language"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Language" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoLanguage` tag"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Pango" , name = "FontsetSimple" })
-- throws : False
-- Skip return : False

foreign import ccall "pango_fontset_simple_new" pango_fontset_simple_new :: 
    Ptr Pango.Language.Language ->          -- language : TInterface (Name {namespace = "Pango", name = "Language"})
    IO (Ptr FontsetSimple)

-- | Creates a new @PangoFontsetSimple@ for the given language.
fontsetSimpleNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Pango.Language.Language
    -- ^ /@language@/: a @PangoLanguage@ tag
    -> m FontsetSimple
    -- ^ __Returns:__ the newly allocated @PangoFontsetSimple@
fontsetSimpleNew language = liftIO $ do
    language' <- unsafeManagedPtrGetPtr language
    result <- pango_fontset_simple_new language'
    checkUnexpectedReturnNULL "fontsetSimpleNew" result
    result' <- (wrapObject FontsetSimple) result
    touchManagedPtr language
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method FontsetSimple::append
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "fontset"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "FontsetSimple" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoFontsetSimple`."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "font"
--           , argType = TInterface Name { namespace = "Pango" , name = "Font" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoFont`." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "pango_fontset_simple_append" pango_fontset_simple_append :: 
    Ptr FontsetSimple ->                    -- fontset : TInterface (Name {namespace = "Pango", name = "FontsetSimple"})
    Ptr Pango.Font.Font ->                  -- font : TInterface (Name {namespace = "Pango", name = "Font"})
    IO ()

-- | Adds a font to the fontset.
-- 
-- The fontset takes ownership of /@font@/.
fontsetSimpleAppend ::
    (B.CallStack.HasCallStack, MonadIO m, IsFontsetSimple a, Pango.Font.IsFont b) =>
    a
    -- ^ /@fontset@/: a @PangoFontsetSimple@.
    -> b
    -- ^ /@font@/: a @PangoFont@.
    -> m ()
fontsetSimpleAppend fontset font = liftIO $ do
    fontset' <- unsafeManagedPtrCastPtr fontset
    font' <- B.ManagedPtr.disownObject font
    pango_fontset_simple_append fontset' font'
    touchManagedPtr fontset
    touchManagedPtr font
    return ()

#if defined(ENABLE_OVERLOADING)
data FontsetSimpleAppendMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, IsFontsetSimple a, Pango.Font.IsFont b) => O.OverloadedMethod FontsetSimpleAppendMethodInfo a signature where
    overloadedMethod = fontsetSimpleAppend

instance O.OverloadedMethodInfo FontsetSimpleAppendMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Objects.FontsetSimple.fontsetSimpleAppend",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Objects-FontsetSimple.html#v:fontsetSimpleAppend"
        })


#endif

-- method FontsetSimple::size
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "fontset"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "FontsetSimple" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoFontsetSimple`."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "pango_fontset_simple_size" pango_fontset_simple_size :: 
    Ptr FontsetSimple ->                    -- fontset : TInterface (Name {namespace = "Pango", name = "FontsetSimple"})
    IO Int32

-- | Returns the number of fonts in the fontset.
fontsetSimpleSize ::
    (B.CallStack.HasCallStack, MonadIO m, IsFontsetSimple a) =>
    a
    -- ^ /@fontset@/: a @PangoFontsetSimple@.
    -> m Int32
    -- ^ __Returns:__ the size of /@fontset@/
fontsetSimpleSize fontset = liftIO $ do
    fontset' <- unsafeManagedPtrCastPtr fontset
    result <- pango_fontset_simple_size fontset'
    touchManagedPtr fontset
    return result

#if defined(ENABLE_OVERLOADING)
data FontsetSimpleSizeMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsFontsetSimple a) => O.OverloadedMethod FontsetSimpleSizeMethodInfo a signature where
    overloadedMethod = fontsetSimpleSize

instance O.OverloadedMethodInfo FontsetSimpleSizeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Objects.FontsetSimple.fontsetSimpleSize",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Objects-FontsetSimple.html#v:fontsetSimpleSize"
        })


#endif


