{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A @PangoFontFamily@ is used to represent a family of related
-- font faces.
-- 
-- The font faces in a family share a common design, but differ in
-- slant, weight, width or other aspects.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Pango.Objects.FontFamily
    ( 

-- * Exported types
    FontFamily(..)                          ,
    IsFontFamily                            ,
    toFontFamily                            ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isMonospace]("GI.Pango.Objects.FontFamily#g:method:isMonospace"), [isVariable]("GI.Pango.Objects.FontFamily#g:method:isVariable"), [itemsChanged]("GI.Gio.Interfaces.ListModel#g:method:itemsChanged"), [listFaces]("GI.Pango.Objects.FontFamily#g:method:listFaces"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getFace]("GI.Pango.Objects.FontFamily#g:method:getFace"), [getItem]("GI.Gio.Interfaces.ListModel#g:method:getItem"), [getItemType]("GI.Gio.Interfaces.ListModel#g:method:getItemType"), [getNItems]("GI.Gio.Interfaces.ListModel#g:method:getNItems"), [getName]("GI.Pango.Objects.FontFamily#g:method:getName"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveFontFamilyMethod                 ,
#endif

-- ** getFace #method:getFace#

#if defined(ENABLE_OVERLOADING)
    FontFamilyGetFaceMethodInfo             ,
#endif
    fontFamilyGetFace                       ,


-- ** getName #method:getName#

#if defined(ENABLE_OVERLOADING)
    FontFamilyGetNameMethodInfo             ,
#endif
    fontFamilyGetName                       ,


-- ** isMonospace #method:isMonospace#

#if defined(ENABLE_OVERLOADING)
    FontFamilyIsMonospaceMethodInfo         ,
#endif
    fontFamilyIsMonospace                   ,


-- ** isVariable #method:isVariable#

#if defined(ENABLE_OVERLOADING)
    FontFamilyIsVariableMethodInfo          ,
#endif
    fontFamilyIsVariable                    ,


-- ** listFaces #method:listFaces#

#if defined(ENABLE_OVERLOADING)
    FontFamilyListFacesMethodInfo           ,
#endif
    fontFamilyListFaces                     ,




 -- * Properties


-- ** isMonospace #attr:isMonospace#
-- | Is this a monospace font
-- 
-- /Since: 1.52/

#if defined(ENABLE_OVERLOADING)
    FontFamilyIsMonospacePropertyInfo       ,
#endif
    getFontFamilyIsMonospace                ,


-- ** isVariable #attr:isVariable#
-- | Is this a variable font
-- 
-- /Since: 1.52/

#if defined(ENABLE_OVERLOADING)
    FontFamilyIsVariablePropertyInfo        ,
#endif
    getFontFamilyIsVariable                 ,


-- ** itemType #attr:itemType#
-- | The type of items contained in this list.
-- 
-- /Since: 1.52/

#if defined(ENABLE_OVERLOADING)
    FontFamilyItemTypePropertyInfo          ,
#endif
#if defined(ENABLE_OVERLOADING)
    fontFamilyItemType                      ,
#endif
    getFontFamilyItemType                   ,


-- ** nItems #attr:nItems#
-- | The number of items contained in this list.
-- 
-- /Since: 1.52/

#if defined(ENABLE_OVERLOADING)
    FontFamilyNItemsPropertyInfo            ,
#endif
#if defined(ENABLE_OVERLOADING)
    fontFamilyNItems                        ,
#endif
    getFontFamilyNItems                     ,


-- ** name #attr:name#
-- | The name of the family
-- 
-- /Since: 1.52/

#if defined(ENABLE_OVERLOADING)
    FontFamilyNamePropertyInfo              ,
#endif
#if defined(ENABLE_OVERLOADING)
    fontFamilyName                          ,
#endif
    getFontFamilyName                       ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import {-# SOURCE #-} qualified GI.Pango.Enums as Pango.Enums
import {-# SOURCE #-} qualified GI.Pango.Flags as Pango.Flags
import {-# SOURCE #-} qualified GI.Pango.Objects.FontFace as Pango.FontFace
import {-# SOURCE #-} qualified GI.Pango.Structs.FontDescription as Pango.FontDescription

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import {-# SOURCE #-} qualified GI.Pango.Objects.FontFace as Pango.FontFace

#endif

-- | Memory-managed wrapper type.
newtype FontFamily = FontFamily (SP.ManagedPtr FontFamily)
    deriving (Eq)

instance SP.ManagedPtrNewtype FontFamily where
    toManagedPtr (FontFamily p) = p

foreign import ccall "pango_font_family_get_type"
    c_pango_font_family_get_type :: IO B.Types.GType

instance B.Types.TypedObject FontFamily where
    glibType = c_pango_font_family_get_type

instance B.Types.GObject FontFamily

-- | Type class for types which can be safely cast to t'FontFamily', for instance with `toFontFamily`.
class (SP.GObject o, O.IsDescendantOf FontFamily o) => IsFontFamily o
instance (SP.GObject o, O.IsDescendantOf FontFamily o) => IsFontFamily o

instance O.HasParentTypes FontFamily
type instance O.ParentTypes FontFamily = '[GObject.Object.Object, Gio.ListModel.ListModel]

-- | Cast to t'FontFamily', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toFontFamily :: (MIO.MonadIO m, IsFontFamily o) => o -> m FontFamily
toFontFamily = MIO.liftIO . B.ManagedPtr.unsafeCastTo FontFamily

-- | Convert t'FontFamily' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe FontFamily) where
    gvalueGType_ = c_pango_font_family_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr FontFamily)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr FontFamily)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject FontFamily ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveFontFamilyMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveFontFamilyMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveFontFamilyMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveFontFamilyMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveFontFamilyMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveFontFamilyMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveFontFamilyMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveFontFamilyMethod "isMonospace" o = FontFamilyIsMonospaceMethodInfo
    ResolveFontFamilyMethod "isVariable" o = FontFamilyIsVariableMethodInfo
    ResolveFontFamilyMethod "itemsChanged" o = Gio.ListModel.ListModelItemsChangedMethodInfo
    ResolveFontFamilyMethod "listFaces" o = FontFamilyListFacesMethodInfo
    ResolveFontFamilyMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveFontFamilyMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveFontFamilyMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveFontFamilyMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveFontFamilyMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveFontFamilyMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveFontFamilyMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveFontFamilyMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveFontFamilyMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveFontFamilyMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveFontFamilyMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveFontFamilyMethod "getFace" o = FontFamilyGetFaceMethodInfo
    ResolveFontFamilyMethod "getItem" o = Gio.ListModel.ListModelGetItemMethodInfo
    ResolveFontFamilyMethod "getItemType" o = Gio.ListModel.ListModelGetItemTypeMethodInfo
    ResolveFontFamilyMethod "getNItems" o = Gio.ListModel.ListModelGetNItemsMethodInfo
    ResolveFontFamilyMethod "getName" o = FontFamilyGetNameMethodInfo
    ResolveFontFamilyMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveFontFamilyMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveFontFamilyMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveFontFamilyMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveFontFamilyMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveFontFamilyMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveFontFamilyMethod t FontFamily, O.OverloadedMethod info FontFamily p) => OL.IsLabel t (FontFamily -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveFontFamilyMethod t FontFamily, O.OverloadedMethod info FontFamily p, R.HasField t FontFamily p) => R.HasField t FontFamily p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveFontFamilyMethod t FontFamily, O.OverloadedMethodInfo info FontFamily) => OL.IsLabel t (O.MethodProxy info FontFamily) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "is-monospace"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@is-monospace@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' fontFamily #isMonospace
-- @
getFontFamilyIsMonospace :: (MonadIO m, IsFontFamily o) => o -> m Bool
getFontFamilyIsMonospace obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "is-monospace"

#if defined(ENABLE_OVERLOADING)
data FontFamilyIsMonospacePropertyInfo
instance AttrInfo FontFamilyIsMonospacePropertyInfo where
    type AttrAllowedOps FontFamilyIsMonospacePropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint FontFamilyIsMonospacePropertyInfo = IsFontFamily
    type AttrSetTypeConstraint FontFamilyIsMonospacePropertyInfo = (~) ()
    type AttrTransferTypeConstraint FontFamilyIsMonospacePropertyInfo = (~) ()
    type AttrTransferType FontFamilyIsMonospacePropertyInfo = ()
    type AttrGetType FontFamilyIsMonospacePropertyInfo = Bool
    type AttrLabel FontFamilyIsMonospacePropertyInfo = "is-monospace"
    type AttrOrigin FontFamilyIsMonospacePropertyInfo = FontFamily
    attrGet = getFontFamilyIsMonospace
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Objects.FontFamily.isMonospace"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Objects-FontFamily.html#g:attr:isMonospace"
        })
#endif

-- VVV Prop "is-variable"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@is-variable@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' fontFamily #isVariable
-- @
getFontFamilyIsVariable :: (MonadIO m, IsFontFamily o) => o -> m Bool
getFontFamilyIsVariable obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "is-variable"

#if defined(ENABLE_OVERLOADING)
data FontFamilyIsVariablePropertyInfo
instance AttrInfo FontFamilyIsVariablePropertyInfo where
    type AttrAllowedOps FontFamilyIsVariablePropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint FontFamilyIsVariablePropertyInfo = IsFontFamily
    type AttrSetTypeConstraint FontFamilyIsVariablePropertyInfo = (~) ()
    type AttrTransferTypeConstraint FontFamilyIsVariablePropertyInfo = (~) ()
    type AttrTransferType FontFamilyIsVariablePropertyInfo = ()
    type AttrGetType FontFamilyIsVariablePropertyInfo = Bool
    type AttrLabel FontFamilyIsVariablePropertyInfo = "is-variable"
    type AttrOrigin FontFamilyIsVariablePropertyInfo = FontFamily
    attrGet = getFontFamilyIsVariable
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Objects.FontFamily.isVariable"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Objects-FontFamily.html#g:attr:isVariable"
        })
#endif

-- VVV Prop "item-type"
   -- Type: TBasicType TGType
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@item-type@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' fontFamily #itemType
-- @
getFontFamilyItemType :: (MonadIO m, IsFontFamily o) => o -> m GType
getFontFamilyItemType obj = MIO.liftIO $ B.Properties.getObjectPropertyGType obj "item-type"

#if defined(ENABLE_OVERLOADING)
data FontFamilyItemTypePropertyInfo
instance AttrInfo FontFamilyItemTypePropertyInfo where
    type AttrAllowedOps FontFamilyItemTypePropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint FontFamilyItemTypePropertyInfo = IsFontFamily
    type AttrSetTypeConstraint FontFamilyItemTypePropertyInfo = (~) ()
    type AttrTransferTypeConstraint FontFamilyItemTypePropertyInfo = (~) ()
    type AttrTransferType FontFamilyItemTypePropertyInfo = ()
    type AttrGetType FontFamilyItemTypePropertyInfo = GType
    type AttrLabel FontFamilyItemTypePropertyInfo = "item-type"
    type AttrOrigin FontFamilyItemTypePropertyInfo = FontFamily
    attrGet = getFontFamilyItemType
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Objects.FontFamily.itemType"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Objects-FontFamily.html#g:attr:itemType"
        })
#endif

-- VVV Prop "n-items"
   -- Type: TBasicType TUInt
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@n-items@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' fontFamily #nItems
-- @
getFontFamilyNItems :: (MonadIO m, IsFontFamily o) => o -> m Word32
getFontFamilyNItems obj = MIO.liftIO $ B.Properties.getObjectPropertyUInt32 obj "n-items"

#if defined(ENABLE_OVERLOADING)
data FontFamilyNItemsPropertyInfo
instance AttrInfo FontFamilyNItemsPropertyInfo where
    type AttrAllowedOps FontFamilyNItemsPropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint FontFamilyNItemsPropertyInfo = IsFontFamily
    type AttrSetTypeConstraint FontFamilyNItemsPropertyInfo = (~) ()
    type AttrTransferTypeConstraint FontFamilyNItemsPropertyInfo = (~) ()
    type AttrTransferType FontFamilyNItemsPropertyInfo = ()
    type AttrGetType FontFamilyNItemsPropertyInfo = Word32
    type AttrLabel FontFamilyNItemsPropertyInfo = "n-items"
    type AttrOrigin FontFamilyNItemsPropertyInfo = FontFamily
    attrGet = getFontFamilyNItems
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Objects.FontFamily.nItems"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Objects-FontFamily.html#g:attr:nItems"
        })
#endif

-- VVV Prop "name"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@name@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' fontFamily #name
-- @
getFontFamilyName :: (MonadIO m, IsFontFamily o) => o -> m T.Text
getFontFamilyName obj = MIO.liftIO $ checkUnexpectedNothing "getFontFamilyName" $ B.Properties.getObjectPropertyString obj "name"

#if defined(ENABLE_OVERLOADING)
data FontFamilyNamePropertyInfo
instance AttrInfo FontFamilyNamePropertyInfo where
    type AttrAllowedOps FontFamilyNamePropertyInfo = '[ 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint FontFamilyNamePropertyInfo = IsFontFamily
    type AttrSetTypeConstraint FontFamilyNamePropertyInfo = (~) ()
    type AttrTransferTypeConstraint FontFamilyNamePropertyInfo = (~) ()
    type AttrTransferType FontFamilyNamePropertyInfo = ()
    type AttrGetType FontFamilyNamePropertyInfo = T.Text
    type AttrLabel FontFamilyNamePropertyInfo = "name"
    type AttrOrigin FontFamilyNamePropertyInfo = FontFamily
    attrGet = getFontFamilyName
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Objects.FontFamily.name"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Objects-FontFamily.html#g:attr:name"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList FontFamily
type instance O.AttributeList FontFamily = FontFamilyAttributeList
type FontFamilyAttributeList = ('[ '("isMonospace", FontFamilyIsMonospacePropertyInfo), '("isVariable", FontFamilyIsVariablePropertyInfo), '("itemType", FontFamilyItemTypePropertyInfo), '("nItems", FontFamilyNItemsPropertyInfo), '("name", FontFamilyNamePropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
fontFamilyItemType :: AttrLabelProxy "itemType"
fontFamilyItemType = AttrLabelProxy

fontFamilyNItems :: AttrLabelProxy "nItems"
fontFamilyNItems = AttrLabelProxy

fontFamilyName :: AttrLabelProxy "name"
fontFamilyName = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList FontFamily = FontFamilySignalList
type FontFamilySignalList = ('[ '("itemsChanged", Gio.ListModel.ListModelItemsChangedSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method FontFamily::get_face
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "family"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "FontFamily" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoFontFamily`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the name of a face. If the name is %NULL,\n  the family's default face (fontconfig calls it \"Regular\")\n  will be returned."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Pango" , name = "FontFace" })
-- throws : False
-- Skip return : False

foreign import ccall "pango_font_family_get_face" pango_font_family_get_face :: 
    Ptr FontFamily ->                       -- family : TInterface (Name {namespace = "Pango", name = "FontFamily"})
    CString ->                              -- name : TBasicType TUTF8
    IO (Ptr Pango.FontFace.FontFace)

-- | Gets the @PangoFontFace@ of /@family@/ with the given name.
-- 
-- /Since: 1.46/
fontFamilyGetFace ::
    (B.CallStack.HasCallStack, MonadIO m, IsFontFamily a) =>
    a
    -- ^ /@family@/: a @PangoFontFamily@
    -> Maybe (T.Text)
    -- ^ /@name@/: the name of a face. If the name is 'P.Nothing',
    --   the family\'s default face (fontconfig calls it \"Regular\")
    --   will be returned.
    -> m (Maybe Pango.FontFace.FontFace)
    -- ^ __Returns:__ the @PangoFontFace@,
    --   or 'P.Nothing' if no face with the given name exists.
fontFamilyGetFace family name = liftIO $ do
    family' <- unsafeManagedPtrCastPtr family
    maybeName <- case name of
        Nothing -> return FP.nullPtr
        Just jName -> do
            jName' <- textToCString jName
            return jName'
    result <- pango_font_family_get_face family' maybeName
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Pango.FontFace.FontFace) result'
        return result''
    touchManagedPtr family
    freeMem maybeName
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data FontFamilyGetFaceMethodInfo
instance (signature ~ (Maybe (T.Text) -> m (Maybe Pango.FontFace.FontFace)), MonadIO m, IsFontFamily a) => O.OverloadedMethod FontFamilyGetFaceMethodInfo a signature where
    overloadedMethod = fontFamilyGetFace

instance O.OverloadedMethodInfo FontFamilyGetFaceMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Objects.FontFamily.fontFamilyGetFace",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Objects-FontFamily.html#v:fontFamilyGetFace"
        })


#endif

-- method FontFamily::get_name
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "family"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "FontFamily" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoFontFamily`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "pango_font_family_get_name" pango_font_family_get_name :: 
    Ptr FontFamily ->                       -- family : TInterface (Name {namespace = "Pango", name = "FontFamily"})
    IO CString

-- | Gets the name of the family.
-- 
-- The name is unique among all fonts for the font backend and can
-- be used in a @PangoFontDescription@ to specify that a face from
-- this family is desired.
fontFamilyGetName ::
    (B.CallStack.HasCallStack, MonadIO m, IsFontFamily a) =>
    a
    -- ^ /@family@/: a @PangoFontFamily@
    -> m T.Text
    -- ^ __Returns:__ the name of the family. This string is owned
    --   by the family object and must not be modified or freed.
fontFamilyGetName family = liftIO $ do
    family' <- unsafeManagedPtrCastPtr family
    result <- pango_font_family_get_name family'
    checkUnexpectedReturnNULL "fontFamilyGetName" result
    result' <- cstringToText result
    touchManagedPtr family
    return result'

#if defined(ENABLE_OVERLOADING)
data FontFamilyGetNameMethodInfo
instance (signature ~ (m T.Text), MonadIO m, IsFontFamily a) => O.OverloadedMethod FontFamilyGetNameMethodInfo a signature where
    overloadedMethod = fontFamilyGetName

instance O.OverloadedMethodInfo FontFamilyGetNameMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Objects.FontFamily.fontFamilyGetName",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Objects-FontFamily.html#v:fontFamilyGetName"
        })


#endif

-- method FontFamily::is_monospace
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "family"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "FontFamily" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoFontFamily`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "pango_font_family_is_monospace" pango_font_family_is_monospace :: 
    Ptr FontFamily ->                       -- family : TInterface (Name {namespace = "Pango", name = "FontFamily"})
    IO CInt

-- | A monospace font is a font designed for text display where the the
-- characters form a regular grid.
-- 
-- For Western languages this would
-- mean that the advance width of all characters are the same, but
-- this categorization also includes Asian fonts which include
-- double-width characters: characters that occupy two grid cells.
-- 'GI.GLib.Functions.unicharIswide' returns a result that indicates whether a
-- character is typically double-width in a monospace font.
-- 
-- The best way to find out the grid-cell size is to call
-- 'GI.Pango.Structs.FontMetrics.fontMetricsGetApproximateDigitWidth', since the
-- results of 'GI.Pango.Structs.FontMetrics.fontMetricsGetApproximateCharWidth' may
-- be affected by double-width characters.
-- 
-- /Since: 1.4/
fontFamilyIsMonospace ::
    (B.CallStack.HasCallStack, MonadIO m, IsFontFamily a) =>
    a
    -- ^ /@family@/: a @PangoFontFamily@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the family is monospace.
fontFamilyIsMonospace family = liftIO $ do
    family' <- unsafeManagedPtrCastPtr family
    result <- pango_font_family_is_monospace family'
    let result' = (/= 0) result
    touchManagedPtr family
    return result'

#if defined(ENABLE_OVERLOADING)
data FontFamilyIsMonospaceMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsFontFamily a) => O.OverloadedMethod FontFamilyIsMonospaceMethodInfo a signature where
    overloadedMethod = fontFamilyIsMonospace

instance O.OverloadedMethodInfo FontFamilyIsMonospaceMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Objects.FontFamily.fontFamilyIsMonospace",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Objects-FontFamily.html#v:fontFamilyIsMonospace"
        })


#endif

-- method FontFamily::is_variable
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "family"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "FontFamily" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoFontFamily`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "pango_font_family_is_variable" pango_font_family_is_variable :: 
    Ptr FontFamily ->                       -- family : TInterface (Name {namespace = "Pango", name = "FontFamily"})
    IO CInt

-- | A variable font is a font which has axes that can be modified to
-- produce different faces.
-- 
-- Such axes are also known as _variations_; see
-- 'GI.Pango.Structs.FontDescription.fontDescriptionSetVariations' for more information.
-- 
-- /Since: 1.44/
fontFamilyIsVariable ::
    (B.CallStack.HasCallStack, MonadIO m, IsFontFamily a) =>
    a
    -- ^ /@family@/: a @PangoFontFamily@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the family is variable
fontFamilyIsVariable family = liftIO $ do
    family' <- unsafeManagedPtrCastPtr family
    result <- pango_font_family_is_variable family'
    let result' = (/= 0) result
    touchManagedPtr family
    return result'

#if defined(ENABLE_OVERLOADING)
data FontFamilyIsVariableMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsFontFamily a) => O.OverloadedMethod FontFamilyIsVariableMethodInfo a signature where
    overloadedMethod = fontFamilyIsVariable

instance O.OverloadedMethodInfo FontFamilyIsVariableMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Objects.FontFamily.fontFamilyIsVariable",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Objects-FontFamily.html#v:fontFamilyIsVariable"
        })


#endif

-- method FontFamily::list_faces
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "family"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "FontFamily" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoFontFamily`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "faces"
--           , argType =
--               TCArray
--                 False
--                 (-1)
--                 2
--                 (TInterface Name { namespace = "Pango" , name = "FontFace" })
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "\n  location to store an array of pointers to `PangoFontFace` objects,\n  or %NULL. This array should be freed with g_free() when it is no\n  longer needed."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferContainer
--           }
--       , Arg
--           { argCName = "n_faces"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "location to store number of elements in @faces."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "n_faces"
--              , argType = TBasicType TInt
--              , direction = DirectionOut
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText =
--                        Just "location to store number of elements in @faces."
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferEverything
--              }
--          ]
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "pango_font_family_list_faces" pango_font_family_list_faces :: 
    Ptr FontFamily ->                       -- family : TInterface (Name {namespace = "Pango", name = "FontFamily"})
    Ptr (Ptr (Ptr Pango.FontFace.FontFace)) -> -- faces : TCArray False (-1) 2 (TInterface (Name {namespace = "Pango", name = "FontFace"}))
    Ptr Int32 ->                            -- n_faces : TBasicType TInt
    IO ()

-- | Lists the different font faces that make up /@family@/.
-- 
-- The faces in a family share a common design, but differ in slant, weight,
-- width and other aspects.
-- 
-- Note that the returned faces are not in any particular order, and
-- multiple faces may have the same name or characteristics.
-- 
-- @PangoFontFamily@ also implemented the t'GI.Gio.Interfaces.ListModel.ListModel' interface
-- for enumerating faces.
fontFamilyListFaces ::
    (B.CallStack.HasCallStack, MonadIO m, IsFontFamily a) =>
    a
    -- ^ /@family@/: a @PangoFontFamily@
    -> m ([Pango.FontFace.FontFace])
fontFamilyListFaces family = liftIO $ do
    family' <- unsafeManagedPtrCastPtr family
    faces <- callocMem :: IO (Ptr (Ptr (Ptr Pango.FontFace.FontFace)))
    nFaces <- allocMem :: IO (Ptr Int32)
    pango_font_family_list_faces family' faces nFaces
    nFaces' <- peek nFaces
    faces' <- peek faces
    faces'' <- (unpackPtrArrayWithLength nFaces') faces'
    faces''' <- mapM (newObject Pango.FontFace.FontFace) faces''
    freeMem faces'
    touchManagedPtr family
    freeMem faces
    freeMem nFaces
    return faces'''

#if defined(ENABLE_OVERLOADING)
data FontFamilyListFacesMethodInfo
instance (signature ~ (m ([Pango.FontFace.FontFace])), MonadIO m, IsFontFamily a) => O.OverloadedMethod FontFamilyListFacesMethodInfo a signature where
    overloadedMethod = fontFamilyListFaces

instance O.OverloadedMethodInfo FontFamilyListFacesMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Objects.FontFamily.fontFamilyListFaces",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Objects-FontFamily.html#v:fontFamilyListFaces"
        })


#endif


