{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A GHashTableIter structure represents an iterator that can be used
-- to iterate over the elements of a t'GI.GLib.Structs.HashTable.HashTable'. GHashTableIter
-- structures are typically allocated on the stack and then initialized
-- with 'GI.GLib.Structs.HashTableIter.hashTableIterInit'.
-- 
-- The iteration order of a t'GI.GLib.Structs.HashTableIter.HashTableIter' over the keys\/values in a hash
-- table is not defined.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GLib.Structs.HashTableIter
    ( 

-- * Exported types
    HashTableIter(..)                       ,
    newZeroHashTableIter                    ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [init]("GI.GLib.Structs.HashTableIter#g:method:init"), [next]("GI.GLib.Structs.HashTableIter#g:method:next"), [remove]("GI.GLib.Structs.HashTableIter#g:method:remove"), [replace]("GI.GLib.Structs.HashTableIter#g:method:replace"), [steal]("GI.GLib.Structs.HashTableIter#g:method:steal").
-- 
-- ==== Getters
-- [getHashTable]("GI.GLib.Structs.HashTableIter#g:method:getHashTable").
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolveHashTableIterMethod              ,
#endif

-- ** getHashTable #method:getHashTable#

#if defined(ENABLE_OVERLOADING)
    HashTableIterGetHashTableMethodInfo     ,
#endif
    hashTableIterGetHashTable               ,


-- ** init #method:init#

#if defined(ENABLE_OVERLOADING)
    HashTableIterInitMethodInfo             ,
#endif
    hashTableIterInit                       ,


-- ** next #method:next#

#if defined(ENABLE_OVERLOADING)
    HashTableIterNextMethodInfo             ,
#endif
    hashTableIterNext                       ,


-- ** remove #method:remove#

#if defined(ENABLE_OVERLOADING)
    HashTableIterRemoveMethodInfo           ,
#endif
    hashTableIterRemove                     ,


-- ** replace #method:replace#

#if defined(ENABLE_OVERLOADING)
    HashTableIterReplaceMethodInfo          ,
#endif
    hashTableIterReplace                    ,


-- ** steal #method:steal#

#if defined(ENABLE_OVERLOADING)
    HashTableIterStealMethodInfo            ,
#endif
    hashTableIterSteal                      ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- | Memory-managed wrapper type.
newtype HashTableIter = HashTableIter (SP.ManagedPtr HashTableIter)
    deriving (Eq)

instance SP.ManagedPtrNewtype HashTableIter where
    toManagedPtr (HashTableIter p) = p

instance BoxedPtr HashTableIter where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 40 >=> B.ManagedPtr.wrapPtr HashTableIter)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr HashTableIter where
    boxedPtrCalloc = callocBytes 40


-- | Construct a t'HashTableIter' struct initialized to zero.
newZeroHashTableIter :: MonadIO m => m HashTableIter
newZeroHashTableIter = liftIO $ boxedPtrCalloc >>= wrapPtr HashTableIter

instance tag ~ 'AttrSet => Constructible HashTableIter tag where
    new _ attrs = do
        o <- newZeroHashTableIter
        GI.Attributes.set o attrs
        return o



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList HashTableIter
type instance O.AttributeList HashTableIter = HashTableIterAttributeList
type HashTableIterAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

-- method HashTableIter::get_hash_table
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "iter"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "HashTableIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an initialized #GHashTableIter"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TGHash (TBasicType TPtr) (TBasicType TPtr))
-- throws : False
-- Skip return : False

foreign import ccall "g_hash_table_iter_get_hash_table" g_hash_table_iter_get_hash_table :: 
    Ptr HashTableIter ->                    -- iter : TInterface (Name {namespace = "GLib", name = "HashTableIter"})
    IO (Ptr (GHashTable (Ptr ()) (Ptr ())))

-- | Returns the t'GI.GLib.Structs.HashTable.HashTable' associated with /@iter@/.
-- 
-- /Since: 2.16/
hashTableIterGetHashTable ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    HashTableIter
    -- ^ /@iter@/: an initialized t'GI.GLib.Structs.HashTableIter.HashTableIter'
    -> m (Map.Map (Ptr ()) (Ptr ()))
    -- ^ __Returns:__ the t'GI.GLib.Structs.HashTable.HashTable' associated with /@iter@/.
hashTableIterGetHashTable iter = liftIO $ do
    iter' <- unsafeManagedPtrGetPtr iter
    result <- g_hash_table_iter_get_hash_table iter'
    checkUnexpectedReturnNULL "hashTableIterGetHashTable" result
    result' <- unpackGHashTable result
    let result'' = mapFirst B.GHT.ptrUnpackPtr result'
    let result''' = mapSecond B.GHT.ptrUnpackPtr result''
    let result'''' = Map.fromList result'''
    touchManagedPtr iter
    return result''''

#if defined(ENABLE_OVERLOADING)
data HashTableIterGetHashTableMethodInfo
instance (signature ~ (m (Map.Map (Ptr ()) (Ptr ()))), MonadIO m) => O.OverloadedMethod HashTableIterGetHashTableMethodInfo HashTableIter signature where
    overloadedMethod = hashTableIterGetHashTable

instance O.OverloadedMethodInfo HashTableIterGetHashTableMethodInfo HashTableIter where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.HashTableIter.hashTableIterGetHashTable",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-HashTableIter.html#v:hashTableIterGetHashTable"
        })


#endif

-- method HashTableIter::init
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "iter"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "HashTableIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an uninitialized #GHashTableIter"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "hash_table"
--           , argType = TGHash (TBasicType TPtr) (TBasicType TPtr)
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GHashTable" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_hash_table_iter_init" g_hash_table_iter_init :: 
    Ptr HashTableIter ->                    -- iter : TInterface (Name {namespace = "GLib", name = "HashTableIter"})
    Ptr (GHashTable (Ptr ()) (Ptr ())) ->   -- hash_table : TGHash (TBasicType TPtr) (TBasicType TPtr)
    IO ()

-- | Initializes a key\/value pair iterator and associates it with
-- /@hashTable@/. Modifying the hash table after calling this function
-- invalidates the returned iterator.
-- 
-- The iteration order of a t'GI.GLib.Structs.HashTableIter.HashTableIter' over the keys\/values in a hash
-- table is not defined.
-- 
-- 
-- === /C code/
-- >
-- >GHashTableIter iter;
-- >gpointer key, value;
-- >
-- >g_hash_table_iter_init (&iter, hash_table);
-- >while (g_hash_table_iter_next (&iter, &key, &value))
-- >  {
-- >    // do something with key and value
-- >  }
-- 
-- 
-- /Since: 2.16/
hashTableIterInit ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    HashTableIter
    -- ^ /@iter@/: an uninitialized t'GI.GLib.Structs.HashTableIter.HashTableIter'
    -> Map.Map (Ptr ()) (Ptr ())
    -- ^ /@hashTable@/: a t'GI.GLib.Structs.HashTable.HashTable'
    -> m ()
hashTableIterInit iter hashTable = liftIO $ do
    iter' <- unsafeManagedPtrGetPtr iter
    let hashTable' = Map.toList hashTable
    let hashTable'' = mapFirst B.GHT.ptrPackPtr hashTable'
    let hashTable''' = mapSecond B.GHT.ptrPackPtr hashTable''
    hashTable'''' <- packGHashTable gDirectHash gDirectEqual Nothing Nothing hashTable'''
    g_hash_table_iter_init iter' hashTable''''
    touchManagedPtr iter
    unrefGHashTable hashTable''''
    return ()

#if defined(ENABLE_OVERLOADING)
data HashTableIterInitMethodInfo
instance (signature ~ (Map.Map (Ptr ()) (Ptr ()) -> m ()), MonadIO m) => O.OverloadedMethod HashTableIterInitMethodInfo HashTableIter signature where
    overloadedMethod = hashTableIterInit

instance O.OverloadedMethodInfo HashTableIterInitMethodInfo HashTableIter where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.HashTableIter.hashTableIterInit",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-HashTableIter.html#v:hashTableIterInit"
        })


#endif

-- method HashTableIter::next
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "iter"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "HashTableIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an initialized #GHashTableIter"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "key"
--           , argType = TBasicType TPtr
--           , direction = DirectionOut
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a location to store the key"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "value"
--           , argType = TBasicType TPtr
--           , direction = DirectionOut
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a location to store the value"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_hash_table_iter_next" g_hash_table_iter_next :: 
    Ptr HashTableIter ->                    -- iter : TInterface (Name {namespace = "GLib", name = "HashTableIter"})
    Ptr (Ptr ()) ->                         -- key : TBasicType TPtr
    Ptr (Ptr ()) ->                         -- value : TBasicType TPtr
    IO CInt

-- | Advances /@iter@/ and retrieves the key and\/or value that are now
-- pointed to as a result of this advancement. If 'P.False' is returned,
-- /@key@/ and /@value@/ are not set, and the iterator becomes invalid.
-- 
-- /Since: 2.16/
hashTableIterNext ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    HashTableIter
    -- ^ /@iter@/: an initialized t'GI.GLib.Structs.HashTableIter.HashTableIter'
    -> m ((Bool, Ptr (), Ptr ()))
    -- ^ __Returns:__ 'P.False' if the end of the t'GI.GLib.Structs.HashTable.HashTable' has been reached.
hashTableIterNext iter = liftIO $ do
    iter' <- unsafeManagedPtrGetPtr iter
    key <- callocMem :: IO (Ptr (Ptr ()))
    value <- callocMem :: IO (Ptr (Ptr ()))
    result <- g_hash_table_iter_next iter' key value
    let result' = (/= 0) result
    key' <- peek key
    value' <- peek value
    touchManagedPtr iter
    freeMem key
    freeMem value
    return (result', key', value')

#if defined(ENABLE_OVERLOADING)
data HashTableIterNextMethodInfo
instance (signature ~ (m ((Bool, Ptr (), Ptr ()))), MonadIO m) => O.OverloadedMethod HashTableIterNextMethodInfo HashTableIter signature where
    overloadedMethod = hashTableIterNext

instance O.OverloadedMethodInfo HashTableIterNextMethodInfo HashTableIter where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.HashTableIter.hashTableIterNext",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-HashTableIter.html#v:hashTableIterNext"
        })


#endif

-- method HashTableIter::remove
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "iter"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "HashTableIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an initialized #GHashTableIter"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_hash_table_iter_remove" g_hash_table_iter_remove :: 
    Ptr HashTableIter ->                    -- iter : TInterface (Name {namespace = "GLib", name = "HashTableIter"})
    IO ()

-- | Removes the key\/value pair currently pointed to by the iterator
-- from its associated t'GI.GLib.Structs.HashTable.HashTable'. Can only be called after
-- 'GI.GLib.Structs.HashTableIter.hashTableIterNext' returned 'P.True', and cannot be called
-- more than once for the same key\/value pair.
-- 
-- If the t'GI.GLib.Structs.HashTable.HashTable' was created using @/g_hash_table_new_full()/@,
-- the key and value are freed using the supplied destroy functions,
-- otherwise you have to make sure that any dynamically allocated
-- values are freed yourself.
-- 
-- It is safe to continue iterating the t'GI.GLib.Structs.HashTable.HashTable' afterward:
-- 
-- === /C code/
-- >
-- >while (g_hash_table_iter_next (&iter, &key, &value))
-- >  {
-- >    if (condition)
-- >      g_hash_table_iter_remove (&iter);
-- >  }
-- 
-- 
-- /Since: 2.16/
hashTableIterRemove ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    HashTableIter
    -- ^ /@iter@/: an initialized t'GI.GLib.Structs.HashTableIter.HashTableIter'
    -> m ()
hashTableIterRemove iter = liftIO $ do
    iter' <- unsafeManagedPtrGetPtr iter
    g_hash_table_iter_remove iter'
    touchManagedPtr iter
    return ()

#if defined(ENABLE_OVERLOADING)
data HashTableIterRemoveMethodInfo
instance (signature ~ (m ()), MonadIO m) => O.OverloadedMethod HashTableIterRemoveMethodInfo HashTableIter signature where
    overloadedMethod = hashTableIterRemove

instance O.OverloadedMethodInfo HashTableIterRemoveMethodInfo HashTableIter where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.HashTableIter.hashTableIterRemove",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-HashTableIter.html#v:hashTableIterRemove"
        })


#endif

-- method HashTableIter::replace
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "iter"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "HashTableIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an initialized #GHashTableIter"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "value"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the value to replace with"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_hash_table_iter_replace" g_hash_table_iter_replace :: 
    Ptr HashTableIter ->                    -- iter : TInterface (Name {namespace = "GLib", name = "HashTableIter"})
    Ptr () ->                               -- value : TBasicType TPtr
    IO ()

-- | Replaces the value currently pointed to by the iterator
-- from its associated t'GI.GLib.Structs.HashTable.HashTable'. Can only be called after
-- 'GI.GLib.Structs.HashTableIter.hashTableIterNext' returned 'P.True'.
-- 
-- If you supplied a /@valueDestroyFunc@/ when creating the
-- t'GI.GLib.Structs.HashTable.HashTable', the old value is freed using that function.
-- 
-- /Since: 2.30/
hashTableIterReplace ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    HashTableIter
    -- ^ /@iter@/: an initialized t'GI.GLib.Structs.HashTableIter.HashTableIter'
    -> Ptr ()
    -- ^ /@value@/: the value to replace with
    -> m ()
hashTableIterReplace iter value = liftIO $ do
    iter' <- unsafeManagedPtrGetPtr iter
    g_hash_table_iter_replace iter' value
    touchManagedPtr iter
    return ()

#if defined(ENABLE_OVERLOADING)
data HashTableIterReplaceMethodInfo
instance (signature ~ (Ptr () -> m ()), MonadIO m) => O.OverloadedMethod HashTableIterReplaceMethodInfo HashTableIter signature where
    overloadedMethod = hashTableIterReplace

instance O.OverloadedMethodInfo HashTableIterReplaceMethodInfo HashTableIter where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.HashTableIter.hashTableIterReplace",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-HashTableIter.html#v:hashTableIterReplace"
        })


#endif

-- method HashTableIter::steal
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "iter"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "HashTableIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an initialized #GHashTableIter"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_hash_table_iter_steal" g_hash_table_iter_steal :: 
    Ptr HashTableIter ->                    -- iter : TInterface (Name {namespace = "GLib", name = "HashTableIter"})
    IO ()

-- | Removes the key\/value pair currently pointed to by the
-- iterator from its associated t'GI.GLib.Structs.HashTable.HashTable', without calling
-- the key and value destroy functions. Can only be called
-- after 'GI.GLib.Structs.HashTableIter.hashTableIterNext' returned 'P.True', and cannot
-- be called more than once for the same key\/value pair.
-- 
-- /Since: 2.16/
hashTableIterSteal ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    HashTableIter
    -- ^ /@iter@/: an initialized t'GI.GLib.Structs.HashTableIter.HashTableIter'
    -> m ()
hashTableIterSteal iter = liftIO $ do
    iter' <- unsafeManagedPtrGetPtr iter
    g_hash_table_iter_steal iter'
    touchManagedPtr iter
    return ()

#if defined(ENABLE_OVERLOADING)
data HashTableIterStealMethodInfo
instance (signature ~ (m ()), MonadIO m) => O.OverloadedMethod HashTableIterStealMethodInfo HashTableIter signature where
    overloadedMethod = hashTableIterSteal

instance O.OverloadedMethodInfo HashTableIterStealMethodInfo HashTableIter where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.HashTableIter.hashTableIterSteal",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-HashTableIter.html#v:hashTableIterSteal"
        })


#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveHashTableIterMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveHashTableIterMethod "init" o = HashTableIterInitMethodInfo
    ResolveHashTableIterMethod "next" o = HashTableIterNextMethodInfo
    ResolveHashTableIterMethod "remove" o = HashTableIterRemoveMethodInfo
    ResolveHashTableIterMethod "replace" o = HashTableIterReplaceMethodInfo
    ResolveHashTableIterMethod "steal" o = HashTableIterStealMethodInfo
    ResolveHashTableIterMethod "getHashTable" o = HashTableIterGetHashTableMethodInfo
    ResolveHashTableIterMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveHashTableIterMethod t HashTableIter, O.OverloadedMethod info HashTableIter p) => OL.IsLabel t (HashTableIter -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveHashTableIterMethod t HashTableIter, O.OverloadedMethod info HashTableIter p, R.HasField t HashTableIter p) => R.HasField t HashTableIter p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveHashTableIterMethod t HashTableIter, O.OverloadedMethodInfo info HashTableIter) => OL.IsLabel t (O.MethodProxy info HashTableIter) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


