{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- @GZlibDecompressor@ is an implementation of t'GI.Gio.Interfaces.Converter.Converter' that
-- decompresses data compressed with zlib.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Objects.ZlibDecompressor
    ( 

-- * Exported types
    ZlibDecompressor(..)                    ,
    IsZlibDecompressor                      ,
    toZlibDecompressor                      ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [convert]("GI.Gio.Interfaces.Converter#g:method:convert"), [convertBytes]("GI.Gio.Interfaces.Converter#g:method:convertBytes"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [reset]("GI.Gio.Interfaces.Converter#g:method:reset"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getFileInfo]("GI.Gio.Objects.ZlibDecompressor#g:method:getFileInfo"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveZlibDecompressorMethod           ,
#endif

-- ** getFileInfo #method:getFileInfo#

#if defined(ENABLE_OVERLOADING)
    ZlibDecompressorGetFileInfoMethodInfo   ,
#endif
    zlibDecompressorGetFileInfo             ,


-- ** new #method:new#

    zlibDecompressorNew                     ,




 -- * Properties


-- ** fileInfo #attr:fileInfo#
-- | A t'GI.Gio.Objects.FileInfo.FileInfo' containing the information found in the gzip header
-- of the data stream processed.
-- 
-- This will be @NULL@ if the header was not yet fully processed, is not
-- present at all, or the compressor’s [ZlibDecompressor:format]("GI.Gio.Objects.ZlibDecompressor#g:attr:format")
-- property is not 'GI.Gio.Enums.ZlibCompressorFormatGzip'.
-- 
-- /Since: 2.26/

#if defined(ENABLE_OVERLOADING)
    ZlibDecompressorFileInfoPropertyInfo    ,
#endif
    getZlibDecompressorFileInfo             ,
#if defined(ENABLE_OVERLOADING)
    zlibDecompressorFileInfo                ,
#endif


-- ** format #attr:format#
-- | The format of the compressed data.
-- 
-- /Since: 2.24/

#if defined(ENABLE_OVERLOADING)
    ZlibDecompressorFormatPropertyInfo      ,
#endif
    constructZlibDecompressorFormat         ,
    getZlibDecompressorFormat               ,
#if defined(ENABLE_OVERLOADING)
    zlibDecompressorFormat                  ,
#endif




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GLib.Structs.DateTime as GLib.DateTime
import qualified GI.GLib.Structs.TimeVal as GLib.TimeVal
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gio.Enums as Gio.Enums
import {-# SOURCE #-} qualified GI.Gio.Flags as Gio.Flags
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Converter as Gio.Converter
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Icon as Gio.Icon
import {-# SOURCE #-} qualified GI.Gio.Objects.FileInfo as Gio.FileInfo
import {-# SOURCE #-} qualified GI.Gio.Structs.FileAttributeMatcher as Gio.FileAttributeMatcher

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gio.Enums as Gio.Enums
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Converter as Gio.Converter
import {-# SOURCE #-} qualified GI.Gio.Objects.FileInfo as Gio.FileInfo

#endif

-- | Memory-managed wrapper type.
newtype ZlibDecompressor = ZlibDecompressor (SP.ManagedPtr ZlibDecompressor)
    deriving (Eq)

instance SP.ManagedPtrNewtype ZlibDecompressor where
    toManagedPtr (ZlibDecompressor p) = p

foreign import ccall "g_zlib_decompressor_get_type"
    c_g_zlib_decompressor_get_type :: IO B.Types.GType

instance B.Types.TypedObject ZlibDecompressor where
    glibType = c_g_zlib_decompressor_get_type

instance B.Types.GObject ZlibDecompressor

-- | Type class for types which can be safely cast to t'ZlibDecompressor', for instance with `toZlibDecompressor`.
class (SP.GObject o, O.IsDescendantOf ZlibDecompressor o) => IsZlibDecompressor o
instance (SP.GObject o, O.IsDescendantOf ZlibDecompressor o) => IsZlibDecompressor o

instance O.HasParentTypes ZlibDecompressor
type instance O.ParentTypes ZlibDecompressor = '[GObject.Object.Object, Gio.Converter.Converter]

-- | Cast to t'ZlibDecompressor', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toZlibDecompressor :: (MIO.MonadIO m, IsZlibDecompressor o) => o -> m ZlibDecompressor
toZlibDecompressor = MIO.liftIO . B.ManagedPtr.unsafeCastTo ZlibDecompressor

-- | Convert t'ZlibDecompressor' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe ZlibDecompressor) where
    gvalueGType_ = c_g_zlib_decompressor_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr ZlibDecompressor)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr ZlibDecompressor)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject ZlibDecompressor ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveZlibDecompressorMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveZlibDecompressorMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveZlibDecompressorMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveZlibDecompressorMethod "convert" o = Gio.Converter.ConverterConvertMethodInfo
    ResolveZlibDecompressorMethod "convertBytes" o = Gio.Converter.ConverterConvertBytesMethodInfo
    ResolveZlibDecompressorMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveZlibDecompressorMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveZlibDecompressorMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveZlibDecompressorMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveZlibDecompressorMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveZlibDecompressorMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveZlibDecompressorMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveZlibDecompressorMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveZlibDecompressorMethod "reset" o = Gio.Converter.ConverterResetMethodInfo
    ResolveZlibDecompressorMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveZlibDecompressorMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveZlibDecompressorMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveZlibDecompressorMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveZlibDecompressorMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveZlibDecompressorMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveZlibDecompressorMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveZlibDecompressorMethod "getFileInfo" o = ZlibDecompressorGetFileInfoMethodInfo
    ResolveZlibDecompressorMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveZlibDecompressorMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveZlibDecompressorMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveZlibDecompressorMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveZlibDecompressorMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveZlibDecompressorMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveZlibDecompressorMethod t ZlibDecompressor, O.OverloadedMethod info ZlibDecompressor p) => OL.IsLabel t (ZlibDecompressor -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveZlibDecompressorMethod t ZlibDecompressor, O.OverloadedMethod info ZlibDecompressor p, R.HasField t ZlibDecompressor p) => R.HasField t ZlibDecompressor p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveZlibDecompressorMethod t ZlibDecompressor, O.OverloadedMethodInfo info ZlibDecompressor) => OL.IsLabel t (O.MethodProxy info ZlibDecompressor) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "file-info"
   -- Type: TInterface (Name {namespace = "Gio", name = "FileInfo"})
   -- Flags: [PropertyReadable]
   -- Nullable: (Just True,Nothing)

-- | Get the value of the “@file-info@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' zlibDecompressor #fileInfo
-- @
getZlibDecompressorFileInfo :: (MonadIO m, IsZlibDecompressor o) => o -> m (Maybe Gio.FileInfo.FileInfo)
getZlibDecompressorFileInfo obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "file-info" Gio.FileInfo.FileInfo

#if defined(ENABLE_OVERLOADING)
data ZlibDecompressorFileInfoPropertyInfo
instance AttrInfo ZlibDecompressorFileInfoPropertyInfo where
    type AttrAllowedOps ZlibDecompressorFileInfoPropertyInfo = '[ 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint ZlibDecompressorFileInfoPropertyInfo = IsZlibDecompressor
    type AttrSetTypeConstraint ZlibDecompressorFileInfoPropertyInfo = (~) ()
    type AttrTransferTypeConstraint ZlibDecompressorFileInfoPropertyInfo = (~) ()
    type AttrTransferType ZlibDecompressorFileInfoPropertyInfo = ()
    type AttrGetType ZlibDecompressorFileInfoPropertyInfo = (Maybe Gio.FileInfo.FileInfo)
    type AttrLabel ZlibDecompressorFileInfoPropertyInfo = "file-info"
    type AttrOrigin ZlibDecompressorFileInfoPropertyInfo = ZlibDecompressor
    attrGet = getZlibDecompressorFileInfo
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.ZlibDecompressor.fileInfo"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-ZlibDecompressor.html#g:attr:fileInfo"
        })
#endif

-- VVV Prop "format"
   -- Type: TInterface (Name {namespace = "Gio", name = "ZlibCompressorFormat"})
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@format@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' zlibDecompressor #format
-- @
getZlibDecompressorFormat :: (MonadIO m, IsZlibDecompressor o) => o -> m Gio.Enums.ZlibCompressorFormat
getZlibDecompressorFormat obj = MIO.liftIO $ B.Properties.getObjectPropertyEnum obj "format"

-- | Construct a t'GValueConstruct' with valid value for the “@format@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructZlibDecompressorFormat :: (IsZlibDecompressor o, MIO.MonadIO m) => Gio.Enums.ZlibCompressorFormat -> m (GValueConstruct o)
constructZlibDecompressorFormat val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyEnum "format" val

#if defined(ENABLE_OVERLOADING)
data ZlibDecompressorFormatPropertyInfo
instance AttrInfo ZlibDecompressorFormatPropertyInfo where
    type AttrAllowedOps ZlibDecompressorFormatPropertyInfo = '[ 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint ZlibDecompressorFormatPropertyInfo = IsZlibDecompressor
    type AttrSetTypeConstraint ZlibDecompressorFormatPropertyInfo = (~) Gio.Enums.ZlibCompressorFormat
    type AttrTransferTypeConstraint ZlibDecompressorFormatPropertyInfo = (~) Gio.Enums.ZlibCompressorFormat
    type AttrTransferType ZlibDecompressorFormatPropertyInfo = Gio.Enums.ZlibCompressorFormat
    type AttrGetType ZlibDecompressorFormatPropertyInfo = Gio.Enums.ZlibCompressorFormat
    type AttrLabel ZlibDecompressorFormatPropertyInfo = "format"
    type AttrOrigin ZlibDecompressorFormatPropertyInfo = ZlibDecompressor
    attrGet = getZlibDecompressorFormat
    attrSet = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructZlibDecompressorFormat
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.ZlibDecompressor.format"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-ZlibDecompressor.html#g:attr:format"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList ZlibDecompressor
type instance O.AttributeList ZlibDecompressor = ZlibDecompressorAttributeList
type ZlibDecompressorAttributeList = ('[ '("fileInfo", ZlibDecompressorFileInfoPropertyInfo), '("format", ZlibDecompressorFormatPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
zlibDecompressorFileInfo :: AttrLabelProxy "fileInfo"
zlibDecompressorFileInfo = AttrLabelProxy

zlibDecompressorFormat :: AttrLabelProxy "format"
zlibDecompressorFormat = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList ZlibDecompressor = ZlibDecompressorSignalList
type ZlibDecompressorSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method ZlibDecompressor::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "format"
--           , argType =
--               TInterface
--                 Name { namespace = "Gio" , name = "ZlibCompressorFormat" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the format to use for the compressed data"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gio" , name = "ZlibDecompressor" })
-- throws : False
-- Skip return : False

foreign import ccall "g_zlib_decompressor_new" g_zlib_decompressor_new :: 
    CUInt ->                                -- format : TInterface (Name {namespace = "Gio", name = "ZlibCompressorFormat"})
    IO (Ptr ZlibDecompressor)

-- | Creates a new decompressor.
-- 
-- /Since: 2.24/
zlibDecompressorNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Gio.Enums.ZlibCompressorFormat
    -- ^ /@format@/: the format to use for the compressed data
    -> m ZlibDecompressor
    -- ^ __Returns:__ a new t'GI.Gio.Objects.ZlibDecompressor.ZlibDecompressor'
zlibDecompressorNew format = liftIO $ do
    let format' = (fromIntegral . fromEnum) format
    result <- g_zlib_decompressor_new format'
    checkUnexpectedReturnNULL "zlibDecompressorNew" result
    result' <- (wrapObject ZlibDecompressor) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method ZlibDecompressor::get_file_info
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "decompressor"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "ZlibDecompressor" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GZlibDecompressor"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "FileInfo" })
-- throws : False
-- Skip return : False

foreign import ccall "g_zlib_decompressor_get_file_info" g_zlib_decompressor_get_file_info :: 
    Ptr ZlibDecompressor ->                 -- decompressor : TInterface (Name {namespace = "Gio", name = "ZlibDecompressor"})
    IO (Ptr Gio.FileInfo.FileInfo)

-- | Gets the [ZlibDecompressor:fileInfo]("GI.Gio.Objects.ZlibDecompressor#g:attr:fileInfo") property.
-- 
-- /Since: 2.26/
zlibDecompressorGetFileInfo ::
    (B.CallStack.HasCallStack, MonadIO m, IsZlibDecompressor a) =>
    a
    -- ^ /@decompressor@/: a t'GI.Gio.Objects.ZlibDecompressor.ZlibDecompressor'
    -> m (Maybe Gio.FileInfo.FileInfo)
    -- ^ __Returns:__ file info from the gzip header, if available
zlibDecompressorGetFileInfo decompressor = liftIO $ do
    decompressor' <- unsafeManagedPtrCastPtr decompressor
    result <- g_zlib_decompressor_get_file_info decompressor'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gio.FileInfo.FileInfo) result'
        return result''
    touchManagedPtr decompressor
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data ZlibDecompressorGetFileInfoMethodInfo
instance (signature ~ (m (Maybe Gio.FileInfo.FileInfo)), MonadIO m, IsZlibDecompressor a) => O.OverloadedMethod ZlibDecompressorGetFileInfoMethodInfo a signature where
    overloadedMethod = zlibDecompressorGetFileInfo

instance O.OverloadedMethodInfo ZlibDecompressorGetFileInfoMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.ZlibDecompressor.zlibDecompressorGetFileInfo",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-ZlibDecompressor.html#v:zlibDecompressorGetFileInfo"
        })


#endif


