{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- An IPv4 or IPv6 socket address. That is, the combination of a
-- t'GI.Gio.Objects.InetAddress.InetAddress' and a port number.
-- 
-- In UNIX terms, @GInetSocketAddress@ corresponds to a
-- <http://developer.gnome.org/gio/stable/man:sockaddr(3type `struct sockaddr_in` or `struct sockaddr_in6`>).

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Objects.InetSocketAddress
    ( 

-- * Exported types
    InetSocketAddress(..)                   ,
    IsInetSocketAddress                     ,
    toInetSocketAddress                     ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [enumerate]("GI.Gio.Interfaces.SocketConnectable#g:method:enumerate"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [proxyEnumerate]("GI.Gio.Interfaces.SocketConnectable#g:method:proxyEnumerate"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [toNative]("GI.Gio.Objects.SocketAddress#g:method:toNative"), [toString]("GI.Gio.Interfaces.SocketConnectable#g:method:toString"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAddress]("GI.Gio.Objects.InetSocketAddress#g:method:getAddress"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getFamily]("GI.Gio.Objects.SocketAddress#g:method:getFamily"), [getFlowinfo]("GI.Gio.Objects.InetSocketAddress#g:method:getFlowinfo"), [getNativeSize]("GI.Gio.Objects.SocketAddress#g:method:getNativeSize"), [getPort]("GI.Gio.Objects.InetSocketAddress#g:method:getPort"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getScopeId]("GI.Gio.Objects.InetSocketAddress#g:method:getScopeId").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveInetSocketAddressMethod          ,
#endif

-- ** getAddress #method:getAddress#

#if defined(ENABLE_OVERLOADING)
    InetSocketAddressGetAddressMethodInfo   ,
#endif
    inetSocketAddressGetAddress             ,


-- ** getFlowinfo #method:getFlowinfo#

#if defined(ENABLE_OVERLOADING)
    InetSocketAddressGetFlowinfoMethodInfo  ,
#endif
    inetSocketAddressGetFlowinfo            ,


-- ** getPort #method:getPort#

#if defined(ENABLE_OVERLOADING)
    InetSocketAddressGetPortMethodInfo      ,
#endif
    inetSocketAddressGetPort                ,


-- ** getScopeId #method:getScopeId#

#if defined(ENABLE_OVERLOADING)
    InetSocketAddressGetScopeIdMethodInfo   ,
#endif
    inetSocketAddressGetScopeId             ,


-- ** new #method:new#

    inetSocketAddressNew                    ,


-- ** newFromString #method:newFromString#

    inetSocketAddressNewFromString          ,




 -- * Properties


-- ** address #attr:address#
-- | The address.
-- 
-- /Since: 2.22/

#if defined(ENABLE_OVERLOADING)
    InetSocketAddressAddressPropertyInfo    ,
#endif
    constructInetSocketAddressAddress       ,
    getInetSocketAddressAddress             ,
#if defined(ENABLE_OVERLOADING)
    inetSocketAddressAddress                ,
#endif


-- ** flowinfo #attr:flowinfo#
-- | The @sin6_flowinfo@ field, for IPv6 addresses.
-- 
-- If unset this property is inherited from [InetSocketAddress:address]("GI.Gio.Objects.InetSocketAddress#g:attr:address").
-- 
-- /Since: 2.32/

#if defined(ENABLE_OVERLOADING)
    InetSocketAddressFlowinfoPropertyInfo   ,
#endif
    constructInetSocketAddressFlowinfo      ,
    getInetSocketAddressFlowinfo            ,
#if defined(ENABLE_OVERLOADING)
    inetSocketAddressFlowinfo               ,
#endif


-- ** port #attr:port#
-- | The port.
-- 
-- /Since: 2.22/

#if defined(ENABLE_OVERLOADING)
    InetSocketAddressPortPropertyInfo       ,
#endif
    constructInetSocketAddressPort          ,
    getInetSocketAddressPort                ,
#if defined(ENABLE_OVERLOADING)
    inetSocketAddressPort                   ,
#endif


-- ** scopeId #attr:scopeId#
-- | The @sin6_scope_id@ field, for IPv6 addresses.
-- 
-- If unset this property is inherited from [InetSocketAddress:address]("GI.Gio.Objects.InetSocketAddress#g:attr:address").
-- 
-- /Since: 2.32/

#if defined(ENABLE_OVERLOADING)
    InetSocketAddressScopeIdPropertyInfo    ,
#endif
    constructInetSocketAddressScopeId       ,
    getInetSocketAddressScopeId             ,
#if defined(ENABLE_OVERLOADING)
    inetSocketAddressScopeId                ,
#endif




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.PollFD as GLib.PollFD
import qualified GI.GLib.Structs.Source as GLib.Source
import qualified GI.GObject.Callbacks as GObject.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Callbacks as Gio.Callbacks
import {-# SOURCE #-} qualified GI.Gio.Enums as Gio.Enums
import {-# SOURCE #-} qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import {-# SOURCE #-} qualified GI.Gio.Interfaces.SocketConnectable as Gio.SocketConnectable
import {-# SOURCE #-} qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import {-# SOURCE #-} qualified GI.Gio.Objects.InetAddress as Gio.InetAddress
import {-# SOURCE #-} qualified GI.Gio.Objects.SocketAddress as Gio.SocketAddress
import {-# SOURCE #-} qualified GI.Gio.Objects.SocketAddressEnumerator as Gio.SocketAddressEnumerator

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gio.Interfaces.SocketConnectable as Gio.SocketConnectable
import {-# SOURCE #-} qualified GI.Gio.Objects.InetAddress as Gio.InetAddress
import {-# SOURCE #-} qualified GI.Gio.Objects.SocketAddress as Gio.SocketAddress

#endif

-- | Memory-managed wrapper type.
newtype InetSocketAddress = InetSocketAddress (SP.ManagedPtr InetSocketAddress)
    deriving (Eq)

instance SP.ManagedPtrNewtype InetSocketAddress where
    toManagedPtr (InetSocketAddress p) = p

foreign import ccall "g_inet_socket_address_get_type"
    c_g_inet_socket_address_get_type :: IO B.Types.GType

instance B.Types.TypedObject InetSocketAddress where
    glibType = c_g_inet_socket_address_get_type

instance B.Types.GObject InetSocketAddress

-- | Type class for types which can be safely cast to t'InetSocketAddress', for instance with `toInetSocketAddress`.
class (SP.GObject o, O.IsDescendantOf InetSocketAddress o) => IsInetSocketAddress o
instance (SP.GObject o, O.IsDescendantOf InetSocketAddress o) => IsInetSocketAddress o

instance O.HasParentTypes InetSocketAddress
type instance O.ParentTypes InetSocketAddress = '[Gio.SocketAddress.SocketAddress, GObject.Object.Object, Gio.SocketConnectable.SocketConnectable]

-- | Cast to t'InetSocketAddress', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toInetSocketAddress :: (MIO.MonadIO m, IsInetSocketAddress o) => o -> m InetSocketAddress
toInetSocketAddress = MIO.liftIO . B.ManagedPtr.unsafeCastTo InetSocketAddress

-- | Convert t'InetSocketAddress' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe InetSocketAddress) where
    gvalueGType_ = c_g_inet_socket_address_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr InetSocketAddress)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr InetSocketAddress)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject InetSocketAddress ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveInetSocketAddressMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveInetSocketAddressMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveInetSocketAddressMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveInetSocketAddressMethod "enumerate" o = Gio.SocketConnectable.SocketConnectableEnumerateMethodInfo
    ResolveInetSocketAddressMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveInetSocketAddressMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveInetSocketAddressMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveInetSocketAddressMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveInetSocketAddressMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveInetSocketAddressMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveInetSocketAddressMethod "proxyEnumerate" o = Gio.SocketConnectable.SocketConnectableProxyEnumerateMethodInfo
    ResolveInetSocketAddressMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveInetSocketAddressMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveInetSocketAddressMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveInetSocketAddressMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveInetSocketAddressMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveInetSocketAddressMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveInetSocketAddressMethod "toNative" o = Gio.SocketAddress.SocketAddressToNativeMethodInfo
    ResolveInetSocketAddressMethod "toString" o = Gio.SocketConnectable.SocketConnectableToStringMethodInfo
    ResolveInetSocketAddressMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveInetSocketAddressMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveInetSocketAddressMethod "getAddress" o = InetSocketAddressGetAddressMethodInfo
    ResolveInetSocketAddressMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveInetSocketAddressMethod "getFamily" o = Gio.SocketAddress.SocketAddressGetFamilyMethodInfo
    ResolveInetSocketAddressMethod "getFlowinfo" o = InetSocketAddressGetFlowinfoMethodInfo
    ResolveInetSocketAddressMethod "getNativeSize" o = Gio.SocketAddress.SocketAddressGetNativeSizeMethodInfo
    ResolveInetSocketAddressMethod "getPort" o = InetSocketAddressGetPortMethodInfo
    ResolveInetSocketAddressMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveInetSocketAddressMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveInetSocketAddressMethod "getScopeId" o = InetSocketAddressGetScopeIdMethodInfo
    ResolveInetSocketAddressMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveInetSocketAddressMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveInetSocketAddressMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveInetSocketAddressMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveInetSocketAddressMethod t InetSocketAddress, O.OverloadedMethod info InetSocketAddress p) => OL.IsLabel t (InetSocketAddress -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveInetSocketAddressMethod t InetSocketAddress, O.OverloadedMethod info InetSocketAddress p, R.HasField t InetSocketAddress p) => R.HasField t InetSocketAddress p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveInetSocketAddressMethod t InetSocketAddress, O.OverloadedMethodInfo info InetSocketAddress) => OL.IsLabel t (O.MethodProxy info InetSocketAddress) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "address"
   -- Type: TInterface (Name {namespace = "Gio", name = "InetAddress"})
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@address@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' inetSocketAddress #address
-- @
getInetSocketAddressAddress :: (MonadIO m, IsInetSocketAddress o) => o -> m Gio.InetAddress.InetAddress
getInetSocketAddressAddress obj = MIO.liftIO $ checkUnexpectedNothing "getInetSocketAddressAddress" $ B.Properties.getObjectPropertyObject obj "address" Gio.InetAddress.InetAddress

-- | Construct a t'GValueConstruct' with valid value for the “@address@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructInetSocketAddressAddress :: (IsInetSocketAddress o, MIO.MonadIO m, Gio.InetAddress.IsInetAddress a) => a -> m (GValueConstruct o)
constructInetSocketAddressAddress val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "address" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data InetSocketAddressAddressPropertyInfo
instance AttrInfo InetSocketAddressAddressPropertyInfo where
    type AttrAllowedOps InetSocketAddressAddressPropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint InetSocketAddressAddressPropertyInfo = IsInetSocketAddress
    type AttrSetTypeConstraint InetSocketAddressAddressPropertyInfo = Gio.InetAddress.IsInetAddress
    type AttrTransferTypeConstraint InetSocketAddressAddressPropertyInfo = Gio.InetAddress.IsInetAddress
    type AttrTransferType InetSocketAddressAddressPropertyInfo = Gio.InetAddress.InetAddress
    type AttrGetType InetSocketAddressAddressPropertyInfo = Gio.InetAddress.InetAddress
    type AttrLabel InetSocketAddressAddressPropertyInfo = "address"
    type AttrOrigin InetSocketAddressAddressPropertyInfo = InetSocketAddress
    attrGet = getInetSocketAddressAddress
    attrSet = undefined
    attrTransfer _ v = do
        unsafeCastTo Gio.InetAddress.InetAddress v
    attrConstruct = constructInetSocketAddressAddress
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.InetSocketAddress.address"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-InetSocketAddress.html#g:attr:address"
        })
#endif

-- VVV Prop "flowinfo"
   -- Type: TBasicType TUInt
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@flowinfo@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' inetSocketAddress #flowinfo
-- @
getInetSocketAddressFlowinfo :: (MonadIO m, IsInetSocketAddress o) => o -> m Word32
getInetSocketAddressFlowinfo obj = MIO.liftIO $ B.Properties.getObjectPropertyUInt32 obj "flowinfo"

-- | Construct a t'GValueConstruct' with valid value for the “@flowinfo@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructInetSocketAddressFlowinfo :: (IsInetSocketAddress o, MIO.MonadIO m) => Word32 -> m (GValueConstruct o)
constructInetSocketAddressFlowinfo val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyUInt32 "flowinfo" val

#if defined(ENABLE_OVERLOADING)
data InetSocketAddressFlowinfoPropertyInfo
instance AttrInfo InetSocketAddressFlowinfoPropertyInfo where
    type AttrAllowedOps InetSocketAddressFlowinfoPropertyInfo = '[ 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint InetSocketAddressFlowinfoPropertyInfo = IsInetSocketAddress
    type AttrSetTypeConstraint InetSocketAddressFlowinfoPropertyInfo = (~) Word32
    type AttrTransferTypeConstraint InetSocketAddressFlowinfoPropertyInfo = (~) Word32
    type AttrTransferType InetSocketAddressFlowinfoPropertyInfo = Word32
    type AttrGetType InetSocketAddressFlowinfoPropertyInfo = Word32
    type AttrLabel InetSocketAddressFlowinfoPropertyInfo = "flowinfo"
    type AttrOrigin InetSocketAddressFlowinfoPropertyInfo = InetSocketAddress
    attrGet = getInetSocketAddressFlowinfo
    attrSet = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructInetSocketAddressFlowinfo
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.InetSocketAddress.flowinfo"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-InetSocketAddress.html#g:attr:flowinfo"
        })
#endif

-- VVV Prop "port"
   -- Type: TBasicType TUInt
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@port@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' inetSocketAddress #port
-- @
getInetSocketAddressPort :: (MonadIO m, IsInetSocketAddress o) => o -> m Word32
getInetSocketAddressPort obj = MIO.liftIO $ B.Properties.getObjectPropertyUInt32 obj "port"

-- | Construct a t'GValueConstruct' with valid value for the “@port@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructInetSocketAddressPort :: (IsInetSocketAddress o, MIO.MonadIO m) => Word32 -> m (GValueConstruct o)
constructInetSocketAddressPort val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyUInt32 "port" val

#if defined(ENABLE_OVERLOADING)
data InetSocketAddressPortPropertyInfo
instance AttrInfo InetSocketAddressPortPropertyInfo where
    type AttrAllowedOps InetSocketAddressPortPropertyInfo = '[ 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint InetSocketAddressPortPropertyInfo = IsInetSocketAddress
    type AttrSetTypeConstraint InetSocketAddressPortPropertyInfo = (~) Word32
    type AttrTransferTypeConstraint InetSocketAddressPortPropertyInfo = (~) Word32
    type AttrTransferType InetSocketAddressPortPropertyInfo = Word32
    type AttrGetType InetSocketAddressPortPropertyInfo = Word32
    type AttrLabel InetSocketAddressPortPropertyInfo = "port"
    type AttrOrigin InetSocketAddressPortPropertyInfo = InetSocketAddress
    attrGet = getInetSocketAddressPort
    attrSet = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructInetSocketAddressPort
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.InetSocketAddress.port"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-InetSocketAddress.html#g:attr:port"
        })
#endif

-- VVV Prop "scope-id"
   -- Type: TBasicType TUInt
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@scope-id@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' inetSocketAddress #scopeId
-- @
getInetSocketAddressScopeId :: (MonadIO m, IsInetSocketAddress o) => o -> m Word32
getInetSocketAddressScopeId obj = MIO.liftIO $ B.Properties.getObjectPropertyUInt32 obj "scope-id"

-- | Construct a t'GValueConstruct' with valid value for the “@scope-id@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructInetSocketAddressScopeId :: (IsInetSocketAddress o, MIO.MonadIO m) => Word32 -> m (GValueConstruct o)
constructInetSocketAddressScopeId val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyUInt32 "scope-id" val

#if defined(ENABLE_OVERLOADING)
data InetSocketAddressScopeIdPropertyInfo
instance AttrInfo InetSocketAddressScopeIdPropertyInfo where
    type AttrAllowedOps InetSocketAddressScopeIdPropertyInfo = '[ 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint InetSocketAddressScopeIdPropertyInfo = IsInetSocketAddress
    type AttrSetTypeConstraint InetSocketAddressScopeIdPropertyInfo = (~) Word32
    type AttrTransferTypeConstraint InetSocketAddressScopeIdPropertyInfo = (~) Word32
    type AttrTransferType InetSocketAddressScopeIdPropertyInfo = Word32
    type AttrGetType InetSocketAddressScopeIdPropertyInfo = Word32
    type AttrLabel InetSocketAddressScopeIdPropertyInfo = "scope-id"
    type AttrOrigin InetSocketAddressScopeIdPropertyInfo = InetSocketAddress
    attrGet = getInetSocketAddressScopeId
    attrSet = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructInetSocketAddressScopeId
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.InetSocketAddress.scopeId"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-InetSocketAddress.html#g:attr:scopeId"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList InetSocketAddress
type instance O.AttributeList InetSocketAddress = InetSocketAddressAttributeList
type InetSocketAddressAttributeList = ('[ '("address", InetSocketAddressAddressPropertyInfo), '("family", Gio.SocketAddress.SocketAddressFamilyPropertyInfo), '("flowinfo", InetSocketAddressFlowinfoPropertyInfo), '("port", InetSocketAddressPortPropertyInfo), '("scopeId", InetSocketAddressScopeIdPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
inetSocketAddressAddress :: AttrLabelProxy "address"
inetSocketAddressAddress = AttrLabelProxy

inetSocketAddressFlowinfo :: AttrLabelProxy "flowinfo"
inetSocketAddressFlowinfo = AttrLabelProxy

inetSocketAddressPort :: AttrLabelProxy "port"
inetSocketAddressPort = AttrLabelProxy

inetSocketAddressScopeId :: AttrLabelProxy "scopeId"
inetSocketAddressScopeId = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList InetSocketAddress = InetSocketAddressSignalList
type InetSocketAddressSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method InetSocketAddress::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "address"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "InetAddress" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GInetAddress" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "port"
--           , argType = TBasicType TUInt16
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a port number" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Gio" , name = "InetSocketAddress" })
-- throws : False
-- Skip return : False

foreign import ccall "g_inet_socket_address_new" g_inet_socket_address_new :: 
    Ptr Gio.InetAddress.InetAddress ->      -- address : TInterface (Name {namespace = "Gio", name = "InetAddress"})
    Word16 ->                               -- port : TBasicType TUInt16
    IO (Ptr InetSocketAddress)

-- | Creates a new t'GI.Gio.Objects.InetSocketAddress.InetSocketAddress' for /@address@/ and /@port@/.
-- 
-- /Since: 2.22/
inetSocketAddressNew ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.InetAddress.IsInetAddress a) =>
    a
    -- ^ /@address@/: a t'GI.Gio.Objects.InetAddress.InetAddress'
    -> Word16
    -- ^ /@port@/: a port number
    -> m InetSocketAddress
    -- ^ __Returns:__ a new t'GI.Gio.Objects.InetSocketAddress.InetSocketAddress'
inetSocketAddressNew address port = liftIO $ do
    address' <- unsafeManagedPtrCastPtr address
    result <- g_inet_socket_address_new address' port
    checkUnexpectedReturnNULL "inetSocketAddressNew" result
    result' <- (wrapObject InetSocketAddress) result
    touchManagedPtr address
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method InetSocketAddress::new_from_string
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "address"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the string form of an IP address"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "port"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a port number" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Gio" , name = "InetSocketAddress" })
-- throws : False
-- Skip return : False

foreign import ccall "g_inet_socket_address_new_from_string" g_inet_socket_address_new_from_string :: 
    CString ->                              -- address : TBasicType TUTF8
    Word32 ->                               -- port : TBasicType TUInt
    IO (Ptr InetSocketAddress)

-- | Creates a new t'GI.Gio.Objects.InetSocketAddress.InetSocketAddress' for /@address@/ and /@port@/.
-- 
-- If /@address@/ is an IPv6 address, it can also contain a scope ID
-- (separated from the address by a @%@). Note that currently this
-- behavior is platform specific. This may change in a future release.
-- 
-- /Since: 2.40/
inetSocketAddressNewFromString ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@address@/: the string form of an IP address
    -> Word32
    -- ^ /@port@/: a port number
    -> m (Maybe InetSocketAddress)
    -- ^ __Returns:__ a new t'GI.Gio.Objects.InetSocketAddress.InetSocketAddress',
    -- or 'P.Nothing' if /@address@/ cannot be parsed.
inetSocketAddressNewFromString address port = liftIO $ do
    address' <- textToCString address
    result <- g_inet_socket_address_new_from_string address' port
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (wrapObject InetSocketAddress) result'
        return result''
    freeMem address'
    return maybeResult

#if defined(ENABLE_OVERLOADING)
#endif

-- method InetSocketAddress::get_address
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "address"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "InetSocketAddress" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GInetSocketAddress"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "InetAddress" })
-- throws : False
-- Skip return : False

foreign import ccall "g_inet_socket_address_get_address" g_inet_socket_address_get_address :: 
    Ptr InetSocketAddress ->                -- address : TInterface (Name {namespace = "Gio", name = "InetSocketAddress"})
    IO (Ptr Gio.InetAddress.InetAddress)

-- | Gets /@address@/\'s t'GI.Gio.Objects.InetAddress.InetAddress'.
-- 
-- /Since: 2.22/
inetSocketAddressGetAddress ::
    (B.CallStack.HasCallStack, MonadIO m, IsInetSocketAddress a) =>
    a
    -- ^ /@address@/: a t'GI.Gio.Objects.InetSocketAddress.InetSocketAddress'
    -> m Gio.InetAddress.InetAddress
    -- ^ __Returns:__ the t'GI.Gio.Objects.InetAddress.InetAddress' for /@address@/, which must be
    -- 'GI.GObject.Objects.Object.objectRef'\'d if it will be stored
inetSocketAddressGetAddress address = liftIO $ do
    address' <- unsafeManagedPtrCastPtr address
    result <- g_inet_socket_address_get_address address'
    checkUnexpectedReturnNULL "inetSocketAddressGetAddress" result
    result' <- (newObject Gio.InetAddress.InetAddress) result
    touchManagedPtr address
    return result'

#if defined(ENABLE_OVERLOADING)
data InetSocketAddressGetAddressMethodInfo
instance (signature ~ (m Gio.InetAddress.InetAddress), MonadIO m, IsInetSocketAddress a) => O.OverloadedMethod InetSocketAddressGetAddressMethodInfo a signature where
    overloadedMethod = inetSocketAddressGetAddress

instance O.OverloadedMethodInfo InetSocketAddressGetAddressMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.InetSocketAddress.inetSocketAddressGetAddress",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-InetSocketAddress.html#v:inetSocketAddressGetAddress"
        })


#endif

-- method InetSocketAddress::get_flowinfo
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "address"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "InetSocketAddress" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a %G_SOCKET_FAMILY_IPV6 #GInetSocketAddress"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt32)
-- throws : False
-- Skip return : False

foreign import ccall "g_inet_socket_address_get_flowinfo" g_inet_socket_address_get_flowinfo :: 
    Ptr InetSocketAddress ->                -- address : TInterface (Name {namespace = "Gio", name = "InetSocketAddress"})
    IO Word32

-- | Gets the @sin6_flowinfo@ field from /@address@/,
-- which must be an IPv6 address.
-- 
-- If not overridden this value will be inherited from [InetSocketAddress:address]("GI.Gio.Objects.InetSocketAddress#g:attr:address").
-- 
-- /Since: 2.32/
inetSocketAddressGetFlowinfo ::
    (B.CallStack.HasCallStack, MonadIO m, IsInetSocketAddress a) =>
    a
    -- ^ /@address@/: a 'GI.Gio.Enums.SocketFamilyIpv6' t'GI.Gio.Objects.InetSocketAddress.InetSocketAddress'
    -> m Word32
    -- ^ __Returns:__ the flowinfo field
inetSocketAddressGetFlowinfo address = liftIO $ do
    address' <- unsafeManagedPtrCastPtr address
    result <- g_inet_socket_address_get_flowinfo address'
    touchManagedPtr address
    return result

#if defined(ENABLE_OVERLOADING)
data InetSocketAddressGetFlowinfoMethodInfo
instance (signature ~ (m Word32), MonadIO m, IsInetSocketAddress a) => O.OverloadedMethod InetSocketAddressGetFlowinfoMethodInfo a signature where
    overloadedMethod = inetSocketAddressGetFlowinfo

instance O.OverloadedMethodInfo InetSocketAddressGetFlowinfoMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.InetSocketAddress.inetSocketAddressGetFlowinfo",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-InetSocketAddress.html#v:inetSocketAddressGetFlowinfo"
        })


#endif

-- method InetSocketAddress::get_port
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "address"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "InetSocketAddress" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GInetSocketAddress"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt16)
-- throws : False
-- Skip return : False

foreign import ccall "g_inet_socket_address_get_port" g_inet_socket_address_get_port :: 
    Ptr InetSocketAddress ->                -- address : TInterface (Name {namespace = "Gio", name = "InetSocketAddress"})
    IO Word16

-- | Gets /@address@/\'s port.
-- 
-- /Since: 2.22/
inetSocketAddressGetPort ::
    (B.CallStack.HasCallStack, MonadIO m, IsInetSocketAddress a) =>
    a
    -- ^ /@address@/: a t'GI.Gio.Objects.InetSocketAddress.InetSocketAddress'
    -> m Word16
    -- ^ __Returns:__ the port for /@address@/
inetSocketAddressGetPort address = liftIO $ do
    address' <- unsafeManagedPtrCastPtr address
    result <- g_inet_socket_address_get_port address'
    touchManagedPtr address
    return result

#if defined(ENABLE_OVERLOADING)
data InetSocketAddressGetPortMethodInfo
instance (signature ~ (m Word16), MonadIO m, IsInetSocketAddress a) => O.OverloadedMethod InetSocketAddressGetPortMethodInfo a signature where
    overloadedMethod = inetSocketAddressGetPort

instance O.OverloadedMethodInfo InetSocketAddressGetPortMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.InetSocketAddress.inetSocketAddressGetPort",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-InetSocketAddress.html#v:inetSocketAddressGetPort"
        })


#endif

-- method InetSocketAddress::get_scope_id
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "address"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "InetSocketAddress" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a %G_SOCKET_FAMILY_IPV6 #GInetAddress"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt32)
-- throws : False
-- Skip return : False

foreign import ccall "g_inet_socket_address_get_scope_id" g_inet_socket_address_get_scope_id :: 
    Ptr InetSocketAddress ->                -- address : TInterface (Name {namespace = "Gio", name = "InetSocketAddress"})
    IO Word32

-- | Gets the @sin6_scope_id@ field from /@address@/,
-- which must be an IPv6 address.
-- 
-- If not overridden this value will be inherited from [InetSocketAddress:address]("GI.Gio.Objects.InetSocketAddress#g:attr:address").
-- 
-- /Since: 2.32/
inetSocketAddressGetScopeId ::
    (B.CallStack.HasCallStack, MonadIO m, IsInetSocketAddress a) =>
    a
    -- ^ /@address@/: a 'GI.Gio.Enums.SocketFamilyIpv6' t'GI.Gio.Objects.InetAddress.InetAddress'
    -> m Word32
    -- ^ __Returns:__ the scope id field
inetSocketAddressGetScopeId address = liftIO $ do
    address' <- unsafeManagedPtrCastPtr address
    result <- g_inet_socket_address_get_scope_id address'
    touchManagedPtr address
    return result

#if defined(ENABLE_OVERLOADING)
data InetSocketAddressGetScopeIdMethodInfo
instance (signature ~ (m Word32), MonadIO m, IsInetSocketAddress a) => O.OverloadedMethod InetSocketAddressGetScopeIdMethodInfo a signature where
    overloadedMethod = inetSocketAddressGetScopeId

instance O.OverloadedMethodInfo InetSocketAddressGetScopeIdMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.InetSocketAddress.inetSocketAddressGetScopeId",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-InetSocketAddress.html#v:inetSocketAddressGetScopeId"
        })


#endif


