{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- The t'GI.Gdk.Objects.Seat.Seat' object represents a collection of input devices
-- that belong to a user.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gdk.Objects.Seat
    ( 

-- * Exported types
    Seat(..)                                ,
    IsSeat                                  ,
    toSeat                                  ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [grab]("GI.Gdk.Objects.Seat#g:method:grab"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [ungrab]("GI.Gdk.Objects.Seat#g:method:ungrab"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getCapabilities]("GI.Gdk.Objects.Seat#g:method:getCapabilities"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDisplay]("GI.Gdk.Objects.Seat#g:method:getDisplay"), [getKeyboard]("GI.Gdk.Objects.Seat#g:method:getKeyboard"), [getPointer]("GI.Gdk.Objects.Seat#g:method:getPointer"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getSlaves]("GI.Gdk.Objects.Seat#g:method:getSlaves").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveSeatMethod                       ,
#endif

-- ** getCapabilities #method:getCapabilities#

#if defined(ENABLE_OVERLOADING)
    SeatGetCapabilitiesMethodInfo           ,
#endif
    seatGetCapabilities                     ,


-- ** getDisplay #method:getDisplay#

#if defined(ENABLE_OVERLOADING)
    SeatGetDisplayMethodInfo                ,
#endif
    seatGetDisplay                          ,


-- ** getKeyboard #method:getKeyboard#

#if defined(ENABLE_OVERLOADING)
    SeatGetKeyboardMethodInfo               ,
#endif
    seatGetKeyboard                         ,


-- ** getPointer #method:getPointer#

#if defined(ENABLE_OVERLOADING)
    SeatGetPointerMethodInfo                ,
#endif
    seatGetPointer                          ,


-- ** getSlaves #method:getSlaves#

#if defined(ENABLE_OVERLOADING)
    SeatGetSlavesMethodInfo                 ,
#endif
    seatGetSlaves                           ,


-- ** grab #method:grab#

#if defined(ENABLE_OVERLOADING)
    SeatGrabMethodInfo                      ,
#endif
    seatGrab                                ,


-- ** ungrab #method:ungrab#

#if defined(ENABLE_OVERLOADING)
    SeatUngrabMethodInfo                    ,
#endif
    seatUngrab                              ,




 -- * Properties


-- ** display #attr:display#
-- | t'GI.Gdk.Objects.Display.Display' of this seat.
-- 
-- /Since: 3.20/

#if defined(ENABLE_OVERLOADING)
    SeatDisplayPropertyInfo                 ,
#endif
    constructSeatDisplay                    ,
    getSeatDisplay                          ,
#if defined(ENABLE_OVERLOADING)
    seatDisplay                             ,
#endif




 -- * Signals


-- ** deviceAdded #signal:deviceAdded#

    SeatDeviceAddedCallback                 ,
#if defined(ENABLE_OVERLOADING)
    SeatDeviceAddedSignalInfo               ,
#endif
    afterSeatDeviceAdded                    ,
    onSeatDeviceAdded                       ,


-- ** deviceRemoved #signal:deviceRemoved#

    SeatDeviceRemovedCallback               ,
#if defined(ENABLE_OVERLOADING)
    SeatDeviceRemovedSignalInfo             ,
#endif
    afterSeatDeviceRemoved                  ,
    onSeatDeviceRemoved                     ,


-- ** toolAdded #signal:toolAdded#

    SeatToolAddedCallback                   ,
#if defined(ENABLE_OVERLOADING)
    SeatToolAddedSignalInfo                 ,
#endif
    afterSeatToolAdded                      ,
    onSeatToolAdded                         ,


-- ** toolRemoved #signal:toolRemoved#

    SeatToolRemovedCallback                 ,
#if defined(ENABLE_OVERLOADING)
    SeatToolRemovedSignalInfo               ,
#endif
    afterSeatToolRemoved                    ,
    onSeatToolRemoved                       ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Enums as Cairo.Enums
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.Cairo.Structs.Pattern as Cairo.Pattern
import qualified GI.Cairo.Structs.Region as Cairo.Region
import qualified GI.Cairo.Structs.Surface as Cairo.Surface
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Callbacks as Gdk.Callbacks
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Flags as Gdk.Flags
import {-# SOURCE #-} qualified GI.Gdk.Objects.AppLaunchContext as Gdk.AppLaunchContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Device as Gdk.Device
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceManager as Gdk.DeviceManager
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceTool as Gdk.DeviceTool
import {-# SOURCE #-} qualified GI.Gdk.Objects.Display as Gdk.Display
import {-# SOURCE #-} qualified GI.Gdk.Objects.DragContext as Gdk.DragContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.DrawingContext as Gdk.DrawingContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import {-# SOURCE #-} qualified GI.Gdk.Objects.GLContext as Gdk.GLContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Monitor as Gdk.Monitor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Screen as Gdk.Screen
import {-# SOURCE #-} qualified GI.Gdk.Objects.Visual as Gdk.Visual
import {-# SOURCE #-} qualified GI.Gdk.Objects.Window as Gdk.Window
import {-# SOURCE #-} qualified GI.Gdk.Structs.Atom as Gdk.Atom
import {-# SOURCE #-} qualified GI.Gdk.Structs.Color as Gdk.Color
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventAny as Gdk.EventAny
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventButton as Gdk.EventButton
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventConfigure as Gdk.EventConfigure
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventCrossing as Gdk.EventCrossing
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventDND as Gdk.EventDND
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventExpose as Gdk.EventExpose
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventFocus as Gdk.EventFocus
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventGrabBroken as Gdk.EventGrabBroken
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventKey as Gdk.EventKey
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventMotion as Gdk.EventMotion
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventOwnerChange as Gdk.EventOwnerChange
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadAxis as Gdk.EventPadAxis
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadButton as Gdk.EventPadButton
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadGroupMode as Gdk.EventPadGroupMode
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventProperty as Gdk.EventProperty
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventProximity as Gdk.EventProximity
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventScroll as Gdk.EventScroll
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSelection as Gdk.EventSelection
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSequence as Gdk.EventSequence
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSetting as Gdk.EventSetting
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouch as Gdk.EventTouch
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouchpadPinch as Gdk.EventTouchpadPinch
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouchpadSwipe as Gdk.EventTouchpadSwipe
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventVisibility as Gdk.EventVisibility
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventWindowState as Gdk.EventWindowState
import {-# SOURCE #-} qualified GI.Gdk.Structs.FrameTimings as Gdk.FrameTimings
import {-# SOURCE #-} qualified GI.Gdk.Structs.Geometry as Gdk.Geometry
import {-# SOURCE #-} qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import {-# SOURCE #-} qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import {-# SOURCE #-} qualified GI.Gdk.Structs.WindowAttr as Gdk.WindowAttr
import {-# SOURCE #-} qualified GI.Gdk.Unions.Event as Gdk.Event
import qualified GI.GdkPixbuf.Objects.Pixbuf as GdkPixbuf.Pixbuf
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Objects.AppLaunchContext as Gio.AppLaunchContext

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Callbacks as Gdk.Callbacks
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Flags as Gdk.Flags
import {-# SOURCE #-} qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Device as Gdk.Device
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceTool as Gdk.DeviceTool
import {-# SOURCE #-} qualified GI.Gdk.Objects.Display as Gdk.Display
import {-# SOURCE #-} qualified GI.Gdk.Objects.Window as Gdk.Window
import {-# SOURCE #-} qualified GI.Gdk.Unions.Event as Gdk.Event

#endif

-- | Memory-managed wrapper type.
newtype Seat = Seat (SP.ManagedPtr Seat)
    deriving (Eq)

instance SP.ManagedPtrNewtype Seat where
    toManagedPtr (Seat p) = p

foreign import ccall "gdk_seat_get_type"
    c_gdk_seat_get_type :: IO B.Types.GType

instance B.Types.TypedObject Seat where
    glibType = c_gdk_seat_get_type

instance B.Types.GObject Seat

-- | Type class for types which can be safely cast to t'Seat', for instance with `toSeat`.
class (SP.GObject o, O.IsDescendantOf Seat o) => IsSeat o
instance (SP.GObject o, O.IsDescendantOf Seat o) => IsSeat o

instance O.HasParentTypes Seat
type instance O.ParentTypes Seat = '[GObject.Object.Object]

-- | Cast to t'Seat', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toSeat :: (MIO.MonadIO m, IsSeat o) => o -> m Seat
toSeat = MIO.liftIO . B.ManagedPtr.unsafeCastTo Seat

-- | Convert t'Seat' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe Seat) where
    gvalueGType_ = c_gdk_seat_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr Seat)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr Seat)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject Seat ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveSeatMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveSeatMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveSeatMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveSeatMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveSeatMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveSeatMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveSeatMethod "grab" o = SeatGrabMethodInfo
    ResolveSeatMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveSeatMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveSeatMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveSeatMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveSeatMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveSeatMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveSeatMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveSeatMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveSeatMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveSeatMethod "ungrab" o = SeatUngrabMethodInfo
    ResolveSeatMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveSeatMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveSeatMethod "getCapabilities" o = SeatGetCapabilitiesMethodInfo
    ResolveSeatMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveSeatMethod "getDisplay" o = SeatGetDisplayMethodInfo
    ResolveSeatMethod "getKeyboard" o = SeatGetKeyboardMethodInfo
    ResolveSeatMethod "getPointer" o = SeatGetPointerMethodInfo
    ResolveSeatMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveSeatMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveSeatMethod "getSlaves" o = SeatGetSlavesMethodInfo
    ResolveSeatMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveSeatMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveSeatMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveSeatMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveSeatMethod t Seat, O.OverloadedMethod info Seat p) => OL.IsLabel t (Seat -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveSeatMethod t Seat, O.OverloadedMethod info Seat p, R.HasField t Seat p) => R.HasField t Seat p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveSeatMethod t Seat, O.OverloadedMethodInfo info Seat) => OL.IsLabel t (O.MethodProxy info Seat) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- signal Seat::device-added
-- | The [deviceAdded](#g:signal:deviceAdded) signal is emitted when a new input
-- device is related to this seat.
-- 
-- /Since: 3.20/
type SeatDeviceAddedCallback =
    Gdk.Device.Device
    -- ^ /@device@/: the newly added t'GI.Gdk.Objects.Device.Device'.
    -> IO ()

type C_SeatDeviceAddedCallback =
    Ptr Seat ->                             -- object
    Ptr Gdk.Device.Device ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_SeatDeviceAddedCallback`.
foreign import ccall "wrapper"
    mk_SeatDeviceAddedCallback :: C_SeatDeviceAddedCallback -> IO (FunPtr C_SeatDeviceAddedCallback)

wrap_SeatDeviceAddedCallback :: 
    GObject a => (a -> SeatDeviceAddedCallback) ->
    C_SeatDeviceAddedCallback
wrap_SeatDeviceAddedCallback gi'cb gi'selfPtr device _ = do
    device' <- (newObject Gdk.Device.Device) device
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  device'


-- | Connect a signal handler for the [deviceAdded](#signal:deviceAdded) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' seat #deviceAdded callback
-- @
-- 
-- 
onSeatDeviceAdded :: (IsSeat a, MonadIO m) => a -> ((?self :: a) => SeatDeviceAddedCallback) -> m SignalHandlerId
onSeatDeviceAdded obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_SeatDeviceAddedCallback wrapped
    wrapped'' <- mk_SeatDeviceAddedCallback wrapped'
    connectSignalFunPtr obj "device-added" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [deviceAdded](#signal:deviceAdded) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' seat #deviceAdded callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterSeatDeviceAdded :: (IsSeat a, MonadIO m) => a -> ((?self :: a) => SeatDeviceAddedCallback) -> m SignalHandlerId
afterSeatDeviceAdded obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_SeatDeviceAddedCallback wrapped
    wrapped'' <- mk_SeatDeviceAddedCallback wrapped'
    connectSignalFunPtr obj "device-added" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data SeatDeviceAddedSignalInfo
instance SignalInfo SeatDeviceAddedSignalInfo where
    type HaskellCallbackType SeatDeviceAddedSignalInfo = SeatDeviceAddedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_SeatDeviceAddedCallback cb
        cb'' <- mk_SeatDeviceAddedCallback cb'
        connectSignalFunPtr obj "device-added" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Seat::device-added"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Seat.html#g:signal:deviceAdded"})

#endif

-- signal Seat::device-removed
-- | The [deviceRemoved](#g:signal:deviceRemoved) signal is emitted when an
-- input device is removed (e.g. unplugged).
-- 
-- /Since: 3.20/
type SeatDeviceRemovedCallback =
    Gdk.Device.Device
    -- ^ /@device@/: the just removed t'GI.Gdk.Objects.Device.Device'.
    -> IO ()

type C_SeatDeviceRemovedCallback =
    Ptr Seat ->                             -- object
    Ptr Gdk.Device.Device ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_SeatDeviceRemovedCallback`.
foreign import ccall "wrapper"
    mk_SeatDeviceRemovedCallback :: C_SeatDeviceRemovedCallback -> IO (FunPtr C_SeatDeviceRemovedCallback)

wrap_SeatDeviceRemovedCallback :: 
    GObject a => (a -> SeatDeviceRemovedCallback) ->
    C_SeatDeviceRemovedCallback
wrap_SeatDeviceRemovedCallback gi'cb gi'selfPtr device _ = do
    device' <- (newObject Gdk.Device.Device) device
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  device'


-- | Connect a signal handler for the [deviceRemoved](#signal:deviceRemoved) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' seat #deviceRemoved callback
-- @
-- 
-- 
onSeatDeviceRemoved :: (IsSeat a, MonadIO m) => a -> ((?self :: a) => SeatDeviceRemovedCallback) -> m SignalHandlerId
onSeatDeviceRemoved obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_SeatDeviceRemovedCallback wrapped
    wrapped'' <- mk_SeatDeviceRemovedCallback wrapped'
    connectSignalFunPtr obj "device-removed" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [deviceRemoved](#signal:deviceRemoved) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' seat #deviceRemoved callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterSeatDeviceRemoved :: (IsSeat a, MonadIO m) => a -> ((?self :: a) => SeatDeviceRemovedCallback) -> m SignalHandlerId
afterSeatDeviceRemoved obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_SeatDeviceRemovedCallback wrapped
    wrapped'' <- mk_SeatDeviceRemovedCallback wrapped'
    connectSignalFunPtr obj "device-removed" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data SeatDeviceRemovedSignalInfo
instance SignalInfo SeatDeviceRemovedSignalInfo where
    type HaskellCallbackType SeatDeviceRemovedSignalInfo = SeatDeviceRemovedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_SeatDeviceRemovedCallback cb
        cb'' <- mk_SeatDeviceRemovedCallback cb'
        connectSignalFunPtr obj "device-removed" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Seat::device-removed"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Seat.html#g:signal:deviceRemoved"})

#endif

-- signal Seat::tool-added
-- | The [toolAdded](#g:signal:toolAdded) signal is emitted whenever a new tool
-- is made known to the seat. The tool may later be assigned
-- to a device (i.e. on proximity with a tablet). The device
-- will emit the [Device::toolChanged]("GI.Gdk.Objects.Device#g:signal:toolChanged") signal accordingly.
-- 
-- A same tool may be used by several devices.
-- 
-- /Since: 3.22/
type SeatToolAddedCallback =
    Gdk.DeviceTool.DeviceTool
    -- ^ /@tool@/: the new t'GI.Gdk.Objects.DeviceTool.DeviceTool' known to the seat
    -> IO ()

type C_SeatToolAddedCallback =
    Ptr Seat ->                             -- object
    Ptr Gdk.DeviceTool.DeviceTool ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_SeatToolAddedCallback`.
foreign import ccall "wrapper"
    mk_SeatToolAddedCallback :: C_SeatToolAddedCallback -> IO (FunPtr C_SeatToolAddedCallback)

wrap_SeatToolAddedCallback :: 
    GObject a => (a -> SeatToolAddedCallback) ->
    C_SeatToolAddedCallback
wrap_SeatToolAddedCallback gi'cb gi'selfPtr tool _ = do
    tool' <- (newObject Gdk.DeviceTool.DeviceTool) tool
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  tool'


-- | Connect a signal handler for the [toolAdded](#signal:toolAdded) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' seat #toolAdded callback
-- @
-- 
-- 
onSeatToolAdded :: (IsSeat a, MonadIO m) => a -> ((?self :: a) => SeatToolAddedCallback) -> m SignalHandlerId
onSeatToolAdded obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_SeatToolAddedCallback wrapped
    wrapped'' <- mk_SeatToolAddedCallback wrapped'
    connectSignalFunPtr obj "tool-added" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [toolAdded](#signal:toolAdded) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' seat #toolAdded callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterSeatToolAdded :: (IsSeat a, MonadIO m) => a -> ((?self :: a) => SeatToolAddedCallback) -> m SignalHandlerId
afterSeatToolAdded obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_SeatToolAddedCallback wrapped
    wrapped'' <- mk_SeatToolAddedCallback wrapped'
    connectSignalFunPtr obj "tool-added" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data SeatToolAddedSignalInfo
instance SignalInfo SeatToolAddedSignalInfo where
    type HaskellCallbackType SeatToolAddedSignalInfo = SeatToolAddedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_SeatToolAddedCallback cb
        cb'' <- mk_SeatToolAddedCallback cb'
        connectSignalFunPtr obj "tool-added" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Seat::tool-added"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Seat.html#g:signal:toolAdded"})

#endif

-- signal Seat::tool-removed
-- | This signal is emitted whenever a tool is no longer known
-- to this /@seat@/.
-- 
-- /Since: 3.22/
type SeatToolRemovedCallback =
    Gdk.DeviceTool.DeviceTool
    -- ^ /@tool@/: the just removed t'GI.Gdk.Objects.DeviceTool.DeviceTool'
    -> IO ()

type C_SeatToolRemovedCallback =
    Ptr Seat ->                             -- object
    Ptr Gdk.DeviceTool.DeviceTool ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_SeatToolRemovedCallback`.
foreign import ccall "wrapper"
    mk_SeatToolRemovedCallback :: C_SeatToolRemovedCallback -> IO (FunPtr C_SeatToolRemovedCallback)

wrap_SeatToolRemovedCallback :: 
    GObject a => (a -> SeatToolRemovedCallback) ->
    C_SeatToolRemovedCallback
wrap_SeatToolRemovedCallback gi'cb gi'selfPtr tool _ = do
    tool' <- (newObject Gdk.DeviceTool.DeviceTool) tool
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  tool'


-- | Connect a signal handler for the [toolRemoved](#signal:toolRemoved) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' seat #toolRemoved callback
-- @
-- 
-- 
onSeatToolRemoved :: (IsSeat a, MonadIO m) => a -> ((?self :: a) => SeatToolRemovedCallback) -> m SignalHandlerId
onSeatToolRemoved obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_SeatToolRemovedCallback wrapped
    wrapped'' <- mk_SeatToolRemovedCallback wrapped'
    connectSignalFunPtr obj "tool-removed" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [toolRemoved](#signal:toolRemoved) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' seat #toolRemoved callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterSeatToolRemoved :: (IsSeat a, MonadIO m) => a -> ((?self :: a) => SeatToolRemovedCallback) -> m SignalHandlerId
afterSeatToolRemoved obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_SeatToolRemovedCallback wrapped
    wrapped'' <- mk_SeatToolRemovedCallback wrapped'
    connectSignalFunPtr obj "tool-removed" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data SeatToolRemovedSignalInfo
instance SignalInfo SeatToolRemovedSignalInfo where
    type HaskellCallbackType SeatToolRemovedSignalInfo = SeatToolRemovedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_SeatToolRemovedCallback cb
        cb'' <- mk_SeatToolRemovedCallback cb'
        connectSignalFunPtr obj "tool-removed" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Seat::tool-removed"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Seat.html#g:signal:toolRemoved"})

#endif

-- VVV Prop "display"
   -- Type: TInterface (Name {namespace = "Gdk", name = "Display"})
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@display@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' seat #display
-- @
getSeatDisplay :: (MonadIO m, IsSeat o) => o -> m Gdk.Display.Display
getSeatDisplay obj = MIO.liftIO $ checkUnexpectedNothing "getSeatDisplay" $ B.Properties.getObjectPropertyObject obj "display" Gdk.Display.Display

-- | Construct a t'GValueConstruct' with valid value for the “@display@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructSeatDisplay :: (IsSeat o, MIO.MonadIO m, Gdk.Display.IsDisplay a) => a -> m (GValueConstruct o)
constructSeatDisplay val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "display" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data SeatDisplayPropertyInfo
instance AttrInfo SeatDisplayPropertyInfo where
    type AttrAllowedOps SeatDisplayPropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint SeatDisplayPropertyInfo = IsSeat
    type AttrSetTypeConstraint SeatDisplayPropertyInfo = Gdk.Display.IsDisplay
    type AttrTransferTypeConstraint SeatDisplayPropertyInfo = Gdk.Display.IsDisplay
    type AttrTransferType SeatDisplayPropertyInfo = Gdk.Display.Display
    type AttrGetType SeatDisplayPropertyInfo = Gdk.Display.Display
    type AttrLabel SeatDisplayPropertyInfo = "display"
    type AttrOrigin SeatDisplayPropertyInfo = Seat
    attrGet = getSeatDisplay
    attrSet = undefined
    attrTransfer _ v = do
        unsafeCastTo Gdk.Display.Display v
    attrConstruct = constructSeatDisplay
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Seat.display"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Seat.html#g:attr:display"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Seat
type instance O.AttributeList Seat = SeatAttributeList
type SeatAttributeList = ('[ '("display", SeatDisplayPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
seatDisplay :: AttrLabelProxy "display"
seatDisplay = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList Seat = SeatSignalList
type SeatSignalList = ('[ '("deviceAdded", SeatDeviceAddedSignalInfo), '("deviceRemoved", SeatDeviceRemovedSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("toolAdded", SeatToolAddedSignalInfo), '("toolRemoved", SeatToolRemovedSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method Seat::get_capabilities
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "seat"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Seat" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkSeat" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gdk" , name = "SeatCapabilities" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_seat_get_capabilities" gdk_seat_get_capabilities :: 
    Ptr Seat ->                             -- seat : TInterface (Name {namespace = "Gdk", name = "Seat"})
    IO CUInt

-- | Returns the capabilities this t'GI.Gdk.Objects.Seat.Seat' currently has.
-- 
-- /Since: 3.20/
seatGetCapabilities ::
    (B.CallStack.HasCallStack, MonadIO m, IsSeat a) =>
    a
    -- ^ /@seat@/: a t'GI.Gdk.Objects.Seat.Seat'
    -> m [Gdk.Flags.SeatCapabilities]
    -- ^ __Returns:__ the seat capabilities
seatGetCapabilities seat = liftIO $ do
    seat' <- unsafeManagedPtrCastPtr seat
    result <- gdk_seat_get_capabilities seat'
    let result' = wordToGFlags result
    touchManagedPtr seat
    return result'

#if defined(ENABLE_OVERLOADING)
data SeatGetCapabilitiesMethodInfo
instance (signature ~ (m [Gdk.Flags.SeatCapabilities]), MonadIO m, IsSeat a) => O.OverloadedMethod SeatGetCapabilitiesMethodInfo a signature where
    overloadedMethod = seatGetCapabilities

instance O.OverloadedMethodInfo SeatGetCapabilitiesMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Seat.seatGetCapabilities",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Seat.html#v:seatGetCapabilities"
        })


#endif

-- method Seat::get_display
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "seat"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Seat" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkSeat" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Display" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_seat_get_display" gdk_seat_get_display :: 
    Ptr Seat ->                             -- seat : TInterface (Name {namespace = "Gdk", name = "Seat"})
    IO (Ptr Gdk.Display.Display)

-- | Returns the t'GI.Gdk.Objects.Display.Display' this seat belongs to.
seatGetDisplay ::
    (B.CallStack.HasCallStack, MonadIO m, IsSeat a) =>
    a
    -- ^ /@seat@/: a t'GI.Gdk.Objects.Seat.Seat'
    -> m Gdk.Display.Display
    -- ^ __Returns:__ a t'GI.Gdk.Objects.Display.Display'. This object is owned by GTK+
    --          and must not be freed.
seatGetDisplay seat = liftIO $ do
    seat' <- unsafeManagedPtrCastPtr seat
    result <- gdk_seat_get_display seat'
    checkUnexpectedReturnNULL "seatGetDisplay" result
    result' <- (newObject Gdk.Display.Display) result
    touchManagedPtr seat
    return result'

#if defined(ENABLE_OVERLOADING)
data SeatGetDisplayMethodInfo
instance (signature ~ (m Gdk.Display.Display), MonadIO m, IsSeat a) => O.OverloadedMethod SeatGetDisplayMethodInfo a signature where
    overloadedMethod = seatGetDisplay

instance O.OverloadedMethodInfo SeatGetDisplayMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Seat.seatGetDisplay",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Seat.html#v:seatGetDisplay"
        })


#endif

-- method Seat::get_keyboard
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "seat"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Seat" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkSeat" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Device" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_seat_get_keyboard" gdk_seat_get_keyboard :: 
    Ptr Seat ->                             -- seat : TInterface (Name {namespace = "Gdk", name = "Seat"})
    IO (Ptr Gdk.Device.Device)

-- | Returns the master device that routes keyboard events.
-- 
-- /Since: 3.20/
seatGetKeyboard ::
    (B.CallStack.HasCallStack, MonadIO m, IsSeat a) =>
    a
    -- ^ /@seat@/: a t'GI.Gdk.Objects.Seat.Seat'
    -> m (Maybe Gdk.Device.Device)
    -- ^ __Returns:__ a master t'GI.Gdk.Objects.Device.Device' with keyboard
    --          capabilities. This object is owned by GTK+ and must not be freed.
seatGetKeyboard seat = liftIO $ do
    seat' <- unsafeManagedPtrCastPtr seat
    result <- gdk_seat_get_keyboard seat'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gdk.Device.Device) result'
        return result''
    touchManagedPtr seat
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data SeatGetKeyboardMethodInfo
instance (signature ~ (m (Maybe Gdk.Device.Device)), MonadIO m, IsSeat a) => O.OverloadedMethod SeatGetKeyboardMethodInfo a signature where
    overloadedMethod = seatGetKeyboard

instance O.OverloadedMethodInfo SeatGetKeyboardMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Seat.seatGetKeyboard",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Seat.html#v:seatGetKeyboard"
        })


#endif

-- method Seat::get_pointer
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "seat"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Seat" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkSeat" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Device" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_seat_get_pointer" gdk_seat_get_pointer :: 
    Ptr Seat ->                             -- seat : TInterface (Name {namespace = "Gdk", name = "Seat"})
    IO (Ptr Gdk.Device.Device)

-- | Returns the master device that routes pointer events.
-- 
-- /Since: 3.20/
seatGetPointer ::
    (B.CallStack.HasCallStack, MonadIO m, IsSeat a) =>
    a
    -- ^ /@seat@/: a t'GI.Gdk.Objects.Seat.Seat'
    -> m (Maybe Gdk.Device.Device)
    -- ^ __Returns:__ a master t'GI.Gdk.Objects.Device.Device' with pointer
    --          capabilities. This object is owned by GTK+ and must not be freed.
seatGetPointer seat = liftIO $ do
    seat' <- unsafeManagedPtrCastPtr seat
    result <- gdk_seat_get_pointer seat'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gdk.Device.Device) result'
        return result''
    touchManagedPtr seat
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data SeatGetPointerMethodInfo
instance (signature ~ (m (Maybe Gdk.Device.Device)), MonadIO m, IsSeat a) => O.OverloadedMethod SeatGetPointerMethodInfo a signature where
    overloadedMethod = seatGetPointer

instance O.OverloadedMethodInfo SeatGetPointerMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Seat.seatGetPointer",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Seat.html#v:seatGetPointer"
        })


#endif

-- method Seat::get_slaves
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "seat"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Seat" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkSeat" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "capabilities"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "SeatCapabilities" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "capabilities to get devices for"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TGList (TInterface Name { namespace = "Gdk" , name = "Device" }))
-- throws : False
-- Skip return : False

foreign import ccall "gdk_seat_get_slaves" gdk_seat_get_slaves :: 
    Ptr Seat ->                             -- seat : TInterface (Name {namespace = "Gdk", name = "Seat"})
    CUInt ->                                -- capabilities : TInterface (Name {namespace = "Gdk", name = "SeatCapabilities"})
    IO (Ptr (GList (Ptr Gdk.Device.Device)))

-- | Returns the slave devices that match the given capabilities.
-- 
-- /Since: 3.20/
seatGetSlaves ::
    (B.CallStack.HasCallStack, MonadIO m, IsSeat a) =>
    a
    -- ^ /@seat@/: a t'GI.Gdk.Objects.Seat.Seat'
    -> [Gdk.Flags.SeatCapabilities]
    -- ^ /@capabilities@/: capabilities to get devices for
    -> m [Gdk.Device.Device]
    -- ^ __Returns:__ A list of @/GdkDevices/@.
    --          The list must be freed with @/g_list_free()/@, the elements are owned
    --          by GDK and must not be freed.
seatGetSlaves seat capabilities = liftIO $ do
    seat' <- unsafeManagedPtrCastPtr seat
    let capabilities' = gflagsToWord capabilities
    result <- gdk_seat_get_slaves seat' capabilities'
    result' <- unpackGList result
    result'' <- mapM (newObject Gdk.Device.Device) result'
    g_list_free result
    touchManagedPtr seat
    return result''

#if defined(ENABLE_OVERLOADING)
data SeatGetSlavesMethodInfo
instance (signature ~ ([Gdk.Flags.SeatCapabilities] -> m [Gdk.Device.Device]), MonadIO m, IsSeat a) => O.OverloadedMethod SeatGetSlavesMethodInfo a signature where
    overloadedMethod = seatGetSlaves

instance O.OverloadedMethodInfo SeatGetSlavesMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Seat.seatGetSlaves",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Seat.html#v:seatGetSlaves"
        })


#endif

-- method Seat::grab
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "seat"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Seat" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkSeat" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #GdkWindow which will own the grab"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "capabilities"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "SeatCapabilities" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "capabilities that will be grabbed"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "owner_events"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "if %FALSE then all device events are reported with respect to\n               @window and are only reported if selected by @event_mask. If\n               %TRUE then pointer events for this application are reported\n               as normal, but pointer events outside this application are\n               reported with respect to @window and only if selected by\n               @event_mask. In either mode, unreported events are discarded."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cursor"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Cursor" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the cursor to display while the grab is active. If\n         this is %NULL then the normal cursors are used for\n         @window and its descendants, and the cursor for @window is used\n         elsewhere."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "event"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Event" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the event that is triggering the grab, or %NULL if none\n        is available."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "prepare_func"
--           , argType =
--               TInterface
--                 Name { namespace = "Gdk" , name = "SeatGrabPrepareFunc" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "function to\n               prepare the window to be grabbed, it can be %NULL if @window is\n               visible before this call."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeCall
--           , argClosure = 7
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "prepare_func_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data to pass to @prepare_func"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "GrabStatus" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_seat_grab" gdk_seat_grab :: 
    Ptr Seat ->                             -- seat : TInterface (Name {namespace = "Gdk", name = "Seat"})
    Ptr Gdk.Window.Window ->                -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    CUInt ->                                -- capabilities : TInterface (Name {namespace = "Gdk", name = "SeatCapabilities"})
    CInt ->                                 -- owner_events : TBasicType TBoolean
    Ptr Gdk.Cursor.Cursor ->                -- cursor : TInterface (Name {namespace = "Gdk", name = "Cursor"})
    Ptr Gdk.Event.Event ->                  -- event : TInterface (Name {namespace = "Gdk", name = "Event"})
    FunPtr Gdk.Callbacks.C_SeatGrabPrepareFunc -> -- prepare_func : TInterface (Name {namespace = "Gdk", name = "SeatGrabPrepareFunc"})
    Ptr () ->                               -- prepare_func_data : TBasicType TPtr
    IO CUInt

-- | Grabs the seat so that all events corresponding to the given /@capabilities@/
-- are passed to this application until the seat is ungrabbed with 'GI.Gdk.Objects.Seat.seatUngrab',
-- or the window becomes hidden. This overrides any previous grab on the
-- seat by this client.
-- 
-- As a rule of thumb, if a grab is desired over 'GI.Gdk.Flags.SeatCapabilitiesPointer',
-- all other \"pointing\" capabilities (eg. 'GI.Gdk.Flags.SeatCapabilitiesTouch') should
-- be grabbed too, so the user is able to interact with all of those while
-- the grab holds, you should thus use 'GI.Gdk.Flags.SeatCapabilitiesAllPointing' most
-- commonly.
-- 
-- Grabs are used for operations which need complete control over the
-- events corresponding to the given capabilities. For example in GTK+ this
-- is used for Drag and Drop operations, popup menus and such.
-- 
-- Note that if the event mask of a t'GI.Gdk.Objects.Window.Window' has selected both button press
-- and button release events, or touch begin and touch end, then a press event
-- will cause an automatic grab until the button is released, equivalent to a
-- grab on the window with /@ownerEvents@/ set to 'P.True'. This is done because most
-- applications expect to receive paired press and release events.
-- 
-- If you set up anything at the time you take the grab that needs to be
-- cleaned up when the grab ends, you should handle the t'GI.Gdk.Structs.EventGrabBroken.EventGrabBroken'
-- events that are emitted when the grab ends unvoluntarily.
-- 
-- /Since: 3.20/
seatGrab ::
    (B.CallStack.HasCallStack, MonadIO m, IsSeat a, Gdk.Window.IsWindow b, Gdk.Cursor.IsCursor c) =>
    a
    -- ^ /@seat@/: a t'GI.Gdk.Objects.Seat.Seat'
    -> b
    -- ^ /@window@/: the t'GI.Gdk.Objects.Window.Window' which will own the grab
    -> [Gdk.Flags.SeatCapabilities]
    -- ^ /@capabilities@/: capabilities that will be grabbed
    -> Bool
    -- ^ /@ownerEvents@/: if 'P.False' then all device events are reported with respect to
    --                /@window@/ and are only reported if selected by /@eventMask@/. If
    --                'P.True' then pointer events for this application are reported
    --                as normal, but pointer events outside this application are
    --                reported with respect to /@window@/ and only if selected by
    --                /@eventMask@/. In either mode, unreported events are discarded.
    -> Maybe (c)
    -- ^ /@cursor@/: the cursor to display while the grab is active. If
    --          this is 'P.Nothing' then the normal cursors are used for
    --          /@window@/ and its descendants, and the cursor for /@window@/ is used
    --          elsewhere.
    -> Maybe (Gdk.Event.Event)
    -- ^ /@event@/: the event that is triggering the grab, or 'P.Nothing' if none
    --         is available.
    -> Maybe (Gdk.Callbacks.SeatGrabPrepareFunc)
    -- ^ /@prepareFunc@/: function to
    --                prepare the window to be grabbed, it can be 'P.Nothing' if /@window@/ is
    --                visible before this call.
    -> m Gdk.Enums.GrabStatus
    -- ^ __Returns:__ 'GI.Gdk.Enums.GrabStatusSuccess' if the grab was successful.
seatGrab seat window capabilities ownerEvents cursor event prepareFunc = liftIO $ do
    seat' <- unsafeManagedPtrCastPtr seat
    window' <- unsafeManagedPtrCastPtr window
    let capabilities' = gflagsToWord capabilities
    let ownerEvents' = (P.fromIntegral . P.fromEnum) ownerEvents
    maybeCursor <- case cursor of
        Nothing -> return FP.nullPtr
        Just jCursor -> do
            jCursor' <- unsafeManagedPtrCastPtr jCursor
            return jCursor'
    maybeEvent <- case event of
        Nothing -> return FP.nullPtr
        Just jEvent -> do
            jEvent' <- unsafeManagedPtrGetPtr jEvent
            return jEvent'
    maybePrepareFunc <- case prepareFunc of
        Nothing -> return FP.nullFunPtr
        Just jPrepareFunc -> do
            jPrepareFunc' <- Gdk.Callbacks.mk_SeatGrabPrepareFunc (Gdk.Callbacks.wrap_SeatGrabPrepareFunc Nothing (Gdk.Callbacks.drop_closures_SeatGrabPrepareFunc jPrepareFunc))
            return jPrepareFunc'
    let prepareFuncData = nullPtr
    result <- gdk_seat_grab seat' window' capabilities' ownerEvents' maybeCursor maybeEvent maybePrepareFunc prepareFuncData
    let result' = (toEnum . fromIntegral) result
    safeFreeFunPtr $ castFunPtrToPtr maybePrepareFunc
    touchManagedPtr seat
    touchManagedPtr window
    whenJust cursor touchManagedPtr
    whenJust event touchManagedPtr
    return result'

#if defined(ENABLE_OVERLOADING)
data SeatGrabMethodInfo
instance (signature ~ (b -> [Gdk.Flags.SeatCapabilities] -> Bool -> Maybe (c) -> Maybe (Gdk.Event.Event) -> Maybe (Gdk.Callbacks.SeatGrabPrepareFunc) -> m Gdk.Enums.GrabStatus), MonadIO m, IsSeat a, Gdk.Window.IsWindow b, Gdk.Cursor.IsCursor c) => O.OverloadedMethod SeatGrabMethodInfo a signature where
    overloadedMethod = seatGrab

instance O.OverloadedMethodInfo SeatGrabMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Seat.seatGrab",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Seat.html#v:seatGrab"
        })


#endif

-- method Seat::ungrab
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "seat"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Seat" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkSeat" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_seat_ungrab" gdk_seat_ungrab :: 
    Ptr Seat ->                             -- seat : TInterface (Name {namespace = "Gdk", name = "Seat"})
    IO ()

-- | Releases a grab added through 'GI.Gdk.Objects.Seat.seatGrab'.
-- 
-- /Since: 3.20/
seatUngrab ::
    (B.CallStack.HasCallStack, MonadIO m, IsSeat a) =>
    a
    -- ^ /@seat@/: a t'GI.Gdk.Objects.Seat.Seat'
    -> m ()
seatUngrab seat = liftIO $ do
    seat' <- unsafeManagedPtrCastPtr seat
    gdk_seat_ungrab seat'
    touchManagedPtr seat
    return ()

#if defined(ENABLE_OVERLOADING)
data SeatUngrabMethodInfo
instance (signature ~ (m ()), MonadIO m, IsSeat a) => O.OverloadedMethod SeatUngrabMethodInfo a signature where
    overloadedMethod = seatUngrab

instance O.OverloadedMethodInfo SeatUngrabMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Seat.seatUngrab",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Seat.html#v:seatUngrab"
        })


#endif


