{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- An opaque type representing a list of files.
-- 
-- /Since: 4.6/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gdk.Structs.FileList
    ( 

-- * Exported types
    FileList(..)                            ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- /None/.
-- 
-- ==== Getters
-- [getFiles]("GI.Gdk.Structs.FileList#g:method:getFiles").
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolveFileListMethod                   ,
#endif

-- ** getFiles #method:getFiles#

#if defined(ENABLE_OVERLOADING)
    FileListGetFilesMethodInfo              ,
#endif
    fileListGetFiles                        ,


-- ** newFromArray #method:newFromArray#

    fileListNewFromArray                    ,


-- ** newFromList #method:newFromList#

    fileListNewFromList                     ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Gio.Interfaces.File as Gio.File

#else
import qualified GI.Gio.Interfaces.File as Gio.File

#endif

-- | Memory-managed wrapper type.
newtype FileList = FileList (SP.ManagedPtr FileList)
    deriving (Eq)

instance SP.ManagedPtrNewtype FileList where
    toManagedPtr (FileList p) = p

foreign import ccall "gdk_file_list_get_type" c_gdk_file_list_get_type :: 
    IO GType

type instance O.ParentTypes FileList = '[]
instance O.HasParentTypes FileList

instance B.Types.TypedObject FileList where
    glibType = c_gdk_file_list_get_type

instance B.Types.GBoxed FileList

-- | Convert t'FileList' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe FileList) where
    gvalueGType_ = c_gdk_file_list_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_boxed gv (FP.nullPtr :: FP.Ptr FileList)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_boxed gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_boxed gv :: IO (Ptr FileList)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newBoxed FileList ptr
        else return P.Nothing
        
    


#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList FileList
type instance O.AttributeList FileList = FileListAttributeList
type FileListAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

-- method FileList::new_from_array
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "files"
--           , argType =
--               TCArray
--                 False
--                 (-1)
--                 1
--                 (TInterface Name { namespace = "Gio" , name = "File" })
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the files to add to the list"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n_files"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the number of files in the array"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "n_files"
--              , argType = TBasicType TSize
--              , direction = DirectionIn
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText = Just "the number of files in the array"
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferNothing
--              }
--          ]
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "FileList" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_file_list_new_from_array" gdk_file_list_new_from_array :: 
    Ptr (Ptr Gio.File.File) ->              -- files : TCArray False (-1) 1 (TInterface (Name {namespace = "Gio", name = "File"}))
    FCT.CSize ->                            -- n_files : TBasicType TSize
    IO (Ptr FileList)

-- | Creates a new @GdkFileList@ for the given array of files.
-- 
-- This function is meant to be used by language bindings.
-- 
-- /Since: 4.8/
fileListNewFromArray ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    [Gio.File.File]
    -- ^ /@files@/: the files to add to the list
    -> m FileList
    -- ^ __Returns:__ the newly create files list
fileListNewFromArray files = liftIO $ do
    let nFiles = fromIntegral $ P.length files
    files' <- mapM unsafeManagedPtrCastPtr files
    files'' <- packPtrArray files'
    result <- gdk_file_list_new_from_array files'' nFiles
    checkUnexpectedReturnNULL "fileListNewFromArray" result
    result' <- (wrapBoxed FileList) result
    mapM_ touchManagedPtr files
    freeMem files''
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method FileList::new_from_list
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "files"
--           , argType =
--               TGSList (TInterface Name { namespace = "Gio" , name = "File" })
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a list of files" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "FileList" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_file_list_new_from_list" gdk_file_list_new_from_list :: 
    Ptr (GSList (Ptr Gio.File.File)) ->     -- files : TGSList (TInterface (Name {namespace = "Gio", name = "File"}))
    IO (Ptr FileList)

-- | Creates a new files list container from a singly linked list of
-- @GFile@ instances.
-- 
-- This function is meant to be used by language bindings
-- 
-- /Since: 4.8/
fileListNewFromList ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.File.IsFile a) =>
    [a]
    -- ^ /@files@/: a list of files
    -> m FileList
    -- ^ __Returns:__ the newly created files list
fileListNewFromList files = liftIO $ do
    files' <- mapM unsafeManagedPtrCastPtr files
    files'' <- packGSList files'
    result <- gdk_file_list_new_from_list files''
    checkUnexpectedReturnNULL "fileListNewFromList" result
    result' <- (wrapBoxed FileList) result
    mapM_ touchManagedPtr files
    g_slist_free files''
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method FileList::get_files
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "file_list"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "FileList" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the file list" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TGSList (TInterface Name { namespace = "Gio" , name = "File" }))
-- throws : False
-- Skip return : False

foreign import ccall "gdk_file_list_get_files" gdk_file_list_get_files :: 
    Ptr FileList ->                         -- file_list : TInterface (Name {namespace = "Gdk", name = "FileList"})
    IO (Ptr (GSList (Ptr Gio.File.File)))

-- | Retrieves the list of files inside a @GdkFileList@.
-- 
-- This function is meant for language bindings.
-- 
-- /Since: 4.6/
fileListGetFiles ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FileList
    -- ^ /@fileList@/: the file list
    -> m [Gio.File.File]
    -- ^ __Returns:__ the files inside the list
fileListGetFiles fileList = liftIO $ do
    fileList' <- unsafeManagedPtrGetPtr fileList
    result <- gdk_file_list_get_files fileList'
    result' <- unpackGSList result
    result'' <- mapM (newObject Gio.File.File) result'
    g_slist_free result
    touchManagedPtr fileList
    return result''

#if defined(ENABLE_OVERLOADING)
data FileListGetFilesMethodInfo
instance (signature ~ (m [Gio.File.File]), MonadIO m) => O.OverloadedMethod FileListGetFilesMethodInfo FileList signature where
    overloadedMethod = fileListGetFiles

instance O.OverloadedMethodInfo FileListGetFilesMethodInfo FileList where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.FileList.fileListGetFiles",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Structs-FileList.html#v:fileListGetFiles"
        })


#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveFileListMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveFileListMethod "getFiles" o = FileListGetFilesMethodInfo
    ResolveFileListMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveFileListMethod t FileList, O.OverloadedMethod info FileList p) => OL.IsLabel t (FileList -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveFileListMethod t FileList, O.OverloadedMethod info FileList p, R.HasField t FileList p) => R.HasField t FileList p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveFileListMethod t FileList, O.OverloadedMethodInfo info FileList) => OL.IsLabel t (O.MethodProxy info FileList) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


