{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Represents the individual outputs that are associated with a @GdkDisplay@.
-- 
-- @GdkDisplay@ keeps a @GListModel@ to enumerate and monitor
-- monitors with 'GI.Gdk.Objects.Display.displayGetMonitors'. You can use
-- 'GI.Gdk.Objects.Display.displayGetMonitorAtSurface' to find a particular
-- monitor.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gdk.Objects.Monitor
    ( 

-- * Exported types
    Monitor(..)                             ,
    IsMonitor                               ,
    toMonitor                               ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isValid]("GI.Gdk.Objects.Monitor#g:method:isValid"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getConnector]("GI.Gdk.Objects.Monitor#g:method:getConnector"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDescription]("GI.Gdk.Objects.Monitor#g:method:getDescription"), [getDisplay]("GI.Gdk.Objects.Monitor#g:method:getDisplay"), [getGeometry]("GI.Gdk.Objects.Monitor#g:method:getGeometry"), [getHeightMm]("GI.Gdk.Objects.Monitor#g:method:getHeightMm"), [getManufacturer]("GI.Gdk.Objects.Monitor#g:method:getManufacturer"), [getModel]("GI.Gdk.Objects.Monitor#g:method:getModel"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRefreshRate]("GI.Gdk.Objects.Monitor#g:method:getRefreshRate"), [getScale]("GI.Gdk.Objects.Monitor#g:method:getScale"), [getScaleFactor]("GI.Gdk.Objects.Monitor#g:method:getScaleFactor"), [getSubpixelLayout]("GI.Gdk.Objects.Monitor#g:method:getSubpixelLayout"), [getWidthMm]("GI.Gdk.Objects.Monitor#g:method:getWidthMm").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveMonitorMethod                    ,
#endif

-- ** getConnector #method:getConnector#

#if defined(ENABLE_OVERLOADING)
    MonitorGetConnectorMethodInfo           ,
#endif
    monitorGetConnector                     ,


-- ** getDescription #method:getDescription#

#if defined(ENABLE_OVERLOADING)
    MonitorGetDescriptionMethodInfo         ,
#endif
    monitorGetDescription                   ,


-- ** getDisplay #method:getDisplay#

#if defined(ENABLE_OVERLOADING)
    MonitorGetDisplayMethodInfo             ,
#endif
    monitorGetDisplay                       ,


-- ** getGeometry #method:getGeometry#

#if defined(ENABLE_OVERLOADING)
    MonitorGetGeometryMethodInfo            ,
#endif
    monitorGetGeometry                      ,


-- ** getHeightMm #method:getHeightMm#

#if defined(ENABLE_OVERLOADING)
    MonitorGetHeightMmMethodInfo            ,
#endif
    monitorGetHeightMm                      ,


-- ** getManufacturer #method:getManufacturer#

#if defined(ENABLE_OVERLOADING)
    MonitorGetManufacturerMethodInfo        ,
#endif
    monitorGetManufacturer                  ,


-- ** getModel #method:getModel#

#if defined(ENABLE_OVERLOADING)
    MonitorGetModelMethodInfo               ,
#endif
    monitorGetModel                         ,


-- ** getRefreshRate #method:getRefreshRate#

#if defined(ENABLE_OVERLOADING)
    MonitorGetRefreshRateMethodInfo         ,
#endif
    monitorGetRefreshRate                   ,


-- ** getScale #method:getScale#

#if defined(ENABLE_OVERLOADING)
    MonitorGetScaleMethodInfo               ,
#endif
    monitorGetScale                         ,


-- ** getScaleFactor #method:getScaleFactor#

#if defined(ENABLE_OVERLOADING)
    MonitorGetScaleFactorMethodInfo         ,
#endif
    monitorGetScaleFactor                   ,


-- ** getSubpixelLayout #method:getSubpixelLayout#

#if defined(ENABLE_OVERLOADING)
    MonitorGetSubpixelLayoutMethodInfo      ,
#endif
    monitorGetSubpixelLayout                ,


-- ** getWidthMm #method:getWidthMm#

#if defined(ENABLE_OVERLOADING)
    MonitorGetWidthMmMethodInfo             ,
#endif
    monitorGetWidthMm                       ,


-- ** isValid #method:isValid#

#if defined(ENABLE_OVERLOADING)
    MonitorIsValidMethodInfo                ,
#endif
    monitorIsValid                          ,




 -- * Properties


-- ** connector #attr:connector#
-- | The connector name.

#if defined(ENABLE_OVERLOADING)
    MonitorConnectorPropertyInfo            ,
#endif
    getMonitorConnector                     ,
#if defined(ENABLE_OVERLOADING)
    monitorConnector                        ,
#endif


-- ** description #attr:description#
-- | A short description of the monitor, meant for display to the user.
-- 
-- /Since: 4.10/

#if defined(ENABLE_OVERLOADING)
    MonitorDescriptionPropertyInfo          ,
#endif
    getMonitorDescription                   ,
#if defined(ENABLE_OVERLOADING)
    monitorDescription                      ,
#endif


-- ** display #attr:display#
-- | The @GdkDisplay@ of the monitor.

#if defined(ENABLE_OVERLOADING)
    MonitorDisplayPropertyInfo              ,
#endif
    constructMonitorDisplay                 ,
    getMonitorDisplay                       ,
#if defined(ENABLE_OVERLOADING)
    monitorDisplay                          ,
#endif


-- ** geometry #attr:geometry#
-- | The geometry of the monitor.

#if defined(ENABLE_OVERLOADING)
    MonitorGeometryPropertyInfo             ,
#endif
    getMonitorGeometry                      ,
#if defined(ENABLE_OVERLOADING)
    monitorGeometry                         ,
#endif


-- ** heightMm #attr:heightMm#
-- | The height of the monitor, in millimeters.

#if defined(ENABLE_OVERLOADING)
    MonitorHeightMmPropertyInfo             ,
#endif
    getMonitorHeightMm                      ,
#if defined(ENABLE_OVERLOADING)
    monitorHeightMm                         ,
#endif


-- ** manufacturer #attr:manufacturer#
-- | The manufacturer name.

#if defined(ENABLE_OVERLOADING)
    MonitorManufacturerPropertyInfo         ,
#endif
    getMonitorManufacturer                  ,
#if defined(ENABLE_OVERLOADING)
    monitorManufacturer                     ,
#endif


-- ** model #attr:model#
-- | The model name.

#if defined(ENABLE_OVERLOADING)
    MonitorModelPropertyInfo                ,
#endif
    getMonitorModel                         ,
#if defined(ENABLE_OVERLOADING)
    monitorModel                            ,
#endif


-- ** refreshRate #attr:refreshRate#
-- | The refresh rate, in milli-Hertz.

#if defined(ENABLE_OVERLOADING)
    MonitorRefreshRatePropertyInfo          ,
#endif
    getMonitorRefreshRate                   ,
#if defined(ENABLE_OVERLOADING)
    monitorRefreshRate                      ,
#endif


-- ** scale #attr:scale#
-- | The scale of the monitor.
-- 
-- /Since: 4.14/

#if defined(ENABLE_OVERLOADING)
    MonitorScalePropertyInfo                ,
#endif
    getMonitorScale                         ,
#if defined(ENABLE_OVERLOADING)
    monitorScale                            ,
#endif


-- ** scaleFactor #attr:scaleFactor#
-- | The scale factor.
-- 
-- The scale factor is the next larger integer,
-- compared to [Surface:scale]("GI.Gdk.Objects.Surface#g:attr:scale").

#if defined(ENABLE_OVERLOADING)
    MonitorScaleFactorPropertyInfo          ,
#endif
    getMonitorScaleFactor                   ,
#if defined(ENABLE_OVERLOADING)
    monitorScaleFactor                      ,
#endif


-- ** subpixelLayout #attr:subpixelLayout#
-- | The subpixel layout.

#if defined(ENABLE_OVERLOADING)
    MonitorSubpixelLayoutPropertyInfo       ,
#endif
    getMonitorSubpixelLayout                ,
#if defined(ENABLE_OVERLOADING)
    monitorSubpixelLayout                   ,
#endif


-- ** valid #attr:valid#
-- | Whether the object is still valid.

#if defined(ENABLE_OVERLOADING)
    MonitorValidPropertyInfo                ,
#endif
    getMonitorValid                         ,
#if defined(ENABLE_OVERLOADING)
    monitorValid                            ,
#endif


-- ** widthMm #attr:widthMm#
-- | The width of the monitor, in millimeters.

#if defined(ENABLE_OVERLOADING)
    MonitorWidthMmPropertyInfo              ,
#endif
    getMonitorWidthMm                       ,
#if defined(ENABLE_OVERLOADING)
    monitorWidthMm                          ,
#endif




 -- * Signals


-- ** invalidate #signal:invalidate#

    MonitorInvalidateCallback               ,
#if defined(ENABLE_OVERLOADING)
    MonitorInvalidateSignalInfo             ,
#endif
    afterMonitorInvalidate                  ,
    onMonitorInvalidate                     ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Enums as Cairo.Enums
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.Region as Cairo.Region
import qualified GI.Cairo.Structs.Surface as Cairo.Surface
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GLib.Structs.String as GLib.String
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Callbacks as Gdk.Callbacks
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Flags as Gdk.Flags
import {-# SOURCE #-} qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import {-# SOURCE #-} qualified GI.Gdk.Objects.AppLaunchContext as Gdk.AppLaunchContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.CairoContext as Gdk.CairoContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.CicpParams as Gdk.CicpParams
import {-# SOURCE #-} qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import {-# SOURCE #-} qualified GI.Gdk.Objects.ContentProvider as Gdk.ContentProvider
import {-# SOURCE #-} qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Device as Gdk.Device
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceTool as Gdk.DeviceTool
import {-# SOURCE #-} qualified GI.Gdk.Objects.Display as Gdk.Display
import {-# SOURCE #-} qualified GI.Gdk.Objects.DrawContext as Gdk.DrawContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Event as Gdk.Event
import {-# SOURCE #-} qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import {-# SOURCE #-} qualified GI.Gdk.Objects.GLContext as Gdk.GLContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Seat as Gdk.Seat
import {-# SOURCE #-} qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import {-# SOURCE #-} qualified GI.Gdk.Objects.Surface as Gdk.Surface
import {-# SOURCE #-} qualified GI.Gdk.Objects.Texture as Gdk.Texture
import {-# SOURCE #-} qualified GI.Gdk.Objects.VulkanContext as Gdk.VulkanContext
import {-# SOURCE #-} qualified GI.Gdk.Structs.ColorState as Gdk.ColorState
import {-# SOURCE #-} qualified GI.Gdk.Structs.ContentFormats as Gdk.ContentFormats
import {-# SOURCE #-} qualified GI.Gdk.Structs.DmabufFormats as Gdk.DmabufFormats
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSequence as Gdk.EventSequence
import {-# SOURCE #-} qualified GI.Gdk.Structs.FrameTimings as Gdk.FrameTimings
import {-# SOURCE #-} qualified GI.Gdk.Structs.KeymapKey as Gdk.KeymapKey
import {-# SOURCE #-} qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import {-# SOURCE #-} qualified GI.Gdk.Structs.TimeCoord as Gdk.TimeCoord
import qualified GI.GdkPixbuf.Objects.Pixbuf as GdkPixbuf.Pixbuf
import qualified GI.Gio.Callbacks as Gio.Callbacks
import qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import qualified GI.Gio.Interfaces.File as Gio.File
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Gio.Interfaces.LoadableIcon as Gio.LoadableIcon
import qualified GI.Gio.Objects.AppLaunchContext as Gio.AppLaunchContext
import qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import qualified GI.Gio.Objects.InputStream as Gio.InputStream
import qualified GI.Gio.Objects.OutputStream as Gio.OutputStream
import qualified GI.Pango.Enums as Pango.Enums

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Objects.Display as Gdk.Display
import {-# SOURCE #-} qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle

#endif

-- | Memory-managed wrapper type.
newtype Monitor = Monitor (SP.ManagedPtr Monitor)
    deriving (Eq)

instance SP.ManagedPtrNewtype Monitor where
    toManagedPtr (Monitor p) = p

foreign import ccall "gdk_monitor_get_type"
    c_gdk_monitor_get_type :: IO B.Types.GType

instance B.Types.TypedObject Monitor where
    glibType = c_gdk_monitor_get_type

instance B.Types.GObject Monitor

-- | Type class for types which can be safely cast to t'Monitor', for instance with `toMonitor`.
class (SP.GObject o, O.IsDescendantOf Monitor o) => IsMonitor o
instance (SP.GObject o, O.IsDescendantOf Monitor o) => IsMonitor o

instance O.HasParentTypes Monitor
type instance O.ParentTypes Monitor = '[GObject.Object.Object]

-- | Cast to t'Monitor', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toMonitor :: (MIO.MonadIO m, IsMonitor o) => o -> m Monitor
toMonitor = MIO.liftIO . B.ManagedPtr.unsafeCastTo Monitor

-- | Convert t'Monitor' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe Monitor) where
    gvalueGType_ = c_gdk_monitor_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr Monitor)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr Monitor)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject Monitor ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveMonitorMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveMonitorMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveMonitorMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveMonitorMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveMonitorMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveMonitorMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveMonitorMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveMonitorMethod "isValid" o = MonitorIsValidMethodInfo
    ResolveMonitorMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveMonitorMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveMonitorMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveMonitorMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveMonitorMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveMonitorMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveMonitorMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveMonitorMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveMonitorMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveMonitorMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveMonitorMethod "getConnector" o = MonitorGetConnectorMethodInfo
    ResolveMonitorMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveMonitorMethod "getDescription" o = MonitorGetDescriptionMethodInfo
    ResolveMonitorMethod "getDisplay" o = MonitorGetDisplayMethodInfo
    ResolveMonitorMethod "getGeometry" o = MonitorGetGeometryMethodInfo
    ResolveMonitorMethod "getHeightMm" o = MonitorGetHeightMmMethodInfo
    ResolveMonitorMethod "getManufacturer" o = MonitorGetManufacturerMethodInfo
    ResolveMonitorMethod "getModel" o = MonitorGetModelMethodInfo
    ResolveMonitorMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveMonitorMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveMonitorMethod "getRefreshRate" o = MonitorGetRefreshRateMethodInfo
    ResolveMonitorMethod "getScale" o = MonitorGetScaleMethodInfo
    ResolveMonitorMethod "getScaleFactor" o = MonitorGetScaleFactorMethodInfo
    ResolveMonitorMethod "getSubpixelLayout" o = MonitorGetSubpixelLayoutMethodInfo
    ResolveMonitorMethod "getWidthMm" o = MonitorGetWidthMmMethodInfo
    ResolveMonitorMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveMonitorMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveMonitorMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveMonitorMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveMonitorMethod t Monitor, O.OverloadedMethod info Monitor p) => OL.IsLabel t (Monitor -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveMonitorMethod t Monitor, O.OverloadedMethod info Monitor p, R.HasField t Monitor p) => R.HasField t Monitor p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveMonitorMethod t Monitor, O.OverloadedMethodInfo info Monitor) => OL.IsLabel t (O.MethodProxy info Monitor) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- signal Monitor::invalidate
-- | Emitted when the output represented by /@monitor@/ gets disconnected.
type MonitorInvalidateCallback =
    IO ()

type C_MonitorInvalidateCallback =
    Ptr Monitor ->                          -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_MonitorInvalidateCallback`.
foreign import ccall "wrapper"
    mk_MonitorInvalidateCallback :: C_MonitorInvalidateCallback -> IO (FunPtr C_MonitorInvalidateCallback)

wrap_MonitorInvalidateCallback :: 
    GObject a => (a -> MonitorInvalidateCallback) ->
    C_MonitorInvalidateCallback
wrap_MonitorInvalidateCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [invalidate](#signal:invalidate) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' monitor #invalidate callback
-- @
-- 
-- 
onMonitorInvalidate :: (IsMonitor a, MonadIO m) => a -> ((?self :: a) => MonitorInvalidateCallback) -> m SignalHandlerId
onMonitorInvalidate obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_MonitorInvalidateCallback wrapped
    wrapped'' <- mk_MonitorInvalidateCallback wrapped'
    connectSignalFunPtr obj "invalidate" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [invalidate](#signal:invalidate) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' monitor #invalidate callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterMonitorInvalidate :: (IsMonitor a, MonadIO m) => a -> ((?self :: a) => MonitorInvalidateCallback) -> m SignalHandlerId
afterMonitorInvalidate obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_MonitorInvalidateCallback wrapped
    wrapped'' <- mk_MonitorInvalidateCallback wrapped'
    connectSignalFunPtr obj "invalidate" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data MonitorInvalidateSignalInfo
instance SignalInfo MonitorInvalidateSignalInfo where
    type HaskellCallbackType MonitorInvalidateSignalInfo = MonitorInvalidateCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_MonitorInvalidateCallback cb
        cb'' <- mk_MonitorInvalidateCallback cb'
        connectSignalFunPtr obj "invalidate" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Monitor::invalidate"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Monitor.html#g:signal:invalidate"})

#endif

-- VVV Prop "connector"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable]
   -- Nullable: (Just True,Nothing)

-- | Get the value of the “@connector@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' monitor #connector
-- @
getMonitorConnector :: (MonadIO m, IsMonitor o) => o -> m (Maybe T.Text)
getMonitorConnector obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "connector"

#if defined(ENABLE_OVERLOADING)
data MonitorConnectorPropertyInfo
instance AttrInfo MonitorConnectorPropertyInfo where
    type AttrAllowedOps MonitorConnectorPropertyInfo = '[ 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint MonitorConnectorPropertyInfo = IsMonitor
    type AttrSetTypeConstraint MonitorConnectorPropertyInfo = (~) ()
    type AttrTransferTypeConstraint MonitorConnectorPropertyInfo = (~) ()
    type AttrTransferType MonitorConnectorPropertyInfo = ()
    type AttrGetType MonitorConnectorPropertyInfo = (Maybe T.Text)
    type AttrLabel MonitorConnectorPropertyInfo = "connector"
    type AttrOrigin MonitorConnectorPropertyInfo = Monitor
    attrGet = getMonitorConnector
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Monitor.connector"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Monitor.html#g:attr:connector"
        })
#endif

-- VVV Prop "description"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable]
   -- Nullable: (Just True,Nothing)

-- | Get the value of the “@description@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' monitor #description
-- @
getMonitorDescription :: (MonadIO m, IsMonitor o) => o -> m (Maybe T.Text)
getMonitorDescription obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "description"

#if defined(ENABLE_OVERLOADING)
data MonitorDescriptionPropertyInfo
instance AttrInfo MonitorDescriptionPropertyInfo where
    type AttrAllowedOps MonitorDescriptionPropertyInfo = '[ 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint MonitorDescriptionPropertyInfo = IsMonitor
    type AttrSetTypeConstraint MonitorDescriptionPropertyInfo = (~) ()
    type AttrTransferTypeConstraint MonitorDescriptionPropertyInfo = (~) ()
    type AttrTransferType MonitorDescriptionPropertyInfo = ()
    type AttrGetType MonitorDescriptionPropertyInfo = (Maybe T.Text)
    type AttrLabel MonitorDescriptionPropertyInfo = "description"
    type AttrOrigin MonitorDescriptionPropertyInfo = Monitor
    attrGet = getMonitorDescription
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Monitor.description"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Monitor.html#g:attr:description"
        })
#endif

-- VVV Prop "display"
   -- Type: TInterface (Name {namespace = "Gdk", name = "Display"})
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@display@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' monitor #display
-- @
getMonitorDisplay :: (MonadIO m, IsMonitor o) => o -> m Gdk.Display.Display
getMonitorDisplay obj = MIO.liftIO $ checkUnexpectedNothing "getMonitorDisplay" $ B.Properties.getObjectPropertyObject obj "display" Gdk.Display.Display

-- | Construct a t'GValueConstruct' with valid value for the “@display@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructMonitorDisplay :: (IsMonitor o, MIO.MonadIO m, Gdk.Display.IsDisplay a) => a -> m (GValueConstruct o)
constructMonitorDisplay val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "display" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data MonitorDisplayPropertyInfo
instance AttrInfo MonitorDisplayPropertyInfo where
    type AttrAllowedOps MonitorDisplayPropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint MonitorDisplayPropertyInfo = IsMonitor
    type AttrSetTypeConstraint MonitorDisplayPropertyInfo = Gdk.Display.IsDisplay
    type AttrTransferTypeConstraint MonitorDisplayPropertyInfo = Gdk.Display.IsDisplay
    type AttrTransferType MonitorDisplayPropertyInfo = Gdk.Display.Display
    type AttrGetType MonitorDisplayPropertyInfo = Gdk.Display.Display
    type AttrLabel MonitorDisplayPropertyInfo = "display"
    type AttrOrigin MonitorDisplayPropertyInfo = Monitor
    attrGet = getMonitorDisplay
    attrSet = undefined
    attrTransfer _ v = do
        unsafeCastTo Gdk.Display.Display v
    attrConstruct = constructMonitorDisplay
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Monitor.display"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Monitor.html#g:attr:display"
        })
#endif

-- VVV Prop "geometry"
   -- Type: TInterface (Name {namespace = "Gdk", name = "Rectangle"})
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@geometry@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' monitor #geometry
-- @
getMonitorGeometry :: (MonadIO m, IsMonitor o) => o -> m (Maybe Gdk.Rectangle.Rectangle)
getMonitorGeometry obj = MIO.liftIO $ B.Properties.getObjectPropertyBoxed obj "geometry" Gdk.Rectangle.Rectangle

#if defined(ENABLE_OVERLOADING)
data MonitorGeometryPropertyInfo
instance AttrInfo MonitorGeometryPropertyInfo where
    type AttrAllowedOps MonitorGeometryPropertyInfo = '[ 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint MonitorGeometryPropertyInfo = IsMonitor
    type AttrSetTypeConstraint MonitorGeometryPropertyInfo = (~) ()
    type AttrTransferTypeConstraint MonitorGeometryPropertyInfo = (~) ()
    type AttrTransferType MonitorGeometryPropertyInfo = ()
    type AttrGetType MonitorGeometryPropertyInfo = (Maybe Gdk.Rectangle.Rectangle)
    type AttrLabel MonitorGeometryPropertyInfo = "geometry"
    type AttrOrigin MonitorGeometryPropertyInfo = Monitor
    attrGet = getMonitorGeometry
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Monitor.geometry"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Monitor.html#g:attr:geometry"
        })
#endif

-- VVV Prop "height-mm"
   -- Type: TBasicType TInt
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@height-mm@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' monitor #heightMm
-- @
getMonitorHeightMm :: (MonadIO m, IsMonitor o) => o -> m Int32
getMonitorHeightMm obj = MIO.liftIO $ B.Properties.getObjectPropertyInt32 obj "height-mm"

#if defined(ENABLE_OVERLOADING)
data MonitorHeightMmPropertyInfo
instance AttrInfo MonitorHeightMmPropertyInfo where
    type AttrAllowedOps MonitorHeightMmPropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint MonitorHeightMmPropertyInfo = IsMonitor
    type AttrSetTypeConstraint MonitorHeightMmPropertyInfo = (~) ()
    type AttrTransferTypeConstraint MonitorHeightMmPropertyInfo = (~) ()
    type AttrTransferType MonitorHeightMmPropertyInfo = ()
    type AttrGetType MonitorHeightMmPropertyInfo = Int32
    type AttrLabel MonitorHeightMmPropertyInfo = "height-mm"
    type AttrOrigin MonitorHeightMmPropertyInfo = Monitor
    attrGet = getMonitorHeightMm
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Monitor.heightMm"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Monitor.html#g:attr:heightMm"
        })
#endif

-- VVV Prop "manufacturer"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable]
   -- Nullable: (Just True,Nothing)

-- | Get the value of the “@manufacturer@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' monitor #manufacturer
-- @
getMonitorManufacturer :: (MonadIO m, IsMonitor o) => o -> m (Maybe T.Text)
getMonitorManufacturer obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "manufacturer"

#if defined(ENABLE_OVERLOADING)
data MonitorManufacturerPropertyInfo
instance AttrInfo MonitorManufacturerPropertyInfo where
    type AttrAllowedOps MonitorManufacturerPropertyInfo = '[ 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint MonitorManufacturerPropertyInfo = IsMonitor
    type AttrSetTypeConstraint MonitorManufacturerPropertyInfo = (~) ()
    type AttrTransferTypeConstraint MonitorManufacturerPropertyInfo = (~) ()
    type AttrTransferType MonitorManufacturerPropertyInfo = ()
    type AttrGetType MonitorManufacturerPropertyInfo = (Maybe T.Text)
    type AttrLabel MonitorManufacturerPropertyInfo = "manufacturer"
    type AttrOrigin MonitorManufacturerPropertyInfo = Monitor
    attrGet = getMonitorManufacturer
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Monitor.manufacturer"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Monitor.html#g:attr:manufacturer"
        })
#endif

-- VVV Prop "model"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable]
   -- Nullable: (Just True,Nothing)

-- | Get the value of the “@model@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' monitor #model
-- @
getMonitorModel :: (MonadIO m, IsMonitor o) => o -> m (Maybe T.Text)
getMonitorModel obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "model"

#if defined(ENABLE_OVERLOADING)
data MonitorModelPropertyInfo
instance AttrInfo MonitorModelPropertyInfo where
    type AttrAllowedOps MonitorModelPropertyInfo = '[ 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint MonitorModelPropertyInfo = IsMonitor
    type AttrSetTypeConstraint MonitorModelPropertyInfo = (~) ()
    type AttrTransferTypeConstraint MonitorModelPropertyInfo = (~) ()
    type AttrTransferType MonitorModelPropertyInfo = ()
    type AttrGetType MonitorModelPropertyInfo = (Maybe T.Text)
    type AttrLabel MonitorModelPropertyInfo = "model"
    type AttrOrigin MonitorModelPropertyInfo = Monitor
    attrGet = getMonitorModel
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Monitor.model"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Monitor.html#g:attr:model"
        })
#endif

-- VVV Prop "refresh-rate"
   -- Type: TBasicType TInt
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@refresh-rate@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' monitor #refreshRate
-- @
getMonitorRefreshRate :: (MonadIO m, IsMonitor o) => o -> m Int32
getMonitorRefreshRate obj = MIO.liftIO $ B.Properties.getObjectPropertyInt32 obj "refresh-rate"

#if defined(ENABLE_OVERLOADING)
data MonitorRefreshRatePropertyInfo
instance AttrInfo MonitorRefreshRatePropertyInfo where
    type AttrAllowedOps MonitorRefreshRatePropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint MonitorRefreshRatePropertyInfo = IsMonitor
    type AttrSetTypeConstraint MonitorRefreshRatePropertyInfo = (~) ()
    type AttrTransferTypeConstraint MonitorRefreshRatePropertyInfo = (~) ()
    type AttrTransferType MonitorRefreshRatePropertyInfo = ()
    type AttrGetType MonitorRefreshRatePropertyInfo = Int32
    type AttrLabel MonitorRefreshRatePropertyInfo = "refresh-rate"
    type AttrOrigin MonitorRefreshRatePropertyInfo = Monitor
    attrGet = getMonitorRefreshRate
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Monitor.refreshRate"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Monitor.html#g:attr:refreshRate"
        })
#endif

-- VVV Prop "scale"
   -- Type: TBasicType TDouble
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@scale@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' monitor #scale
-- @
getMonitorScale :: (MonadIO m, IsMonitor o) => o -> m Double
getMonitorScale obj = MIO.liftIO $ B.Properties.getObjectPropertyDouble obj "scale"

#if defined(ENABLE_OVERLOADING)
data MonitorScalePropertyInfo
instance AttrInfo MonitorScalePropertyInfo where
    type AttrAllowedOps MonitorScalePropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint MonitorScalePropertyInfo = IsMonitor
    type AttrSetTypeConstraint MonitorScalePropertyInfo = (~) ()
    type AttrTransferTypeConstraint MonitorScalePropertyInfo = (~) ()
    type AttrTransferType MonitorScalePropertyInfo = ()
    type AttrGetType MonitorScalePropertyInfo = Double
    type AttrLabel MonitorScalePropertyInfo = "scale"
    type AttrOrigin MonitorScalePropertyInfo = Monitor
    attrGet = getMonitorScale
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Monitor.scale"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Monitor.html#g:attr:scale"
        })
#endif

-- VVV Prop "scale-factor"
   -- Type: TBasicType TInt
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@scale-factor@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' monitor #scaleFactor
-- @
getMonitorScaleFactor :: (MonadIO m, IsMonitor o) => o -> m Int32
getMonitorScaleFactor obj = MIO.liftIO $ B.Properties.getObjectPropertyInt32 obj "scale-factor"

#if defined(ENABLE_OVERLOADING)
data MonitorScaleFactorPropertyInfo
instance AttrInfo MonitorScaleFactorPropertyInfo where
    type AttrAllowedOps MonitorScaleFactorPropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint MonitorScaleFactorPropertyInfo = IsMonitor
    type AttrSetTypeConstraint MonitorScaleFactorPropertyInfo = (~) ()
    type AttrTransferTypeConstraint MonitorScaleFactorPropertyInfo = (~) ()
    type AttrTransferType MonitorScaleFactorPropertyInfo = ()
    type AttrGetType MonitorScaleFactorPropertyInfo = Int32
    type AttrLabel MonitorScaleFactorPropertyInfo = "scale-factor"
    type AttrOrigin MonitorScaleFactorPropertyInfo = Monitor
    attrGet = getMonitorScaleFactor
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Monitor.scaleFactor"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Monitor.html#g:attr:scaleFactor"
        })
#endif

-- VVV Prop "subpixel-layout"
   -- Type: TInterface (Name {namespace = "Gdk", name = "SubpixelLayout"})
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@subpixel-layout@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' monitor #subpixelLayout
-- @
getMonitorSubpixelLayout :: (MonadIO m, IsMonitor o) => o -> m Gdk.Enums.SubpixelLayout
getMonitorSubpixelLayout obj = MIO.liftIO $ B.Properties.getObjectPropertyEnum obj "subpixel-layout"

#if defined(ENABLE_OVERLOADING)
data MonitorSubpixelLayoutPropertyInfo
instance AttrInfo MonitorSubpixelLayoutPropertyInfo where
    type AttrAllowedOps MonitorSubpixelLayoutPropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint MonitorSubpixelLayoutPropertyInfo = IsMonitor
    type AttrSetTypeConstraint MonitorSubpixelLayoutPropertyInfo = (~) ()
    type AttrTransferTypeConstraint MonitorSubpixelLayoutPropertyInfo = (~) ()
    type AttrTransferType MonitorSubpixelLayoutPropertyInfo = ()
    type AttrGetType MonitorSubpixelLayoutPropertyInfo = Gdk.Enums.SubpixelLayout
    type AttrLabel MonitorSubpixelLayoutPropertyInfo = "subpixel-layout"
    type AttrOrigin MonitorSubpixelLayoutPropertyInfo = Monitor
    attrGet = getMonitorSubpixelLayout
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Monitor.subpixelLayout"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Monitor.html#g:attr:subpixelLayout"
        })
#endif

-- VVV Prop "valid"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@valid@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' monitor #valid
-- @
getMonitorValid :: (MonadIO m, IsMonitor o) => o -> m Bool
getMonitorValid obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "valid"

#if defined(ENABLE_OVERLOADING)
data MonitorValidPropertyInfo
instance AttrInfo MonitorValidPropertyInfo where
    type AttrAllowedOps MonitorValidPropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint MonitorValidPropertyInfo = IsMonitor
    type AttrSetTypeConstraint MonitorValidPropertyInfo = (~) ()
    type AttrTransferTypeConstraint MonitorValidPropertyInfo = (~) ()
    type AttrTransferType MonitorValidPropertyInfo = ()
    type AttrGetType MonitorValidPropertyInfo = Bool
    type AttrLabel MonitorValidPropertyInfo = "valid"
    type AttrOrigin MonitorValidPropertyInfo = Monitor
    attrGet = getMonitorValid
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Monitor.valid"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Monitor.html#g:attr:valid"
        })
#endif

-- VVV Prop "width-mm"
   -- Type: TBasicType TInt
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@width-mm@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' monitor #widthMm
-- @
getMonitorWidthMm :: (MonadIO m, IsMonitor o) => o -> m Int32
getMonitorWidthMm obj = MIO.liftIO $ B.Properties.getObjectPropertyInt32 obj "width-mm"

#if defined(ENABLE_OVERLOADING)
data MonitorWidthMmPropertyInfo
instance AttrInfo MonitorWidthMmPropertyInfo where
    type AttrAllowedOps MonitorWidthMmPropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint MonitorWidthMmPropertyInfo = IsMonitor
    type AttrSetTypeConstraint MonitorWidthMmPropertyInfo = (~) ()
    type AttrTransferTypeConstraint MonitorWidthMmPropertyInfo = (~) ()
    type AttrTransferType MonitorWidthMmPropertyInfo = ()
    type AttrGetType MonitorWidthMmPropertyInfo = Int32
    type AttrLabel MonitorWidthMmPropertyInfo = "width-mm"
    type AttrOrigin MonitorWidthMmPropertyInfo = Monitor
    attrGet = getMonitorWidthMm
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Monitor.widthMm"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Monitor.html#g:attr:widthMm"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Monitor
type instance O.AttributeList Monitor = MonitorAttributeList
type MonitorAttributeList = ('[ '("connector", MonitorConnectorPropertyInfo), '("description", MonitorDescriptionPropertyInfo), '("display", MonitorDisplayPropertyInfo), '("geometry", MonitorGeometryPropertyInfo), '("heightMm", MonitorHeightMmPropertyInfo), '("manufacturer", MonitorManufacturerPropertyInfo), '("model", MonitorModelPropertyInfo), '("refreshRate", MonitorRefreshRatePropertyInfo), '("scale", MonitorScalePropertyInfo), '("scaleFactor", MonitorScaleFactorPropertyInfo), '("subpixelLayout", MonitorSubpixelLayoutPropertyInfo), '("valid", MonitorValidPropertyInfo), '("widthMm", MonitorWidthMmPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
monitorConnector :: AttrLabelProxy "connector"
monitorConnector = AttrLabelProxy

monitorDescription :: AttrLabelProxy "description"
monitorDescription = AttrLabelProxy

monitorDisplay :: AttrLabelProxy "display"
monitorDisplay = AttrLabelProxy

monitorGeometry :: AttrLabelProxy "geometry"
monitorGeometry = AttrLabelProxy

monitorHeightMm :: AttrLabelProxy "heightMm"
monitorHeightMm = AttrLabelProxy

monitorManufacturer :: AttrLabelProxy "manufacturer"
monitorManufacturer = AttrLabelProxy

monitorModel :: AttrLabelProxy "model"
monitorModel = AttrLabelProxy

monitorRefreshRate :: AttrLabelProxy "refreshRate"
monitorRefreshRate = AttrLabelProxy

monitorScale :: AttrLabelProxy "scale"
monitorScale = AttrLabelProxy

monitorScaleFactor :: AttrLabelProxy "scaleFactor"
monitorScaleFactor = AttrLabelProxy

monitorSubpixelLayout :: AttrLabelProxy "subpixelLayout"
monitorSubpixelLayout = AttrLabelProxy

monitorValid :: AttrLabelProxy "valid"
monitorValid = AttrLabelProxy

monitorWidthMm :: AttrLabelProxy "widthMm"
monitorWidthMm = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList Monitor = MonitorSignalList
type MonitorSignalList = ('[ '("invalidate", MonitorInvalidateSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method Monitor::get_connector
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "monitor"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Monitor" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkMonitor`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_monitor_get_connector" gdk_monitor_get_connector :: 
    Ptr Monitor ->                          -- monitor : TInterface (Name {namespace = "Gdk", name = "Monitor"})
    IO CString

-- | Gets the name of the monitor\'s connector, if available.
-- 
-- These are strings such as \"eDP-1\", or \"HDMI-2\". They depend
-- on software and hardware configuration, and should not be
-- relied on as stable identifiers of a specific monitor.
monitorGetConnector ::
    (B.CallStack.HasCallStack, MonadIO m, IsMonitor a) =>
    a
    -- ^ /@monitor@/: a @GdkMonitor@
    -> m (Maybe T.Text)
    -- ^ __Returns:__ the name of the connector
monitorGetConnector monitor = liftIO $ do
    monitor' <- unsafeManagedPtrCastPtr monitor
    result <- gdk_monitor_get_connector monitor'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        return result''
    touchManagedPtr monitor
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data MonitorGetConnectorMethodInfo
instance (signature ~ (m (Maybe T.Text)), MonadIO m, IsMonitor a) => O.OverloadedMethod MonitorGetConnectorMethodInfo a signature where
    overloadedMethod = monitorGetConnector

instance O.OverloadedMethodInfo MonitorGetConnectorMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Monitor.monitorGetConnector",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Monitor.html#v:monitorGetConnector"
        })


#endif

-- method Monitor::get_description
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "monitor"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Monitor" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkMonitor`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_monitor_get_description" gdk_monitor_get_description :: 
    Ptr Monitor ->                          -- monitor : TInterface (Name {namespace = "Gdk", name = "Monitor"})
    IO CString

-- | Gets a string describing the monitor, if available.
-- 
-- This can be used to identify a monitor in the UI.
-- 
-- /Since: 4.10/
monitorGetDescription ::
    (B.CallStack.HasCallStack, MonadIO m, IsMonitor a) =>
    a
    -- ^ /@monitor@/: a @GdkMonitor@
    -> m (Maybe T.Text)
    -- ^ __Returns:__ the monitor description
monitorGetDescription monitor = liftIO $ do
    monitor' <- unsafeManagedPtrCastPtr monitor
    result <- gdk_monitor_get_description monitor'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        return result''
    touchManagedPtr monitor
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data MonitorGetDescriptionMethodInfo
instance (signature ~ (m (Maybe T.Text)), MonadIO m, IsMonitor a) => O.OverloadedMethod MonitorGetDescriptionMethodInfo a signature where
    overloadedMethod = monitorGetDescription

instance O.OverloadedMethodInfo MonitorGetDescriptionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Monitor.monitorGetDescription",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Monitor.html#v:monitorGetDescription"
        })


#endif

-- method Monitor::get_display
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "monitor"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Monitor" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkMonitor`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Display" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_monitor_get_display" gdk_monitor_get_display :: 
    Ptr Monitor ->                          -- monitor : TInterface (Name {namespace = "Gdk", name = "Monitor"})
    IO (Ptr Gdk.Display.Display)

-- | Gets the display that this monitor belongs to.
monitorGetDisplay ::
    (B.CallStack.HasCallStack, MonadIO m, IsMonitor a) =>
    a
    -- ^ /@monitor@/: a @GdkMonitor@
    -> m Gdk.Display.Display
    -- ^ __Returns:__ the display
monitorGetDisplay monitor = liftIO $ do
    monitor' <- unsafeManagedPtrCastPtr monitor
    result <- gdk_monitor_get_display monitor'
    checkUnexpectedReturnNULL "monitorGetDisplay" result
    result' <- (newObject Gdk.Display.Display) result
    touchManagedPtr monitor
    return result'

#if defined(ENABLE_OVERLOADING)
data MonitorGetDisplayMethodInfo
instance (signature ~ (m Gdk.Display.Display), MonadIO m, IsMonitor a) => O.OverloadedMethod MonitorGetDisplayMethodInfo a signature where
    overloadedMethod = monitorGetDisplay

instance O.OverloadedMethodInfo MonitorGetDisplayMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Monitor.monitorGetDisplay",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Monitor.html#v:monitorGetDisplay"
        })


#endif

-- method Monitor::get_geometry
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "monitor"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Monitor" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkMonitor`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "geometry"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Rectangle" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a `GdkRectangle` to be filled with the monitor geometry"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_monitor_get_geometry" gdk_monitor_get_geometry :: 
    Ptr Monitor ->                          -- monitor : TInterface (Name {namespace = "Gdk", name = "Monitor"})
    Ptr Gdk.Rectangle.Rectangle ->          -- geometry : TInterface (Name {namespace = "Gdk", name = "Rectangle"})
    IO ()

-- | Retrieves the size and position of the monitor within the
-- display coordinate space.
-- 
-- The returned geometry is in  ”application pixels”, not in
-- ”device pixels” (see 'GI.Gdk.Objects.Monitor.monitorGetScale').
monitorGetGeometry ::
    (B.CallStack.HasCallStack, MonadIO m, IsMonitor a) =>
    a
    -- ^ /@monitor@/: a @GdkMonitor@
    -> m (Gdk.Rectangle.Rectangle)
monitorGetGeometry monitor = liftIO $ do
    monitor' <- unsafeManagedPtrCastPtr monitor
    geometry <- SP.callocBoxedBytes 16 :: IO (Ptr Gdk.Rectangle.Rectangle)
    gdk_monitor_get_geometry monitor' geometry
    geometry' <- (wrapBoxed Gdk.Rectangle.Rectangle) geometry
    touchManagedPtr monitor
    return geometry'

#if defined(ENABLE_OVERLOADING)
data MonitorGetGeometryMethodInfo
instance (signature ~ (m (Gdk.Rectangle.Rectangle)), MonadIO m, IsMonitor a) => O.OverloadedMethod MonitorGetGeometryMethodInfo a signature where
    overloadedMethod = monitorGetGeometry

instance O.OverloadedMethodInfo MonitorGetGeometryMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Monitor.monitorGetGeometry",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Monitor.html#v:monitorGetGeometry"
        })


#endif

-- method Monitor::get_height_mm
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "monitor"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Monitor" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkMonitor`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_monitor_get_height_mm" gdk_monitor_get_height_mm :: 
    Ptr Monitor ->                          -- monitor : TInterface (Name {namespace = "Gdk", name = "Monitor"})
    IO Int32

-- | Gets the height in millimeters of the monitor.
monitorGetHeightMm ::
    (B.CallStack.HasCallStack, MonadIO m, IsMonitor a) =>
    a
    -- ^ /@monitor@/: a @GdkMonitor@
    -> m Int32
    -- ^ __Returns:__ the physical height of the monitor
monitorGetHeightMm monitor = liftIO $ do
    monitor' <- unsafeManagedPtrCastPtr monitor
    result <- gdk_monitor_get_height_mm monitor'
    touchManagedPtr monitor
    return result

#if defined(ENABLE_OVERLOADING)
data MonitorGetHeightMmMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsMonitor a) => O.OverloadedMethod MonitorGetHeightMmMethodInfo a signature where
    overloadedMethod = monitorGetHeightMm

instance O.OverloadedMethodInfo MonitorGetHeightMmMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Monitor.monitorGetHeightMm",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Monitor.html#v:monitorGetHeightMm"
        })


#endif

-- method Monitor::get_manufacturer
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "monitor"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Monitor" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkMonitor`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_monitor_get_manufacturer" gdk_monitor_get_manufacturer :: 
    Ptr Monitor ->                          -- monitor : TInterface (Name {namespace = "Gdk", name = "Monitor"})
    IO CString

-- | Gets the name or PNP ID of the monitor\'s manufacturer.
-- 
-- Note that this value might also vary depending on actual
-- display backend.
-- 
-- The PNP ID registry is located at
-- <https://uefi.org/pnp_id_list https://uefi.org/pnp_id_list>.
monitorGetManufacturer ::
    (B.CallStack.HasCallStack, MonadIO m, IsMonitor a) =>
    a
    -- ^ /@monitor@/: a @GdkMonitor@
    -> m (Maybe T.Text)
    -- ^ __Returns:__ the name of the manufacturer
monitorGetManufacturer monitor = liftIO $ do
    monitor' <- unsafeManagedPtrCastPtr monitor
    result <- gdk_monitor_get_manufacturer monitor'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        return result''
    touchManagedPtr monitor
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data MonitorGetManufacturerMethodInfo
instance (signature ~ (m (Maybe T.Text)), MonadIO m, IsMonitor a) => O.OverloadedMethod MonitorGetManufacturerMethodInfo a signature where
    overloadedMethod = monitorGetManufacturer

instance O.OverloadedMethodInfo MonitorGetManufacturerMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Monitor.monitorGetManufacturer",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Monitor.html#v:monitorGetManufacturer"
        })


#endif

-- method Monitor::get_model
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "monitor"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Monitor" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkMonitor`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_monitor_get_model" gdk_monitor_get_model :: 
    Ptr Monitor ->                          -- monitor : TInterface (Name {namespace = "Gdk", name = "Monitor"})
    IO CString

-- | Gets the string identifying the monitor model, if available.
monitorGetModel ::
    (B.CallStack.HasCallStack, MonadIO m, IsMonitor a) =>
    a
    -- ^ /@monitor@/: a @GdkMonitor@
    -> m (Maybe T.Text)
    -- ^ __Returns:__ the monitor model
monitorGetModel monitor = liftIO $ do
    monitor' <- unsafeManagedPtrCastPtr monitor
    result <- gdk_monitor_get_model monitor'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        return result''
    touchManagedPtr monitor
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data MonitorGetModelMethodInfo
instance (signature ~ (m (Maybe T.Text)), MonadIO m, IsMonitor a) => O.OverloadedMethod MonitorGetModelMethodInfo a signature where
    overloadedMethod = monitorGetModel

instance O.OverloadedMethodInfo MonitorGetModelMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Monitor.monitorGetModel",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Monitor.html#v:monitorGetModel"
        })


#endif

-- method Monitor::get_refresh_rate
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "monitor"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Monitor" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkMonitor`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_monitor_get_refresh_rate" gdk_monitor_get_refresh_rate :: 
    Ptr Monitor ->                          -- monitor : TInterface (Name {namespace = "Gdk", name = "Monitor"})
    IO Int32

-- | Gets the refresh rate of the monitor, if available.
-- 
-- The value is in milli-Hertz, so a refresh rate of 60Hz
-- is returned as 60000.
monitorGetRefreshRate ::
    (B.CallStack.HasCallStack, MonadIO m, IsMonitor a) =>
    a
    -- ^ /@monitor@/: a @GdkMonitor@
    -> m Int32
    -- ^ __Returns:__ the refresh rate in milli-Hertz, or 0
monitorGetRefreshRate monitor = liftIO $ do
    monitor' <- unsafeManagedPtrCastPtr monitor
    result <- gdk_monitor_get_refresh_rate monitor'
    touchManagedPtr monitor
    return result

#if defined(ENABLE_OVERLOADING)
data MonitorGetRefreshRateMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsMonitor a) => O.OverloadedMethod MonitorGetRefreshRateMethodInfo a signature where
    overloadedMethod = monitorGetRefreshRate

instance O.OverloadedMethodInfo MonitorGetRefreshRateMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Monitor.monitorGetRefreshRate",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Monitor.html#v:monitorGetRefreshRate"
        })


#endif

-- method Monitor::get_scale
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "monitor"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Monitor" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkMonitor`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TDouble)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_monitor_get_scale" gdk_monitor_get_scale :: 
    Ptr Monitor ->                          -- monitor : TInterface (Name {namespace = "Gdk", name = "Monitor"})
    IO CDouble

-- | Gets the internal scale factor that maps from monitor coordinates
-- to device pixels.
-- 
-- This can be used if you want to create pixel based data for a
-- particular monitor, but most of the time you’re drawing to a surface
-- where it is better to use 'GI.Gdk.Objects.Surface.surfaceGetScale' instead.
-- 
-- /Since: 4.14/
monitorGetScale ::
    (B.CallStack.HasCallStack, MonadIO m, IsMonitor a) =>
    a
    -- ^ /@monitor@/: a @GdkMonitor@
    -> m Double
    -- ^ __Returns:__ the scale
monitorGetScale monitor = liftIO $ do
    monitor' <- unsafeManagedPtrCastPtr monitor
    result <- gdk_monitor_get_scale monitor'
    let result' = realToFrac result
    touchManagedPtr monitor
    return result'

#if defined(ENABLE_OVERLOADING)
data MonitorGetScaleMethodInfo
instance (signature ~ (m Double), MonadIO m, IsMonitor a) => O.OverloadedMethod MonitorGetScaleMethodInfo a signature where
    overloadedMethod = monitorGetScale

instance O.OverloadedMethodInfo MonitorGetScaleMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Monitor.monitorGetScale",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Monitor.html#v:monitorGetScale"
        })


#endif

-- method Monitor::get_scale_factor
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "monitor"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Monitor" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkMonitor`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_monitor_get_scale_factor" gdk_monitor_get_scale_factor :: 
    Ptr Monitor ->                          -- monitor : TInterface (Name {namespace = "Gdk", name = "Monitor"})
    IO Int32

-- | Gets the internal scale factor that maps from monitor coordinates
-- to device pixels.
-- 
-- On traditional systems this is 1, but on very high density outputs
-- it can be a higher value (often 2).
-- 
-- This can be used if you want to create pixel based data for a
-- particular monitor, but most of the time you’re drawing to a surface
-- where it is better to use 'GI.Gdk.Objects.Surface.surfaceGetScaleFactor' instead.
monitorGetScaleFactor ::
    (B.CallStack.HasCallStack, MonadIO m, IsMonitor a) =>
    a
    -- ^ /@monitor@/: a @GdkMonitor@
    -> m Int32
    -- ^ __Returns:__ the scale factor
monitorGetScaleFactor monitor = liftIO $ do
    monitor' <- unsafeManagedPtrCastPtr monitor
    result <- gdk_monitor_get_scale_factor monitor'
    touchManagedPtr monitor
    return result

#if defined(ENABLE_OVERLOADING)
data MonitorGetScaleFactorMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsMonitor a) => O.OverloadedMethod MonitorGetScaleFactorMethodInfo a signature where
    overloadedMethod = monitorGetScaleFactor

instance O.OverloadedMethodInfo MonitorGetScaleFactorMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Monitor.monitorGetScaleFactor",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Monitor.html#v:monitorGetScaleFactor"
        })


#endif

-- method Monitor::get_subpixel_layout
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "monitor"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Monitor" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkMonitor`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gdk" , name = "SubpixelLayout" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_monitor_get_subpixel_layout" gdk_monitor_get_subpixel_layout :: 
    Ptr Monitor ->                          -- monitor : TInterface (Name {namespace = "Gdk", name = "Monitor"})
    IO CUInt

-- | Gets information about the layout of red, green and blue
-- primaries for pixels.
monitorGetSubpixelLayout ::
    (B.CallStack.HasCallStack, MonadIO m, IsMonitor a) =>
    a
    -- ^ /@monitor@/: a @GdkMonitor@
    -> m Gdk.Enums.SubpixelLayout
    -- ^ __Returns:__ the subpixel layout
monitorGetSubpixelLayout monitor = liftIO $ do
    monitor' <- unsafeManagedPtrCastPtr monitor
    result <- gdk_monitor_get_subpixel_layout monitor'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr monitor
    return result'

#if defined(ENABLE_OVERLOADING)
data MonitorGetSubpixelLayoutMethodInfo
instance (signature ~ (m Gdk.Enums.SubpixelLayout), MonadIO m, IsMonitor a) => O.OverloadedMethod MonitorGetSubpixelLayoutMethodInfo a signature where
    overloadedMethod = monitorGetSubpixelLayout

instance O.OverloadedMethodInfo MonitorGetSubpixelLayoutMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Monitor.monitorGetSubpixelLayout",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Monitor.html#v:monitorGetSubpixelLayout"
        })


#endif

-- method Monitor::get_width_mm
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "monitor"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Monitor" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkMonitor`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_monitor_get_width_mm" gdk_monitor_get_width_mm :: 
    Ptr Monitor ->                          -- monitor : TInterface (Name {namespace = "Gdk", name = "Monitor"})
    IO Int32

-- | Gets the width in millimeters of the monitor.
monitorGetWidthMm ::
    (B.CallStack.HasCallStack, MonadIO m, IsMonitor a) =>
    a
    -- ^ /@monitor@/: a @GdkMonitor@
    -> m Int32
    -- ^ __Returns:__ the physical width of the monitor
monitorGetWidthMm monitor = liftIO $ do
    monitor' <- unsafeManagedPtrCastPtr monitor
    result <- gdk_monitor_get_width_mm monitor'
    touchManagedPtr monitor
    return result

#if defined(ENABLE_OVERLOADING)
data MonitorGetWidthMmMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsMonitor a) => O.OverloadedMethod MonitorGetWidthMmMethodInfo a signature where
    overloadedMethod = monitorGetWidthMm

instance O.OverloadedMethodInfo MonitorGetWidthMmMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Monitor.monitorGetWidthMm",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Monitor.html#v:monitorGetWidthMm"
        })


#endif

-- method Monitor::is_valid
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "monitor"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Monitor" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkMonitor`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_monitor_is_valid" gdk_monitor_is_valid :: 
    Ptr Monitor ->                          -- monitor : TInterface (Name {namespace = "Gdk", name = "Monitor"})
    IO CInt

-- | Returns 'P.True' if the /@monitor@/ object corresponds to a
-- physical monitor.
-- 
-- The /@monitor@/ becomes invalid when the physical monitor
-- is unplugged or removed.
monitorIsValid ::
    (B.CallStack.HasCallStack, MonadIO m, IsMonitor a) =>
    a
    -- ^ /@monitor@/: a @GdkMonitor@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the object corresponds to a physical monitor
monitorIsValid monitor = liftIO $ do
    monitor' <- unsafeManagedPtrCastPtr monitor
    result <- gdk_monitor_is_valid monitor'
    let result' = (/= 0) result
    touchManagedPtr monitor
    return result'

#if defined(ENABLE_OVERLOADING)
data MonitorIsValidMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsMonitor a) => O.OverloadedMethod MonitorIsValidMethodInfo a signature where
    overloadedMethod = monitorIsValid

instance O.OverloadedMethodInfo MonitorIsValidMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Monitor.monitorIsValid",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Monitor.html#v:monitorIsValid"
        })


#endif


