/* TasklistButtonPopover.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from TasklistButtonPopover.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include "tasklistapplet.h"
#include <libxfce4windowing/libxfce4windowing.h>
#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	TASKLIST_BUTTON_POPOVER_0_PROPERTY,
	TASKLIST_BUTTON_POPOVER_WINDOW_PROPERTY,
	TASKLIST_BUTTON_POPOVER_NUM_PROPERTIES
};
static GParamSpec* tasklist_button_popover_properties[TASKLIST_BUTTON_POPOVER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block2Data Block2Data;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _TasklistButtonPopoverPrivate {
	XfwWindow* _window;
	GtkButton* maximize_button;
	GtkButton* minimize_button;
	GtkButton* close_button;
};

struct _Block2Data {
	int _ref_count_;
	TasklistButtonPopover* self;
	XfwWorkspace* workspace;
};

static gint TasklistButtonPopover_private_offset;
static gpointer tasklist_button_popover_parent_class = NULL;
static GType tasklist_button_popover_type_id = 0;

static void tasklist_button_popover_build_workspace_buttons (TasklistButtonPopover* self,
                                                      GtkListBox* list_box);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void ____lambda4_ (Block2Data* _data2_);
static void _____lambda4__gtk_button_clicked (GtkButton* _sender,
                                       gpointer self);
static void tasklist_button_popover_update_maximize_label (TasklistButtonPopover* self);
static GObject * tasklist_button_popover_constructor (GType type,
                                               guint n_construct_properties,
                                               GObjectConstructParam * construct_properties);
static void _tasklist_button_popover___lambda5_ (TasklistButtonPopover* self);
static void __tasklist_button_popover___lambda5__gtk_button_clicked (GtkButton* _sender,
                                                              gpointer self);
static void _tasklist_button_popover___lambda6_ (TasklistButtonPopover* self);
static void __tasklist_button_popover___lambda6__gtk_button_clicked (GtkButton* _sender,
                                                              gpointer self);
static void _tasklist_button_popover___lambda7_ (TasklistButtonPopover* self);
static void __tasklist_button_popover___lambda7__gtk_button_clicked (GtkButton* _sender,
                                                              gpointer self);
static void _tasklist_button_popover___lambda8_ (TasklistButtonPopover* self,
                                          XfwWindowState changed_mask,
                                          XfwWindowState new_state);
static void __tasklist_button_popover___lambda8__libxfce4windowing_window_state_changed (XfwWindow* _sender,
                                                                                  XfwWindowState changed_mask,
                                                                                  XfwWindowState new_state,
                                                                                  gpointer self);
static void tasklist_button_popover_finalize (GObject * obj);
static void _vala_tasklist_button_popover_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec);
static void _vala_tasklist_button_popover_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec);

static inline gpointer
tasklist_button_popover_get_instance_private (TasklistButtonPopover* self)
{
	return G_STRUCT_MEMBER_P (self, TasklistButtonPopover_private_offset);
}

TasklistButtonPopover*
tasklist_button_popover_construct (GType object_type,
                                   TasklistButton* button,
                                   XfwWindow* window)
{
	TasklistButtonPopover * self = NULL;
	g_return_val_if_fail (button != NULL, NULL);
	g_return_val_if_fail (window != NULL, NULL);
	self = (TasklistButtonPopover*) g_object_new (object_type, "relative-to", button, "window", window, NULL);
	return self;
}

TasklistButtonPopover*
tasklist_button_popover_new (TasklistButton* button,
                             XfwWindow* window)
{
	return tasklist_button_popover_construct (TYPE_TASKLIST_BUTTON_POPOVER, button, window);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		TasklistButtonPopover* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->workspace);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static void
____lambda4_ (Block2Data* _data2_)
{
	TasklistButtonPopover* self;
	XfwWorkspace* _tmp0_;
	XfwWindow* _tmp1_;
	XfwWorkspace* _tmp2_;
	GError* _inner_error0_ = NULL;
	self = _data2_->self;
	_tmp0_ = _data2_->workspace;
	_tmp1_ = self->priv->_window;
	_tmp2_ = xfw_window_get_workspace (_tmp1_);
	if (_tmp0_ == _tmp2_) {
		return;
	}
	{
		XfwWindow* _tmp3_;
		XfwWorkspace* _tmp4_;
		_tmp3_ = self->priv->_window;
		_tmp4_ = _data2_->workspace;
		xfw_window_move_to_workspace (_tmp3_, _tmp4_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		XfwWindow* _tmp5_;
		const gchar* _tmp6_;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = self->priv->_window;
		_tmp6_ = xfw_window_get_name (_tmp5_);
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		g_warning ("TasklistButtonPopover.vala:120: Unable to move window '%s' to new work" \
"space: %s", _tmp6_, _tmp8_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
_____lambda4__gtk_button_clicked (GtkButton* _sender,
                                  gpointer self)
{
	____lambda4_ (self);
}

static void
tasklist_button_popover_build_workspace_buttons (TasklistButtonPopover* self,
                                                 GtkListBox* list_box)
{
	XfwWorkspace* current_workspace = NULL;
	XfwWindow* _tmp0_;
	XfwWorkspace* _tmp1_;
	XfwWorkspace* _tmp2_;
	XfwWorkspaceGroup* workspace_group = NULL;
	XfwWorkspace* _tmp3_;
	XfwWorkspaceGroup* _tmp4_;
	XfwWorkspaceGroup* _tmp5_;
	XfwWorkspaceGroup* _tmp6_;
	GList* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (list_box != NULL);
	_tmp0_ = self->priv->_window;
	_tmp1_ = xfw_window_get_workspace (_tmp0_);
	current_workspace = _tmp1_;
	_tmp2_ = current_workspace;
	if (_tmp2_ == NULL) {
		return;
	}
	_tmp3_ = current_workspace;
	_tmp4_ = xfw_workspace_get_workspace_group (_tmp3_);
	workspace_group = _tmp4_;
	_tmp5_ = workspace_group;
	if (_tmp5_ == NULL) {
		return;
	}
	_tmp6_ = workspace_group;
	_tmp7_ = xfw_workspace_group_list_workspaces (_tmp6_);
	{
		GList* workspace_collection = NULL;
		GList* workspace_it = NULL;
		workspace_collection = _tmp7_;
		for (workspace_it = workspace_collection; workspace_it != NULL; workspace_it = workspace_it->next) {
			XfwWorkspace* _tmp8_;
			XfwWorkspace* workspace = NULL;
			_tmp8_ = _g_object_ref0 ((XfwWorkspace*) workspace_it->data);
			workspace = _tmp8_;
			{
				Block2Data* _data2_;
				GtkButton* button = NULL;
				XfwWorkspace* _tmp9_;
				const gchar* _tmp10_;
				gchar* _tmp11_;
				gchar* _tmp12_;
				GtkButton* _tmp13_ = NULL;
				GtkButton* _tmp14_;
				GtkLabel* button_label = NULL;
				GtkButton* _tmp15_;
				GtkWidget* _tmp16_;
				GtkLabel* _tmp17_;
				GtkLabel* _tmp18_;
				GtkButton* _tmp19_;
				GtkButton* _tmp20_;
				_data2_ = g_slice_new0 (Block2Data);
				_data2_->_ref_count_ = 1;
				_data2_->self = g_object_ref (self);
				_data2_->workspace = workspace;
				_tmp9_ = _data2_->workspace;
				_tmp10_ = xfw_workspace_get_name (_tmp9_);
				_tmp11_ = g_strdup_printf (_ ("Move to %s"), _tmp10_);
				_tmp12_ = _tmp11_;
				_tmp13_ = (GtkButton*) gtk_button_new_with_label (_tmp12_);
				gtk_button_set_relief (_tmp13_, GTK_RELIEF_NONE);
				g_object_ref_sink (_tmp13_);
				_tmp14_ = _tmp13_;
				_g_free0 (_tmp12_);
				button = _tmp14_;
				_tmp15_ = button;
				_tmp16_ = gtk_bin_get_child ((GtkBin*) _tmp15_);
				_tmp17_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, gtk_label_get_type ()) ? ((GtkLabel*) _tmp16_) : NULL);
				button_label = _tmp17_;
				_tmp18_ = button_label;
				gtk_widget_set_halign ((GtkWidget*) _tmp18_, GTK_ALIGN_START);
				_tmp19_ = button;
				g_signal_connect_data (_tmp19_, "clicked", (GCallback) _____lambda4__gtk_button_clicked, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
				_tmp20_ = button;
				gtk_container_add ((GtkContainer*) list_box, (GtkWidget*) _tmp20_);
				_g_object_unref0 (button_label);
				_g_object_unref0 (button);
				block2_data_unref (_data2_);
				_data2_ = NULL;
			}
		}
	}
}

static void
tasklist_button_popover_update_maximize_label (TasklistButtonPopover* self)
{
	const gchar* _tmp0_ = NULL;
	XfwWindow* _tmp1_;
	GtkButton* _tmp2_;
	GtkLabel* maximize_button_label = NULL;
	GtkButton* _tmp3_;
	GtkWidget* _tmp4_;
	GtkLabel* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->_window;
	if (xfw_window_is_maximized (_tmp1_)) {
		_tmp0_ = _ ("Unmaximize");
	} else {
		_tmp0_ = _ ("Maximize");
	}
	_tmp2_ = self->priv->maximize_button;
	gtk_button_set_label (_tmp2_, _tmp0_);
	_tmp3_ = self->priv->maximize_button;
	_tmp4_ = gtk_bin_get_child ((GtkBin*) _tmp3_);
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, gtk_label_get_type ()) ? ((GtkLabel*) _tmp4_) : NULL);
	maximize_button_label = _tmp5_;
	gtk_widget_set_halign ((GtkWidget*) maximize_button_label, GTK_ALIGN_START);
	_g_object_unref0 (maximize_button_label);
}

XfwWindow*
tasklist_button_popover_get_window (TasklistButtonPopover* self)
{
	XfwWindow* result;
	XfwWindow* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_window;
	result = _tmp0_;
	return result;
}

static void
tasklist_button_popover_set_window (TasklistButtonPopover* self,
                                    XfwWindow* value)
{
	XfwWindow* old_value;
	g_return_if_fail (self != NULL);
	old_value = tasklist_button_popover_get_window (self);
	if (old_value != value) {
		XfwWindow* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_window);
		self->priv->_window = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, tasklist_button_popover_properties[TASKLIST_BUTTON_POPOVER_WINDOW_PROPERTY]);
	}
}

static void
_tasklist_button_popover___lambda5_ (TasklistButtonPopover* self)
{
	gboolean maximized = FALSE;
	XfwWindow* _tmp0_;
	GError* _inner_error0_ = NULL;
	_tmp0_ = self->priv->_window;
	maximized = xfw_window_is_maximized (_tmp0_);
	{
		XfwWindow* _tmp1_;
		_tmp1_ = self->priv->_window;
		xfw_window_set_maximized (_tmp1_, !maximized, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		XfwWindow* _tmp2_;
		const gchar* _tmp3_;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = self->priv->_window;
		_tmp3_ = xfw_window_get_name (_tmp2_);
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("TasklistButtonPopover.vala:64: Unable to set maximized on window %s: %" \
"s", _tmp3_, _tmp5_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
__tasklist_button_popover___lambda5__gtk_button_clicked (GtkButton* _sender,
                                                         gpointer self)
{
	_tasklist_button_popover___lambda5_ ((TasklistButtonPopover*) self);
}

static void
_tasklist_button_popover___lambda6_ (TasklistButtonPopover* self)
{
	GError* _inner_error0_ = NULL;
	{
		XfwWindow* _tmp0_;
		_tmp0_ = self->priv->_window;
		xfw_window_set_minimized (_tmp0_, TRUE, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		XfwWindow* _tmp1_;
		const gchar* _tmp2_;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = self->priv->_window;
		_tmp2_ = xfw_window_get_name (_tmp1_);
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("TasklistButtonPopover.vala:72: Unable to set minimized on window %s: %" \
"s", _tmp2_, _tmp4_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
__tasklist_button_popover___lambda6__gtk_button_clicked (GtkButton* _sender,
                                                         gpointer self)
{
	_tasklist_button_popover___lambda6_ ((TasklistButtonPopover*) self);
}

static void
_tasklist_button_popover___lambda7_ (TasklistButtonPopover* self)
{
	GError* _inner_error0_ = NULL;
	{
		XfwWindow* _tmp0_;
		_tmp0_ = self->priv->_window;
		xfw_window_close (_tmp0_, (guint64) gtk_get_current_event_time (), &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		XfwWindow* _tmp1_;
		const gchar* _tmp2_;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = self->priv->_window;
		_tmp2_ = xfw_window_get_name (_tmp1_);
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("TasklistButtonPopover.vala:80: Unable to close window '%s': %s", _tmp2_, _tmp4_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
__tasklist_button_popover___lambda7__gtk_button_clicked (GtkButton* _sender,
                                                         gpointer self)
{
	_tasklist_button_popover___lambda7_ ((TasklistButtonPopover*) self);
}

static void
_tasklist_button_popover___lambda8_ (TasklistButtonPopover* self,
                                     XfwWindowState changed_mask,
                                     XfwWindowState new_state)
{
	if ((changed_mask & XFW_WINDOW_STATE_MAXIMIZED) == XFW_WINDOW_STATE_MAXIMIZED) {
		tasklist_button_popover_update_maximize_label (self);
	}
}

static void
__tasklist_button_popover___lambda8__libxfce4windowing_window_state_changed (XfwWindow* _sender,
                                                                             XfwWindowState changed_mask,
                                                                             XfwWindowState new_state,
                                                                             gpointer self)
{
	_tasklist_button_popover___lambda8_ ((TasklistButtonPopover*) self, changed_mask, new_state);
}

static GObject *
tasklist_button_popover_constructor (GType type,
                                     guint n_construct_properties,
                                     GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	TasklistButtonPopover * self;
	GtkStyleContext* _tmp0_;
	GtkButton* _tmp1_ = NULL;
	GtkButton* _tmp2_ = NULL;
	GtkLabel* minimize_button_label = NULL;
	GtkButton* _tmp3_;
	GtkWidget* _tmp4_;
	GtkLabel* _tmp5_;
	GtkLabel* _tmp6_;
	GtkButton* _tmp7_ = NULL;
	GtkLabel* close_button_label = NULL;
	GtkButton* _tmp8_;
	GtkWidget* _tmp9_;
	GtkLabel* _tmp10_;
	GtkLabel* _tmp11_;
	GtkListBox* list_box = NULL;
	GtkListBox* _tmp12_ = NULL;
	GtkListBox* _tmp13_;
	GtkButton* _tmp14_;
	GtkListBox* _tmp15_;
	GtkButton* _tmp16_;
	GtkListBox* _tmp17_;
	GtkButton* _tmp18_;
	GtkListBox* _tmp19_;
	GtkListBox* _tmp20_;
	GtkButton* _tmp21_;
	GtkButton* _tmp22_;
	GtkButton* _tmp23_;
	XfwWindow* _tmp24_;
	GtkListBox* _tmp25_;
	parent_class = G_OBJECT_CLASS (tasklist_button_popover_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TASKLIST_BUTTON_POPOVER, TasklistButtonPopover);
	g_object_set ((GtkWidget*) self, "width-request", 200, NULL);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp0_, "icon-popover");
	_tmp1_ = (GtkButton*) gtk_button_new_with_label ("");
	gtk_button_set_relief (_tmp1_, GTK_RELIEF_NONE);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->maximize_button);
	self->priv->maximize_button = _tmp1_;
	_tmp2_ = (GtkButton*) gtk_button_new_with_label (_ ("Minimize"));
	gtk_button_set_relief (_tmp2_, GTK_RELIEF_NONE);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->minimize_button);
	self->priv->minimize_button = _tmp2_;
	_tmp3_ = self->priv->minimize_button;
	_tmp4_ = gtk_bin_get_child ((GtkBin*) _tmp3_);
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, gtk_label_get_type ()) ? ((GtkLabel*) _tmp4_) : NULL);
	minimize_button_label = _tmp5_;
	_tmp6_ = minimize_button_label;
	gtk_widget_set_halign ((GtkWidget*) _tmp6_, GTK_ALIGN_START);
	_tmp7_ = (GtkButton*) gtk_button_new_with_label (_ ("Close"));
	gtk_button_set_relief (_tmp7_, GTK_RELIEF_NONE);
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->priv->close_button);
	self->priv->close_button = _tmp7_;
	_tmp8_ = self->priv->close_button;
	_tmp9_ = gtk_bin_get_child ((GtkBin*) _tmp8_);
	_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, gtk_label_get_type ()) ? ((GtkLabel*) _tmp9_) : NULL);
	close_button_label = _tmp10_;
	_tmp11_ = close_button_label;
	gtk_widget_set_halign ((GtkWidget*) _tmp11_, GTK_ALIGN_START);
	_tmp12_ = (GtkListBox*) gtk_list_box_new ();
	gtk_list_box_set_selection_mode (_tmp12_, GTK_SELECTION_NONE);
	g_object_ref_sink (_tmp12_);
	list_box = _tmp12_;
	_tmp13_ = list_box;
	_tmp14_ = self->priv->maximize_button;
	gtk_container_add ((GtkContainer*) _tmp13_, (GtkWidget*) _tmp14_);
	_tmp15_ = list_box;
	_tmp16_ = self->priv->minimize_button;
	gtk_container_add ((GtkContainer*) _tmp15_, (GtkWidget*) _tmp16_);
	_tmp17_ = list_box;
	_tmp18_ = self->priv->close_button;
	gtk_container_add ((GtkContainer*) _tmp17_, (GtkWidget*) _tmp18_);
	_tmp19_ = list_box;
	tasklist_button_popover_build_workspace_buttons (self, _tmp19_);
	_tmp20_ = list_box;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp20_);
	_tmp21_ = self->priv->maximize_button;
	g_signal_connect_object (_tmp21_, "clicked", (GCallback) __tasklist_button_popover___lambda5__gtk_button_clicked, self, 0);
	_tmp22_ = self->priv->minimize_button;
	g_signal_connect_object (_tmp22_, "clicked", (GCallback) __tasklist_button_popover___lambda6__gtk_button_clicked, self, 0);
	_tmp23_ = self->priv->close_button;
	g_signal_connect_object (_tmp23_, "clicked", (GCallback) __tasklist_button_popover___lambda7__gtk_button_clicked, self, 0);
	_tmp24_ = self->priv->_window;
	g_signal_connect_object (_tmp24_, "state-changed", (GCallback) __tasklist_button_popover___lambda8__libxfce4windowing_window_state_changed, self, 0);
	tasklist_button_popover_update_maximize_label (self);
	_tmp25_ = list_box;
	gtk_widget_show_all ((GtkWidget*) _tmp25_);
	_g_object_unref0 (list_box);
	_g_object_unref0 (close_button_label);
	_g_object_unref0 (minimize_button_label);
	return obj;
}

static void
tasklist_button_popover_class_init (TasklistButtonPopoverClass * klass,
                                    gpointer klass_data)
{
	tasklist_button_popover_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &TasklistButtonPopover_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_tasklist_button_popover_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_tasklist_button_popover_set_property;
	G_OBJECT_CLASS (klass)->constructor = tasklist_button_popover_constructor;
	G_OBJECT_CLASS (klass)->finalize = tasklist_button_popover_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), TASKLIST_BUTTON_POPOVER_WINDOW_PROPERTY, tasklist_button_popover_properties[TASKLIST_BUTTON_POPOVER_WINDOW_PROPERTY] = g_param_spec_object ("window", "window", "window", xfw_window_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
tasklist_button_popover_instance_init (TasklistButtonPopover * self,
                                       gpointer klass)
{
	self->priv = tasklist_button_popover_get_instance_private (self);
}

static void
tasklist_button_popover_finalize (GObject * obj)
{
	TasklistButtonPopover * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TASKLIST_BUTTON_POPOVER, TasklistButtonPopover);
	_g_object_unref0 (self->priv->_window);
	_g_object_unref0 (self->priv->maximize_button);
	_g_object_unref0 (self->priv->minimize_button);
	_g_object_unref0 (self->priv->close_button);
	G_OBJECT_CLASS (tasklist_button_popover_parent_class)->finalize (obj);
}

GType
tasklist_button_popover_get_type (void)
{
	return tasklist_button_popover_type_id;
}

GType
tasklist_button_popover_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (TasklistButtonPopoverClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tasklist_button_popover_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TasklistButtonPopover), 0, (GInstanceInitFunc) tasklist_button_popover_instance_init, NULL };
	tasklist_button_popover_type_id = g_type_module_register_type (module, gtk_popover_get_type (), "TasklistButtonPopover", &g_define_type_info, 0);
	TasklistButtonPopover_private_offset = sizeof (TasklistButtonPopoverPrivate);
	return tasklist_button_popover_type_id;
}

static void
_vala_tasklist_button_popover_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec)
{
	TasklistButtonPopover * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_TASKLIST_BUTTON_POPOVER, TasklistButtonPopover);
	switch (property_id) {
		case TASKLIST_BUTTON_POPOVER_WINDOW_PROPERTY:
		g_value_set_object (value, tasklist_button_popover_get_window (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_tasklist_button_popover_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec)
{
	TasklistButtonPopover * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_TASKLIST_BUTTON_POPOVER, TasklistButtonPopover);
	switch (property_id) {
		case TASKLIST_BUTTON_POPOVER_WINDOW_PROPERTY:
		tasklist_button_popover_set_window (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

