/* toplevel.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from toplevel.vala, do not modify */

/*
 * This file is part of budgie-desktop.
 *
 * Copyright Budgie Desktop Developers
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */

#include "budgie-private.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include "plugin.h"
#include <glib-object.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BUDGIE_TOPLEVEL_0_PROPERTY,
	BUDGIE_TOPLEVEL_SHADOW_DEPTH_PROPERTY,
	BUDGIE_TOPLEVEL_INTENDED_SIZE_PROPERTY,
	BUDGIE_TOPLEVEL_INTENDED_SPACING_PROPERTY,
	BUDGIE_TOPLEVEL_SHADOW_VISIBLE_PROPERTY,
	BUDGIE_TOPLEVEL_THEME_REGIONS_PROPERTY,
	BUDGIE_TOPLEVEL_DOCK_MODE_PROPERTY,
	BUDGIE_TOPLEVEL_INTERSECTED_PROPERTY,
	BUDGIE_TOPLEVEL_UUID_PROPERTY,
	BUDGIE_TOPLEVEL_POSITION_PROPERTY,
	BUDGIE_TOPLEVEL_TRANSPARENCY_PROPERTY,
	BUDGIE_TOPLEVEL_AUTOHIDE_PROPERTY,
	BUDGIE_TOPLEVEL_NUM_PROPERTIES
};
static GParamSpec* budgie_toplevel_properties[BUDGIE_TOPLEVEL_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	BUDGIE_TOPLEVEL_APPLET_ADDED_SIGNAL,
	BUDGIE_TOPLEVEL_APPLET_REMOVED_SIGNAL,
	BUDGIE_TOPLEVEL_APPLETS_CHANGED_SIGNAL,
	BUDGIE_TOPLEVEL_NUM_SIGNALS
};
static guint budgie_toplevel_signals[BUDGIE_TOPLEVEL_NUM_SIGNALS] = {0};

struct _BudgieToplevelPrivate {
	gint _shadow_depth;
	gint _intended_size;
	gint _intended_spacing;
	gboolean _shadow_visible;
	gboolean _theme_regions;
	gboolean _dock_mode;
	gboolean _intersected;
	gchar* _uuid;
	BudgiePanelPosition _position;
	BudgiePanelTransparency _transparency;
	BudgieAutohidePolicy _autohide;
};

static gint BudgieToplevel_private_offset;
static gpointer budgie_toplevel_parent_class = NULL;

static GList* budgie_toplevel_real_get_applets (BudgieToplevel* self);
static gboolean budgie_toplevel_real_can_move_applet_left (BudgieToplevel* self,
                                                    BudgieAppletInfo* info);
static gboolean budgie_toplevel_real_can_move_applet_right (BudgieToplevel* self,
                                                     BudgieAppletInfo* info);
static void budgie_toplevel_real_move_applet_left (BudgieToplevel* self,
                                            BudgieAppletInfo* info);
static void budgie_toplevel_real_move_applet_right (BudgieToplevel* self,
                                             BudgieAppletInfo* info);
static void budgie_toplevel_real_add_new_applet (BudgieToplevel* self,
                                          const gchar* id);
static void budgie_toplevel_real_remove_applet (BudgieToplevel* self,
                                         BudgieAppletInfo* info);
static void budgie_toplevel_finalize (GObject * obj);
static GType budgie_toplevel_get_type_once (void);
static void _vala_budgie_toplevel_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec);
static void _vala_budgie_toplevel_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec);

static GType
budgie_struts_get_type_once (void)
{
	static const GEnumValue values[] = {{BUDGIE_STRUTS_LEFT, "BUDGIE_STRUTS_LEFT", "left"}, {BUDGIE_STRUTS_RIGHT, "BUDGIE_STRUTS_RIGHT", "right"}, {BUDGIE_STRUTS_TOP, "BUDGIE_STRUTS_TOP", "top"}, {BUDGIE_STRUTS_BOTTOM, "BUDGIE_STRUTS_BOTTOM", "bottom"}, {BUDGIE_STRUTS_LEFT_START, "BUDGIE_STRUTS_LEFT_START", "left-start"}, {BUDGIE_STRUTS_LEFT_END, "BUDGIE_STRUTS_LEFT_END", "left-end"}, {BUDGIE_STRUTS_RIGHT_START, "BUDGIE_STRUTS_RIGHT_START", "right-start"}, {BUDGIE_STRUTS_RIGHT_END, "BUDGIE_STRUTS_RIGHT_END", "right-end"}, {BUDGIE_STRUTS_TOP_START, "BUDGIE_STRUTS_TOP_START", "top-start"}, {BUDGIE_STRUTS_TOP_END, "BUDGIE_STRUTS_TOP_END", "top-end"}, {BUDGIE_STRUTS_BOTTOM_START, "BUDGIE_STRUTS_BOTTOM_START", "bottom-start"}, {BUDGIE_STRUTS_BOTTOM_END, "BUDGIE_STRUTS_BOTTOM_END", "bottom-end"}, {0, NULL, NULL}};
	GType budgie_struts_type_id;
	budgie_struts_type_id = g_enum_register_static ("BudgieStruts", values);
	return budgie_struts_type_id;
}

GType
budgie_struts_get_type (void)
{
	static volatile gsize budgie_struts_type_id__once = 0;
	if (g_once_init_enter (&budgie_struts_type_id__once)) {
		GType budgie_struts_type_id;
		budgie_struts_type_id = budgie_struts_get_type_once ();
		g_once_init_leave (&budgie_struts_type_id__once, budgie_struts_type_id);
	}
	return budgie_struts_type_id__once;
}

static inline gpointer
budgie_toplevel_get_instance_private (BudgieToplevel* self)
{
	return G_STRUCT_MEMBER_P (self, BudgieToplevel_private_offset);
}

static GList*
budgie_toplevel_real_get_applets (BudgieToplevel* self)
{
	g_critical ("Type `%s' does not implement abstract method `budgie_toplevel_get_applets'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

GList*
budgie_toplevel_get_applets (BudgieToplevel* self)
{
	BudgieToplevelClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = BUDGIE_TOPLEVEL_GET_CLASS (self);
	if (_klass_->get_applets) {
		return _klass_->get_applets (self);
	}
	return NULL;
}

static gboolean
budgie_toplevel_real_can_move_applet_left (BudgieToplevel* self,
                                           BudgieAppletInfo* info)
{
	gboolean _tmp0_ = FALSE;
	g_critical ("Type `%s' does not implement abstract method `budgie_toplevel_can_move_applet_left'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return _tmp0_;
}

gboolean
budgie_toplevel_can_move_applet_left (BudgieToplevel* self,
                                      BudgieAppletInfo* info)
{
	BudgieToplevelClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = BUDGIE_TOPLEVEL_GET_CLASS (self);
	if (_klass_->can_move_applet_left) {
		return _klass_->can_move_applet_left (self, info);
	}
	return FALSE;
}

static gboolean
budgie_toplevel_real_can_move_applet_right (BudgieToplevel* self,
                                            BudgieAppletInfo* info)
{
	gboolean _tmp0_ = FALSE;
	g_critical ("Type `%s' does not implement abstract method `budgie_toplevel_can_move_applet_right'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return _tmp0_;
}

gboolean
budgie_toplevel_can_move_applet_right (BudgieToplevel* self,
                                       BudgieAppletInfo* info)
{
	BudgieToplevelClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = BUDGIE_TOPLEVEL_GET_CLASS (self);
	if (_klass_->can_move_applet_right) {
		return _klass_->can_move_applet_right (self, info);
	}
	return FALSE;
}

static void
budgie_toplevel_real_move_applet_left (BudgieToplevel* self,
                                       BudgieAppletInfo* info)
{
	g_critical ("Type `%s' does not implement abstract method `budgie_toplevel_move_applet_left'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
budgie_toplevel_move_applet_left (BudgieToplevel* self,
                                  BudgieAppletInfo* info)
{
	BudgieToplevelClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = BUDGIE_TOPLEVEL_GET_CLASS (self);
	if (_klass_->move_applet_left) {
		_klass_->move_applet_left (self, info);
	}
}

static void
budgie_toplevel_real_move_applet_right (BudgieToplevel* self,
                                        BudgieAppletInfo* info)
{
	g_critical ("Type `%s' does not implement abstract method `budgie_toplevel_move_applet_right'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
budgie_toplevel_move_applet_right (BudgieToplevel* self,
                                   BudgieAppletInfo* info)
{
	BudgieToplevelClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = BUDGIE_TOPLEVEL_GET_CLASS (self);
	if (_klass_->move_applet_right) {
		_klass_->move_applet_right (self, info);
	}
}

static void
budgie_toplevel_real_add_new_applet (BudgieToplevel* self,
                                     const gchar* id)
{
	g_critical ("Type `%s' does not implement abstract method `budgie_toplevel_add_new_applet'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
budgie_toplevel_add_new_applet (BudgieToplevel* self,
                                const gchar* id)
{
	BudgieToplevelClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = BUDGIE_TOPLEVEL_GET_CLASS (self);
	if (_klass_->add_new_applet) {
		_klass_->add_new_applet (self, id);
	}
}

static void
budgie_toplevel_real_remove_applet (BudgieToplevel* self,
                                    BudgieAppletInfo* info)
{
	g_critical ("Type `%s' does not implement abstract method `budgie_toplevel_remove_applet'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
budgie_toplevel_remove_applet (BudgieToplevel* self,
                               BudgieAppletInfo* info)
{
	BudgieToplevelClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = BUDGIE_TOPLEVEL_GET_CLASS (self);
	if (_klass_->remove_applet) {
		_klass_->remove_applet (self, info);
	}
}

BudgieToplevel*
budgie_toplevel_construct (GType object_type)
{
	BudgieToplevel * self = NULL;
	self = (BudgieToplevel*) g_object_new (object_type, NULL);
	return self;
}

gint
budgie_toplevel_get_shadow_depth (BudgieToplevel* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_shadow_depth;
	return result;
}

void
budgie_toplevel_set_shadow_depth (BudgieToplevel* self,
                                  gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_toplevel_get_shadow_depth (self);
	if (old_value != value) {
		self->priv->_shadow_depth = value;
		g_object_notify_by_pspec ((GObject *) self, budgie_toplevel_properties[BUDGIE_TOPLEVEL_SHADOW_DEPTH_PROPERTY]);
	}
}

gint
budgie_toplevel_get_intended_size (BudgieToplevel* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_intended_size;
	return result;
}

void
budgie_toplevel_set_intended_size (BudgieToplevel* self,
                                   gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_toplevel_get_intended_size (self);
	if (old_value != value) {
		self->priv->_intended_size = value;
		g_object_notify_by_pspec ((GObject *) self, budgie_toplevel_properties[BUDGIE_TOPLEVEL_INTENDED_SIZE_PROPERTY]);
	}
}

gint
budgie_toplevel_get_intended_spacing (BudgieToplevel* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_intended_spacing;
	return result;
}

void
budgie_toplevel_set_intended_spacing (BudgieToplevel* self,
                                      gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_toplevel_get_intended_spacing (self);
	if (old_value != value) {
		self->priv->_intended_spacing = value;
		g_object_notify_by_pspec ((GObject *) self, budgie_toplevel_properties[BUDGIE_TOPLEVEL_INTENDED_SPACING_PROPERTY]);
	}
}

gboolean
budgie_toplevel_get_shadow_visible (BudgieToplevel* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_shadow_visible;
	return result;
}

void
budgie_toplevel_set_shadow_visible (BudgieToplevel* self,
                                    gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_toplevel_get_shadow_visible (self);
	if (old_value != value) {
		self->priv->_shadow_visible = value;
		g_object_notify_by_pspec ((GObject *) self, budgie_toplevel_properties[BUDGIE_TOPLEVEL_SHADOW_VISIBLE_PROPERTY]);
	}
}

gboolean
budgie_toplevel_get_theme_regions (BudgieToplevel* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_theme_regions;
	return result;
}

void
budgie_toplevel_set_theme_regions (BudgieToplevel* self,
                                   gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_toplevel_get_theme_regions (self);
	if (old_value != value) {
		self->priv->_theme_regions = value;
		g_object_notify_by_pspec ((GObject *) self, budgie_toplevel_properties[BUDGIE_TOPLEVEL_THEME_REGIONS_PROPERTY]);
	}
}

gboolean
budgie_toplevel_get_dock_mode (BudgieToplevel* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_dock_mode;
	return result;
}

void
budgie_toplevel_set_dock_mode (BudgieToplevel* self,
                               gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_toplevel_get_dock_mode (self);
	if (old_value != value) {
		self->priv->_dock_mode = value;
		g_object_notify_by_pspec ((GObject *) self, budgie_toplevel_properties[BUDGIE_TOPLEVEL_DOCK_MODE_PROPERTY]);
	}
}

gboolean
budgie_toplevel_get_intersected (BudgieToplevel* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_intersected;
	return result;
}

void
budgie_toplevel_set_intersected (BudgieToplevel* self,
                                 gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_toplevel_get_intersected (self);
	if (old_value != value) {
		self->priv->_intersected = value;
		g_object_notify_by_pspec ((GObject *) self, budgie_toplevel_properties[BUDGIE_TOPLEVEL_INTERSECTED_PROPERTY]);
	}
}

const gchar*
budgie_toplevel_get_uuid (BudgieToplevel* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_uuid;
	result = _tmp0_;
	return result;
}

void
budgie_toplevel_set_uuid (BudgieToplevel* self,
                          const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_toplevel_get_uuid (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_uuid);
		self->priv->_uuid = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, budgie_toplevel_properties[BUDGIE_TOPLEVEL_UUID_PROPERTY]);
	}
}

BudgiePanelPosition
budgie_toplevel_get_position (BudgieToplevel* self)
{
	BudgiePanelPosition result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_position;
	return result;
}

void
budgie_toplevel_set_position (BudgieToplevel* self,
                              BudgiePanelPosition value)
{
	BudgiePanelPosition old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_toplevel_get_position (self);
	if (old_value != value) {
		self->priv->_position = value;
		g_object_notify_by_pspec ((GObject *) self, budgie_toplevel_properties[BUDGIE_TOPLEVEL_POSITION_PROPERTY]);
	}
}

BudgiePanelTransparency
budgie_toplevel_get_transparency (BudgieToplevel* self)
{
	BudgiePanelTransparency result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_transparency;
	return result;
}

void
budgie_toplevel_set_transparency (BudgieToplevel* self,
                                  BudgiePanelTransparency value)
{
	BudgiePanelTransparency old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_toplevel_get_transparency (self);
	if (old_value != value) {
		self->priv->_transparency = value;
		g_object_notify_by_pspec ((GObject *) self, budgie_toplevel_properties[BUDGIE_TOPLEVEL_TRANSPARENCY_PROPERTY]);
	}
}

BudgieAutohidePolicy
budgie_toplevel_get_autohide (BudgieToplevel* self)
{
	BudgieAutohidePolicy result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_autohide;
	return result;
}

void
budgie_toplevel_set_autohide (BudgieToplevel* self,
                              BudgieAutohidePolicy value)
{
	BudgieAutohidePolicy old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_toplevel_get_autohide (self);
	if (old_value != value) {
		self->priv->_autohide = value;
		g_object_notify_by_pspec ((GObject *) self, budgie_toplevel_properties[BUDGIE_TOPLEVEL_AUTOHIDE_PROPERTY]);
	}
}

static void
budgie_toplevel_class_init (BudgieToplevelClass * klass,
                            gpointer klass_data)
{
	budgie_toplevel_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BudgieToplevel_private_offset);
	((BudgieToplevelClass *) klass)->get_applets = (GList* (*) (BudgieToplevel*)) budgie_toplevel_real_get_applets;
	((BudgieToplevelClass *) klass)->can_move_applet_left = (gboolean (*) (BudgieToplevel*, BudgieAppletInfo*)) budgie_toplevel_real_can_move_applet_left;
	((BudgieToplevelClass *) klass)->can_move_applet_right = (gboolean (*) (BudgieToplevel*, BudgieAppletInfo*)) budgie_toplevel_real_can_move_applet_right;
	((BudgieToplevelClass *) klass)->move_applet_left = (void (*) (BudgieToplevel*, BudgieAppletInfo*)) budgie_toplevel_real_move_applet_left;
	((BudgieToplevelClass *) klass)->move_applet_right = (void (*) (BudgieToplevel*, BudgieAppletInfo*)) budgie_toplevel_real_move_applet_right;
	((BudgieToplevelClass *) klass)->add_new_applet = (void (*) (BudgieToplevel*, const gchar*)) budgie_toplevel_real_add_new_applet;
	((BudgieToplevelClass *) klass)->remove_applet = (void (*) (BudgieToplevel*, BudgieAppletInfo*)) budgie_toplevel_real_remove_applet;
	G_OBJECT_CLASS (klass)->get_property = _vala_budgie_toplevel_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_budgie_toplevel_set_property;
	G_OBJECT_CLASS (klass)->finalize = budgie_toplevel_finalize;
	/**
	* Depth of our shadow component, to enable Raven blending
	*/
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_TOPLEVEL_SHADOW_DEPTH_PROPERTY, budgie_toplevel_properties[BUDGIE_TOPLEVEL_SHADOW_DEPTH_PROPERTY] = g_param_spec_int ("shadow-depth", "shadow-depth", "shadow-depth", G_MININT, G_MAXINT, 5, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	* Our required size (height or width dependening on orientation
	*/
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_TOPLEVEL_INTENDED_SIZE_PROPERTY, budgie_toplevel_properties[BUDGIE_TOPLEVEL_INTENDED_SIZE_PROPERTY] = g_param_spec_int ("intended-size", "intended-size", "intended-size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	* Our configured applet spacing
	*/
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_TOPLEVEL_INTENDED_SPACING_PROPERTY, budgie_toplevel_properties[BUDGIE_TOPLEVEL_INTENDED_SPACING_PROPERTY] = g_param_spec_int ("intended-spacing", "intended-spacing", "intended-spacing", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_TOPLEVEL_SHADOW_VISIBLE_PROPERTY, budgie_toplevel_properties[BUDGIE_TOPLEVEL_SHADOW_VISIBLE_PROPERTY] = g_param_spec_boolean ("shadow-visible", "shadow-visible", "shadow-visible", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_TOPLEVEL_THEME_REGIONS_PROPERTY, budgie_toplevel_properties[BUDGIE_TOPLEVEL_THEME_REGIONS_PROPERTY] = g_param_spec_boolean ("theme-regions", "theme-regions", "theme-regions", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_TOPLEVEL_DOCK_MODE_PROPERTY, budgie_toplevel_properties[BUDGIE_TOPLEVEL_DOCK_MODE_PROPERTY] = g_param_spec_boolean ("dock-mode", "dock-mode", "dock-mode", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_TOPLEVEL_INTERSECTED_PROPERTY, budgie_toplevel_properties[BUDGIE_TOPLEVEL_INTERSECTED_PROPERTY] = g_param_spec_boolean ("intersected", "intersected", "intersected", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	* Unique identifier for this panel
	*/
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_TOPLEVEL_UUID_PROPERTY, budgie_toplevel_properties[BUDGIE_TOPLEVEL_UUID_PROPERTY] = g_param_spec_string ("uuid", "uuid", "uuid", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_TOPLEVEL_POSITION_PROPERTY, budgie_toplevel_properties[BUDGIE_TOPLEVEL_POSITION_PROPERTY] = g_param_spec_flags ("position", "position", "position", budgie_panel_position_get_type (), BUDGIE_PANEL_POSITION_BOTTOM, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_TOPLEVEL_TRANSPARENCY_PROPERTY, budgie_toplevel_properties[BUDGIE_TOPLEVEL_TRANSPARENCY_PROPERTY] = g_param_spec_flags ("transparency", "transparency", "transparency", BUDGIE_TYPE_PANEL_TRANSPARENCY, BUDGIE_PANEL_TRANSPARENCY_NONE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_TOPLEVEL_AUTOHIDE_PROPERTY, budgie_toplevel_properties[BUDGIE_TOPLEVEL_AUTOHIDE_PROPERTY] = g_param_spec_flags ("autohide", "autohide", "autohide", BUDGIE_TYPE_AUTOHIDE_POLICY, BUDGIE_AUTOHIDE_POLICY_NONE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	budgie_toplevel_signals[BUDGIE_TOPLEVEL_APPLET_ADDED_SIGNAL] = g_signal_new ("applet-added", BUDGIE_TYPE_TOPLEVEL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, budgie_applet_info_get_type ());
	budgie_toplevel_signals[BUDGIE_TOPLEVEL_APPLET_REMOVED_SIGNAL] = g_signal_new ("applet-removed", BUDGIE_TYPE_TOPLEVEL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	budgie_toplevel_signals[BUDGIE_TOPLEVEL_APPLETS_CHANGED_SIGNAL] = g_signal_new ("applets-changed", BUDGIE_TYPE_TOPLEVEL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
budgie_toplevel_instance_init (BudgieToplevel * self,
                               gpointer klass)
{
	self->priv = budgie_toplevel_get_instance_private (self);
	self->priv->_shadow_depth = 5;
	self->priv->_dock_mode = FALSE;
	self->priv->_intersected = FALSE;
	self->priv->_position = BUDGIE_PANEL_POSITION_BOTTOM;
	self->priv->_transparency = BUDGIE_PANEL_TRANSPARENCY_NONE;
	self->priv->_autohide = BUDGIE_AUTOHIDE_POLICY_NONE;
}

static void
budgie_toplevel_finalize (GObject * obj)
{
	BudgieToplevel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_TOPLEVEL, BudgieToplevel);
	_g_free0 (self->priv->_uuid);
	G_OBJECT_CLASS (budgie_toplevel_parent_class)->finalize (obj);
}

static GType
budgie_toplevel_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieToplevelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_toplevel_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieToplevel), 0, (GInstanceInitFunc) budgie_toplevel_instance_init, NULL };
	GType budgie_toplevel_type_id;
	budgie_toplevel_type_id = g_type_register_static (gtk_window_get_type (), "BudgieToplevel", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	BudgieToplevel_private_offset = g_type_add_instance_private (budgie_toplevel_type_id, sizeof (BudgieToplevelPrivate));
	return budgie_toplevel_type_id;
}

GType
budgie_toplevel_get_type (void)
{
	static volatile gsize budgie_toplevel_type_id__once = 0;
	if (g_once_init_enter (&budgie_toplevel_type_id__once)) {
		GType budgie_toplevel_type_id;
		budgie_toplevel_type_id = budgie_toplevel_get_type_once ();
		g_once_init_leave (&budgie_toplevel_type_id__once, budgie_toplevel_type_id);
	}
	return budgie_toplevel_type_id__once;
}

static void
_vala_budgie_toplevel_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec)
{
	BudgieToplevel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_TYPE_TOPLEVEL, BudgieToplevel);
	switch (property_id) {
		case BUDGIE_TOPLEVEL_SHADOW_DEPTH_PROPERTY:
		g_value_set_int (value, budgie_toplevel_get_shadow_depth (self));
		break;
		case BUDGIE_TOPLEVEL_INTENDED_SIZE_PROPERTY:
		g_value_set_int (value, budgie_toplevel_get_intended_size (self));
		break;
		case BUDGIE_TOPLEVEL_INTENDED_SPACING_PROPERTY:
		g_value_set_int (value, budgie_toplevel_get_intended_spacing (self));
		break;
		case BUDGIE_TOPLEVEL_SHADOW_VISIBLE_PROPERTY:
		g_value_set_boolean (value, budgie_toplevel_get_shadow_visible (self));
		break;
		case BUDGIE_TOPLEVEL_THEME_REGIONS_PROPERTY:
		g_value_set_boolean (value, budgie_toplevel_get_theme_regions (self));
		break;
		case BUDGIE_TOPLEVEL_DOCK_MODE_PROPERTY:
		g_value_set_boolean (value, budgie_toplevel_get_dock_mode (self));
		break;
		case BUDGIE_TOPLEVEL_INTERSECTED_PROPERTY:
		g_value_set_boolean (value, budgie_toplevel_get_intersected (self));
		break;
		case BUDGIE_TOPLEVEL_UUID_PROPERTY:
		g_value_set_string (value, budgie_toplevel_get_uuid (self));
		break;
		case BUDGIE_TOPLEVEL_POSITION_PROPERTY:
		g_value_set_flags (value, budgie_toplevel_get_position (self));
		break;
		case BUDGIE_TOPLEVEL_TRANSPARENCY_PROPERTY:
		g_value_set_flags (value, budgie_toplevel_get_transparency (self));
		break;
		case BUDGIE_TOPLEVEL_AUTOHIDE_PROPERTY:
		g_value_set_flags (value, budgie_toplevel_get_autohide (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_budgie_toplevel_set_property (GObject * object,
                                    guint property_id,
                                    const GValue * value,
                                    GParamSpec * pspec)
{
	BudgieToplevel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_TYPE_TOPLEVEL, BudgieToplevel);
	switch (property_id) {
		case BUDGIE_TOPLEVEL_SHADOW_DEPTH_PROPERTY:
		budgie_toplevel_set_shadow_depth (self, g_value_get_int (value));
		break;
		case BUDGIE_TOPLEVEL_INTENDED_SIZE_PROPERTY:
		budgie_toplevel_set_intended_size (self, g_value_get_int (value));
		break;
		case BUDGIE_TOPLEVEL_INTENDED_SPACING_PROPERTY:
		budgie_toplevel_set_intended_spacing (self, g_value_get_int (value));
		break;
		case BUDGIE_TOPLEVEL_SHADOW_VISIBLE_PROPERTY:
		budgie_toplevel_set_shadow_visible (self, g_value_get_boolean (value));
		break;
		case BUDGIE_TOPLEVEL_THEME_REGIONS_PROPERTY:
		budgie_toplevel_set_theme_regions (self, g_value_get_boolean (value));
		break;
		case BUDGIE_TOPLEVEL_DOCK_MODE_PROPERTY:
		budgie_toplevel_set_dock_mode (self, g_value_get_boolean (value));
		break;
		case BUDGIE_TOPLEVEL_INTERSECTED_PROPERTY:
		budgie_toplevel_set_intersected (self, g_value_get_boolean (value));
		break;
		case BUDGIE_TOPLEVEL_UUID_PROPERTY:
		budgie_toplevel_set_uuid (self, g_value_get_string (value));
		break;
		case BUDGIE_TOPLEVEL_POSITION_PROPERTY:
		budgie_toplevel_set_position (self, g_value_get_flags (value));
		break;
		case BUDGIE_TOPLEVEL_TRANSPARENCY_PROPERTY:
		budgie_toplevel_set_transparency (self, g_value_get_flags (value));
		break;
		case BUDGIE_TOPLEVEL_AUTOHIDE_PROPERTY:
		budgie_toplevel_set_autohide (self, g_value_get_flags (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static GType
budgie_panel_transparency_get_type_once (void)
{
	static const GFlagsValue values[] = {{BUDGIE_PANEL_TRANSPARENCY_NONE, "BUDGIE_PANEL_TRANSPARENCY_NONE", "none"}, {BUDGIE_PANEL_TRANSPARENCY_DYNAMIC, "BUDGIE_PANEL_TRANSPARENCY_DYNAMIC", "dynamic"}, {BUDGIE_PANEL_TRANSPARENCY_ALWAYS, "BUDGIE_PANEL_TRANSPARENCY_ALWAYS", "always"}, {0, NULL, NULL}};
	GType budgie_panel_transparency_type_id;
	budgie_panel_transparency_type_id = g_flags_register_static ("BudgiePanelTransparency", values);
	return budgie_panel_transparency_type_id;
}

GType
budgie_panel_transparency_get_type (void)
{
	static volatile gsize budgie_panel_transparency_type_id__once = 0;
	if (g_once_init_enter (&budgie_panel_transparency_type_id__once)) {
		GType budgie_panel_transparency_type_id;
		budgie_panel_transparency_type_id = budgie_panel_transparency_get_type_once ();
		g_once_init_leave (&budgie_panel_transparency_type_id__once, budgie_panel_transparency_type_id);
	}
	return budgie_panel_transparency_type_id__once;
}

static GType
budgie_autohide_policy_get_type_once (void)
{
	static const GFlagsValue values[] = {{BUDGIE_AUTOHIDE_POLICY_NONE, "BUDGIE_AUTOHIDE_POLICY_NONE", "none"}, {BUDGIE_AUTOHIDE_POLICY_AUTOMATIC, "BUDGIE_AUTOHIDE_POLICY_AUTOMATIC", "automatic"}, {BUDGIE_AUTOHIDE_POLICY_INTELLIGENT, "BUDGIE_AUTOHIDE_POLICY_INTELLIGENT", "intelligent"}, {0, NULL, NULL}};
	GType budgie_autohide_policy_type_id;
	budgie_autohide_policy_type_id = g_flags_register_static ("BudgieAutohidePolicy", values);
	return budgie_autohide_policy_type_id;
}

GType
budgie_autohide_policy_get_type (void)
{
	static volatile gsize budgie_autohide_policy_type_id__once = 0;
	if (g_once_init_enter (&budgie_autohide_policy_type_id__once)) {
		GType budgie_autohide_policy_type_id;
		budgie_autohide_policy_type_id = budgie_autohide_policy_get_type_once ();
		g_once_init_leave (&budgie_autohide_policy_type_id__once, budgie_autohide_policy_type_id);
	}
	return budgie_autohide_policy_type_id__once;
}

gchar*
budgie_position_class_name (BudgiePanelPosition position)
{
	gchar* result;
	switch (position) {
		case BUDGIE_PANEL_POSITION_TOP:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("top");
			result = _tmp0_;
			return result;
		}
		case BUDGIE_PANEL_POSITION_BOTTOM:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("bottom");
			result = _tmp1_;
			return result;
		}
		case BUDGIE_PANEL_POSITION_LEFT:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("left");
			result = _tmp2_;
			return result;
		}
		case BUDGIE_PANEL_POSITION_RIGHT:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("right");
			result = _tmp3_;
			return result;
		}
		default:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("");
			result = _tmp4_;
			return result;
		}
	}
}

