/* polkitdialog.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from polkitdialog.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <polkitagent/polkitagent.h>
#include <polkit/polkit.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <libxfce4windowing/libxfce4windowing.h>
#include <gtk-layer-shell/gtk-layer-shell.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include <pwd.h>
#include <sys/types.h>
#include <grp.h>
#include "session.h"
#include <theme-manager.h>
#include <locale.h>
#include <budgie-config.h>
#include <unistd.h>
#include <stdio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define BUDGIE_TYPE_AGENT_DIALOG (budgie_agent_dialog_get_type ())
#define BUDGIE_AGENT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_AGENT_DIALOG, BudgieAgentDialog))
#define BUDGIE_AGENT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_AGENT_DIALOG, BudgieAgentDialogClass))
#define BUDGIE_IS_AGENT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_AGENT_DIALOG))
#define BUDGIE_IS_AGENT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_AGENT_DIALOG))
#define BUDGIE_AGENT_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_AGENT_DIALOG, BudgieAgentDialogClass))

typedef struct _BudgieAgentDialog BudgieAgentDialog;
typedef struct _BudgieAgentDialogClass BudgieAgentDialogClass;
typedef struct _BudgieAgentDialogPrivate BudgieAgentDialogPrivate;
enum  {
	BUDGIE_AGENT_DIALOG_0_PROPERTY,
	BUDGIE_AGENT_DIALOG_ACTION_ID_PROPERTY,
	BUDGIE_AGENT_DIALOG_MESSAGE_PROPERTY,
	BUDGIE_AGENT_DIALOG_AUTH_DATA_PROPERTY,
	BUDGIE_AGENT_DIALOG_AUTH_ICON_NAME_PROPERTY,
	BUDGIE_AGENT_DIALOG_ACTION_DESC_PROPERTY,
	BUDGIE_AGENT_DIALOG_CANCELLABLE_PROPERTY,
	BUDGIE_AGENT_DIALOG_COOKIE_PROPERTY,
	BUDGIE_AGENT_DIALOG_NUM_PROPERTIES
};
static GParamSpec* budgie_agent_dialog_properties[BUDGIE_AGENT_DIALOG_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block1Data Block1Data;
typedef struct _Block2Data Block2Data;
typedef struct _Block3Data Block3Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
enum  {
	BUDGIE_AGENT_DIALOG_DONE_SIGNAL,
	BUDGIE_AGENT_DIALOG_NUM_SIGNALS
};
static guint budgie_agent_dialog_signals[BUDGIE_AGENT_DIALOG_NUM_SIGNALS] = {0};

#define BUDGIE_TYPE_AGENT (budgie_agent_get_type ())
#define BUDGIE_AGENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_AGENT, BudgieAgent))
#define BUDGIE_AGENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_AGENT, BudgieAgentClass))
#define BUDGIE_IS_AGENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_AGENT))
#define BUDGIE_IS_AGENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_AGENT))
#define BUDGIE_AGENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_AGENT, BudgieAgentClass))

typedef struct _BudgieAgent BudgieAgent;
typedef struct _BudgieAgentClass BudgieAgentClass;
typedef struct _BudgieAgentPrivate BudgieAgentPrivate;
enum  {
	BUDGIE_AGENT_0_PROPERTY,
	BUDGIE_AGENT_NUM_PROPERTIES
};
static GParamSpec* budgie_agent_properties[BUDGIE_AGENT_NUM_PROPERTIES];
typedef struct _Block4Data Block4Data;
typedef struct _BudgieAgentInitiateAuthenticationData BudgieAgentInitiateAuthenticationData;
typedef struct _BudgieAgentRegisterWithSessionData BudgieAgentRegisterWithSessionData;
enum  {
	BUDGIE_AGENT_STOPAGENT_SIGNAL,
	BUDGIE_AGENT_NUM_SIGNALS
};
static guint budgie_agent_signals[BUDGIE_AGENT_NUM_SIGNALS] = {0};
typedef struct _Block5Data Block5Data;

struct _BudgieAgentDialog {
	GtkWindow parent_instance;
	BudgieAgentDialogPrivate * priv;
	gboolean is_cancelled;
	PolkitAgentSession* pk_session;
};

struct _BudgieAgentDialogClass {
	GtkWindowClass parent_class;
};

struct _BudgieAgentDialogPrivate {
	GtkEntry* entry_auth;
	GtkLabel* label_message;
	GtkImage* image_icon;
	GtkComboBox* combobox_idents;
	GtkLabel* label_username;
	GtkLabel* label_identity;
	GtkLabel* label_prompt;
	GtkLabel* label_error;
	GtkRevealer* details_revealer;
	GtkLabel* label_action_value;
	GtkLabel* label_id_value;
	PolkitIdentity* pk_identity;
	gchar* _icon;
	GCancellable* _cancellable;
	gchar* _cookie;
	gulong error_id;
	gulong request_id;
	gulong info_id;
	gulong complete_id;
};

struct _Block1Data {
	int _ref_count_;
	BudgieAgentDialog* self;
	gchar* action_id;
};

struct _Block2Data {
	int _ref_count_;
	Block1Data * _data1_;
	PolkitAuthority* authority;
};

struct _Block3Data {
	int _ref_count_;
	Block2Data * _data2_;
	PolkitActionDescription* action;
};

struct _BudgieAgent {
	PolkitAgentListener parent_instance;
	BudgieAgentPrivate * priv;
};

struct _BudgieAgentClass {
	PolkitAgentListenerClass parent_class;
};

struct _BudgieAgentPrivate {
	LibSessionSessionClient* sclient;
	BudgieThemeManager* theme_manager;
};

struct _Block4Data {
	int _ref_count_;
	BudgieAgent* self;
	gpointer _async_data_;
};

struct _BudgieAgentInitiateAuthenticationData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	BudgieAgent* self;
	gchar* action_id;
	gchar* message;
	gchar* icon_name;
	PolkitDetails* details;
	gchar* cookie;
	GList* identities;
	GCancellable* cancellable;
	gboolean result;
	Block4Data* _data4_;
	BudgieAgentDialog* dialog;
	BudgieAgentDialog* _tmp0_;
	BudgieAgentDialog* _tmp1_;
	BudgieAgentDialog* _tmp2_;
	BudgieAgentDialog* _tmp3_;
	BudgieAgentDialog* _tmp4_;
	BudgieAgentDialog* _tmp5_;
	BudgieAgentDialog* _tmp6_;
	GError* _tmp7_;
	GError* _inner_error0_;
};

struct _BudgieAgentRegisterWithSessionData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	BudgieAgent* self;
	gboolean result;
	LibSessionSessionClient* _tmp0_;
	LibSessionSessionClient* _tmp1_;
	LibSessionSessionClient* _tmp2_;
	LibSessionSessionClient* _tmp3_;
	LibSessionSessionClient* _tmp4_;
};

struct _Block5Data {
	int _ref_count_;
	void* agenthandle;
};

static gint BudgieAgentDialog_private_offset;
static gpointer budgie_agent_dialog_parent_class = NULL;
static gint BudgieAgent_private_offset;
static gpointer budgie_agent_parent_class = NULL;

VALA_EXTERN GType budgie_agent_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieAgentDialog, g_object_unref)
VALA_EXTERN BudgieAgentDialog* budgie_agent_dialog_new (const gchar* action_id,
                                            const gchar* message,
                                            const gchar* icon_name,
                                            const gchar* cookie,
                                            GCancellable* cancellable);
VALA_EXTERN BudgieAgentDialog* budgie_agent_dialog_construct (GType object_type,
                                                  const gchar* action_id,
                                                  const gchar* message,
                                                  const gchar* icon_name,
                                                  const gchar* cookie,
                                                  GCancellable* cancellable);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void ___lambda4_ (Block2Data* _data2_,
                  GObject* obj,
                  GAsyncResult* res);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void ___lambda5_ (Block3Data* _data3_,
                  PolkitActionDescription* a);
static void ____lambda5__gfunc (gconstpointer data,
                         gpointer self);
VALA_EXTERN void budgie_agent_dialog_set_action_desc (BudgieAgentDialog* self,
                                          const gchar* value);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void ____lambda4__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void budgie_agent_dialog_on_ident_changed (BudgieAgentDialog* self);
static void _budgie_agent_dialog_on_ident_changed_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                  gpointer self);
static gboolean budgie_agent_dialog_on_key_release (BudgieAgentDialog* self,
                                             GdkEventKey* key);
static gboolean _budgie_agent_dialog_on_key_release_gtk_widget_key_release_event (GtkWidget* _sender,
                                                                           GdkEventKey* event,
                                                                           gpointer self);
static void budgie_agent_dialog_on_agent_cancelled (BudgieAgentDialog* self);
static void _budgie_agent_dialog_on_agent_cancelled_g_cancellable_cancelled (GCancellable* _sender,
                                                                      gpointer self);
static void budgie_agent_dialog_on_entry_auth_activate (BudgieAgentDialog* self);
static void budgie_agent_dialog_on_agent_authenticate (BudgieAgentDialog* self);
static void _budgie_agent_dialog_on_entry_auth_activate_gtk_entry_activate (GtkEntry* _sender,
                                                                     gpointer self);
static void budgie_agent_dialog_on_details_button_clicked (BudgieAgentDialog* self,
                                                    GtkButton* button);
static void _budgie_agent_dialog_on_details_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                        gpointer self);
static void budgie_agent_dialog_real_show (GtkWidget* base);
static void budgie_agent_dialog_on_pk_session_completed (BudgieAgentDialog* self,
                                                  gboolean authorized);
static void budgie_agent_dialog_deselect_session (BudgieAgentDialog* self);
VALA_EXTERN void budgie_agent_dialog_set_auth_data (BudgieAgentDialog* self,
                                        const gchar* value);
static void budgie_agent_dialog_select_session (BudgieAgentDialog* self);
static void budgie_agent_dialog_on_pk_request (BudgieAgentDialog* self,
                                        const gchar* request,
                                        gboolean echo_on);
static void budgie_agent_dialog_on_pk_error (BudgieAgentDialog* self,
                                      const gchar* text);
static void budgie_agent_dialog_on_pk_info (BudgieAgentDialog* self,
                                     const gchar* text);
VALA_EXTERN const gchar* budgie_agent_dialog_get_cookie (BudgieAgentDialog* self);
static void _budgie_agent_dialog_on_pk_session_completed_polkit_agent_session_completed (PolkitAgentSession* _sender,
                                                                                  gboolean gained_authorization,
                                                                                  gpointer self);
static void _budgie_agent_dialog_on_pk_request_polkit_agent_session_request (PolkitAgentSession* _sender,
                                                                      const gchar* request,
                                                                      gboolean echo_on,
                                                                      gpointer self);
static void _budgie_agent_dialog_on_pk_error_polkit_agent_session_show_error (PolkitAgentSession* _sender,
                                                                       const gchar* text,
                                                                       gpointer self);
static void _budgie_agent_dialog_on_pk_info_polkit_agent_session_show_info (PolkitAgentSession* _sender,
                                                                     const gchar* text,
                                                                     gpointer self);
VALA_EXTERN void budgie_agent_dialog_set_from_idents (BudgieAgentDialog* self,
                                          GList* idents);
VALA_EXTERN gchar* budgie_agent_dialog_get_auth_data (BudgieAgentDialog* self);
static void _budgie_agent_dialog_on_agent_authenticate_gtk_button_clicked (GtkButton* _sender,
                                                                    gpointer self);
static void _budgie_agent_dialog_on_agent_cancelled_gtk_button_clicked (GtkButton* _sender,
                                                                 gpointer self);
VALA_EXTERN const gchar* budgie_agent_dialog_get_action_id (BudgieAgentDialog* self);
VALA_EXTERN void budgie_agent_dialog_set_action_id (BudgieAgentDialog* self,
                                        const gchar* value);
VALA_EXTERN gchar* budgie_agent_dialog_get_message (BudgieAgentDialog* self);
VALA_EXTERN void budgie_agent_dialog_set_message (BudgieAgentDialog* self,
                                      const gchar* value);
VALA_EXTERN const gchar* budgie_agent_dialog_get_auth_icon_name (BudgieAgentDialog* self);
VALA_EXTERN void budgie_agent_dialog_set_auth_icon_name (BudgieAgentDialog* self,
                                             const gchar* value);
VALA_EXTERN const gchar* budgie_agent_dialog_get_action_desc (BudgieAgentDialog* self);
VALA_EXTERN GCancellable* budgie_agent_dialog_get_cancellable (BudgieAgentDialog* self);
VALA_EXTERN void budgie_agent_dialog_set_cancellable (BudgieAgentDialog* self,
                                          GCancellable* value);
VALA_EXTERN void budgie_agent_dialog_set_cookie (BudgieAgentDialog* self,
                                     const gchar* value);
static void budgie_agent_dialog_finalize (GObject * obj);
static GType budgie_agent_dialog_get_type_once (void);
static void _vala_budgie_agent_dialog_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec);
static void _vala_budgie_agent_dialog_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec);
VALA_EXTERN GType budgie_agent_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieAgent, g_object_unref)
static void budgie_agent_real_initiate_authentication_data_free (gpointer _data);
static void budgie_agent_real_initiate_authentication (PolkitAgentListener* base,
                                                const gchar* action_id,
                                                const gchar* message,
                                                const gchar* icon_name,
                                                PolkitDetails* details,
                                                const gchar* cookie,
                                                GList* identities,
                                                GCancellable* cancellable,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_);
static gboolean budgie_agent_real_initiate_authentication_co (BudgieAgentInitiateAuthenticationData* _data_);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void __lambda6_ (Block4Data* _data4_);
static void ___lambda6__budgie_agent_dialog_done (BudgieAgentDialog* _sender,
                                           gpointer self);
VALA_EXTERN BudgieAgent* budgie_agent_new (void);
VALA_EXTERN BudgieAgent* budgie_agent_construct (GType object_type);
static void budgie_agent_register_with_session (BudgieAgent* self,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_);
static gboolean budgie_agent_register_with_session_finish (BudgieAgent* self,
                                                    GAsyncResult* _res_);
static void __lambda10_ (BudgieAgent* self,
                  GObject* o,
                  GAsyncResult* res);
static void ___lambda10__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void budgie_agent_register_with_session_data_free (gpointer _data);
static gboolean budgie_agent_register_with_session_co (BudgieAgentRegisterWithSessionData* _data_);
static void budgie_agent_register_with_session_ready (GObject* source_object,
                                               GAsyncResult* _res_,
                                               gpointer _user_data_);
static void __lambda7_ (BudgieAgent* self);
static void budgie_agent_end_session (BudgieAgent* self,
                               gboolean quit);
static void ___lambda7__lib_session_session_client_query_end_session (LibSessionSessionClient* _sender,
                                                               guint flags,
                                                               gpointer self);
static void __lambda8_ (BudgieAgent* self);
static void ___lambda8__lib_session_session_client_end_session (LibSessionSessionClient* _sender,
                                                         guint flags,
                                                         gpointer self);
static void __lambda9_ (BudgieAgent* self);
static void ___lambda9__lib_session_session_client_stop (LibSessionSessionClient* _sender,
                                                  gpointer self);
static void budgie_agent_finalize (GObject * obj);
static GType budgie_agent_get_type_once (void);
static gint _vala_main (gchar** args,
                 gint args_length1);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void ___lambda11_ (Block5Data* _data5_);
static void ____lambda11__budgie_agent_stopagent (BudgieAgent* _sender,
                                           gpointer self);

static inline gpointer
budgie_agent_dialog_get_instance_private (BudgieAgentDialog* self)
{
	return G_STRUCT_MEMBER_P (self, BudgieAgentDialog_private_offset);
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		BudgieAgentDialog* self;
		self = _data1_->self;
		_g_free0 (_data1_->action_id);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		BudgieAgentDialog* self;
		self = _data2_->_data1_->self;
		_g_object_unref0 (_data2_->authority);
		block1_data_unref (_data2_->_data1_);
		_data2_->_data1_ = NULL;
		g_slice_free (Block2Data, _data2_);
	}
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		BudgieAgentDialog* self;
		self = _data3_->_data2_->_data1_->self;
		_g_object_unref0 (_data3_->action);
		block2_data_unref (_data3_->_data2_);
		_data3_->_data2_ = NULL;
		g_slice_free (Block3Data, _data3_);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
___lambda5_ (Block3Data* _data3_,
             PolkitActionDescription* a)
{
	Block2Data* _data2_;
	Block1Data* _data1_;
	BudgieAgentDialog* self;
	const gchar* _tmp0_;
	_data2_ = _data3_->_data2_;
	_data1_ = _data2_->_data1_;
	self = _data1_->self;
	g_return_if_fail (a != NULL);
	_tmp0_ = polkit_action_description_get_action_id (a);
	if (g_strcmp0 (_tmp0_, _data1_->action_id) == 0) {
		PolkitActionDescription* _tmp1_;
		_tmp1_ = _g_object_ref0 (a);
		_g_object_unref0 (_data3_->action);
		_data3_->action = _tmp1_;
		return;
	}
}

static void
____lambda5__gfunc (gconstpointer data,
                    gpointer self)
{
	___lambda5_ (self, (PolkitActionDescription*) data);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
___lambda4_ (Block2Data* _data2_,
             GObject* obj,
             GAsyncResult* res)
{
	Block1Data* _data1_;
	BudgieAgentDialog* self;
	GError* _inner_error0_ = NULL;
	_data1_ = _data2_->_data1_;
	self = _data1_->self;
	g_return_if_fail (res != NULL);
	{
		Block3Data* _data3_;
		GList* actions = NULL;
		GList* _tmp0_;
		PolkitActionDescription* _tmp1_;
		_data3_ = g_slice_new0 (Block3Data);
		_data3_->_ref_count_ = 1;
		_data3_->_data2_ = block2_data_ref (_data2_);
		_tmp0_ = polkit_authority_enumerate_actions_finish (_data2_->authority, res, &_inner_error0_);
		actions = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			block3_data_unref (_data3_);
			_data3_ = NULL;
			goto __catch0_g_error;
		}
		_data3_->action = NULL;
		g_list_foreach (actions, ____lambda5__gfunc, _data3_);
		_tmp1_ = _data3_->action;
		if (_tmp1_ != NULL) {
			PolkitActionDescription* _tmp2_;
			const gchar* _tmp3_;
			_tmp2_ = _data3_->action;
			_tmp3_ = polkit_action_description_get_description (_tmp2_);
			budgie_agent_dialog_set_action_desc (self, _tmp3_);
		}
		(actions == NULL) ? NULL : (actions = (_g_list_free__g_object_unref0_ (actions), NULL));
		block3_data_unref (_data3_);
		_data3_ = NULL;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("polkitdialog.vala:138: Error enumerating Polkit actions: %s", _tmp5_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
____lambda4__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	___lambda4_ (self, source_object, res);
	block2_data_unref (self);
}

static void
_budgie_agent_dialog_on_ident_changed_gtk_combo_box_changed (GtkComboBox* _sender,
                                                             gpointer self)
{
	budgie_agent_dialog_on_ident_changed ((BudgieAgentDialog*) self);
}

static gboolean
_budgie_agent_dialog_on_key_release_gtk_widget_key_release_event (GtkWidget* _sender,
                                                                  GdkEventKey* event,
                                                                  gpointer self)
{
	gboolean result;
	result = budgie_agent_dialog_on_key_release ((BudgieAgentDialog*) self, event);
	return result;
}

static void
_budgie_agent_dialog_on_agent_cancelled_g_cancellable_cancelled (GCancellable* _sender,
                                                                 gpointer self)
{
	budgie_agent_dialog_on_agent_cancelled ((BudgieAgentDialog*) self);
}

BudgieAgentDialog*
budgie_agent_dialog_construct (GType object_type,
                               const gchar* action_id,
                               const gchar* message,
                               const gchar* icon_name,
                               const gchar* cookie,
                               GCancellable* cancellable)
{
	BudgieAgentDialog * self = NULL;
	Block1Data* _data1_;
	gchar* _tmp0_;
	GtkEventBox* header = NULL;
	GtkEventBox* _tmp1_;
	GtkStyleContext* _tmp2_;
	GtkComboBox* _tmp6_;
	GtkCellRendererText* render = NULL;
	GtkCellRendererText* _tmp7_;
	GtkComboBox* _tmp8_;
	GtkComboBox* _tmp9_;
	GtkComboBox* _tmp10_;
	XfwMonitor* primary_monitor = NULL;
	XfwScreen* _tmp11_;
	XfwScreen* _tmp12_;
	XfwMonitor* _tmp13_;
	XfwMonitor* _tmp14_;
	XfwMonitor* _tmp15_;
	GdkMonitor* _tmp16_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (action_id != NULL, NULL);
	g_return_val_if_fail (message != NULL, NULL);
	g_return_val_if_fail (icon_name != NULL, NULL);
	g_return_val_if_fail (cookie != NULL, NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_tmp0_ = g_strdup (action_id);
	_g_free0 (_data1_->action_id);
	_data1_->action_id = _tmp0_;
	self = (BudgieAgentDialog*) g_object_new (object_type, "action-id", _data1_->action_id, "message", message, "auth-icon-name", icon_name, "cookie", cookie, "cancellable", cancellable, "resizable", FALSE, NULL);
	_data1_->self = g_object_ref (self);
	gtk_window_set_keep_above ((GtkWindow*) self, TRUE);
	_tmp1_ = (GtkEventBox*) gtk_event_box_new ();
	g_object_ref_sink (_tmp1_);
	header = _tmp1_;
	gtk_window_set_titlebar ((GtkWindow*) self, (GtkWidget*) header);
	_tmp2_ = gtk_widget_get_style_context ((GtkWidget*) header);
	gtk_style_context_remove_class (_tmp2_, "titlebar");
	{
		Block2Data* _data2_;
		PolkitAuthority* _tmp3_;
		_data2_ = g_slice_new0 (Block2Data);
		_data2_->_ref_count_ = 1;
		_data2_->_data1_ = block1_data_ref (_data1_);
		_tmp3_ = polkit_authority_get_sync (NULL, &_inner_error0_);
		_data2_->authority = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			block2_data_unref (_data2_);
			_data2_ = NULL;
			goto __catch0_g_error;
		}
		polkit_authority_enumerate_actions (_data2_->authority, NULL, ____lambda4__gasync_ready_callback, block2_data_ref (_data2_));
		block2_data_unref (_data2_);
		_data2_ = NULL;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("polkitdialog.vala:142: Error getting Polkit Authority: %s", _tmp5_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (header);
		block1_data_unref (_data1_);
		_data1_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp6_ = self->priv->combobox_idents;
	g_signal_connect_object (_tmp6_, "changed", (GCallback) _budgie_agent_dialog_on_ident_changed_gtk_combo_box_changed, self, 0);
	_tmp7_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp7_);
	render = _tmp7_;
	_tmp8_ = self->priv->combobox_idents;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp8_, (GtkCellRenderer*) render, TRUE);
	_tmp9_ = self->priv->combobox_idents;
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp9_, (GtkCellRenderer*) render, "text", 0);
	_tmp10_ = self->priv->combobox_idents;
	gtk_combo_box_set_id_column (_tmp10_, 0);
	_tmp11_ = xfw_screen_get_default ();
	_tmp12_ = _tmp11_;
	_tmp13_ = xfw_screen_get_primary_monitor (_tmp12_);
	_tmp14_ = _g_object_ref0 (_tmp13_);
	_tmp15_ = _tmp14_;
	_g_object_unref0 (_tmp12_);
	primary_monitor = _tmp15_;
	gtk_layer_init_for_window ((GtkWindow*) self);
	gtk_layer_set_layer ((GtkWindow*) self, GTK_LAYER_SHELL_LAYER_TOP);
	_tmp16_ = xfw_monitor_get_gdk_monitor (primary_monitor);
	gtk_layer_set_monitor ((GtkWindow*) self, _tmp16_);
	gtk_layer_set_anchor ((GtkWindow*) self, GTK_LAYER_SHELL_EDGE_LEFT, FALSE);
	gtk_layer_set_anchor ((GtkWindow*) self, GTK_LAYER_SHELL_EDGE_TOP, FALSE);
	gtk_layer_set_keyboard_mode ((GtkWindow*) self, GTK_LAYER_SHELL_KEYBOARD_MODE_ON_DEMAND);
	g_signal_connect_object ((GtkWidget*) self, "key-release-event", (GCallback) _budgie_agent_dialog_on_key_release_gtk_widget_key_release_event, self, 0);
	g_signal_connect_object (cancellable, "cancelled", (GCallback) _budgie_agent_dialog_on_agent_cancelled_g_cancellable_cancelled, self, 0);
	_g_object_unref0 (primary_monitor);
	_g_object_unref0 (render);
	_g_object_unref0 (header);
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return self;
}

BudgieAgentDialog*
budgie_agent_dialog_new (const gchar* action_id,
                         const gchar* message,
                         const gchar* icon_name,
                         const gchar* cookie,
                         GCancellable* cancellable)
{
	return budgie_agent_dialog_construct (BUDGIE_TYPE_AGENT_DIALOG, action_id, message, icon_name, cookie, cancellable);
}

static gboolean
budgie_agent_dialog_on_key_release (BudgieAgentDialog* self,
                                    GdkEventKey* key)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	if (key->keyval == GDK_KEY_Escape) {
		budgie_agent_dialog_on_agent_cancelled (self);
		result = GDK_EVENT_STOP;
		return result;
	}
	result = GDK_EVENT_PROPAGATE;
	return result;
}

static void
budgie_agent_dialog_on_entry_auth_activate (BudgieAgentDialog* self)
{
	g_return_if_fail (self != NULL);
	budgie_agent_dialog_on_agent_authenticate (self);
}

static void
_budgie_agent_dialog_on_entry_auth_activate_gtk_entry_activate (GtkEntry* _sender,
                                                                gpointer self)
{
	budgie_agent_dialog_on_entry_auth_activate ((BudgieAgentDialog*) self);
}

static void
budgie_agent_dialog_on_details_button_clicked (BudgieAgentDialog* self,
                                               GtkButton* button)
{
	GtkRevealer* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	_tmp0_ = self->priv->details_revealer;
	if (gtk_revealer_get_reveal_child (_tmp0_)) {
		GtkRevealer* _tmp1_;
		GtkImage* _tmp2_;
		GtkImage* _tmp3_;
		_tmp1_ = self->priv->details_revealer;
		gtk_revealer_set_reveal_child (_tmp1_, FALSE);
		_tmp2_ = (GtkImage*) gtk_image_new_from_icon_name ("pan-end-symbolic", (GtkIconSize) GTK_ICON_SIZE_BUTTON);
		g_object_ref_sink (_tmp2_);
		_tmp3_ = _tmp2_;
		gtk_button_set_image (button, (GtkWidget*) _tmp3_);
		_g_object_unref0 (_tmp3_);
	} else {
		GtkRevealer* _tmp4_;
		GtkImage* _tmp5_;
		GtkImage* _tmp6_;
		_tmp4_ = self->priv->details_revealer;
		gtk_revealer_set_reveal_child (_tmp4_, TRUE);
		_tmp5_ = (GtkImage*) gtk_image_new_from_icon_name ("pan-down-symbolic", (GtkIconSize) GTK_ICON_SIZE_BUTTON);
		g_object_ref_sink (_tmp5_);
		_tmp6_ = _tmp5_;
		gtk_button_set_image (button, (GtkWidget*) _tmp6_);
		_g_object_unref0 (_tmp6_);
	}
}

static void
_budgie_agent_dialog_on_details_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                   gpointer self)
{
	budgie_agent_dialog_on_details_button_clicked ((BudgieAgentDialog*) self, _sender);
}

static void
budgie_agent_dialog_real_show (GtkWidget* base)
{
	BudgieAgentDialog * self;
	GdkWindow* win = NULL;
	GdkWindow* _tmp0_;
	GdkWindow* _tmp1_;
	GdkWindow* _tmp2_;
	GtkEntry* _tmp3_;
	self = (BudgieAgentDialog*) base;
	GTK_WIDGET_CLASS (budgie_agent_dialog_parent_class)->show ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow));
	win = NULL;
	_tmp0_ = gtk_widget_get_window ((GtkWidget*) self);
	win = _tmp0_;
	_tmp1_ = win;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp2_ = win;
	gdk_window_focus (_tmp2_, (guint32) GDK_CURRENT_TIME);
	_tmp3_ = self->priv->entry_auth;
	gtk_widget_grab_focus ((GtkWidget*) _tmp3_);
}

static void
budgie_agent_dialog_on_pk_session_completed (BudgieAgentDialog* self,
                                             gboolean authorized)
{
	g_return_if_fail (self != NULL);
	gtk_widget_set_sensitive ((GtkWidget*) self, TRUE);
	if (!authorized) {
		GtkLabel* _tmp0_;
		PolkitAgentSession* session = NULL;
		PolkitAgentSession* _tmp1_;
		PolkitAgentSession* _tmp2_;
		GtkEntry* _tmp3_;
		PolkitAgentSession* _tmp4_;
		PolkitAgentSession* _tmp5_;
		_tmp0_ = self->priv->label_error;
		gtk_label_set_text (_tmp0_, _ ("Authentication failed"));
		_tmp1_ = self->pk_session;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		session = _tmp2_;
		budgie_agent_dialog_deselect_session (self);
		budgie_agent_dialog_set_auth_data (self, "");
		_tmp3_ = self->priv->entry_auth;
		gtk_widget_grab_focus ((GtkWidget*) _tmp3_);
		_tmp4_ = session;
		_tmp5_ = _g_object_ref0 (_tmp4_);
		_g_object_unref0 (self->pk_session);
		self->pk_session = _tmp5_;
		budgie_agent_dialog_select_session (self);
		_g_object_unref0 (session);
		return;
	}
	g_signal_emit (self, budgie_agent_dialog_signals[BUDGIE_AGENT_DIALOG_DONE_SIGNAL], 0);
}

static void
budgie_agent_dialog_on_pk_request (BudgieAgentDialog* self,
                                   const gchar* request,
                                   gboolean echo_on)
{
	GtkEntry* _tmp0_;
	GtkLabel* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (request != NULL);
	_tmp0_ = self->priv->entry_auth;
	gtk_entry_set_visibility (_tmp0_, echo_on);
	_tmp1_ = self->priv->label_prompt;
	gtk_label_set_text (_tmp1_, request);
}

static void
budgie_agent_dialog_on_pk_error (BudgieAgentDialog* self,
                                 const gchar* text)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	g_warning ("polkitdialog.vala:228: PkError: %s", text);
}

static void
budgie_agent_dialog_on_pk_info (BudgieAgentDialog* self,
                                const gchar* text)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	g_message ("polkitdialog.vala:232: PKInfo: %s", text);
}

static void
budgie_agent_dialog_deselect_session (BudgieAgentDialog* self)
{
	PolkitAgentSession* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->pk_session;
	if (_tmp0_ != NULL) {
		PolkitAgentSession* _tmp1_;
		PolkitAgentSession* _tmp2_;
		PolkitAgentSession* _tmp3_;
		PolkitAgentSession* _tmp4_;
		_tmp1_ = self->pk_session;
		g_signal_handler_disconnect (_tmp1_, self->priv->error_id);
		_tmp2_ = self->pk_session;
		g_signal_handler_disconnect (_tmp2_, self->priv->complete_id);
		_tmp3_ = self->pk_session;
		g_signal_handler_disconnect (_tmp3_, self->priv->request_id);
		_tmp4_ = self->pk_session;
		g_signal_handler_disconnect (_tmp4_, self->priv->info_id);
	}
	_g_object_unref0 (self->pk_session);
	self->pk_session = NULL;
}

static void
_budgie_agent_dialog_on_pk_session_completed_polkit_agent_session_completed (PolkitAgentSession* _sender,
                                                                             gboolean gained_authorization,
                                                                             gpointer self)
{
	budgie_agent_dialog_on_pk_session_completed ((BudgieAgentDialog*) self, gained_authorization);
}

static void
_budgie_agent_dialog_on_pk_request_polkit_agent_session_request (PolkitAgentSession* _sender,
                                                                 const gchar* request,
                                                                 gboolean echo_on,
                                                                 gpointer self)
{
	budgie_agent_dialog_on_pk_request ((BudgieAgentDialog*) self, request, echo_on);
}

static void
_budgie_agent_dialog_on_pk_error_polkit_agent_session_show_error (PolkitAgentSession* _sender,
                                                                  const gchar* text,
                                                                  gpointer self)
{
	budgie_agent_dialog_on_pk_error ((BudgieAgentDialog*) self, text);
}

static void
_budgie_agent_dialog_on_pk_info_polkit_agent_session_show_info (PolkitAgentSession* _sender,
                                                                const gchar* text,
                                                                gpointer self)
{
	budgie_agent_dialog_on_pk_info ((BudgieAgentDialog*) self, text);
}

static void
budgie_agent_dialog_select_session (BudgieAgentDialog* self)
{
	PolkitAgentSession* _tmp0_;
	PolkitIdentity* _tmp1_;
	const gchar* _tmp2_;
	PolkitAgentSession* _tmp3_;
	PolkitAgentSession* _tmp4_;
	gulong _tmp5_;
	PolkitAgentSession* _tmp6_;
	gulong _tmp7_;
	PolkitAgentSession* _tmp8_;
	gulong _tmp9_;
	PolkitAgentSession* _tmp10_;
	gulong _tmp11_;
	PolkitAgentSession* _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->pk_session;
	if (_tmp0_ != NULL) {
		budgie_agent_dialog_deselect_session (self);
	}
	_tmp1_ = self->priv->pk_identity;
	_tmp2_ = self->priv->_cookie;
	_tmp3_ = polkit_agent_session_new (_tmp1_, _tmp2_);
	_g_object_unref0 (self->pk_session);
	self->pk_session = _tmp3_;
	_tmp4_ = self->pk_session;
	_tmp5_ = g_signal_connect_object (_tmp4_, "completed", (GCallback) _budgie_agent_dialog_on_pk_session_completed_polkit_agent_session_completed, self, 0);
	self->priv->complete_id = _tmp5_;
	_tmp6_ = self->pk_session;
	_tmp7_ = g_signal_connect_object (_tmp6_, "request", (GCallback) _budgie_agent_dialog_on_pk_request_polkit_agent_session_request, self, 0);
	self->priv->request_id = _tmp7_;
	_tmp8_ = self->pk_session;
	_tmp9_ = g_signal_connect_object (_tmp8_, "show-error", (GCallback) _budgie_agent_dialog_on_pk_error_polkit_agent_session_show_error, self, 0);
	self->priv->error_id = _tmp9_;
	_tmp10_ = self->pk_session;
	_tmp11_ = g_signal_connect_object (_tmp10_, "show-info", (GCallback) _budgie_agent_dialog_on_pk_info_polkit_agent_session_show_info, self, 0);
	self->priv->info_id = _tmp11_;
	_tmp12_ = self->pk_session;
	polkit_agent_session_initiate (_tmp12_);
}

static void
budgie_agent_dialog_on_ident_changed (BudgieAgentDialog* self)
{
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_;
	GtkTreeModel* model = NULL;
	GtkComboBox* _tmp3_;
	GtkTreeModel* _tmp4_;
	GtkTreeModel* _tmp5_;
	GtkTreeModel* _tmp6_;
	GtkTreeModel* _tmp7_;
	GtkTreeIter _tmp8_;
	PolkitIdentity* _tmp9_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->combobox_idents;
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	if (!_tmp2_) {
		budgie_agent_dialog_deselect_session (self);
		return;
	}
	_tmp3_ = self->priv->combobox_idents;
	_tmp4_ = gtk_combo_box_get_model (_tmp3_);
	_tmp5_ = _g_object_ref0 (_tmp4_);
	model = _tmp5_;
	_tmp6_ = model;
	if (_tmp6_ == NULL) {
		_g_object_unref0 (model);
		return;
	}
	_tmp7_ = model;
	_tmp8_ = iter;
	gtk_tree_model_get (_tmp7_, &_tmp8_, 1, &_tmp9_, -1, -1);
	_g_object_unref0 (self->priv->pk_identity);
	self->priv->pk_identity = _tmp9_;
	budgie_agent_dialog_select_session (self);
	_g_object_unref0 (model);
}

void
budgie_agent_dialog_set_from_idents (BudgieAgentDialog* self,
                                     GList* idents)
{
	GtkListStore* model = NULL;
	GtkListStore* _tmp0_;
	GtkTreeIter iter = {0};
	gint length = 0;
	gchar* name = NULL;
	GtkComboBox* _tmp22_;
	GtkListStore* _tmp23_;
	GtkComboBox* _tmp24_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_list_store_new (2, G_TYPE_STRING, polkit_identity_get_type (), -1);
	model = _tmp0_;
	length = 0;
	name = NULL;
	{
		GList* ident_collection = NULL;
		GList* ident_it = NULL;
		ident_collection = idents;
		for (ident_it = ident_collection; ident_it != NULL; ident_it = ident_it->next) {
			PolkitIdentity* ident = NULL;
			ident = (PolkitIdentity*) ident_it->data;
			{
				PolkitIdentity* _tmp1_;
				GtkListStore* _tmp15_;
				GtkTreeIter _tmp16_ = {0};
				GtkListStore* _tmp17_;
				GtkTreeIter _tmp18_;
				const gchar* _tmp19_;
				PolkitIdentity* _tmp20_;
				gint _tmp21_;
				_tmp1_ = ident;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, polkit_unix_user_get_type ())) {
					struct passwd* pwd = NULL;
					PolkitIdentity* _tmp2_;
					struct passwd* _tmp3_;
					struct passwd* _tmp4_;
					const gchar* _tmp5_;
					gchar* _tmp6_;
					_tmp2_ = ident;
					_tmp3_ = getpwuid ((uid_t) polkit_unix_user_get_uid (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, polkit_unix_user_get_type (), PolkitUnixUser)));
					pwd = _tmp3_;
					_tmp4_ = pwd;
					_tmp5_ = _tmp4_->pw_name;
					_tmp6_ = g_strdup_printf ("%s", _tmp5_);
					_g_free0 (name);
					name = _tmp6_;
				} else {
					PolkitIdentity* _tmp7_;
					_tmp7_ = ident;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, polkit_unix_group_get_type ())) {
						struct group* gwd = NULL;
						PolkitIdentity* _tmp8_;
						struct group* _tmp9_;
						struct group* _tmp10_;
						const gchar* _tmp11_;
						gchar* _tmp12_;
						_tmp8_ = ident;
						_tmp9_ = getgrgid ((gid_t) polkit_unix_group_get_gid (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, polkit_unix_group_get_type (), PolkitUnixGroup)));
						gwd = _tmp9_;
						_tmp10_ = gwd;
						_tmp11_ = _tmp10_->gr_name;
						_tmp12_ = g_strdup_printf ("%s: %s", _ ("Group:"), _tmp11_);
						_g_free0 (name);
						name = _tmp12_;
					} else {
						PolkitIdentity* _tmp13_;
						gchar* _tmp14_;
						_tmp13_ = ident;
						_tmp14_ = polkit_identity_to_string (_tmp13_);
						_g_free0 (name);
						name = _tmp14_;
					}
				}
				_tmp15_ = model;
				gtk_list_store_append (_tmp15_, &_tmp16_);
				iter = _tmp16_;
				_tmp17_ = model;
				_tmp18_ = iter;
				_tmp19_ = name;
				_tmp20_ = ident;
				gtk_list_store_set (_tmp17_, &_tmp18_, 0, _tmp19_, 1, _tmp20_, -1);
				length = length + 1;
				_tmp21_ = length;
			}
		}
	}
	_tmp22_ = self->priv->combobox_idents;
	_tmp23_ = model;
	gtk_combo_box_set_model (_tmp22_, (GtkTreeModel*) _tmp23_);
	_tmp24_ = self->priv->combobox_idents;
	gtk_combo_box_set_active (_tmp24_, 0);
	if (length < 2) {
		GtkComboBox* _tmp25_;
		GtkComboBox* _tmp26_;
		_tmp25_ = self->priv->combobox_idents;
		gtk_widget_set_no_show_all ((GtkWidget*) _tmp25_, TRUE);
		_tmp26_ = self->priv->combobox_idents;
		gtk_widget_hide ((GtkWidget*) _tmp26_);
	}
	if (length == 1) {
		GtkLabel* _tmp27_;
		GtkLabel* _tmp28_;
		GtkLabel* _tmp29_;
		const gchar* _tmp30_;
		_tmp27_ = self->priv->label_username;
		gtk_widget_set_visible ((GtkWidget*) _tmp27_, TRUE);
		_tmp28_ = self->priv->label_identity;
		gtk_widget_set_visible ((GtkWidget*) _tmp28_, TRUE);
		_tmp29_ = self->priv->label_identity;
		_tmp30_ = name;
		gtk_label_set_label (_tmp29_, _tmp30_);
	}
	_g_free0 (name);
	_g_object_unref0 (model);
}

static void
budgie_agent_dialog_on_agent_authenticate (BudgieAgentDialog* self)
{
	PolkitAgentSession* _tmp0_;
	GtkLabel* _tmp1_;
	PolkitAgentSession* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->pk_session;
	if (_tmp0_ == NULL) {
		return;
	}
	gtk_widget_set_sensitive ((GtkWidget*) self, FALSE);
	_tmp1_ = self->priv->label_error;
	gtk_label_set_text (_tmp1_, "");
	_tmp2_ = self->pk_session;
	_tmp3_ = budgie_agent_dialog_get_auth_data (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	polkit_agent_session_response (_tmp2_, _tmp5_);
	_g_free0 (_tmp5_);
}

static void
_budgie_agent_dialog_on_agent_authenticate_gtk_button_clicked (GtkButton* _sender,
                                                               gpointer self)
{
	budgie_agent_dialog_on_agent_authenticate ((BudgieAgentDialog*) self);
}

static void
budgie_agent_dialog_on_agent_cancelled (BudgieAgentDialog* self)
{
	PolkitAgentSession* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->pk_session;
	if (_tmp0_ != NULL) {
		PolkitAgentSession* _tmp1_;
		_tmp1_ = self->pk_session;
		polkit_agent_session_cancel (_tmp1_);
	}
	self->is_cancelled = TRUE;
	g_signal_emit (self, budgie_agent_dialog_signals[BUDGIE_AGENT_DIALOG_DONE_SIGNAL], 0);
}

static void
_budgie_agent_dialog_on_agent_cancelled_gtk_button_clicked (GtkButton* _sender,
                                                            gpointer self)
{
	budgie_agent_dialog_on_agent_cancelled ((BudgieAgentDialog*) self);
}

const gchar*
budgie_agent_dialog_get_action_id (BudgieAgentDialog* self)
{
	const gchar* result;
	GtkLabel* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->label_id_value;
	_tmp1_ = gtk_label_get_text (_tmp0_);
	result = _tmp1_;
	return result;
}

void
budgie_agent_dialog_set_action_id (BudgieAgentDialog* self,
                                   const gchar* value)
{
	GtkLabel* _tmp0_;
	GtkLabel* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->label_id_value;
	gtk_label_set_text (_tmp0_, value);
	_tmp1_ = self->priv->label_id_value;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp1_, value);
	g_object_notify_by_pspec ((GObject *) self, budgie_agent_dialog_properties[BUDGIE_AGENT_DIALOG_ACTION_ID_PROPERTY]);
}

gchar*
budgie_agent_dialog_get_message (BudgieAgentDialog* self)
{
	gchar* result;
	GtkLabel* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->label_message;
	_tmp1_ = gtk_label_get_text (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	result = _tmp2_;
	return result;
}

void
budgie_agent_dialog_set_message (BudgieAgentDialog* self,
                                 const gchar* value)
{
	GtkLabel* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->label_message;
	gtk_label_set_text (_tmp0_, value);
	g_object_notify_by_pspec ((GObject *) self, budgie_agent_dialog_properties[BUDGIE_AGENT_DIALOG_MESSAGE_PROPERTY]);
}

gchar*
budgie_agent_dialog_get_auth_data (BudgieAgentDialog* self)
{
	gchar* result;
	GtkEntry* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->entry_auth;
	_tmp1_ = gtk_entry_get_text (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	result = _tmp2_;
	return result;
}

void
budgie_agent_dialog_set_auth_data (BudgieAgentDialog* self,
                                   const gchar* value)
{
	GtkEntry* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->entry_auth;
	gtk_entry_set_text (_tmp0_, value);
	g_object_notify_by_pspec ((GObject *) self, budgie_agent_dialog_properties[BUDGIE_AGENT_DIALOG_AUTH_DATA_PROPERTY]);
}

const gchar*
budgie_agent_dialog_get_auth_icon_name (BudgieAgentDialog* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_icon;
	result = _tmp0_;
	return result;
}

void
budgie_agent_dialog_set_auth_icon_name (BudgieAgentDialog* self,
                                        const gchar* value)
{
	GtkImage* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->image_icon;
	gtk_image_set_from_icon_name (_tmp0_, value, (GtkIconSize) GTK_ICON_SIZE_DIALOG);
	_tmp1_ = g_strdup (value);
	_g_free0 (self->priv->_icon);
	self->priv->_icon = _tmp1_;
	g_object_notify_by_pspec ((GObject *) self, budgie_agent_dialog_properties[BUDGIE_AGENT_DIALOG_AUTH_ICON_NAME_PROPERTY]);
}

const gchar*
budgie_agent_dialog_get_action_desc (BudgieAgentDialog* self)
{
	const gchar* result;
	GtkLabel* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->label_action_value;
	_tmp1_ = gtk_label_get_text (_tmp0_);
	result = _tmp1_;
	return result;
}

void
budgie_agent_dialog_set_action_desc (BudgieAgentDialog* self,
                                     const gchar* value)
{
	GtkLabel* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->label_action_value;
	gtk_label_set_text (_tmp0_, value);
	g_object_notify_by_pspec ((GObject *) self, budgie_agent_dialog_properties[BUDGIE_AGENT_DIALOG_ACTION_DESC_PROPERTY]);
}

GCancellable*
budgie_agent_dialog_get_cancellable (BudgieAgentDialog* self)
{
	GCancellable* result;
	GCancellable* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_cancellable;
	result = _tmp0_;
	return result;
}

void
budgie_agent_dialog_set_cancellable (BudgieAgentDialog* self,
                                     GCancellable* value)
{
	GCancellable* old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_agent_dialog_get_cancellable (self);
	if (old_value != value) {
		self->priv->_cancellable = value;
		g_object_notify_by_pspec ((GObject *) self, budgie_agent_dialog_properties[BUDGIE_AGENT_DIALOG_CANCELLABLE_PROPERTY]);
	}
}

const gchar*
budgie_agent_dialog_get_cookie (BudgieAgentDialog* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_cookie;
	result = _tmp0_;
	return result;
}

void
budgie_agent_dialog_set_cookie (BudgieAgentDialog* self,
                                const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_agent_dialog_get_cookie (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_cookie);
		self->priv->_cookie = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, budgie_agent_dialog_properties[BUDGIE_AGENT_DIALOG_COOKIE_PROPERTY]);
	}
}

static void
budgie_agent_dialog_class_init (BudgieAgentDialogClass * klass,
                                gpointer klass_data)
{
	budgie_agent_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BudgieAgentDialog_private_offset);
	((GtkWidgetClass *) klass)->show = (void (*) (GtkWidget*)) budgie_agent_dialog_real_show;
	G_OBJECT_CLASS (klass)->get_property = _vala_budgie_agent_dialog_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_budgie_agent_dialog_set_property;
	G_OBJECT_CLASS (klass)->finalize = budgie_agent_dialog_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_AGENT_DIALOG_ACTION_ID_PROPERTY, budgie_agent_dialog_properties[BUDGIE_AGENT_DIALOG_ACTION_ID_PROPERTY] = g_param_spec_string ("action-id", "action-id", "action-id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_AGENT_DIALOG_MESSAGE_PROPERTY, budgie_agent_dialog_properties[BUDGIE_AGENT_DIALOG_MESSAGE_PROPERTY] = g_param_spec_string ("message", "message", "message", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_AGENT_DIALOG_AUTH_DATA_PROPERTY, budgie_agent_dialog_properties[BUDGIE_AGENT_DIALOG_AUTH_DATA_PROPERTY] = g_param_spec_string ("auth-data", "auth-data", "auth-data", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_AGENT_DIALOG_AUTH_ICON_NAME_PROPERTY, budgie_agent_dialog_properties[BUDGIE_AGENT_DIALOG_AUTH_ICON_NAME_PROPERTY] = g_param_spec_string ("auth-icon-name", "auth-icon-name", "auth-icon-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_AGENT_DIALOG_ACTION_DESC_PROPERTY, budgie_agent_dialog_properties[BUDGIE_AGENT_DIALOG_ACTION_DESC_PROPERTY] = g_param_spec_string ("action-desc", "action-desc", "action-desc", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_AGENT_DIALOG_CANCELLABLE_PROPERTY, budgie_agent_dialog_properties[BUDGIE_AGENT_DIALOG_CANCELLABLE_PROPERTY] = g_param_spec_object ("cancellable", "cancellable", "cancellable", g_cancellable_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_AGENT_DIALOG_COOKIE_PROPERTY, budgie_agent_dialog_properties[BUDGIE_AGENT_DIALOG_COOKIE_PROPERTY] = g_param_spec_string ("cookie", "cookie", "cookie", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/com/solus-project/budgie/polkit/dialog.ui");
	budgie_agent_dialog_signals[BUDGIE_AGENT_DIALOG_DONE_SIGNAL] = g_signal_new ("done", BUDGIE_TYPE_AGENT_DIALOG, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "entry_auth", FALSE, BudgieAgentDialog_private_offset + G_STRUCT_OFFSET (BudgieAgentDialogPrivate, entry_auth));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "label_message", FALSE, BudgieAgentDialog_private_offset + G_STRUCT_OFFSET (BudgieAgentDialogPrivate, label_message));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "image_icon", FALSE, BudgieAgentDialog_private_offset + G_STRUCT_OFFSET (BudgieAgentDialogPrivate, image_icon));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "combobox_idents", FALSE, BudgieAgentDialog_private_offset + G_STRUCT_OFFSET (BudgieAgentDialogPrivate, combobox_idents));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "label_username", FALSE, BudgieAgentDialog_private_offset + G_STRUCT_OFFSET (BudgieAgentDialogPrivate, label_username));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "label_identity", FALSE, BudgieAgentDialog_private_offset + G_STRUCT_OFFSET (BudgieAgentDialogPrivate, label_identity));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "label_prompt", FALSE, BudgieAgentDialog_private_offset + G_STRUCT_OFFSET (BudgieAgentDialogPrivate, label_prompt));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "label_error", FALSE, BudgieAgentDialog_private_offset + G_STRUCT_OFFSET (BudgieAgentDialogPrivate, label_error));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "details_revealer", FALSE, BudgieAgentDialog_private_offset + G_STRUCT_OFFSET (BudgieAgentDialogPrivate, details_revealer));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "label_action_value", FALSE, BudgieAgentDialog_private_offset + G_STRUCT_OFFSET (BudgieAgentDialogPrivate, label_action_value));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "label_id_value", FALSE, BudgieAgentDialog_private_offset + G_STRUCT_OFFSET (BudgieAgentDialogPrivate, label_id_value));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_entry_auth_activate", G_CALLBACK(_budgie_agent_dialog_on_entry_auth_activate_gtk_entry_activate));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_details_button_clicked", G_CALLBACK(_budgie_agent_dialog_on_details_button_clicked_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_agent_authenticate", G_CALLBACK(_budgie_agent_dialog_on_agent_authenticate_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_agent_cancelled", G_CALLBACK(_budgie_agent_dialog_on_agent_cancelled_gtk_button_clicked));
}

static void
budgie_agent_dialog_instance_init (BudgieAgentDialog * self,
                                   gpointer klass)
{
	gchar* _tmp0_;
	self->priv = budgie_agent_dialog_get_instance_private (self);
	self->pk_session = NULL;
	self->priv->pk_identity = NULL;
	_tmp0_ = g_strdup ("dialog-password-symbolic");
	self->priv->_icon = _tmp0_;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
budgie_agent_dialog_finalize (GObject * obj)
{
	BudgieAgentDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_AGENT_DIALOG, BudgieAgentDialog);
	_g_object_unref0 (self->pk_session);
	_g_object_unref0 (self->priv->pk_identity);
	_g_free0 (self->priv->_icon);
	_g_free0 (self->priv->_cookie);
	G_OBJECT_CLASS (budgie_agent_dialog_parent_class)->finalize (obj);
}

static GType
budgie_agent_dialog_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieAgentDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_agent_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieAgentDialog), 0, (GInstanceInitFunc) budgie_agent_dialog_instance_init, NULL };
	GType budgie_agent_dialog_type_id;
	budgie_agent_dialog_type_id = g_type_register_static (gtk_window_get_type (), "BudgieAgentDialog", &g_define_type_info, 0);
	BudgieAgentDialog_private_offset = g_type_add_instance_private (budgie_agent_dialog_type_id, sizeof (BudgieAgentDialogPrivate));
	return budgie_agent_dialog_type_id;
}

GType
budgie_agent_dialog_get_type (void)
{
	static volatile gsize budgie_agent_dialog_type_id__once = 0;
	if (g_once_init_enter (&budgie_agent_dialog_type_id__once)) {
		GType budgie_agent_dialog_type_id;
		budgie_agent_dialog_type_id = budgie_agent_dialog_get_type_once ();
		g_once_init_leave (&budgie_agent_dialog_type_id__once, budgie_agent_dialog_type_id);
	}
	return budgie_agent_dialog_type_id__once;
}

static void
_vala_budgie_agent_dialog_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec)
{
	BudgieAgentDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_TYPE_AGENT_DIALOG, BudgieAgentDialog);
	switch (property_id) {
		case BUDGIE_AGENT_DIALOG_ACTION_ID_PROPERTY:
		g_value_set_string (value, budgie_agent_dialog_get_action_id (self));
		break;
		case BUDGIE_AGENT_DIALOG_MESSAGE_PROPERTY:
		g_value_take_string (value, budgie_agent_dialog_get_message (self));
		break;
		case BUDGIE_AGENT_DIALOG_AUTH_DATA_PROPERTY:
		g_value_take_string (value, budgie_agent_dialog_get_auth_data (self));
		break;
		case BUDGIE_AGENT_DIALOG_AUTH_ICON_NAME_PROPERTY:
		g_value_set_string (value, budgie_agent_dialog_get_auth_icon_name (self));
		break;
		case BUDGIE_AGENT_DIALOG_ACTION_DESC_PROPERTY:
		g_value_set_string (value, budgie_agent_dialog_get_action_desc (self));
		break;
		case BUDGIE_AGENT_DIALOG_CANCELLABLE_PROPERTY:
		g_value_set_object (value, budgie_agent_dialog_get_cancellable (self));
		break;
		case BUDGIE_AGENT_DIALOG_COOKIE_PROPERTY:
		g_value_set_string (value, budgie_agent_dialog_get_cookie (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_budgie_agent_dialog_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec)
{
	BudgieAgentDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_TYPE_AGENT_DIALOG, BudgieAgentDialog);
	switch (property_id) {
		case BUDGIE_AGENT_DIALOG_ACTION_ID_PROPERTY:
		budgie_agent_dialog_set_action_id (self, g_value_get_string (value));
		break;
		case BUDGIE_AGENT_DIALOG_MESSAGE_PROPERTY:
		budgie_agent_dialog_set_message (self, g_value_get_string (value));
		break;
		case BUDGIE_AGENT_DIALOG_AUTH_DATA_PROPERTY:
		budgie_agent_dialog_set_auth_data (self, g_value_get_string (value));
		break;
		case BUDGIE_AGENT_DIALOG_AUTH_ICON_NAME_PROPERTY:
		budgie_agent_dialog_set_auth_icon_name (self, g_value_get_string (value));
		break;
		case BUDGIE_AGENT_DIALOG_ACTION_DESC_PROPERTY:
		budgie_agent_dialog_set_action_desc (self, g_value_get_string (value));
		break;
		case BUDGIE_AGENT_DIALOG_CANCELLABLE_PROPERTY:
		budgie_agent_dialog_set_cancellable (self, g_value_get_object (value));
		break;
		case BUDGIE_AGENT_DIALOG_COOKIE_PROPERTY:
		budgie_agent_dialog_set_cookie (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
budgie_agent_get_instance_private (BudgieAgent* self)
{
	return G_STRUCT_MEMBER_P (self, BudgieAgent_private_offset);
}

static void
budgie_agent_real_initiate_authentication_data_free (gpointer _data)
{
	BudgieAgentInitiateAuthenticationData* _data_;
	_data_ = _data;
	_g_free0 (_data_->action_id);
	_g_free0 (_data_->message);
	_g_free0 (_data_->icon_name);
	_g_object_unref0 (_data_->details);
	_g_free0 (_data_->cookie);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (BudgieAgentInitiateAuthenticationData, _data_);
}

static void
budgie_agent_real_initiate_authentication (PolkitAgentListener* base,
                                           const gchar* action_id,
                                           const gchar* message,
                                           const gchar* icon_name,
                                           PolkitDetails* details,
                                           const gchar* cookie,
                                           GList* identities,
                                           GCancellable* cancellable,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_)
{
	BudgieAgent * self;
	BudgieAgentInitiateAuthenticationData* _data_;
	BudgieAgent* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	PolkitDetails* _tmp4_;
	gchar* _tmp5_;
	GCancellable* _tmp6_;
	g_return_if_fail (action_id != NULL);
	g_return_if_fail (message != NULL);
	g_return_if_fail (icon_name != NULL);
	g_return_if_fail (details != NULL);
	g_return_if_fail (cookie != NULL);
	self = (BudgieAgent*) base;
	_data_ = g_slice_new0 (BudgieAgentInitiateAuthenticationData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, budgie_agent_real_initiate_authentication_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (action_id);
	_g_free0 (_data_->action_id);
	_data_->action_id = _tmp1_;
	_tmp2_ = g_strdup (message);
	_g_free0 (_data_->message);
	_data_->message = _tmp2_;
	_tmp3_ = g_strdup (icon_name);
	_g_free0 (_data_->icon_name);
	_data_->icon_name = _tmp3_;
	_tmp4_ = _g_object_ref0 (details);
	_g_object_unref0 (_data_->details);
	_data_->details = _tmp4_;
	_tmp5_ = g_strdup (cookie);
	_g_free0 (_data_->cookie);
	_data_->cookie = _tmp5_;
	_data_->identities = identities;
	_tmp6_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp6_;
	budgie_agent_real_initiate_authentication_co (_data_);
}

static gboolean
budgie_agent_initiate_authentication_finish (PolkitAgentListener* base,
                                             GAsyncResult* _res_,
                                             GError** error)
{
	gboolean result;
	BudgieAgentInitiateAuthenticationData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		gboolean _tmp0_ = FALSE;
		return _tmp0_;
	}
	result = _data_->result;
	return result;
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		BudgieAgent* self;
		self = _data4_->self;
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static void
__lambda6_ (Block4Data* _data4_)
{
	BudgieAgent* self;
	self = _data4_->self;
	budgie_agent_real_initiate_authentication_co (_data4_->_async_data_);
}

static void
___lambda6__budgie_agent_dialog_done (BudgieAgentDialog* _sender,
                                      gpointer self)
{
	__lambda6_ (self);
}

static gboolean
budgie_agent_real_initiate_authentication_co (BudgieAgentInitiateAuthenticationData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data4_ = g_slice_new0 (Block4Data);
	_data_->_data4_->_ref_count_ = 1;
	_data_->_data4_->self = g_object_ref (_data_->self);
	_data_->_data4_->_async_data_ = _data_;
	_data_->_tmp0_ = budgie_agent_dialog_new (_data_->action_id, _data_->message, "dialog-password-symbolic", _data_->cookie, _data_->cancellable);
	g_object_ref_sink (_data_->_tmp0_);
	_data_->dialog = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->dialog;
	g_signal_connect_data (_data_->_tmp1_, "done", (GCallback) ___lambda6__budgie_agent_dialog_done, block4_data_ref (_data_->_data4_), (GClosureNotify) block4_data_unref, 0);
	if (_data_->identities == NULL) {
		_data_->_tmp2_ = _data_->dialog;
		gtk_widget_destroy ((GtkWidget*) _data_->_tmp2_);
		_data_->result = FALSE;
		_g_object_unref0 (_data_->dialog);
		block4_data_unref (_data_->_data4_);
		_data_->_data4_ = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp3_ = _data_->dialog;
	budgie_agent_dialog_set_from_idents (_data_->_tmp3_, _data_->identities);
	_data_->_tmp4_ = _data_->dialog;
	gtk_widget_show ((GtkWidget*) _data_->_tmp4_);
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	_data_->_tmp5_ = _data_->dialog;
	gtk_widget_destroy ((GtkWidget*) _data_->_tmp5_);
	_data_->_tmp6_ = _data_->dialog;
	if (_data_->_tmp6_->is_cancelled) {
		_data_->_tmp7_ = g_error_new_literal (POLKIT_ERROR, POLKIT_ERROR_CANCELLED, "Authentication dialog was dismissed by the user");
		_data_->_inner_error0_ = _data_->_tmp7_;
		if (_data_->_inner_error0_->domain == POLKIT_ERROR) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->dialog);
			block4_data_unref (_data_->_data4_);
			_data_->_data4_ = NULL;
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (_data_->dialog);
			block4_data_unref (_data_->_data4_);
			_data_->_data4_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->result = TRUE;
	_g_object_unref0 (_data_->dialog);
	block4_data_unref (_data_->_data4_);
	_data_->_data4_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
__lambda10_ (BudgieAgent* self,
             GObject* o,
             GAsyncResult* res)
{
	gboolean success = FALSE;
	g_return_if_fail (res != NULL);
	success = budgie_agent_register_with_session_finish (self, res);
	if (!success) {
		g_message ("polkitdialog.vala:389: Failed to register with Session manager");
	}
}

static void
___lambda10__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda10_ ((BudgieAgent*) self, source_object, res);
	g_object_unref (self);
}

BudgieAgent*
budgie_agent_construct (GType object_type)
{
	BudgieAgent * self = NULL;
	BudgieThemeManager* _tmp0_;
	self = (BudgieAgent*) g_object_new (object_type, NULL);
	_tmp0_ = budgie_theme_manager_new ();
	_g_object_unref0 (self->priv->theme_manager);
	self->priv->theme_manager = _tmp0_;
	budgie_agent_register_with_session (self, ___lambda10__gasync_ready_callback, g_object_ref (self));
	return self;
}

BudgieAgent*
budgie_agent_new (void)
{
	return budgie_agent_construct (BUDGIE_TYPE_AGENT);
}

static void
budgie_agent_register_with_session_data_free (gpointer _data)
{
	BudgieAgentRegisterWithSessionData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (BudgieAgentRegisterWithSessionData, _data_);
}

static void
budgie_agent_register_with_session (BudgieAgent* self,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_)
{
	BudgieAgentRegisterWithSessionData* _data_;
	BudgieAgent* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (BudgieAgentRegisterWithSessionData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, budgie_agent_register_with_session_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	budgie_agent_register_with_session_co (_data_);
}

static gboolean
budgie_agent_register_with_session_finish (BudgieAgent* self,
                                           GAsyncResult* _res_)
{
	gboolean result;
	BudgieAgentRegisterWithSessionData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	return result;
}

static void
budgie_agent_register_with_session_ready (GObject* source_object,
                                          GAsyncResult* _res_,
                                          gpointer _user_data_)
{
	BudgieAgentRegisterWithSessionData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	budgie_agent_register_with_session_co (_data_);
}

static void
__lambda7_ (BudgieAgent* self)
{
	budgie_agent_end_session (self, FALSE);
}

static void
___lambda7__lib_session_session_client_query_end_session (LibSessionSessionClient* _sender,
                                                          guint flags,
                                                          gpointer self)
{
	__lambda7_ ((BudgieAgent*) self);
}

static void
__lambda8_ (BudgieAgent* self)
{
	budgie_agent_end_session (self, FALSE);
}

static void
___lambda8__lib_session_session_client_end_session (LibSessionSessionClient* _sender,
                                                    guint flags,
                                                    gpointer self)
{
	__lambda8_ ((BudgieAgent*) self);
}

static void
__lambda9_ (BudgieAgent* self)
{
	budgie_agent_end_session (self, TRUE);
}

static void
___lambda9__lib_session_session_client_stop (LibSessionSessionClient* _sender,
                                             gpointer self)
{
	__lambda9_ ((BudgieAgent*) self);
}

static gboolean
budgie_agent_register_with_session_co (BudgieAgentRegisterWithSessionData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	lib_session_register_with_session ("budgie-polkit", budgie_agent_register_with_session_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp0_ = lib_session_register_with_session_finish (_data_->_res_);
	_g_object_unref0 (_data_->self->priv->sclient);
	_data_->self->priv->sclient = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->self->priv->sclient;
	if (_data_->_tmp1_ == NULL) {
		_data_->result = FALSE;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp2_ = _data_->self->priv->sclient;
	g_signal_connect_object (_data_->_tmp2_, "query-end-session", (GCallback) ___lambda7__lib_session_session_client_query_end_session, _data_->self, 0);
	_data_->_tmp3_ = _data_->self->priv->sclient;
	g_signal_connect_object (_data_->_tmp3_, "end-session", (GCallback) ___lambda8__lib_session_session_client_end_session, _data_->self, 0);
	_data_->_tmp4_ = _data_->self->priv->sclient;
	g_signal_connect_object (_data_->_tmp4_, "stop", (GCallback) ___lambda9__lib_session_session_client_stop, _data_->self, 0);
	_data_->result = TRUE;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
budgie_agent_end_session (BudgieAgent* self,
                          gboolean quit)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	if (quit) {
		g_signal_emit (self, budgie_agent_signals[BUDGIE_AGENT_STOPAGENT_SIGNAL], 0);
		return;
	}
	{
		LibSessionSessionClient* _tmp0_;
		_tmp0_ = self->priv->sclient;
		lib_session_session_client_EndSessionResponse (_tmp0_, TRUE, "", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_warning ("polkitdialog.vala:422: Unable to respond to session manager! %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
budgie_agent_class_init (BudgieAgentClass * klass,
                         gpointer klass_data)
{
	budgie_agent_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BudgieAgent_private_offset);
	((PolkitAgentListenerClass *) klass)->initiate_authentication = (void (*) (PolkitAgentListener*, const gchar*, const gchar*, const gchar*, PolkitDetails*, const gchar*, GList*, GCancellable*, GAsyncReadyCallback, gpointer)) budgie_agent_real_initiate_authentication;
	((PolkitAgentListenerClass *) klass)->initiate_authentication_finish = (gboolean (*) (PolkitAgentListener*, GAsyncResult*, GError**)) budgie_agent_initiate_authentication_finish;
	G_OBJECT_CLASS (klass)->finalize = budgie_agent_finalize;
	budgie_agent_signals[BUDGIE_AGENT_STOPAGENT_SIGNAL] = g_signal_new ("stopagent", BUDGIE_TYPE_AGENT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
budgie_agent_instance_init (BudgieAgent * self,
                            gpointer klass)
{
	self->priv = budgie_agent_get_instance_private (self);
}

static void
budgie_agent_finalize (GObject * obj)
{
	BudgieAgent * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_AGENT, BudgieAgent);
	_g_object_unref0 (self->priv->sclient);
	_g_object_unref0 (self->priv->theme_manager);
	G_OBJECT_CLASS (budgie_agent_parent_class)->finalize (obj);
}

static GType
budgie_agent_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieAgentClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_agent_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieAgent), 0, (GInstanceInitFunc) budgie_agent_instance_init, NULL };
	GType budgie_agent_type_id;
	budgie_agent_type_id = g_type_register_static (polkit_agent_listener_get_type (), "BudgieAgent", &g_define_type_info, 0);
	BudgieAgent_private_offset = g_type_add_instance_private (budgie_agent_type_id, sizeof (BudgieAgentPrivate));
	return budgie_agent_type_id;
}

GType
budgie_agent_get_type (void)
{
	static volatile gsize budgie_agent_type_id__once = 0;
	if (g_once_init_enter (&budgie_agent_type_id__once)) {
		GType budgie_agent_type_id;
		budgie_agent_type_id = budgie_agent_get_type_once ();
		g_once_init_leave (&budgie_agent_type_id__once, budgie_agent_type_id);
	}
	return budgie_agent_type_id__once;
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		g_slice_free (Block5Data, _data5_);
	}
}

static void
___lambda11_ (Block5Data* _data5_)
{
	void* _tmp0_;
	_tmp0_ = _data5_->agenthandle;
	polkit_agent_listener_unregister (_tmp0_);
	gtk_main_quit ();
	return;
}

static void
____lambda11__budgie_agent_stopagent (BudgieAgent* _sender,
                                      gpointer self)
{
	___lambda11_ (self);
}

static gint
_vala_main (gchar** args,
            gint args_length1)
{
	BudgieAgent* agent = NULL;
	BudgieAgent* _tmp0_;
	PolkitSubject* subject = NULL;
	gint pid = 0;
	GError* _inner_error0_ = NULL;
	gint result;
	gtk_init ((gint*) (&args_length1), &args);
	setlocale (LC_ALL, "");
	bindtextdomain (BUDGIE_GETTEXT_PACKAGE, BUDGIE_LOCALEDIR);
	bind_textdomain_codeset (BUDGIE_GETTEXT_PACKAGE, "UTF-8");
	textdomain (BUDGIE_GETTEXT_PACKAGE);
	_tmp0_ = budgie_agent_new ();
	agent = _tmp0_;
	subject = NULL;
	pid = (gint) getpid ();
	{
		PolkitUnixSession* _tmp1_ = NULL;
		PolkitUnixSession* _tmp2_;
		PolkitUnixSession* _tmp3_;
		_tmp2_ = (PolkitUnixSession*) polkit_unix_session_new_for_process_sync (pid, NULL, &_inner_error0_);
		_tmp1_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = _tmp1_;
		_tmp1_ = NULL;
		_g_object_unref0 (subject);
		subject = (PolkitSubject*) _tmp3_;
		_g_object_unref0 (_tmp1_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		FILE* _tmp4_;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = stdout;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		fprintf (_tmp4_, "Unable to initiate PolKit: %s", _tmp6_);
		result = 1;
		_g_error_free0 (e);
		_g_object_unref0 (subject);
		_g_object_unref0 (agent);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp7_ = -1;
		_g_object_unref0 (subject);
		_g_object_unref0 (agent);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp7_;
	}
	{
		Block5Data* _data5_;
		BudgieAgent* _tmp8_;
		PolkitSubject* _tmp9_;
		void* _tmp10_;
		BudgieAgent* _tmp11_;
		_data5_ = g_slice_new0 (Block5Data);
		_data5_->_ref_count_ = 1;
		_tmp8_ = agent;
		_tmp9_ = subject;
		_tmp10_ = polkit_agent_listener_register ((PolkitAgentListener*) _tmp8_, POLKIT_AGENT_REGISTER_FLAGS_NONE, _tmp9_, "/org/freedesktop/PolicyKit1/AuthenticationAgent", NULL, &_inner_error0_);
		_data5_->agenthandle = _tmp10_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			block5_data_unref (_data5_);
			_data5_ = NULL;
			goto __catch1_g_error;
		}
		_tmp11_ = agent;
		g_signal_connect_data (_tmp11_, "stopagent", (GCallback) ____lambda11__budgie_agent_stopagent, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
		block5_data_unref (_data5_);
		_data5_ = NULL;
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		FILE* _tmp12_;
		GError* _tmp13_;
		const gchar* _tmp14_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp12_ = stderr;
		_tmp13_ = e;
		_tmp14_ = _tmp13_->message;
		fprintf (_tmp12_, "Unable to register listener: %s", _tmp14_);
		result = 1;
		_g_error_free0 (e);
		_g_object_unref0 (subject);
		_g_object_unref0 (agent);
		return result;
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp15_ = -1;
		_g_object_unref0 (subject);
		_g_object_unref0 (agent);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp15_;
	}
	gtk_main ();
	result = 0;
	_g_object_unref0 (subject);
	_g_object_unref0 (agent);
	return result;
}

int
main (int argc,
      char ** argv)
{
	return _vala_main (argv, argc);
}

