/* manager.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from manager.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <glib-object.h>
#include <libxfce4windowing/libxfce4windowing.h>
#include <gdk/gdk.h>
#include <glib.h>
#include <theme-manager.h>
#include "session.h"
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define BUDGIE_TYPE_WAYLAND_CLIENT (budgie_wayland_client_get_type ())
#define BUDGIE_WAYLAND_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_WAYLAND_CLIENT, BudgieWaylandClient))
#define BUDGIE_WAYLAND_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_WAYLAND_CLIENT, BudgieWaylandClientClass))
#define BUDGIE_IS_WAYLAND_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_WAYLAND_CLIENT))
#define BUDGIE_IS_WAYLAND_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_WAYLAND_CLIENT))
#define BUDGIE_WAYLAND_CLIENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_WAYLAND_CLIENT, BudgieWaylandClientClass))

typedef struct _BudgieWaylandClient BudgieWaylandClient;
typedef struct _BudgieWaylandClientClass BudgieWaylandClientClass;
typedef struct _BudgieWaylandClientPrivate BudgieWaylandClientPrivate;
enum  {
	BUDGIE_WAYLAND_CLIENT_0_PROPERTY,
	BUDGIE_WAYLAND_CLIENT_GDK_MONITOR_PROPERTY,
	BUDGIE_WAYLAND_CLIENT_MONITOR_RES_PROPERTY,
	BUDGIE_WAYLAND_CLIENT_NUM_PROPERTIES
};
static GParamSpec* budgie_wayland_client_properties[BUDGIE_WAYLAND_CLIENT_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block8Data Block8Data;

#define BUDGIE_TYPE_SERVICE_MANAGER (budgie_service_manager_get_type ())
#define BUDGIE_SERVICE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_SERVICE_MANAGER, BudgieServiceManager))
#define BUDGIE_SERVICE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_SERVICE_MANAGER, BudgieServiceManagerClass))
#define BUDGIE_IS_SERVICE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_SERVICE_MANAGER))
#define BUDGIE_IS_SERVICE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_SERVICE_MANAGER))
#define BUDGIE_SERVICE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_SERVICE_MANAGER, BudgieServiceManagerClass))

typedef struct _BudgieServiceManager BudgieServiceManager;
typedef struct _BudgieServiceManagerClass BudgieServiceManagerClass;
typedef struct _BudgieServiceManagerPrivate BudgieServiceManagerPrivate;

#define BUDGIE_TYPE_OSD_MANAGER (budgie_osd_manager_get_type ())
#define BUDGIE_OSD_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_OSD_MANAGER, BudgieOSDManager))
#define BUDGIE_OSD_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_OSD_MANAGER, BudgieOSDManagerClass))
#define BUDGIE_IS_OSD_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_OSD_MANAGER))
#define BUDGIE_IS_OSD_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_OSD_MANAGER))
#define BUDGIE_OSD_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_OSD_MANAGER, BudgieOSDManagerClass))

typedef struct _BudgieOSDManager BudgieOSDManager;
typedef struct _BudgieOSDManagerClass BudgieOSDManagerClass;

#define BUDGIE_TYPE_OSD_KEYS (budgie_osd_keys_get_type ())
#define BUDGIE_OSD_KEYS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_OSD_KEYS, BudgieOSDKeys))
#define BUDGIE_OSD_KEYS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_OSD_KEYS, BudgieOSDKeysClass))
#define BUDGIE_IS_OSD_KEYS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_OSD_KEYS))
#define BUDGIE_IS_OSD_KEYS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_OSD_KEYS))
#define BUDGIE_OSD_KEYS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_OSD_KEYS, BudgieOSDKeysClass))

typedef struct _BudgieOSDKeys BudgieOSDKeys;
typedef struct _BudgieOSDKeysClass BudgieOSDKeysClass;

#define BUDGIE_NOTIFICATIONS_TYPE_SERVER (budgie_notifications_server_get_type ())
#define BUDGIE_NOTIFICATIONS_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_NOTIFICATIONS_TYPE_SERVER, BudgieNotificationsServer))
#define BUDGIE_NOTIFICATIONS_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_NOTIFICATIONS_TYPE_SERVER, BudgieNotificationsServerClass))
#define BUDGIE_NOTIFICATIONS_IS_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_NOTIFICATIONS_TYPE_SERVER))
#define BUDGIE_NOTIFICATIONS_IS_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_NOTIFICATIONS_TYPE_SERVER))
#define BUDGIE_NOTIFICATIONS_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_NOTIFICATIONS_TYPE_SERVER, BudgieNotificationsServerClass))

typedef struct _BudgieNotificationsServer BudgieNotificationsServer;
typedef struct _BudgieNotificationsServerClass BudgieNotificationsServerClass;

#define BUDGIE_STATUS_NOTIFIER_TYPE_FREEDESKTOP_WATCHER (budgie_status_notifier_freedesktop_watcher_get_type ())
#define BUDGIE_STATUS_NOTIFIER_FREEDESKTOP_WATCHER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_STATUS_NOTIFIER_TYPE_FREEDESKTOP_WATCHER, BudgieStatusNotifierFreedesktopWatcher))
#define BUDGIE_STATUS_NOTIFIER_FREEDESKTOP_WATCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_STATUS_NOTIFIER_TYPE_FREEDESKTOP_WATCHER, BudgieStatusNotifierFreedesktopWatcherClass))
#define BUDGIE_STATUS_NOTIFIER_IS_FREEDESKTOP_WATCHER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_STATUS_NOTIFIER_TYPE_FREEDESKTOP_WATCHER))
#define BUDGIE_STATUS_NOTIFIER_IS_FREEDESKTOP_WATCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_STATUS_NOTIFIER_TYPE_FREEDESKTOP_WATCHER))
#define BUDGIE_STATUS_NOTIFIER_FREEDESKTOP_WATCHER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_STATUS_NOTIFIER_TYPE_FREEDESKTOP_WATCHER, BudgieStatusNotifierFreedesktopWatcherClass))

typedef struct _BudgieStatusNotifierFreedesktopWatcher BudgieStatusNotifierFreedesktopWatcher;
typedef struct _BudgieStatusNotifierFreedesktopWatcherClass BudgieStatusNotifierFreedesktopWatcherClass;

#define BUDGIE_TYPE_XDG_DIR_TRACKER (budgie_xdg_dir_tracker_get_type ())
#define BUDGIE_XDG_DIR_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_XDG_DIR_TRACKER, BudgieXDGDirTracker))
#define BUDGIE_XDG_DIR_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_XDG_DIR_TRACKER, BudgieXDGDirTrackerClass))
#define BUDGIE_IS_XDG_DIR_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_XDG_DIR_TRACKER))
#define BUDGIE_IS_XDG_DIR_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_XDG_DIR_TRACKER))
#define BUDGIE_XDG_DIR_TRACKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_XDG_DIR_TRACKER, BudgieXDGDirTrackerClass))

typedef struct _BudgieXDGDirTracker BudgieXDGDirTracker;
typedef struct _BudgieXDGDirTrackerClass BudgieXDGDirTrackerClass;

#define BUDGIE_TYPE_BACKGROUND (budgie_background_get_type ())
#define BUDGIE_BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_BACKGROUND, BudgieBackground))
#define BUDGIE_BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_BACKGROUND, BudgieBackgroundClass))
#define BUDGIE_IS_BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_BACKGROUND))
#define BUDGIE_IS_BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_BACKGROUND))
#define BUDGIE_BACKGROUND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_BACKGROUND, BudgieBackgroundClass))

typedef struct _BudgieBackground BudgieBackground;
typedef struct _BudgieBackgroundClass BudgieBackgroundClass;

#define BUDGIE_TYPE_SCREENLOCK (budgie_screenlock_get_type ())
#define BUDGIE_SCREENLOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_SCREENLOCK, BudgieScreenlock))
#define BUDGIE_SCREENLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_SCREENLOCK, BudgieScreenlockClass))
#define BUDGIE_IS_SCREENLOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_SCREENLOCK))
#define BUDGIE_IS_SCREENLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_SCREENLOCK))
#define BUDGIE_SCREENLOCK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_SCREENLOCK, BudgieScreenlockClass))

typedef struct _BudgieScreenlock BudgieScreenlock;
typedef struct _BudgieScreenlockClass BudgieScreenlockClass;

#define BUDGIE_TYPE_NIGHT_LIGHT_MANAGER (budgie_night_light_manager_get_type ())
#define BUDGIE_NIGHT_LIGHT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_NIGHT_LIGHT_MANAGER, BudgieNightLightManager))
#define BUDGIE_NIGHT_LIGHT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_NIGHT_LIGHT_MANAGER, BudgieNightLightManagerClass))
#define BUDGIE_IS_NIGHT_LIGHT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_NIGHT_LIGHT_MANAGER))
#define BUDGIE_IS_NIGHT_LIGHT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_NIGHT_LIGHT_MANAGER))
#define BUDGIE_NIGHT_LIGHT_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_NIGHT_LIGHT_MANAGER, BudgieNightLightManagerClass))

typedef struct _BudgieNightLightManager BudgieNightLightManager;
typedef struct _BudgieNightLightManagerClass BudgieNightLightManagerClass;

#define BUDGIE_TYPE_SCREENSHOT_MANAGER (budgie_screenshot_manager_get_type ())
#define BUDGIE_SCREENSHOT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_SCREENSHOT_MANAGER, BudgieScreenshotManager))
#define BUDGIE_SCREENSHOT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_SCREENSHOT_MANAGER, BudgieScreenshotManagerClass))
#define BUDGIE_IS_SCREENSHOT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_SCREENSHOT_MANAGER))
#define BUDGIE_IS_SCREENSHOT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_SCREENSHOT_MANAGER))
#define BUDGIE_SCREENSHOT_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_SCREENSHOT_MANAGER, BudgieScreenshotManagerClass))

typedef struct _BudgieScreenshotManager BudgieScreenshotManager;
typedef struct _BudgieScreenshotManagerClass BudgieScreenshotManagerClass;
enum  {
	BUDGIE_SERVICE_MANAGER_0_PROPERTY,
	BUDGIE_SERVICE_MANAGER_NUM_PROPERTIES
};
static GParamSpec* budgie_service_manager_properties[BUDGIE_SERVICE_MANAGER_NUM_PROPERTIES];
#define _budgie_osd_manager_unref0(var) ((var == NULL) ? NULL : (var = (budgie_osd_manager_unref (var), NULL)))
#define _budgie_background_unref0(var) ((var == NULL) ? NULL : (var = (budgie_background_unref (var), NULL)))
#define _budgie_screenlock_unref0(var) ((var == NULL) ? NULL : (var = (budgie_screenlock_unref (var), NULL)))
typedef struct _BudgieServiceManagerRegisterWithSessionData BudgieServiceManagerRegisterWithSessionData;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _BudgieWaylandClient {
	GObject parent_instance;
	BudgieWaylandClientPrivate * priv;
};

struct _BudgieWaylandClientClass {
	GObjectClass parent_class;
};

struct _BudgieWaylandClientPrivate {
	XfwScreen* screen;
	XfwMonitor* primary_monitor;
	GdkMonitor* _gdk_monitor;
	GdkRectangle _monitor_res;
};

struct _Block8Data {
	int _ref_count_;
	BudgieWaylandClient* self;
	gint loop;
};

struct _BudgieServiceManager {
	GObject parent_instance;
	BudgieServiceManagerPrivate * priv;
};

struct _BudgieServiceManagerClass {
	GObjectClass parent_class;
};

struct _BudgieServiceManagerPrivate {
	BudgieThemeManager* theme_manager;
	LibSessionSessionClient* sclient;
	BudgieWaylandClient* wayland_client;
	BudgieOSDManager* osd;
	BudgieOSDKeys* osdkeys;
	BudgieNotificationsServer* notifications;
	BudgieStatusNotifierFreedesktopWatcher* status_notifier;
	BudgieXDGDirTracker* xdg_tracker;
	BudgieBackground* background;
	BudgieScreenlock* screenlock;
	BudgieNightLightManager* nightlight;
	BudgieScreenshotManager* screenshot_manager;
};

struct _BudgieServiceManagerRegisterWithSessionData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	BudgieServiceManager* self;
	gboolean result;
	LibSessionSessionClient* _tmp0_;
	LibSessionSessionClient* _tmp1_;
	LibSessionSessionClient* _tmp2_;
	LibSessionSessionClient* _tmp3_;
	LibSessionSessionClient* _tmp4_;
};

static gint BudgieWaylandClient_private_offset;
static gpointer budgie_wayland_client_parent_class = NULL;
static gint BudgieServiceManager_private_offset;
static gpointer budgie_service_manager_parent_class = NULL;

VALA_EXTERN GType budgie_wayland_client_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieWaylandClient, g_object_unref)
VALA_EXTERN gboolean budgie_wayland_client_is_initialised (BudgieWaylandClient* self);
VALA_EXTERN BudgieWaylandClient* budgie_wayland_client_new (void);
VALA_EXTERN BudgieWaylandClient* budgie_wayland_client_construct (GType object_type);
static void budgie_wayland_client_on_monitors_changed (BudgieWaylandClient* self);
static void _budgie_wayland_client_on_monitors_changed_libxfce4windowing_screen_monitors_changed (XfwScreen* _sender,
                                                                                           gpointer self);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
static gboolean __lambda6_ (Block8Data* _data8_);
static void budgie_wayland_client_set_monitor_res (BudgieWaylandClient* self,
                                            GdkRectangle * value);
static void budgie_wayland_client_set_gdk_monitor (BudgieWaylandClient* self,
                                            GdkMonitor* value);
static gboolean ___lambda6__gsource_func (gpointer self);
VALA_EXTERN GdkMonitor* budgie_wayland_client_get_gdk_monitor (BudgieWaylandClient* self);
VALA_EXTERN void budgie_wayland_client_get_monitor_res (BudgieWaylandClient* self,
                                            GdkRectangle * result);
static gboolean _cairo_rectangle_int_equal (const cairo_rectangle_int_t * s1,
                                     const cairo_rectangle_int_t * s2);
static GObject * budgie_wayland_client_constructor (GType type,
                                             guint n_construct_properties,
                                             GObjectConstructParam * construct_properties);
static void budgie_wayland_client_finalize (GObject * obj);
static GType budgie_wayland_client_get_type_once (void);
static void _vala_budgie_wayland_client_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void _vala_budgie_wayland_client_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec);
VALA_EXTERN GType budgie_service_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieServiceManager, g_object_unref)
VALA_EXTERN gpointer budgie_osd_manager_ref (gpointer instance);
VALA_EXTERN void budgie_osd_manager_unref (gpointer instance);
VALA_EXTERN GParamSpec* budgie_param_spec_osd_manager (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags);
VALA_EXTERN void budgie_value_set_osd_manager (GValue* value,
                                   gpointer v_object);
VALA_EXTERN void budgie_value_take_osd_manager (GValue* value,
                                    gpointer v_object);
VALA_EXTERN gpointer budgie_value_get_osd_manager (const GValue* value);
VALA_EXTERN GType budgie_osd_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieOSDManager, budgie_osd_manager_unref)
VALA_EXTERN guint budgie_osd_manager_register_object (void* object,
                                          GDBusConnection* connection,
                                          const gchar* path,
                                          GError** error);
VALA_EXTERN GType budgie_osd_keys_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieOSDKeys, g_object_unref)
VALA_EXTERN GType budgie_notifications_server_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieNotificationsServer, g_object_unref)
VALA_EXTERN guint budgie_notifications_server_register_object (void* object,
                                                   GDBusConnection* connection,
                                                   const gchar* path,
                                                   GError** error);
VALA_EXTERN GType budgie_status_notifier_freedesktop_watcher_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieStatusNotifierFreedesktopWatcher, g_object_unref)
VALA_EXTERN guint budgie_status_notifier_freedesktop_watcher_register_object (void* object,
                                                                  GDBusConnection* connection,
                                                                  const gchar* path,
                                                                  GError** error);
VALA_EXTERN GType budgie_xdg_dir_tracker_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieXDGDirTracker, g_object_unref)
VALA_EXTERN guint budgie_xdg_dir_tracker_register_object (void* object,
                                              GDBusConnection* connection,
                                              const gchar* path,
                                              GError** error);
VALA_EXTERN gpointer budgie_background_ref (gpointer instance);
VALA_EXTERN void budgie_background_unref (gpointer instance);
VALA_EXTERN GParamSpec* budgie_param_spec_background (const gchar* name,
                                          const gchar* nick,
                                          const gchar* blurb,
                                          GType object_type,
                                          GParamFlags flags);
VALA_EXTERN void budgie_value_set_background (GValue* value,
                                  gpointer v_object);
VALA_EXTERN void budgie_value_take_background (GValue* value,
                                   gpointer v_object);
VALA_EXTERN gpointer budgie_value_get_background (const GValue* value);
VALA_EXTERN GType budgie_background_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieBackground, budgie_background_unref)
VALA_EXTERN gpointer budgie_screenlock_ref (gpointer instance);
VALA_EXTERN void budgie_screenlock_unref (gpointer instance);
VALA_EXTERN GParamSpec* budgie_param_spec_screenlock (const gchar* name,
                                          const gchar* nick,
                                          const gchar* blurb,
                                          GType object_type,
                                          GParamFlags flags);
VALA_EXTERN void budgie_value_set_screenlock (GValue* value,
                                  gpointer v_object);
VALA_EXTERN void budgie_value_take_screenlock (GValue* value,
                                   gpointer v_object);
VALA_EXTERN gpointer budgie_value_get_screenlock (const GValue* value);
VALA_EXTERN GType budgie_screenlock_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieScreenlock, budgie_screenlock_unref)
VALA_EXTERN guint budgie_screenlock_register_object (void* object,
                                         GDBusConnection* connection,
                                         const gchar* path,
                                         GError** error);
VALA_EXTERN GType budgie_night_light_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieNightLightManager, g_object_unref)
VALA_EXTERN GType budgie_screenshot_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieScreenshotManager, g_object_unref)
VALA_EXTERN guint budgie_screenshot_manager_register_object (void* object,
                                                 GDBusConnection* connection,
                                                 const gchar* path,
                                                 GError** error);
VALA_EXTERN BudgieServiceManager* budgie_service_manager_new (gboolean replace);
VALA_EXTERN BudgieServiceManager* budgie_service_manager_construct (GType object_type,
                                                        gboolean replace);
VALA_EXTERN BudgieStatusNotifierFreedesktopWatcher* budgie_status_notifier_freedesktop_watcher_new (void);
VALA_EXTERN BudgieStatusNotifierFreedesktopWatcher* budgie_status_notifier_freedesktop_watcher_construct (GType object_type);
static void budgie_service_manager_register_with_session (BudgieServiceManager* self,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_);
static gboolean budgie_service_manager_register_with_session_finish (BudgieServiceManager* self,
                                                              GAsyncResult* _res_);
static void __lambda52_ (BudgieServiceManager* self,
                  GObject* o,
                  GAsyncResult* res);
static void ___lambda52__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
VALA_EXTERN BudgieOSDManager* budgie_osd_manager_new (void);
VALA_EXTERN BudgieOSDManager* budgie_osd_manager_construct (GType object_type);
VALA_EXTERN void budgie_osd_manager_setup_dbus (BudgieOSDManager* self,
                                    gboolean replace);
VALA_EXTERN BudgieOSDKeys* budgie_osd_keys_new (void);
VALA_EXTERN BudgieOSDKeys* budgie_osd_keys_construct (GType object_type);
VALA_EXTERN BudgieNotificationsServer* budgie_notifications_server_new (void);
VALA_EXTERN BudgieNotificationsServer* budgie_notifications_server_construct (GType object_type);
VALA_EXTERN void budgie_notifications_server_setup_dbus (BudgieNotificationsServer* self,
                                             gboolean replace);
VALA_EXTERN BudgieBackground* budgie_background_new (void);
VALA_EXTERN BudgieBackground* budgie_background_construct (GType object_type);
VALA_EXTERN BudgieXDGDirTracker* budgie_xdg_dir_tracker_new (void);
VALA_EXTERN BudgieXDGDirTracker* budgie_xdg_dir_tracker_construct (GType object_type);
VALA_EXTERN void budgie_xdg_dir_tracker_setup_dbus (BudgieXDGDirTracker* self,
                                        gboolean replace);
VALA_EXTERN BudgieScreenlock* budgie_screenlock_init (void);
VALA_EXTERN void budgie_screenlock_setup_dbus (BudgieScreenlock* self);
VALA_EXTERN BudgieNightLightManager* budgie_night_light_manager_new (void);
VALA_EXTERN BudgieNightLightManager* budgie_night_light_manager_construct (GType object_type);
VALA_EXTERN BudgieScreenshotManager* budgie_screenshot_manager_new (void);
VALA_EXTERN BudgieScreenshotManager* budgie_screenshot_manager_construct (GType object_type);
VALA_EXTERN void budgie_screenshot_manager_serve (BudgieScreenshotManager* self);
static void budgie_service_manager_register_with_session_data_free (gpointer _data);
static gboolean budgie_service_manager_register_with_session_co (BudgieServiceManagerRegisterWithSessionData* _data_);
static void budgie_service_manager_register_with_session_ready (GObject* source_object,
                                                         GAsyncResult* _res_,
                                                         gpointer _user_data_);
static void __lambda49_ (BudgieServiceManager* self);
static void budgie_service_manager_end_session (BudgieServiceManager* self,
                                         gboolean quit);
static void ___lambda49__lib_session_session_client_query_end_session (LibSessionSessionClient* _sender,
                                                                guint flags,
                                                                gpointer self);
static void __lambda50_ (BudgieServiceManager* self);
static void ___lambda50__lib_session_session_client_end_session (LibSessionSessionClient* _sender,
                                                          guint flags,
                                                          gpointer self);
static void __lambda51_ (BudgieServiceManager* self);
static void ___lambda51__lib_session_session_client_stop (LibSessionSessionClient* _sender,
                                                   gpointer self);
static void budgie_service_manager_finalize (GObject * obj);
static GType budgie_service_manager_get_type_once (void);

static inline gpointer
budgie_wayland_client_get_instance_private (BudgieWaylandClient* self)
{
	return G_STRUCT_MEMBER_P (self, BudgieWaylandClient_private_offset);
}

gboolean
budgie_wayland_client_is_initialised (BudgieWaylandClient* self)
{
	XfwMonitor* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->primary_monitor;
	result = _tmp0_ != NULL;
	return result;
}

static void
_budgie_wayland_client_on_monitors_changed_libxfce4windowing_screen_monitors_changed (XfwScreen* _sender,
                                                                                      gpointer self)
{
	budgie_wayland_client_on_monitors_changed ((BudgieWaylandClient*) self);
}

BudgieWaylandClient*
budgie_wayland_client_construct (GType object_type)
{
	BudgieWaylandClient * self = NULL;
	XfwMonitor* _tmp0_;
	XfwScreen* _tmp1_;
	XfwScreen* _tmp2_;
	self = (BudgieWaylandClient*) g_object_new (object_type, NULL);
	_tmp0_ = self->priv->primary_monitor;
	if (_tmp0_ != NULL) {
		return self;
	}
	_tmp1_ = xfw_screen_get_default ();
	_g_object_unref0 (self->priv->screen);
	self->priv->screen = _tmp1_;
	_tmp2_ = self->priv->screen;
	g_signal_connect_object (_tmp2_, "monitors-changed", (GCallback) _budgie_wayland_client_on_monitors_changed_libxfce4windowing_screen_monitors_changed, self, 0);
	budgie_wayland_client_on_monitors_changed (self);
	return self;
}

BudgieWaylandClient*
budgie_wayland_client_new (void)
{
	return budgie_wayland_client_construct (BUDGIE_TYPE_WAYLAND_CLIENT);
}

static Block8Data*
block8_data_ref (Block8Data* _data8_)
{
	g_atomic_int_inc (&_data8_->_ref_count_);
	return _data8_;
}

static void
block8_data_unref (void * _userdata_)
{
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
		BudgieWaylandClient* self;
		self = _data8_->self;
		_g_object_unref0 (self);
		g_slice_free (Block8Data, _data8_);
	}
}

static gboolean
__lambda6_ (Block8Data* _data8_)
{
	BudgieWaylandClient* self;
	XfwScreen* _tmp0_;
	XfwMonitor* _tmp1_;
	gboolean _tmp2_ = FALSE;
	XfwMonitor* _tmp3_;
	gboolean result;
	self = _data8_->self;
	_tmp0_ = self->priv->screen;
	_tmp1_ = xfw_screen_get_primary_monitor (_tmp0_);
	self->priv->primary_monitor = _tmp1_;
	_tmp3_ = self->priv->primary_monitor;
	if (_tmp3_ != NULL) {
		_tmp2_ = TRUE;
	} else {
		gint _tmp4_;
		_tmp4_ = _data8_->loop;
		_data8_->loop = _tmp4_ + 1;
		_tmp2_ = _tmp4_ > 10;
	}
	if (_tmp2_) {
		XfwMonitor* _tmp5_;
		GdkRectangle _tmp6_ = {0};
		XfwMonitor* _tmp7_;
		GdkMonitor* _tmp8_;
		_tmp5_ = self->priv->primary_monitor;
		xfw_monitor_get_logical_geometry (_tmp5_, &_tmp6_);
		budgie_wayland_client_set_monitor_res (self, &_tmp6_);
		_tmp7_ = self->priv->primary_monitor;
		_tmp8_ = xfw_monitor_get_gdk_monitor (_tmp7_);
		budgie_wayland_client_set_gdk_monitor (self, _tmp8_);
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}

static gboolean
___lambda6__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda6_ (self);
	return result;
}

static void
budgie_wayland_client_on_monitors_changed (BudgieWaylandClient* self)
{
	Block8Data* _data8_;
	g_return_if_fail (self != NULL);
	_data8_ = g_slice_new0 (Block8Data);
	_data8_->_ref_count_ = 1;
	_data8_->self = g_object_ref (self);
	_data8_->loop = 0;
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 200, ___lambda6__gsource_func, block8_data_ref (_data8_), block8_data_unref);
	block8_data_unref (_data8_);
	_data8_ = NULL;
}

GdkMonitor*
budgie_wayland_client_get_gdk_monitor (BudgieWaylandClient* self)
{
	GdkMonitor* result;
	GdkMonitor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_gdk_monitor;
	result = _tmp0_;
	return result;
}

static void
budgie_wayland_client_set_gdk_monitor (BudgieWaylandClient* self,
                                       GdkMonitor* value)
{
	GdkMonitor* old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_wayland_client_get_gdk_monitor (self);
	if (old_value != value) {
		self->priv->_gdk_monitor = value;
		g_object_notify_by_pspec ((GObject *) self, budgie_wayland_client_properties[BUDGIE_WAYLAND_CLIENT_GDK_MONITOR_PROPERTY]);
	}
}

void
budgie_wayland_client_get_monitor_res (BudgieWaylandClient* self,
                                       GdkRectangle * result)
{
	GdkRectangle _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_monitor_res;
	*result = _tmp0_;
	return;
}

static gboolean
_cairo_rectangle_int_equal (const cairo_rectangle_int_t * s1,
                            const cairo_rectangle_int_t * s2)
{
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	if (s1->x != s2->x) {
		return FALSE;
	}
	if (s1->y != s2->y) {
		return FALSE;
	}
	if (s1->width != s2->width) {
		return FALSE;
	}
	if (s1->height != s2->height) {
		return FALSE;
	}
	return TRUE;
}

static void
budgie_wayland_client_set_monitor_res (BudgieWaylandClient* self,
                                       GdkRectangle * value)
{
	GdkRectangle old_value;
	g_return_if_fail (self != NULL);
	budgie_wayland_client_get_monitor_res (self, &old_value);
	if (_cairo_rectangle_int_equal (value, &old_value) != TRUE) {
		GdkRectangle _tmp0_;
		_tmp0_ = *value;
		self->priv->_monitor_res = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, budgie_wayland_client_properties[BUDGIE_WAYLAND_CLIENT_MONITOR_RES_PROPERTY]);
	}
}

static GObject *
budgie_wayland_client_constructor (GType type,
                                   guint n_construct_properties,
                                   GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	static GWeakRef BudgieWaylandClient_singleton__ref;
	static GMutex BudgieWaylandClient_singleton__lock;
	BudgieWaylandClient * self;
	g_mutex_lock (&BudgieWaylandClient_singleton__lock);
	obj = g_weak_ref_get (&BudgieWaylandClient_singleton__ref);
	if (obj != NULL) {
		g_mutex_unlock (&BudgieWaylandClient_singleton__lock);
		return obj;
	}
	parent_class = G_OBJECT_CLASS (budgie_wayland_client_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_WAYLAND_CLIENT, BudgieWaylandClient);
	g_weak_ref_set (&BudgieWaylandClient_singleton__ref, obj);
	g_mutex_unlock (&BudgieWaylandClient_singleton__lock);
	return obj;
}

static void
budgie_wayland_client_class_init (BudgieWaylandClientClass * klass,
                                  gpointer klass_data)
{
	budgie_wayland_client_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BudgieWaylandClient_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_budgie_wayland_client_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_budgie_wayland_client_set_property;
	G_OBJECT_CLASS (klass)->constructor = budgie_wayland_client_constructor;
	G_OBJECT_CLASS (klass)->finalize = budgie_wayland_client_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_WAYLAND_CLIENT_GDK_MONITOR_PROPERTY, budgie_wayland_client_properties[BUDGIE_WAYLAND_CLIENT_GDK_MONITOR_PROPERTY] = g_param_spec_object ("gdk-monitor", "gdk-monitor", "gdk-monitor", gdk_monitor_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_WAYLAND_CLIENT_MONITOR_RES_PROPERTY, budgie_wayland_client_properties[BUDGIE_WAYLAND_CLIENT_MONITOR_RES_PROPERTY] = g_param_spec_boxed ("monitor-res", "monitor-res", "monitor-res", gdk_rectangle_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
budgie_wayland_client_instance_init (BudgieWaylandClient * self,
                                     gpointer klass)
{
	self->priv = budgie_wayland_client_get_instance_private (self);
	self->priv->screen = NULL;
	self->priv->primary_monitor = NULL;
}

static void
budgie_wayland_client_finalize (GObject * obj)
{
	BudgieWaylandClient * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_WAYLAND_CLIENT, BudgieWaylandClient);
	_g_object_unref0 (self->priv->screen);
	G_OBJECT_CLASS (budgie_wayland_client_parent_class)->finalize (obj);
}

static GType
budgie_wayland_client_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieWaylandClientClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_wayland_client_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieWaylandClient), 0, (GInstanceInitFunc) budgie_wayland_client_instance_init, NULL };
	GType budgie_wayland_client_type_id;
	budgie_wayland_client_type_id = g_type_register_static (G_TYPE_OBJECT, "BudgieWaylandClient", &g_define_type_info, 0);
	BudgieWaylandClient_private_offset = g_type_add_instance_private (budgie_wayland_client_type_id, sizeof (BudgieWaylandClientPrivate));
	return budgie_wayland_client_type_id;
}

GType
budgie_wayland_client_get_type (void)
{
	static volatile gsize budgie_wayland_client_type_id__once = 0;
	if (g_once_init_enter (&budgie_wayland_client_type_id__once)) {
		GType budgie_wayland_client_type_id;
		budgie_wayland_client_type_id = budgie_wayland_client_get_type_once ();
		g_once_init_leave (&budgie_wayland_client_type_id__once, budgie_wayland_client_type_id);
	}
	return budgie_wayland_client_type_id__once;
}

static void
_vala_budgie_wayland_client_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	BudgieWaylandClient * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_TYPE_WAYLAND_CLIENT, BudgieWaylandClient);
	switch (property_id) {
		case BUDGIE_WAYLAND_CLIENT_GDK_MONITOR_PROPERTY:
		g_value_set_object (value, budgie_wayland_client_get_gdk_monitor (self));
		break;
		case BUDGIE_WAYLAND_CLIENT_MONITOR_RES_PROPERTY:
		{
			GdkRectangle boxed;
			budgie_wayland_client_get_monitor_res (self, &boxed);
			g_value_set_boxed (value, &boxed);
		}
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_budgie_wayland_client_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec)
{
	BudgieWaylandClient * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_TYPE_WAYLAND_CLIENT, BudgieWaylandClient);
	switch (property_id) {
		case BUDGIE_WAYLAND_CLIENT_GDK_MONITOR_PROPERTY:
		budgie_wayland_client_set_gdk_monitor (self, g_value_get_object (value));
		break;
		case BUDGIE_WAYLAND_CLIENT_MONITOR_RES_PROPERTY:
		budgie_wayland_client_set_monitor_res (self, g_value_get_boxed (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
budgie_service_manager_get_instance_private (BudgieServiceManager* self)
{
	return G_STRUCT_MEMBER_P (self, BudgieServiceManager_private_offset);
}

/**
* Construct a new ServiceManager and initialiase appropriately
*/
static void
__lambda52_ (BudgieServiceManager* self,
             GObject* o,
             GAsyncResult* res)
{
	gboolean success = FALSE;
	g_return_if_fail (res != NULL);
	success = budgie_service_manager_register_with_session_finish (self, res);
	if (!success) {
		g_message ("manager.vala:96: Failed to register with Session manager");
	}
}

static void
___lambda52__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda52_ ((BudgieServiceManager*) self, source_object, res);
	g_object_unref (self);
}

static gpointer
_budgie_screenlock_ref0 (gpointer self)
{
	return self ? budgie_screenlock_ref (self) : NULL;
}

BudgieServiceManager*
budgie_service_manager_construct (GType object_type,
                                  gboolean replace)
{
	BudgieServiceManager * self = NULL;
	BudgieThemeManager* _tmp0_;
	BudgieStatusNotifierFreedesktopWatcher* _tmp1_;
	BudgieOSDManager* _tmp2_;
	BudgieOSDManager* _tmp3_;
	BudgieOSDKeys* _tmp4_;
	BudgieNotificationsServer* _tmp5_;
	BudgieNotificationsServer* _tmp6_;
	BudgieBackground* _tmp7_;
	BudgieXDGDirTracker* _tmp8_;
	BudgieXDGDirTracker* _tmp9_;
	BudgieScreenlock* _tmp10_;
	BudgieScreenlock* _tmp11_;
	BudgieScreenlock* _tmp12_;
	BudgieNightLightManager* _tmp13_;
	BudgieScreenshotManager* _tmp14_;
	BudgieScreenshotManager* _tmp15_;
	self = (BudgieServiceManager*) g_object_new (object_type, NULL);
	_tmp0_ = budgie_theme_manager_new ();
	_g_object_unref0 (self->priv->theme_manager);
	self->priv->theme_manager = _tmp0_;
	_tmp1_ = budgie_status_notifier_freedesktop_watcher_new ();
	_g_object_unref0 (self->priv->status_notifier);
	self->priv->status_notifier = _tmp1_;
	budgie_service_manager_register_with_session (self, ___lambda52__gasync_ready_callback, g_object_ref (self));
	_tmp2_ = budgie_osd_manager_new ();
	_budgie_osd_manager_unref0 (self->priv->osd);
	self->priv->osd = _tmp2_;
	_tmp3_ = self->priv->osd;
	budgie_osd_manager_setup_dbus (_tmp3_, replace);
	_tmp4_ = budgie_osd_keys_new ();
	_g_object_unref0 (self->priv->osdkeys);
	self->priv->osdkeys = _tmp4_;
	_tmp5_ = budgie_notifications_server_new ();
	_g_object_unref0 (self->priv->notifications);
	self->priv->notifications = _tmp5_;
	_tmp6_ = self->priv->notifications;
	budgie_notifications_server_setup_dbus (_tmp6_, replace);
	_tmp7_ = budgie_background_new ();
	_budgie_background_unref0 (self->priv->background);
	self->priv->background = _tmp7_;
	_tmp8_ = budgie_xdg_dir_tracker_new ();
	_g_object_unref0 (self->priv->xdg_tracker);
	self->priv->xdg_tracker = _tmp8_;
	_tmp9_ = self->priv->xdg_tracker;
	budgie_xdg_dir_tracker_setup_dbus (_tmp9_, replace);
	_tmp10_ = budgie_screenlock_init ();
	_tmp11_ = _budgie_screenlock_ref0 (_tmp10_);
	_budgie_screenlock_unref0 (self->priv->screenlock);
	self->priv->screenlock = _tmp11_;
	_tmp12_ = self->priv->screenlock;
	budgie_screenlock_setup_dbus (_tmp12_);
	_tmp13_ = budgie_night_light_manager_new ();
	_g_object_unref0 (self->priv->nightlight);
	self->priv->nightlight = _tmp13_;
	_tmp14_ = budgie_screenshot_manager_new ();
	_g_object_unref0 (self->priv->screenshot_manager);
	self->priv->screenshot_manager = _tmp14_;
	_tmp15_ = self->priv->screenshot_manager;
	budgie_screenshot_manager_serve (_tmp15_);
	return self;
}

BudgieServiceManager*
budgie_service_manager_new (gboolean replace)
{
	return budgie_service_manager_construct (BUDGIE_TYPE_SERVICE_MANAGER, replace);
}

static void
budgie_service_manager_register_with_session_data_free (gpointer _data)
{
	BudgieServiceManagerRegisterWithSessionData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (BudgieServiceManagerRegisterWithSessionData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
budgie_service_manager_register_with_session (BudgieServiceManager* self,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_)
{
	BudgieServiceManagerRegisterWithSessionData* _data_;
	BudgieServiceManager* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (BudgieServiceManagerRegisterWithSessionData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, budgie_service_manager_register_with_session_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	budgie_service_manager_register_with_session_co (_data_);
}

static gboolean
budgie_service_manager_register_with_session_finish (BudgieServiceManager* self,
                                                     GAsyncResult* _res_)
{
	gboolean result;
	BudgieServiceManagerRegisterWithSessionData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	return result;
}

/**
* Attempt registration with the Session Manager
*/
static void
budgie_service_manager_register_with_session_ready (GObject* source_object,
                                                    GAsyncResult* _res_,
                                                    gpointer _user_data_)
{
	BudgieServiceManagerRegisterWithSessionData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	budgie_service_manager_register_with_session_co (_data_);
}

static void
__lambda49_ (BudgieServiceManager* self)
{
	budgie_service_manager_end_session (self, FALSE);
}

static void
___lambda49__lib_session_session_client_query_end_session (LibSessionSessionClient* _sender,
                                                           guint flags,
                                                           gpointer self)
{
	__lambda49_ ((BudgieServiceManager*) self);
}

static void
__lambda50_ (BudgieServiceManager* self)
{
	budgie_service_manager_end_session (self, FALSE);
}

static void
___lambda50__lib_session_session_client_end_session (LibSessionSessionClient* _sender,
                                                     guint flags,
                                                     gpointer self)
{
	__lambda50_ ((BudgieServiceManager*) self);
}

static void
__lambda51_ (BudgieServiceManager* self)
{
	budgie_service_manager_end_session (self, TRUE);
}

static void
___lambda51__lib_session_session_client_stop (LibSessionSessionClient* _sender,
                                              gpointer self)
{
	__lambda51_ ((BudgieServiceManager*) self);
}

static gboolean
budgie_service_manager_register_with_session_co (BudgieServiceManagerRegisterWithSessionData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	lib_session_register_with_session ("budgie-daemon", budgie_service_manager_register_with_session_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp0_ = lib_session_register_with_session_finish (_data_->_res_);
	_g_object_unref0 (_data_->self->priv->sclient);
	_data_->self->priv->sclient = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->self->priv->sclient;
	if (_data_->_tmp1_ == NULL) {
		_data_->result = FALSE;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp2_ = _data_->self->priv->sclient;
	g_signal_connect_object (_data_->_tmp2_, "query-end-session", (GCallback) ___lambda49__lib_session_session_client_query_end_session, _data_->self, 0);
	_data_->_tmp3_ = _data_->self->priv->sclient;
	g_signal_connect_object (_data_->_tmp3_, "end-session", (GCallback) ___lambda50__lib_session_session_client_end_session, _data_->self, 0);
	_data_->_tmp4_ = _data_->self->priv->sclient;
	g_signal_connect_object (_data_->_tmp4_, "stop", (GCallback) ___lambda51__lib_session_session_client_stop, _data_->self, 0);
	_data_->result = TRUE;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

/**
* Properly shutdown when asked to
*/
static void
budgie_service_manager_end_session (BudgieServiceManager* self,
                                    gboolean quit)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	if (quit) {
		gtk_main_quit ();
		return;
	}
	{
		LibSessionSessionClient* _tmp0_;
		_tmp0_ = self->priv->sclient;
		lib_session_session_client_EndSessionResponse (_tmp0_, TRUE, "", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_warning ("manager.vala:155: Unable to respond to session manager! %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
budgie_service_manager_class_init (BudgieServiceManagerClass * klass,
                                   gpointer klass_data)
{
	budgie_service_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BudgieServiceManager_private_offset);
	G_OBJECT_CLASS (klass)->finalize = budgie_service_manager_finalize;
}

static void
budgie_service_manager_instance_init (BudgieServiceManager * self,
                                      gpointer klass)
{
	BudgieWaylandClient* _tmp0_;
	self->priv = budgie_service_manager_get_instance_private (self);
	_tmp0_ = budgie_wayland_client_new ();
	self->priv->wayland_client = _tmp0_;
}

static void
budgie_service_manager_finalize (GObject * obj)
{
	BudgieServiceManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_SERVICE_MANAGER, BudgieServiceManager);
	_g_object_unref0 (self->priv->theme_manager);
	_g_object_unref0 (self->priv->sclient);
	_g_object_unref0 (self->priv->wayland_client);
	_budgie_osd_manager_unref0 (self->priv->osd);
	_g_object_unref0 (self->priv->osdkeys);
	_g_object_unref0 (self->priv->notifications);
	_g_object_unref0 (self->priv->status_notifier);
	_g_object_unref0 (self->priv->xdg_tracker);
	_budgie_background_unref0 (self->priv->background);
	_budgie_screenlock_unref0 (self->priv->screenlock);
	_g_object_unref0 (self->priv->nightlight);
	_g_object_unref0 (self->priv->screenshot_manager);
	G_OBJECT_CLASS (budgie_service_manager_parent_class)->finalize (obj);
}

/**
* Main lifecycle management, handle all the various session and GTK+ bits
*/
static GType
budgie_service_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieServiceManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_service_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieServiceManager), 0, (GInstanceInitFunc) budgie_service_manager_instance_init, NULL };
	GType budgie_service_manager_type_id;
	budgie_service_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "BudgieServiceManager", &g_define_type_info, 0);
	BudgieServiceManager_private_offset = g_type_add_instance_private (budgie_service_manager_type_id, sizeof (BudgieServiceManagerPrivate));
	return budgie_service_manager_type_id;
}

GType
budgie_service_manager_get_type (void)
{
	static volatile gsize budgie_service_manager_type_id__once = 0;
	if (g_once_init_enter (&budgie_service_manager_type_id__once)) {
		GType budgie_service_manager_type_id;
		budgie_service_manager_type_id = budgie_service_manager_get_type_once ();
		g_once_init_leave (&budgie_service_manager_type_id__once, budgie_service_manager_type_id);
	}
	return budgie_service_manager_type_id__once;
}

