/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.grpc.xds;

import java.util.HashMap;
import java.util.Map;
import net.snowflake.client.jdbc.internal.google.common.annotations.VisibleForTesting;
import net.snowflake.client.jdbc.internal.grpc.internal.GrpcUtil;
import net.snowflake.client.jdbc.internal.grpc.xds.FaultFilter;
import net.snowflake.client.jdbc.internal.grpc.xds.Filter;
import net.snowflake.client.jdbc.internal.grpc.xds.GcpAuthenticationFilter;
import net.snowflake.client.jdbc.internal.grpc.xds.RbacFilter;
import net.snowflake.client.jdbc.internal.grpc.xds.RouterFilter;
import net.snowflake.client.jdbc.internal.javax.annotation.Nullable;

final class FilterRegistry {
    private static FilterRegistry instance;
    private final Map<String, Filter.Provider> supportedFilters = new HashMap<String, Filter.Provider>();
    static boolean isEnabledGcpAuthnFilter;

    private FilterRegistry() {
    }

    static synchronized FilterRegistry getDefaultRegistry() {
        if (instance == null) {
            instance = FilterRegistry.newRegistry().register(new FaultFilter.Provider(), new RouterFilter.Provider(), new RbacFilter.Provider());
            if (isEnabledGcpAuthnFilter) {
                instance.register(new GcpAuthenticationFilter.Provider());
            }
        }
        return instance;
    }

    @VisibleForTesting
    static FilterRegistry newRegistry() {
        return new FilterRegistry();
    }

    @VisibleForTesting
    FilterRegistry register(Filter.Provider ... filters) {
        for (Filter.Provider filter : filters) {
            for (String typeUrl : filter.typeUrls()) {
                this.supportedFilters.put(typeUrl, filter);
            }
        }
        return this;
    }

    @Nullable
    Filter.Provider get(String typeUrl) {
        return this.supportedFilters.get(typeUrl);
    }

    static {
        isEnabledGcpAuthnFilter = GrpcUtil.getFlag("GRPC_EXPERIMENTAL_XDS_GCP_AUTHENTICATION_FILTER", false);
    }
}

