/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core.arrow;

import java.math.BigDecimal;
import java.time.Duration;
import net.snowflake.client.core.DataConversionContext;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.arrow.AbstractArrowVectorConverter;
import net.snowflake.client.core.arrow.ArrowVectorConverterUtil;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeType;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.DecimalVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ValueVector;

public class DecimalToScaledFixedConverter
extends AbstractArrowVectorConverter {
    protected DecimalVector decimalVector;

    public DecimalToScaledFixedConverter(ValueVector fieldVector, int vectorIndex, DataConversionContext context) {
        super(String.format("%s(%s,%s)", new Object[]{SnowflakeType.FIXED, fieldVector.getField().getMetadata().get("precision"), fieldVector.getField().getMetadata().get("scale")}), fieldVector, vectorIndex, context);
        this.decimalVector = (DecimalVector)fieldVector;
    }

    @Override
    public byte[] toBytes(int index) {
        if (this.isNull(index)) {
            return null;
        }
        return this.toBigDecimal(index).toBigInteger().toByteArray();
    }

    @Override
    public byte toByte(int index) throws SFException {
        if (this.isNull(index)) {
            return 0;
        }
        BigDecimal bigDecimal = this.toBigDecimal(index);
        if (bigDecimal.scale() == 0) {
            byte byteVal = bigDecimal.byteValue();
            if ((long)byteVal == bigDecimal.longValue()) {
                return byteVal;
            }
            throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, this.logicalTypeStr, "Byte", bigDecimal.toPlainString());
        }
        throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, this.logicalTypeStr, "Byte", bigDecimal.toPlainString());
    }

    @Override
    public short toShort(int index) throws SFException {
        if (this.isNull(index)) {
            return 0;
        }
        BigDecimal bigDecimal = this.toBigDecimal(index);
        if (bigDecimal.scale() == 0) {
            short shortValue = bigDecimal.shortValue();
            if (bigDecimal.compareTo(BigDecimal.valueOf(shortValue)) == 0) {
                return shortValue;
            }
            throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, this.logicalTypeStr, "Short", bigDecimal.toPlainString());
        }
        throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, this.logicalTypeStr, "Short", bigDecimal.toPlainString());
    }

    @Override
    public int toInt(int index) throws SFException {
        if (this.isNull(index)) {
            return 0;
        }
        BigDecimal bigDecimal = this.toBigDecimal(index);
        if (bigDecimal.scale() == 0) {
            int intValue = bigDecimal.intValue();
            if (bigDecimal.compareTo(BigDecimal.valueOf(intValue)) == 0) {
                return intValue;
            }
            throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, this.logicalTypeStr, "Int", bigDecimal.toPlainString());
        }
        throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, this.logicalTypeStr, "Int", bigDecimal.toPlainString());
    }

    @Override
    public long toLong(int index) throws SFException {
        if (this.isNull(index)) {
            return 0L;
        }
        BigDecimal bigDecimal = this.toBigDecimal(index);
        if (bigDecimal.scale() == 0) {
            long longValue = bigDecimal.longValue();
            if (bigDecimal.compareTo(BigDecimal.valueOf(longValue)) == 0) {
                return longValue;
            }
            throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, this.logicalTypeStr, "Long", bigDecimal.toPlainString());
        }
        throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, this.logicalTypeStr, "Long", bigDecimal.toPlainString());
    }

    @Override
    public float toFloat(int index) throws SFException {
        if (this.isNull(index)) {
            return 0.0f;
        }
        BigDecimal bigDecimal = this.toBigDecimal(index);
        return bigDecimal.floatValue();
    }

    @Override
    public double toDouble(int index) throws SFException {
        if (this.isNull(index)) {
            return 0.0;
        }
        BigDecimal bigDecimal = this.toBigDecimal(index);
        return bigDecimal.doubleValue();
    }

    @Override
    public BigDecimal toBigDecimal(int index) {
        return this.decimalVector.getObject(index);
    }

    @Override
    public Object toObject(int index) throws SFException {
        return this.toBigDecimal(index);
    }

    @Override
    public String toString(int index) {
        BigDecimal bigDecimal = this.toBigDecimal(index);
        return bigDecimal == null ? null : bigDecimal.toPlainString();
    }

    @Override
    public boolean toBoolean(int index) throws SFException {
        if (this.isNull(index)) {
            return false;
        }
        BigDecimal val = this.toBigDecimal(index);
        if (val.compareTo(BigDecimal.ZERO) == 0) {
            return false;
        }
        if (val.compareTo(BigDecimal.ONE) == 0) {
            return true;
        }
        throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, this.logicalTypeStr, "Boolean", val.toPlainString());
    }

    @Override
    public Duration toDuration(int index) throws SFException {
        if (this.isNull(index)) {
            return null;
        }
        BigDecimal numNanos = this.toBigDecimal(index);
        try {
            return ArrowVectorConverterUtil.getDurationFromNanos(numNanos);
        }
        catch (ArithmeticException e) {
            throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, this.logicalTypeStr, "Duration", numNanos.toPlainString());
        }
    }
}

