/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds;

import java.security.AccessController;

public final class JaybirdSystemProperties {
    private static final String COMMON_PREFIX = "org.firebirdsql.";
    private static final String JDBC_PREFIX = "org.firebirdsql.jdbc.";
    @Deprecated
    public static final String FORCE_CONSOLE_LOGGER_PROP = "org.firebirdsql.jdbc.forceConsoleLogger";
    @Deprecated
    public static final String DISABLE_LOGGING_PROP = "org.firebirdsql.jdbc.disableLogging";
    @Deprecated
    public static final String LOGGER_IMPLEMENTATION_PROP = "org.firebirdsql.jdbc.loggerImplementation";
    public static final String SYNC_WRAP_NATIVE_LIBRARY_PROP = "org.firebirdsql.jna.syncWrapNativeLibrary";
    public static final String PROCESS_ID_PROP = "org.firebirdsql.jdbc.pid";
    public static final String PROCESS_NAME_PROP = "org.firebirdsql.jdbc.processName";
    public static final String DEFAULT_CONNECTION_ENCODING_PROPERTY = "org.firebirdsql.jdbc.defaultConnectionEncoding";
    public static final String REQUIRE_CONNECTION_ENCODING_PROPERTY = "org.firebirdsql.jdbc.requireConnectionEncoding";
    public static final String DEFAULT_MAX_INLINE_BLOB_SIZE = "org.firebirdsql.jdbc.defaultMaxInlineBlobSize";
    public static final String DEFAULT_MAX_BLOB_CACHE_SIZE = "org.firebirdsql.jdbc.defaultMaxBlobCacheSize";
    public static final String DATATYPE_CODER_CACHE_SIZE = "org.firebirdsql.datatypeCoderCacheSize";
    public static final String NATIVE_LIBRARY_SHUTDOWN_DISABLED = "org.firebirdsql.nativeResourceShutdownDisabled";

    private JaybirdSystemProperties() {
    }

    @Deprecated
    public static boolean isForceConsoleLogger() {
        return JaybirdSystemProperties.getBooleanSystemPropertyPrivileged(FORCE_CONSOLE_LOGGER_PROP);
    }

    @Deprecated
    public static boolean isDisableLogging() {
        return JaybirdSystemProperties.getBooleanSystemPropertyPrivileged(DISABLE_LOGGING_PROP);
    }

    @Deprecated
    public static String getLoggerImplementation() {
        return JaybirdSystemProperties.getSystemPropertyPrivileged(LOGGER_IMPLEMENTATION_PROP);
    }

    public static boolean isSyncWrapNativeLibrary() {
        return JaybirdSystemProperties.getBooleanSystemPropertyPrivileged(SYNC_WRAP_NATIVE_LIBRARY_PROP);
    }

    public static Integer getProcessId() {
        return JaybirdSystemProperties.getIntegerSystemPropertyPrivileged(PROCESS_ID_PROP);
    }

    public static String getProcessName() {
        return JaybirdSystemProperties.getSystemPropertyPrivileged(PROCESS_NAME_PROP);
    }

    public static String getDefaultConnectionEncoding() {
        return JaybirdSystemProperties.getSystemPropertyPrivileged(DEFAULT_CONNECTION_ENCODING_PROPERTY);
    }

    public static boolean isRequireConnectionEncoding() {
        return JaybirdSystemProperties.getBooleanSystemPropertyPrivileged(REQUIRE_CONNECTION_ENCODING_PROPERTY);
    }

    public static boolean isNativeResourceShutdownDisabled() {
        return JaybirdSystemProperties.getBooleanSystemPropertyPrivileged(NATIVE_LIBRARY_SHUTDOWN_DISABLED);
    }

    public static int getDatatypeCoderCacheSize(int defaultValue) {
        Integer value = JaybirdSystemProperties.getIntegerSystemPropertyPrivileged(DATATYPE_CODER_CACHE_SIZE);
        return value != null ? value : defaultValue;
    }

    public static Integer getDefaultMaxInlineBlobSize() {
        return JaybirdSystemProperties.getIntegerSystemPropertyPrivileged(DEFAULT_MAX_INLINE_BLOB_SIZE);
    }

    public static Integer getDefaultMaxBlobCacheSize() {
        return JaybirdSystemProperties.getIntegerSystemPropertyPrivileged(DEFAULT_MAX_BLOB_CACHE_SIZE);
    }

    private static String getSystemPropertyPrivileged(String propertyName) {
        return AccessController.doPrivileged(() -> System.getProperty(propertyName));
    }

    private static boolean getBooleanSystemPropertyPrivileged(String propertyName) {
        return AccessController.doPrivileged(() -> Boolean.getBoolean(propertyName));
    }

    private static Integer getIntegerSystemPropertyPrivileged(String propertyName) {
        return AccessController.doPrivileged(() -> Integer.getInteger(propertyName));
    }
}

