/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.type.slots;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.cext.capi.ExternalFunctionNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTiming;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.builtins.objects.cext.common.CExtCommonNodes;
import com.oracle.graal.python.builtins.objects.function.PBuiltinFunction;
import com.oracle.graal.python.builtins.objects.function.PFunction;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.function.Signature;
import com.oracle.graal.python.builtins.objects.method.PBuiltinMethod;
import com.oracle.graal.python.builtins.objects.method.PDecoratedMethod;
import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.slots.Slot2Builtin;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlot;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotDescrGet;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.argument.CreateArgumentsNode;
import com.oracle.graal.python.nodes.call.BoundDescriptor;
import com.oracle.graal.python.nodes.call.CallDispatchers;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.call.special.MaybeBindDescriptorNode;
import com.oracle.graal.python.nodes.function.BuiltinFunctionRootNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonQuaternaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonVarargsBuiltinNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;

public final class TpSlotVarargs {
    private static final CApiTiming C_API_TIMING = CApiTiming.create(true, "<varargs slot>");

    private TpSlotVarargs() {
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    @ReportPolymorphism
    public static abstract class CallSlotTpCallNode
    extends CallVarargsTpSlotBaseNode {
        @Specialization
        static Object callPython(VirtualFrame frame, Node inliningTarget, TpSlot.TpSlotPythonSingle slot, Object self, Object[] args, PKeyword[] keywords, @Cached CallSlotVarargsPythonNode callNode) {
            return callNode.execute(frame, inliningTarget, slot, self, args, keywords);
        }

        @Specialization
        @HostCompilerDirectives.InliningCutoff
        static Object callNative(VirtualFrame frame, TpSlot.TpSlotCExtNative slot, Object self, Object[] args, PKeyword[] keywords, @Cached ExternalFunctionNodes.DefaultCheckFunctionResultNode checkResult, @Cached CApiTransitions.NativeToPythonTransferNode toPythonNode, @Cached CallSlotVarargsNativeNode callNode) {
            return callNode.execute(frame, slot, self, args, keywords, SpecialMethodNames.T___CALL__, checkResult, toPythonNode);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    @ReportPolymorphism
    public static abstract class CallSlotTpNewNode
    extends CallVarargsTpSlotBaseNode {
        @Specialization
        static Object callPython(VirtualFrame frame, Node inliningTarget, TpSlot.TpSlotPythonSingle slot, Object self, Object[] args, PKeyword[] keywords, @Cached BindNewMethodNode bindNew, @Cached(inline=false) CallNode callNode) {
            Object callable = bindNew.execute(frame, inliningTarget, slot.getCallable(), self);
            return callNode.execute((Frame)frame, callable, PythonUtils.prependArgument(self, args), keywords);
        }

        @Specialization
        @HostCompilerDirectives.InliningCutoff
        static Object callNative(VirtualFrame frame, TpSlot.TpSlotCExtNative slot, Object self, Object[] args, PKeyword[] keywords, @Cached ExternalFunctionNodes.DefaultCheckFunctionResultNode checkResult, @Cached CApiTransitions.NativeToPythonTransferNode toPythonNode, @Cached CallSlotVarargsNativeNode callNode) {
            return callNode.execute(frame, slot, self, args, keywords, SpecialMethodNames.T___NEW__, checkResult, toPythonNode);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    public static abstract class BindNewMethodNode
    extends Node {
        public abstract Object execute(VirtualFrame var1, Node var2, Object var3, Object var4);

        @Specialization(guards={"isStaticmethod(descriptor)"})
        static Object doStaticmethod(PDecoratedMethod descriptor, Object type) {
            return descriptor.getCallable();
        }

        protected static boolean isStaticmethod(PDecoratedMethod descriptor) {
            return descriptor.getInitialPythonClass() == PythonBuiltinClassType.PStaticmethod;
        }

        @Specialization
        static Object doBuiltinMethod(PBuiltinMethod descriptor, Object type) {
            return descriptor;
        }

        @Specialization
        static Object doFunction(PFunction descriptor, Object type) {
            return descriptor;
        }

        @Fallback
        static Object doBind(VirtualFrame frame, Node inliningTarget, Object descriptor, Object type, @Cached TpSlots.GetObjectSlotsNode getSlotsNode, @Cached TpSlotDescrGet.CallSlotDescrGet callGetSlot) {
            TpSlot getMethod = getSlotsNode.execute(inliningTarget, descriptor).tp_descr_get();
            if (getMethod != null) {
                return callGetSlot.execute(frame, inliningTarget, getMethod, descriptor, PNone.NO_VALUE, type);
            }
            return descriptor;
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    @ReportPolymorphism
    public static abstract class CallSlotTpInitNode
    extends CallVarargsTpSlotBaseNode {
        @Specialization
        static Object callPython(VirtualFrame frame, Node inliningTarget, TpSlot.TpSlotPythonSingle slot, Object self, Object[] args, PKeyword[] keywords, @Cached CallSlotVarargsPythonNode callNode, @Cached PRaiseNode raiseNode) {
            Object result = callNode.execute(frame, inliningTarget, slot, self, args, keywords);
            if (result != PNone.NONE) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.SHOULD_RETURN_NONE, "__init__()");
            }
            return PNone.NO_VALUE;
        }

        @Specialization
        @HostCompilerDirectives.InliningCutoff
        static Object callNative(VirtualFrame frame, TpSlot.TpSlotCExtNative slot, Object self, Object[] args, PKeyword[] keywords, @Cached ExternalFunctionNodes.InitCheckFunctionResultNode checkResult, @Cached CallSlotVarargsNativeNode callNode) {
            return callNode.execute(frame, slot, self, args, keywords, SpecialMethodNames.T___INIT__, checkResult, null);
        }
    }

    @GenerateInline(value=false)
    @GenerateUncached
    static abstract class CallSlotVarargsNativeNode
    extends Node {
        CallSlotVarargsNativeNode() {
        }

        abstract Object execute(VirtualFrame var1, TpSlot.TpSlotCExtNative var2, Object var3, Object[] var4, PKeyword[] var5, TruffleString var6, CExtCommonNodes.CheckFunctionResultNode var7, CApiTransitions.NativeToPythonTransferNode var8);

        @Specialization
        static Object callNative(VirtualFrame frame, TpSlot.TpSlotCExtNative slot, Object self, Object[] args, PKeyword[] keywords, TruffleString name, CExtCommonNodes.CheckFunctionResultNode checkResultNode, CApiTransitions.NativeToPythonTransferNode toPythonNode, @Bind Node inliningTarget, @Bind PythonContext context, @Cached PythonContext.GetThreadStateNode getThreadStateNode, @Cached CApiTransitions.PythonToNativeNode toNativeNode, @Cached ExternalFunctionNodes.CreateArgsTupleNode createArgsTupleNode, @Cached ExternalFunctionNodes.EagerTupleState eagerTupleState, @Cached ExternalFunctionNodes.ExternalFunctionInvokeNode externalInvokeNode) {
            PythonLanguage language = context.getLanguage(inliningTarget);
            PythonContext.PythonThreadState state = getThreadStateNode.execute(inliningTarget, context);
            PTuple argsTuple = createArgsTupleNode.execute(inliningTarget, language, args, eagerTupleState);
            PNone kwargsDict = keywords.length > 0 ? PFactory.createDict(language, keywords) : PNone.NO_VALUE;
            Object nativeResult = externalInvokeNode.call(frame, inliningTarget, state, C_API_TIMING, name, slot.callable, toNativeNode.execute(self), toNativeNode.execute(argsTuple), toNativeNode.execute(kwargsDict));
            eagerTupleState.report(inliningTarget, argsTuple);
            checkResultNode.execute(state, name, nativeResult);
            if (toPythonNode != null) {
                return toPythonNode.execute(nativeResult);
            }
            return PNone.NO_VALUE;
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    static abstract class CallSlotVarargsPythonNode
    extends Node {
        CallSlotVarargsPythonNode() {
        }

        abstract Object execute(VirtualFrame var1, Node var2, TpSlot.TpSlotPythonSingle var3, Object var4, Object[] var5, PKeyword[] var6);

        @Specialization
        static Object callPython(VirtualFrame frame, Node inliningTarget, TpSlot.TpSlotPythonSingle slot, Object self, Object[] args, PKeyword[] keywords, @Cached MaybeBindDescriptorNode bindDescriptorNode, @Cached(inline=false) CallNode callNode) {
            Object[] callArgs;
            Object callable;
            Object bound = bindDescriptorNode.execute((Frame)frame, inliningTarget, slot.getCallable(), self, slot.getType());
            if (bound instanceof BoundDescriptor) {
                BoundDescriptor boundDescriptor = (BoundDescriptor)bound;
                callable = boundDescriptor.descriptor;
                callArgs = args;
            } else {
                callable = slot.getCallable();
                callArgs = new Object[args.length + 1];
                callArgs[0] = self;
                PythonUtils.arraycopy(args, 0, callArgs, 1, args.length);
            }
            return callNode.execute((Frame)frame, callable, callArgs, keywords);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    static abstract class DispatchVarargsBuiltinFullDirectNode
    extends Node {
        DispatchVarargsBuiltinFullDirectNode() {
        }

        public abstract Object execute(VirtualFrame var1, Node var2, TpSlotVarargsBuiltin<?> var3, Object var4, Object[] var5, PKeyword[] var6);

        @Specialization
        static Object call(VirtualFrame frame, Node inliningTarget, TpSlotVarargsBuiltin<?> slot, Object self, Object[] args, PKeyword[] keywords, @Cached CreateArgumentsNode createArgumentsNode, @Cached(value="createDirectCallNode(slot)", inline=false) DirectCallNode callNode, @Cached CallDispatchers.SimpleDirectInvokeNode invoke) {
            CompilerAsserts.partialEvaluationConstant(slot);
            Object[] arguments = createArgumentsNode.execute(inliningTarget, slot.getName(), args, keywords, slot.getSignature(), self, null, slot.getDefaults(), slot.getKwDefaults(), false);
            return invoke.execute(frame, inliningTarget, callNode, arguments);
        }

        @NeverDefault
        protected static DirectCallNode createDirectCallNode(TpSlotVarargsBuiltin<?> slot) {
            return Truffle.getRuntime().createDirectCallNode((CallTarget)PythonLanguage.get(null).getBuiltinSlotCallTarget(slot.callTargetIndex));
        }
    }

    @GenerateCached(value=false)
    static abstract class CallVarargsTpSlotBaseNode
    extends Node {
        CallVarargsTpSlotBaseNode() {
        }

        public abstract Object execute(VirtualFrame var1, Node var2, TpSlot var3, Object var4, Object[] var5, PKeyword[] var6);

        @Specialization(guards={"frame != null", "cachedSlot == slot"}, limit="3")
        static Object callCachedBuiltin(VirtualFrame frame, Node inliningTarget, TpSlotVarargsBuiltin<?> slot, Object self, Object[] args, PKeyword[] keywords, @Cached(value="slot") TpSlotVarargsBuiltin<?> cachedSlot, @Cached(value="cachedSlot.createSlotNodeIfDirect()") PythonBuiltinBaseNode slotNode, @Cached DispatchVarargsBuiltinFullDirectNode dispatchFullNode) {
            if (slotNode != null) {
                if (slotNode instanceof PythonUnaryBuiltinNode) {
                    PythonUnaryBuiltinNode unaryBuiltinNode = (PythonUnaryBuiltinNode)slotNode;
                    if (keywords.length == 0 && args.length == 0) {
                        return unaryBuiltinNode.execute(frame, self);
                    }
                } else if (slotNode instanceof PythonBinaryBuiltinNode) {
                    PythonBinaryBuiltinNode binaryBuiltinNode = (PythonBinaryBuiltinNode)slotNode;
                    if (keywords.length == 0 && (args.length == 1 || args.length + cachedSlot.getDefaults().length >= 1 && args.length <= 1)) {
                        return binaryBuiltinNode.execute(frame, self, args.length == 1 ? args[0] : PNone.NO_VALUE);
                    }
                } else if (slotNode instanceof PythonTernaryBuiltinNode) {
                    PythonTernaryBuiltinNode ternaryBuiltinNode = (PythonTernaryBuiltinNode)slotNode;
                    if (keywords.length == 0 && (args.length == 2 || args.length + cachedSlot.getDefaults().length >= 2 && args.length <= 2)) {
                        return ternaryBuiltinNode.execute(frame, self, args.length >= 1 ? args[0] : PNone.NO_VALUE, args.length == 2 ? args[1] : PNone.NO_VALUE);
                    }
                } else if (slotNode instanceof PythonQuaternaryBuiltinNode) {
                    PythonQuaternaryBuiltinNode quaternaryBuiltinNode = (PythonQuaternaryBuiltinNode)slotNode;
                    if (keywords.length == 0 && (args.length == 3 || args.length + cachedSlot.getDefaults().length >= 3 && args.length <= 3)) {
                        return quaternaryBuiltinNode.execute(frame, self, args.length >= 1 ? args[0] : PNone.NO_VALUE, args.length >= 2 ? args[1] : PNone.NO_VALUE, args.length == 3 ? args[2] : PNone.NO_VALUE);
                    }
                } else if (slotNode instanceof PythonVarargsBuiltinNode) {
                    PythonVarargsBuiltinNode varargsBuiltinNode = (PythonVarargsBuiltinNode)slotNode;
                    return varargsBuiltinNode.execute(frame, self, args, keywords);
                }
            }
            return dispatchFullNode.execute(frame, inliningTarget, cachedSlot, self, args, keywords);
        }

        @Specialization(replaces={"callCachedBuiltin"})
        @HostCompilerDirectives.InliningCutoff
        static Object callGenericBuiltin(VirtualFrame frame, Node inliningTarget, TpSlotVarargsBuiltin<?> slot, Object self, Object[] args, PKeyword[] keywords, @Cached CreateArgumentsNode createArgumentsNode, @Cached CallDispatchers.SimpleIndirectInvokeNode invoke) {
            Object[] arguments = createArgumentsNode.execute(inliningTarget, slot.getName(), args, keywords, slot.getSignature(), self, null, slot.getDefaults(), slot.getKwDefaults(), false);
            RootCallTarget callTarget = PythonLanguage.get(inliningTarget).getBuiltinSlotCallTarget(slot.callTargetIndex);
            return invoke.execute((Frame)frame, inliningTarget, callTarget, arguments);
        }
    }

    public static abstract class TpSlotNewBuiltin<T extends PythonBuiltinBaseNode>
    extends TpSlotVarargsBuiltin<T> {
        protected TpSlotNewBuiltin(NodeFactory<T> nodeFactory) {
            super(nodeFactory, "__new__", true);
        }

        @Override
        public PBuiltinMethod createBuiltin(Python3Core core, Object type, TruffleString tsName, ExternalFunctionNodes.PExternalFunctionWrapper wrapper) {
            PythonBuiltinClassType bt;
            PythonLanguage language = core.getLanguage();
            NodeFactory factory = this.getNodeFactory();
            Class nodeClass = factory.getNodeClass();
            Slot.SlotSignature slotSignature = nodeClass.getAnnotation(Slot.SlotSignature.class);
            Slot2Builtin builtin = new Slot2Builtin(slotSignature, "__new__", null);
            PythonBuiltinClassType builtinType = type instanceof PythonBuiltinClassType ? (bt = (PythonBuiltinClassType)((Object)type)) : null;
            RootCallTarget callTarget = language.createCachedCallTarget(l -> new BuiltinFunctionRootNode((PythonLanguage)((Object)l), builtin, (NodeFactory<? extends PythonBuiltinBaseNode>)factory, false, builtinType), nodeClass, nodeClass, builtinType, "__new__");
            return PFactory.createNewWrapper(language, type, this.defaults, this.kwDefaults, callTarget, this);
        }
    }

    public static abstract class TpSlotVarargsBuiltin<T extends PythonBuiltinBaseNode>
    extends TpSlot.TpSlotBuiltin<T> {
        final int callTargetIndex = TpSlot.TpSlotBuiltinCallTargetRegistry.getNextCallTargetIndex();
        private final String name;
        private final TruffleString tsName;
        protected final boolean directInvocation;
        protected final Signature signature;
        protected final Object[] defaults;
        protected final PKeyword[] kwDefaults;

        protected TpSlotVarargsBuiltin(NodeFactory<T> nodeFactory, String name) {
            this(nodeFactory, name, false);
        }

        protected TpSlotVarargsBuiltin(NodeFactory<T> nodeFactory, String name, boolean takesClass) {
            super(nodeFactory);
            this.name = name;
            this.tsName = PythonUtils.tsLiteral(name);
            Class nodeClass = nodeFactory.getNodeClass();
            Slot.SlotSignature slotSignature = nodeClass.getAnnotation(Slot.SlotSignature.class);
            Slot2Builtin builtin = new Slot2Builtin(slotSignature, name, null);
            this.signature = BuiltinFunctionRootNode.createSignature(nodeFactory, builtin, true, takesClass);
            this.defaults = PBuiltinFunction.generateDefaults(PythonBuiltins.numDefaults(builtin));
            this.kwDefaults = PBuiltinFunction.generateKwDefaults(this.signature);
            this.directInvocation = PythonUnaryBuiltinNode.class.isAssignableFrom(nodeClass) || PythonBinaryBuiltinNode.class.isAssignableFrom(nodeClass) || PythonTernaryBuiltinNode.class.isAssignableFrom(nodeClass) || PythonVarargsBuiltinNode.class.isAssignableFrom(nodeClass) || PythonQuaternaryBuiltinNode.class.isAssignableFrom(nodeClass);
        }

        final PythonBuiltinBaseNode createSlotNodeIfDirect() {
            return this.directInvocation ? (PythonBuiltinBaseNode)((Object)this.createNode()) : null;
        }

        public Signature getSignature() {
            return this.signature;
        }

        public Object[] getDefaults() {
            return this.defaults;
        }

        public PKeyword[] getKwDefaults() {
            return this.kwDefaults;
        }

        public TruffleString getName() {
            return this.tsName;
        }

        @Override
        public final void initialize(PythonLanguage language) {
            RootCallTarget callTarget = TpSlotVarargsBuiltin.createSlotCallTarget(language, null, this.getNodeFactory(), this.name);
            language.setBuiltinSlotCallTarget(this.callTargetIndex, callTarget);
        }

        @Override
        public PythonObject createBuiltin(Python3Core core, Object type, TruffleString tsName, ExternalFunctionNodes.PExternalFunctionWrapper wrapper) {
            return this.createBuiltin(core, type, tsName, null, wrapper, this.getNodeFactory());
        }
    }
}

