/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.flavor.python;

import com.oracle.truffle.regex.charset.CodePointSet;
import com.oracle.truffle.regex.charset.CodePointSetAccumulator;
import com.oracle.truffle.regex.charset.Range;
import com.oracle.truffle.regex.flavor.python.PythonFlavor;
import com.oracle.truffle.regex.tregex.string.Encodings;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.graalvm.collections.EconomicMap;
import org.graalvm.shadowed.com.ibm.icu.lang.UCharacter;

public final class PythonLocaleData {
    private static final int CACHE_SIZE = 16;
    private static final LRUCache<CacheKey, PythonLocaleData> CACHED_LOCALE_DATA = new LRUCache(16);
    private static final CodePointSet WORD_CHARS = PythonFlavor.UNICODE.getProperty("Alphabetic").union(PythonFlavor.UNICODE.getProperty("gc=digit")).union(CodePointSet.create(95));
    private final CodePointSet wordChars;
    private final CodePointSet nonWordChars;
    private final byte[] caseFolding;

    public static PythonLocaleData getLocaleData(String locale) {
        if (locale.equals("C")) {
            return PythonLocaleData.createCachedLocaleData(false, Charset.forName("US-ASCII"));
        }
        int dot = locale.indexOf(46);
        if (dot == -1) {
            throw new IllegalArgumentException("malformed locale: " + locale);
        }
        String language = locale.substring(0, dot);
        String encoding = locale.substring(dot + 1);
        try {
            return PythonLocaleData.createCachedLocaleData(language.startsWith("tr_"), Charset.forName(encoding));
        }
        catch (IllegalCharsetNameException | UnsupportedCharsetException e) {
            throw new IllegalArgumentException("unsupported locale: " + locale);
        }
    }

    public CodePointSet getWordCharacters() {
        return this.wordChars;
    }

    public CodePointSet getNonWordCharacters() {
        return this.nonWordChars;
    }

    public void caseFoldUnfold(CodePointSetAccumulator charClass, CodePointSetAccumulator copy) {
        charClass.copyTo(copy);
        int iFolding = 0;
        for (Range r : copy) {
            for (iFolding = this.caseFoldingBinarySearch(iFolding, r.lo); iFolding < this.caseFoldingSize() && this.caseFoldingFrom(iFolding) >= r.lo && this.caseFoldingFrom(iFolding) <= r.hi; ++iFolding) {
                charClass.addCodePoint(this.caseFoldingTo(iFolding));
            }
        }
    }

    private int caseFoldingFrom(int index) {
        return this.caseFolding[index << 1] & 0xFF;
    }

    private int caseFoldingTo(int index) {
        return this.caseFolding[(index << 1) + 1] & 0xFF;
    }

    private int caseFoldingSize() {
        return this.caseFolding.length >> 1;
    }

    private int caseFoldingBinarySearch(int minIndex, int target) {
        int lo = minIndex;
        int hi = this.caseFoldingSize() - 1;
        while (lo < hi) {
            int mid = lo + hi >> 1;
            if (this.caseFoldingFrom(mid) < target) {
                lo = mid + 1;
                continue;
            }
            if (this.caseFoldingFrom(mid) > target) {
                hi = mid - 1;
                continue;
            }
            return mid;
        }
        return lo;
    }

    private static PythonLocaleData createCachedLocaleData(boolean turkish, Charset charset) {
        CacheKey key = new CacheKey(turkish, charset);
        PythonLocaleData localeData = (PythonLocaleData)CACHED_LOCALE_DATA.get(key);
        if (localeData == null) {
            localeData = new PythonLocaleData(turkish, charset);
            CACHED_LOCALE_DATA.put(key, localeData);
        }
        return localeData;
    }

    private PythonLocaleData(boolean turkish, Charset charset) {
        int[] codePoints = PythonLocaleData.charsetToCodePoints(charset);
        CodePointSetAccumulator wordCharsAccum = new CodePointSetAccumulator();
        for (int b = 0; b <= 255; ++b) {
            int codePoint = codePoints[b];
            if (!WORD_CHARS.contains(codePoint)) continue;
            wordCharsAccum.appendCodePoint(b);
        }
        this.wordChars = wordCharsAccum.toCodePointSet();
        this.nonWordChars = this.wordChars.createInverse(Encodings.LATIN_1);
        EconomicMap invCodePoints = EconomicMap.create((int)256);
        for (int b = 0; b <= 255; ++b) {
            invCodePoints.put((Object)codePoints[b], (Object)((byte)b));
        }
        ArrayList<CaseFoldingEntry> caseFoldingAccum = new ArrayList<CaseFoldingEntry>();
        for (int b = 0; b <= 255; ++b) {
            int codePoint = codePoints[b];
            int lowerCase = PythonLocaleData.toLowerCase(codePoint, turkish);
            int upperCase = PythonLocaleData.toUpperCase(codePoint, turkish);
            if (lowerCase != codePoint && invCodePoints.containsKey((Object)lowerCase)) {
                caseFoldingAccum.add(new CaseFoldingEntry((byte)b, (Byte)invCodePoints.get((Object)lowerCase)));
            }
            if (upperCase == codePoint || !invCodePoints.containsKey((Object)upperCase)) continue;
            caseFoldingAccum.add(new CaseFoldingEntry((byte)b, (Byte)invCodePoints.get((Object)upperCase)));
        }
        Collections.sort(caseFoldingAccum);
        this.caseFolding = new byte[caseFoldingAccum.size() << 1];
        for (int i = 0; i < caseFoldingAccum.size(); ++i) {
            this.caseFolding[i << 1] = ((CaseFoldingEntry)caseFoldingAccum.get((int)i)).mapping;
            this.caseFolding[(i << 1) + 1] = ((CaseFoldingEntry)caseFoldingAccum.get((int)i)).character;
        }
    }

    private static int toLowerCase(int codePoint, boolean turkish) {
        if (turkish && codePoint == 73) {
            return 305;
        }
        return UCharacter.toLowerCase((int)codePoint);
    }

    private static int toUpperCase(int codePoint, boolean turkish) {
        if (turkish && codePoint == 105) {
            return 304;
        }
        return UCharacter.toUpperCase((int)codePoint);
    }

    private static int[] charsetToCodePoints(Charset charset) {
        int[] codePoints = PythonLocaleData.charsetToCodePointsFast(charset);
        if (codePoints == null) {
            return PythonLocaleData.charsetToCodePointsSlow(charset);
        }
        assert (Arrays.equals(codePoints, PythonLocaleData.charsetToCodePointsSlow(charset)));
        return codePoints;
    }

    private static int[] charsetToCodePointsFast(Charset charset) {
        try {
            ByteBuffer byteRange = ByteBuffer.allocate(256);
            for (int b = 0; b <= 255; ++b) {
                byteRange.put((byte)b);
            }
            byteRange.rewind();
            CharBuffer decoded = charset.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPLACE).decode(byteRange);
            if (decoded.codePoints().count() == 256L) {
                return decoded.codePoints().toArray();
            }
        }
        catch (CharacterCodingException characterCodingException) {
            // empty catch block
        }
        return null;
    }

    private static int[] charsetToCodePointsSlow(Charset charset) {
        int[] codePoints = new int[256];
        CharsetDecoder decoder = charset.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPLACE);
        ByteBuffer singleByte = ByteBuffer.allocate(1);
        for (int b = 0; b <= 255; ++b) {
            decoder.reset();
            singleByte.put(0, (byte)b);
            singleByte.rewind();
            try {
                CharBuffer codePoint = decoder.decode(singleByte);
                if (codePoint.codePoints().count() == 1L) {
                    codePoints[b] = codePoint.codePoints().findFirst().getAsInt();
                    continue;
                }
                codePoints[b] = 65533;
                continue;
            }
            catch (CharacterCodingException e) {
                codePoints[b] = 65533;
            }
        }
        return codePoints;
    }

    private static final class CacheKey {
        private final boolean turkish;
        private final Charset charset;

        CacheKey(boolean turkish, Charset charset) {
            this.turkish = turkish;
            this.charset = charset;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            return this.turkish == other.turkish && this.charset.equals(other.charset);
        }

        public int hashCode() {
            return Objects.hash(this.turkish, this.charset);
        }
    }

    private static class LRUCache<K, V>
    extends LinkedHashMap<K, V> {
        private static final long serialVersionUID = 6638590251101633602L;
        private final int cacheSize;

        LRUCache(int cacheSize) {
            super(cacheSize + 1, 0.75f, true);
            this.cacheSize = cacheSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > this.cacheSize;
        }
    }

    private static final class CaseFoldingEntry
    implements Comparable<CaseFoldingEntry> {
        final byte character;
        final byte mapping;

        CaseFoldingEntry(byte character, byte mapping) {
            this.character = character;
            this.mapping = mapping;
        }

        @Override
        public int compareTo(CaseFoldingEntry o) {
            int cmp = Integer.compare(this.mapping & 0xFF, o.mapping & 0xFF);
            if (cmp != 0) {
                return cmp;
            }
            return Integer.compare(this.character & 0xFF, o.character & 0xFF);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CaseFoldingEntry)) {
                return false;
            }
            CaseFoldingEntry other = (CaseFoldingEntry)obj;
            return this.character == other.character && this.mapping == other.mapping;
        }

        public int hashCode() {
            return Objects.hash(this.character, this.mapping);
        }
    }
}

