/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.opentelemetry.sdk.trace;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import net.snowflake.client.jdbc.internal.javax.annotation.Nullable;
import net.snowflake.client.jdbc.internal.opentelemetry.api.common.AttributeKey;
import net.snowflake.client.jdbc.internal.opentelemetry.api.common.Attributes;
import net.snowflake.client.jdbc.internal.opentelemetry.api.incubator.propagation.ExtendedContextPropagators;
import net.snowflake.client.jdbc.internal.opentelemetry.api.incubator.trace.ExtendedSpanBuilder;
import net.snowflake.client.jdbc.internal.opentelemetry.api.incubator.trace.SpanCallable;
import net.snowflake.client.jdbc.internal.opentelemetry.api.incubator.trace.SpanRunnable;
import net.snowflake.client.jdbc.internal.opentelemetry.api.internal.ImmutableSpanContext;
import net.snowflake.client.jdbc.internal.opentelemetry.api.trace.Span;
import net.snowflake.client.jdbc.internal.opentelemetry.api.trace.SpanContext;
import net.snowflake.client.jdbc.internal.opentelemetry.api.trace.SpanKind;
import net.snowflake.client.jdbc.internal.opentelemetry.api.trace.StatusCode;
import net.snowflake.client.jdbc.internal.opentelemetry.api.trace.TraceFlags;
import net.snowflake.client.jdbc.internal.opentelemetry.api.trace.TraceState;
import net.snowflake.client.jdbc.internal.opentelemetry.context.Context;
import net.snowflake.client.jdbc.internal.opentelemetry.context.Scope;
import net.snowflake.client.jdbc.internal.opentelemetry.context.propagation.ContextPropagators;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.common.InstrumentationScopeInfo;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.internal.AttributeUtil;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.internal.AttributesMap;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.trace.IdGenerator;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.trace.SdkSpan;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.trace.SpanLimits;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.trace.TracerSharedState;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.trace.data.LinkData;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.trace.samplers.SamplingDecision;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.trace.samplers.SamplingResult;

final class SdkSpanBuilder
implements ExtendedSpanBuilder {
    private final String spanName;
    private final InstrumentationScopeInfo instrumentationScopeInfo;
    private final TracerSharedState tracerSharedState;
    private final SpanLimits spanLimits;
    @Nullable
    private Context parent;
    private SpanKind spanKind = SpanKind.INTERNAL;
    @Nullable
    private AttributesMap attributes;
    @Nullable
    private List<LinkData> links;
    private int totalNumberOfLinksAdded = 0;
    private long startEpochNanos = 0L;

    SdkSpanBuilder(String spanName, InstrumentationScopeInfo instrumentationScopeInfo, TracerSharedState tracerSharedState, SpanLimits spanLimits) {
        this.spanName = spanName;
        this.instrumentationScopeInfo = instrumentationScopeInfo;
        this.tracerSharedState = tracerSharedState;
        this.spanLimits = spanLimits;
    }

    @Override
    public ExtendedSpanBuilder setParent(Context context) {
        if (context == null) {
            return this;
        }
        this.parent = context;
        return this;
    }

    @Override
    public ExtendedSpanBuilder setNoParent() {
        this.parent = Context.root();
        return this;
    }

    @Override
    public ExtendedSpanBuilder setSpanKind(SpanKind spanKind) {
        if (spanKind == null) {
            return this;
        }
        this.spanKind = spanKind;
        return this;
    }

    @Override
    public ExtendedSpanBuilder addLink(SpanContext spanContext) {
        if (spanContext == null || !spanContext.isValid()) {
            return this;
        }
        this.addLink(LinkData.create(spanContext));
        return this;
    }

    @Override
    public ExtendedSpanBuilder addLink(SpanContext spanContext, Attributes attributes) {
        if (spanContext == null || !spanContext.isValid()) {
            return this;
        }
        if (attributes == null) {
            attributes = Attributes.empty();
        }
        int totalAttributeCount = attributes.size();
        this.addLink(LinkData.create(spanContext, AttributeUtil.applyAttributesLimit(attributes, this.spanLimits.getMaxNumberOfAttributesPerLink(), this.spanLimits.getMaxAttributeValueLength()), totalAttributeCount));
        return this;
    }

    private void addLink(LinkData link) {
        ++this.totalNumberOfLinksAdded;
        if (this.links == null) {
            this.links = new ArrayList<LinkData>(this.spanLimits.getMaxNumberOfLinks());
        }
        if (this.links.size() == this.spanLimits.getMaxNumberOfLinks()) {
            return;
        }
        this.links.add(link);
    }

    @Override
    public ExtendedSpanBuilder setAttribute(String key, String value) {
        return this.setAttribute((AttributeKey)AttributeKey.stringKey(key), (Object)value);
    }

    @Override
    public ExtendedSpanBuilder setAttribute(String key, long value) {
        return this.setAttribute((AttributeKey)AttributeKey.longKey(key), (Object)value);
    }

    @Override
    public ExtendedSpanBuilder setAttribute(String key, double value) {
        return this.setAttribute((AttributeKey)AttributeKey.doubleKey(key), (Object)value);
    }

    @Override
    public ExtendedSpanBuilder setAttribute(String key, boolean value) {
        return this.setAttribute((AttributeKey)AttributeKey.booleanKey(key), (Object)value);
    }

    @Override
    public <T> ExtendedSpanBuilder setAttribute(AttributeKey<T> key, T value) {
        if (key == null || key.getKey().isEmpty() || value == null) {
            return this;
        }
        this.attributes().put(key, value);
        return this;
    }

    @Override
    public ExtendedSpanBuilder setStartTimestamp(long startTimestamp, TimeUnit unit) {
        if (startTimestamp < 0L || unit == null) {
            return this;
        }
        this.startEpochNanos = unit.toNanos(startTimestamp);
        return this;
    }

    @Override
    public ExtendedSpanBuilder setParentFrom(ContextPropagators propagators, Map<String, String> carrier) {
        this.setParent(ExtendedContextPropagators.extractTextMapPropagationContext(carrier, propagators));
        return this;
    }

    @Override
    public Span startSpan() {
        Context parentContext = this.parent == null ? Context.current() : this.parent;
        Span parentSpan = Span.fromContext(parentContext);
        SpanContext parentSpanContext = parentSpan.getSpanContext();
        IdGenerator idGenerator = this.tracerSharedState.getIdGenerator();
        String spanId = idGenerator.generateSpanId();
        String traceId = !parentSpanContext.isValid() ? idGenerator.generateTraceId() : parentSpanContext.getTraceId();
        List<LinkData> currentLinks = this.links;
        List<LinkData> immutableLinks = currentLinks == null ? Collections.emptyList() : Collections.unmodifiableList(currentLinks);
        this.links = null;
        Attributes immutableAttributes = this.attributes == null ? Attributes.empty() : this.attributes;
        SamplingResult samplingResult = this.tracerSharedState.getSampler().shouldSample(parentContext, traceId, this.spanName, this.spanKind, immutableAttributes, immutableLinks);
        SamplingDecision samplingDecision = samplingResult.getDecision();
        TraceState samplingResultTraceState = samplingResult.getUpdatedTraceState(parentSpanContext.getTraceState());
        SpanContext spanContext = ImmutableSpanContext.create(traceId, spanId, SdkSpanBuilder.isSampled(samplingDecision) ? TraceFlags.getSampled() : TraceFlags.getDefault(), samplingResultTraceState, false, this.tracerSharedState.isIdGeneratorSafeToSkipIdValidation());
        if (!SdkSpanBuilder.isRecording(samplingDecision)) {
            return Span.wrap(spanContext);
        }
        Attributes samplingAttributes = samplingResult.getAttributes();
        if (!samplingAttributes.isEmpty()) {
            samplingAttributes.forEach((key, value) -> this.attributes().put(key, value));
        }
        AttributesMap recordedAttributes = this.attributes;
        this.attributes = null;
        return SdkSpan.startSpan(spanContext, this.spanName, this.instrumentationScopeInfo, this.spanKind, parentSpan, parentContext, this.spanLimits, this.tracerSharedState.getActiveSpanProcessor(), this.tracerSharedState.getClock(), this.tracerSharedState.getResource(), recordedAttributes, currentLinks, this.totalNumberOfLinksAdded, this.startEpochNanos);
    }

    @Override
    public <T, E extends Throwable> T startAndCall(SpanCallable<T, E> spanCallable) throws E {
        return this.startAndCall(spanCallable, SdkSpanBuilder::setSpanError);
    }

    @Override
    public <T, E extends Throwable> T startAndCall(SpanCallable<T, E> spanCallable, BiConsumer<Span, Throwable> handleException) throws E {
        Span span = this.startSpan();
        try {
            T t2;
            block11: {
                Scope unused = span.makeCurrent();
                try {
                    t2 = spanCallable.callInSpan();
                    if (unused == null) break block11;
                    unused.close();
                }
                catch (Throwable throwable) {
                    try {
                        if (unused != null) {
                            try {
                                unused.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable e) {
                        handleException.accept(span, e);
                        throw e;
                    }
                }
            }
            return t2;
        }
        finally {
            span.end();
        }
    }

    @Override
    public <E extends Throwable> void startAndRun(SpanRunnable<E> runnable) throws E {
        this.startAndRun(runnable, SdkSpanBuilder::setSpanError);
    }

    @Override
    public <E extends Throwable> void startAndRun(SpanRunnable<E> runnable, BiConsumer<Span, Throwable> handleException) throws E {
        this.startAndCall(() -> {
            runnable.runInSpan();
            return null;
        }, handleException);
    }

    private AttributesMap attributes() {
        AttributesMap attributes = this.attributes;
        if (attributes == null) {
            attributes = this.attributes = AttributesMap.create(this.spanLimits.getMaxNumberOfAttributes(), this.spanLimits.getMaxAttributeValueLength());
        }
        return attributes;
    }

    static boolean isRecording(SamplingDecision decision) {
        return SamplingDecision.RECORD_ONLY.equals((Object)decision) || SamplingDecision.RECORD_AND_SAMPLE.equals((Object)decision);
    }

    static boolean isSampled(SamplingDecision decision) {
        return SamplingDecision.RECORD_AND_SAMPLE.equals((Object)decision);
    }

    private static void setSpanError(Span span, Throwable exception) {
        span.setStatus(StatusCode.ERROR);
        span.recordException(exception);
    }
}

