/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.exemplar;

import java.util.Set;
import net.snowflake.client.jdbc.internal.javax.annotation.Nullable;
import net.snowflake.client.jdbc.internal.opentelemetry.api.common.AttributeKey;
import net.snowflake.client.jdbc.internal.opentelemetry.api.common.Attributes;
import net.snowflake.client.jdbc.internal.opentelemetry.api.trace.Span;
import net.snowflake.client.jdbc.internal.opentelemetry.api.trace.SpanContext;
import net.snowflake.client.jdbc.internal.opentelemetry.context.Context;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.common.Clock;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.data.DoubleExemplarData;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.data.LongExemplarData;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.data.ImmutableDoubleExemplarData;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.data.ImmutableLongExemplarData;

class ReservoirCell {
    private final Clock clock;
    @Nullable
    private Attributes attributes;
    private SpanContext spanContext = SpanContext.getInvalid();
    private long recordTime;
    private long longValue;
    private double doubleValue;

    ReservoirCell(Clock clock) {
        this.clock = clock;
    }

    synchronized void recordLongMeasurement(long value, Attributes attributes, Context context) {
        this.longValue = value;
        this.offerMeasurement(attributes, context);
    }

    synchronized void recordDoubleMeasurement(double value, Attributes attributes, Context context) {
        this.doubleValue = value;
        this.offerMeasurement(attributes, context);
    }

    private void offerMeasurement(Attributes attributes, Context context) {
        this.attributes = attributes;
        this.recordTime = this.clock.now(false);
        Span current = Span.fromContext(context);
        if (current.getSpanContext().isValid()) {
            this.spanContext = current.getSpanContext();
        }
    }

    @Nullable
    synchronized LongExemplarData getAndResetLong(Attributes pointAttributes) {
        Attributes attributes = this.attributes;
        if (attributes == null) {
            return null;
        }
        LongExemplarData result = ImmutableLongExemplarData.create(ReservoirCell.filtered(attributes, pointAttributes), this.recordTime, this.spanContext, this.longValue);
        this.reset();
        return result;
    }

    @Nullable
    synchronized DoubleExemplarData getAndResetDouble(Attributes pointAttributes) {
        Attributes attributes = this.attributes;
        if (attributes == null) {
            return null;
        }
        DoubleExemplarData result = ImmutableDoubleExemplarData.create(ReservoirCell.filtered(attributes, pointAttributes), this.recordTime, this.spanContext, this.doubleValue);
        this.reset();
        return result;
    }

    synchronized void reset() {
        this.attributes = null;
        this.longValue = 0L;
        this.doubleValue = 0.0;
        this.spanContext = SpanContext.getInvalid();
        this.recordTime = 0L;
    }

    private static Attributes filtered(Attributes original, Attributes metricPoint) {
        if (metricPoint.isEmpty()) {
            return original;
        }
        Set<AttributeKey<?>> metricPointKeys = metricPoint.asMap().keySet();
        return original.toBuilder().removeIf(metricPointKeys::contains).build();
    }
}

