/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics;

import java.util.List;
import java.util.function.Consumer;
import net.snowflake.client.jdbc.internal.opentelemetry.api.common.AttributeKey;
import net.snowflake.client.jdbc.internal.opentelemetry.api.common.Attributes;
import net.snowflake.client.jdbc.internal.opentelemetry.api.incubator.metrics.ExtendedDoubleGauge;
import net.snowflake.client.jdbc.internal.opentelemetry.api.incubator.metrics.ExtendedDoubleGaugeBuilder;
import net.snowflake.client.jdbc.internal.opentelemetry.api.metrics.DoubleGaugeBuilder;
import net.snowflake.client.jdbc.internal.opentelemetry.api.metrics.LongGaugeBuilder;
import net.snowflake.client.jdbc.internal.opentelemetry.api.metrics.ObservableDoubleGauge;
import net.snowflake.client.jdbc.internal.opentelemetry.api.metrics.ObservableDoubleMeasurement;
import net.snowflake.client.jdbc.internal.opentelemetry.context.Context;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.AbstractInstrument;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.InstrumentBuilder;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.InstrumentType;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.InstrumentValueType;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.SdkLongGauge;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.state.MeterProviderSharedState;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.state.MeterSharedState;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.state.WriteableMetricStorage;

final class SdkDoubleGauge
extends AbstractInstrument
implements ExtendedDoubleGauge {
    private final MeterSharedState meterSharedState;
    private final WriteableMetricStorage storage;

    private SdkDoubleGauge(InstrumentDescriptor descriptor, MeterSharedState meterSharedState, WriteableMetricStorage storage) {
        super(descriptor);
        this.meterSharedState = meterSharedState;
        this.storage = storage;
    }

    @Override
    public void set(double value, Attributes attributes) {
        this.storage.recordDouble(value, attributes, Context.current());
    }

    @Override
    public void set(double value, Attributes attributes, Context context) {
        this.storage.recordDouble(value, attributes, context);
    }

    @Override
    public void set(double increment) {
        this.set(increment, Attributes.empty());
    }

    @Override
    public boolean isEnabled() {
        return this.meterSharedState.isMeterEnabled() && this.storage.isEnabled();
    }

    static final class SdkDoubleGaugeBuilder
    implements ExtendedDoubleGaugeBuilder {
        private final InstrumentBuilder builder;

        SdkDoubleGaugeBuilder(MeterProviderSharedState meterProviderSharedState, MeterSharedState meterSharedState, String name) {
            this.builder = new InstrumentBuilder(name, InstrumentType.GAUGE, InstrumentValueType.DOUBLE, meterProviderSharedState, meterSharedState);
        }

        @Override
        public DoubleGaugeBuilder setDescription(String description) {
            this.builder.setDescription(description);
            return this;
        }

        @Override
        public DoubleGaugeBuilder setUnit(String unit) {
            this.builder.setUnit(unit);
            return this;
        }

        @Override
        public SdkDoubleGauge build() {
            return this.builder.buildSynchronousInstrument((x$0, x$1, x$2) -> new SdkDoubleGauge(x$0, x$1, x$2));
        }

        @Override
        public ExtendedDoubleGaugeBuilder setAttributesAdvice(List<AttributeKey<?>> attributes) {
            this.builder.setAdviceAttributes(attributes);
            return this;
        }

        @Override
        public LongGaugeBuilder ofLongs() {
            return this.builder.swapBuilder(SdkLongGauge.SdkLongGaugeBuilder::new);
        }

        @Override
        public ObservableDoubleGauge buildWithCallback(Consumer<ObservableDoubleMeasurement> callback) {
            return this.builder.buildDoubleAsynchronousInstrument(InstrumentType.OBSERVABLE_GAUGE, callback);
        }

        @Override
        public ObservableDoubleMeasurement buildObserver() {
            return this.builder.buildObservableMeasurement(InstrumentType.OBSERVABLE_GAUGE);
        }

        public String toString() {
            return this.builder.toStringHelper(this.getClass().getSimpleName());
        }
    }
}

