/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.opentelemetry.sdk.logs;

import net.snowflake.client.jdbc.internal.opentelemetry.api.incubator.logs.ExtendedLogger;
import net.snowflake.client.jdbc.internal.opentelemetry.api.logs.LogRecordBuilder;
import net.snowflake.client.jdbc.internal.opentelemetry.api.logs.Logger;
import net.snowflake.client.jdbc.internal.opentelemetry.api.logs.LoggerProvider;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.common.InstrumentationScopeInfo;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.logs.LoggerSharedState;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.logs.SdkLogRecordBuilder;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.logs.internal.LoggerConfig;

final class SdkLogger
implements ExtendedLogger {
    private static final Logger NOOP_LOGGER = LoggerProvider.noop().get("noop");
    private final LoggerSharedState loggerSharedState;
    private final InstrumentationScopeInfo instrumentationScopeInfo;
    private final boolean loggerEnabled;

    SdkLogger(LoggerSharedState loggerSharedState, InstrumentationScopeInfo instrumentationScopeInfo, LoggerConfig loggerConfig) {
        this.loggerSharedState = loggerSharedState;
        this.instrumentationScopeInfo = instrumentationScopeInfo;
        this.loggerEnabled = loggerConfig.isEnabled();
    }

    @Override
    public LogRecordBuilder logRecordBuilder() {
        if (this.loggerEnabled) {
            return new SdkLogRecordBuilder(this.loggerSharedState, this.instrumentationScopeInfo);
        }
        return NOOP_LOGGER.logRecordBuilder();
    }

    InstrumentationScopeInfo getInstrumentationScopeInfo() {
        return this.instrumentationScopeInfo;
    }

    @Override
    public boolean isEnabled() {
        return this.loggerEnabled;
    }
}

