/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.cloud.storage;

import java.util.function.Supplier;
import net.snowflake.client.jdbc.internal.google.api.core.ApiFuture;
import net.snowflake.client.jdbc.internal.google.api.gax.retrying.ResultRetryAlgorithm;
import net.snowflake.client.jdbc.internal.google.api.gax.rpc.ClientStreamingCallable;
import net.snowflake.client.jdbc.internal.google.cloud.RestorableState;
import net.snowflake.client.jdbc.internal.google.cloud.WriteChannel;
import net.snowflake.client.jdbc.internal.google.cloud.storage.BaseStorageWriteChannel;
import net.snowflake.client.jdbc.internal.google.cloud.storage.ByteStringStrategy;
import net.snowflake.client.jdbc.internal.google.cloud.storage.Conversions;
import net.snowflake.client.jdbc.internal.google.cloud.storage.CrossTransportUtils;
import net.snowflake.client.jdbc.internal.google.cloud.storage.Hasher;
import net.snowflake.client.jdbc.internal.google.cloud.storage.LazyWriteChannel;
import net.snowflake.client.jdbc.internal.google.cloud.storage.ResumableMedia;
import net.snowflake.client.jdbc.internal.google.cloud.storage.ResumableWrite;
import net.snowflake.client.jdbc.internal.google.cloud.storage.Retrying;
import net.snowflake.client.jdbc.internal.google.storage.v2.WriteObjectRequest;
import net.snowflake.client.jdbc.internal.google.storage.v2.WriteObjectResponse;

final class GrpcBlobWriteChannel
extends BaseStorageWriteChannel<WriteObjectResponse> {
    private final ClientStreamingCallable<WriteObjectRequest, WriteObjectResponse> write;
    private final Retrying.RetryingDependencies deps;
    private final ResultRetryAlgorithm<?> alg;
    private final Supplier<ApiFuture<ResumableWrite>> start;
    private final Hasher hasher;

    GrpcBlobWriteChannel(ClientStreamingCallable<WriteObjectRequest, WriteObjectResponse> write, Retrying.RetryingDependencies deps, ResultRetryAlgorithm<?> alg, Supplier<ApiFuture<ResumableWrite>> start, Hasher hasher) {
        super(Conversions.grpc().blobInfo().compose(WriteObjectResponse::getResource));
        this.write = write;
        this.deps = deps;
        this.alg = alg;
        this.start = start;
        this.hasher = hasher;
    }

    @Override
    public RestorableState<WriteChannel> capture() {
        return (RestorableState)CrossTransportUtils.throwHttpJsonOnly(WriteChannel.class, "capture");
    }

    @Override
    protected LazyWriteChannel<WriteObjectResponse> newLazyWriteChannel() {
        return new LazyWriteChannel<WriteObjectResponse>(() -> ResumableMedia.gapic().write().byteChannel(this.write).setHasher(this.hasher).setByteStringStrategy(ByteStringStrategy.copy()).resumable().withRetryConfig(this.deps, this.alg).buffered(this.getBufferHandle()).setStartAsync(this.start.get()).build());
    }
}

