/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.apache.arrow.vector.complex;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.snowflake.client.jdbc.internal.apache.arrow.memory.ArrowBuf;
import net.snowflake.client.jdbc.internal.apache.arrow.memory.BufferAllocator;
import net.snowflake.client.jdbc.internal.apache.arrow.memory.OutOfMemoryException;
import net.snowflake.client.jdbc.internal.apache.arrow.memory.ReferenceManager;
import net.snowflake.client.jdbc.internal.apache.arrow.memory.util.CommonUtil;
import net.snowflake.client.jdbc.internal.apache.arrow.memory.util.LargeMemoryUtil;
import net.snowflake.client.jdbc.internal.apache.arrow.memory.util.hash.ArrowBufHasher;
import net.snowflake.client.jdbc.internal.apache.arrow.util.Preconditions;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.BaseValueVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.BigIntVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.BitVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.BufferBacked;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.DateDayVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.DateMilliVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.Decimal256Vector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.DecimalVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.DensityAwareVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.DurationVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.FieldVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.FixedSizeBinaryVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.Float2Vector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.Float4Vector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.Float8Vector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.IntVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.IntervalDayVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.IntervalMonthDayNanoVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.IntervalYearVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.LargeVarBinaryVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.LargeVarCharVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.SmallIntVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.TimeMicroVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.TimeMilliVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.TimeNanoVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.TimeSecVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.TimeStampMicroTZVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.TimeStampMicroVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.TimeStampMilliTZVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.TimeStampMilliVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.TimeStampNanoTZVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.TimeStampNanoVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.TimeStampSecTZVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.TimeStampSecVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.TinyIntVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.UInt1Vector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.UInt2Vector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.UInt4Vector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.UInt8Vector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ValueVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.VarBinaryVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.VarCharVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ViewVarBinaryVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ViewVarCharVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.compare.VectorVisitor;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.AbstractContainerVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.AbstractStructVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.ListVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.MapVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.NonNullableStructVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.StructVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.VectorWithOrdinal;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.impl.ComplexCopier;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.impl.UnionReader;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.impl.UnionWriter;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.reader.FieldReader;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.writer.FieldWriter;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.ComplexHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableBigIntHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableBitHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableDateDayHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableDateMilliHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableDecimal256Holder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableDecimalHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableDurationHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableFixedSizeBinaryHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableFloat2Holder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableFloat4Holder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableFloat8Holder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableIntHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableIntervalDayHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableIntervalMonthDayNanoHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableIntervalYearHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableLargeVarBinaryHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableLargeVarCharHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableSmallIntHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableTimeMicroHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableTimeMilliHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableTimeNanoHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableTimeSecHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableTimeStampMicroHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableTimeStampMicroTZHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableTimeStampMilliHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableTimeStampMilliTZHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableTimeStampNanoHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableTimeStampNanoTZHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableTimeStampSecHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableTimeStampSecTZHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableTinyIntHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableUInt1Holder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableUInt2Holder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableUInt4Holder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableUInt8Holder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableVarBinaryHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableVarCharHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableViewVarBinaryHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableViewVarCharHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.UnionHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ipc.message.ArrowFieldNode;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.Types;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.UnionMode;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.pojo.ArrowType;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.pojo.Field;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.pojo.FieldType;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.util.CallBack;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.util.OversizedAllocationException;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.util.TransferPair;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.util.ValueVectorUtility;

public class UnionVector
extends AbstractContainerVector
implements FieldVector {
    int valueCount;
    NonNullableStructVector internalStruct;
    protected ArrowBuf typeBuffer;
    private StructVector structVector;
    private ListVector listVector;
    private MapVector mapVector;
    private FieldReader reader;
    private int singleType = 0;
    private ValueVector singleVector;
    private int typeBufferAllocationSizeInBytes;
    private final FieldType fieldType;
    private final Field[] typeIds = new Field[128];
    public static final byte TYPE_WIDTH = 1;
    private static final FieldType INTERNAL_STRUCT_TYPE = new FieldType(false, ArrowType.Struct.INSTANCE, null, null);
    private TinyIntVector tinyIntVector;
    private UInt1Vector uInt1Vector;
    private UInt2Vector uInt2Vector;
    private SmallIntVector smallIntVector;
    private Float2Vector float2Vector;
    private IntVector intVector;
    private UInt4Vector uInt4Vector;
    private Float4Vector float4Vector;
    private DateDayVector dateDayVector;
    private IntervalYearVector intervalYearVector;
    private TimeSecVector timeSecVector;
    private TimeMilliVector timeMilliVector;
    private BigIntVector bigIntVector;
    private UInt8Vector uInt8Vector;
    private Float8Vector float8Vector;
    private DateMilliVector dateMilliVector;
    private DurationVector durationVector;
    private TimeStampSecVector timeStampSecVector;
    private TimeStampMilliVector timeStampMilliVector;
    private TimeStampMicroVector timeStampMicroVector;
    private TimeStampNanoVector timeStampNanoVector;
    private TimeStampSecTZVector timeStampSecTZVector;
    private TimeStampMilliTZVector timeStampMilliTZVector;
    private TimeStampMicroTZVector timeStampMicroTZVector;
    private TimeStampNanoTZVector timeStampNanoTZVector;
    private TimeMicroVector timeMicroVector;
    private TimeNanoVector timeNanoVector;
    private IntervalDayVector intervalDayVector;
    private IntervalMonthDayNanoVector intervalMonthDayNanoVector;
    private Decimal256Vector decimal256Vector;
    private DecimalVector decimalVector;
    private FixedSizeBinaryVector fixedSizeBinaryVector;
    private VarBinaryVector varBinaryVector;
    private VarCharVector varCharVector;
    private ViewVarBinaryVector viewVarBinaryVector;
    private ViewVarCharVector viewVarCharVector;
    private LargeVarCharVector largeVarCharVector;
    private LargeVarBinaryVector largeVarBinaryVector;
    private BitVector bitVector;
    UnionWriter writer;

    public static UnionVector empty(String name, BufferAllocator allocator) {
        FieldType fieldType = FieldType.nullable(new ArrowType.Union(UnionMode.Sparse, null));
        return new UnionVector(name, allocator, fieldType, null);
    }

    public UnionVector(String name, BufferAllocator allocator, FieldType fieldType, CallBack callBack) {
        super(name, allocator, callBack);
        this.fieldType = fieldType;
        this.internalStruct = new NonNullableStructVector("internal", allocator, INTERNAL_STRUCT_TYPE, callBack, AbstractStructVector.ConflictPolicy.CONFLICT_REPLACE, false);
        this.typeBuffer = allocator.getEmpty();
        this.typeBufferAllocationSizeInBytes = 3970;
    }

    @Override
    public BufferAllocator getAllocator() {
        return this.allocator;
    }

    @Override
    public Types.MinorType getMinorType() {
        return Types.MinorType.UNION;
    }

    @Override
    public void initializeChildrenFromFields(List<Field> children) {
        int count = 0;
        for (Field child : children) {
            int[] typeIds;
            int typeId = Types.getMinorTypeForArrowType(child.getType()).ordinal();
            if (this.fieldType != null && (typeIds = ((ArrowType.Union)this.fieldType.getType()).getTypeIds()) != null) {
                typeId = typeIds[count++];
            }
            this.typeIds[typeId] = child;
        }
        this.internalStruct.initializeChildrenFromFields(children);
    }

    @Override
    public List<FieldVector> getChildrenFromFields() {
        return this.internalStruct.getChildrenFromFields();
    }

    @Override
    public void loadFieldBuffers(ArrowFieldNode fieldNode, List<ArrowBuf> ownBuffers) {
        if (ownBuffers.size() != 1) {
            throw new IllegalArgumentException("Illegal buffer count, expected 1, got: " + ownBuffers.size());
        }
        ArrowBuf buffer = ownBuffers.get(0);
        this.typeBuffer.getReferenceManager().release();
        this.typeBuffer = buffer.getReferenceManager().retain(buffer, this.allocator);
        this.typeBufferAllocationSizeInBytes = LargeMemoryUtil.checkedCastToInt(this.typeBuffer.capacity());
        this.valueCount = fieldNode.getLength();
    }

    @Override
    public List<ArrowBuf> getFieldBuffers() {
        ArrayList<ArrowBuf> result = new ArrayList<ArrowBuf>(1);
        this.setReaderAndWriterIndex();
        result.add(this.typeBuffer);
        return result;
    }

    private void setReaderAndWriterIndex() {
        this.typeBuffer.readerIndex(0L);
        this.typeBuffer.writerIndex(this.valueCount * 1);
    }

    @Override
    @Deprecated
    public List<BufferBacked> getFieldInnerVectors() {
        throw new UnsupportedOperationException("There are no inner vectors. Use geFieldBuffers");
    }

    private String fieldName(Types.MinorType type) {
        return type.name().toLowerCase();
    }

    private FieldType fieldType(Types.MinorType type) {
        return FieldType.nullable(type.getType());
    }

    private <T extends FieldVector> T addOrGet(Types.MinorType minorType, Class<T> c) {
        return this.addOrGet(null, minorType, c);
    }

    private <T extends FieldVector> T addOrGet(String name, Types.MinorType minorType, ArrowType arrowType, Class<T> c) {
        return this.internalStruct.addOrGet(name == null ? this.fieldName(minorType) : name, FieldType.nullable(arrowType), c);
    }

    private <T extends FieldVector> T addOrGet(String name, Types.MinorType minorType, Class<T> c) {
        return this.internalStruct.addOrGet(name == null ? this.fieldName(minorType) : name, this.fieldType(minorType), c);
    }

    @Override
    public long getValidityBufferAddress() {
        throw new UnsupportedOperationException();
    }

    public long getTypeBufferAddress() {
        return this.typeBuffer.memoryAddress();
    }

    @Override
    public long getDataBufferAddress() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getOffsetBufferAddress() {
        throw new UnsupportedOperationException();
    }

    public ArrowBuf getTypeBuffer() {
        return this.typeBuffer;
    }

    @Override
    public ArrowBuf getValidityBuffer() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ArrowBuf getDataBuffer() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ArrowBuf getOffsetBuffer() {
        throw new UnsupportedOperationException();
    }

    public StructVector getStruct() {
        if (this.structVector == null) {
            int vectorCount = this.internalStruct.size();
            this.structVector = this.addOrGet(Types.MinorType.STRUCT, StructVector.class);
            if (this.internalStruct.size() > vectorCount) {
                this.structVector.allocateNew();
                if (this.callBack != null) {
                    this.callBack.doWork();
                }
            }
        }
        return this.structVector;
    }

    public TinyIntVector getTinyIntVector() {
        return this.getTinyIntVector(null);
    }

    public TinyIntVector getTinyIntVector(String name) {
        if (this.tinyIntVector == null) {
            int vectorCount = this.internalStruct.size();
            this.tinyIntVector = this.addOrGet(name, Types.MinorType.TINYINT, TinyIntVector.class);
            if (this.internalStruct.size() > vectorCount) {
                this.tinyIntVector.allocateNew();
                if (this.callBack != null) {
                    this.callBack.doWork();
                }
            }
        }
        return this.tinyIntVector;
    }

    public UInt1Vector getUInt1Vector() {
        return this.getUInt1Vector(null);
    }

    public UInt1Vector getUInt1Vector(String name) {
        if (this.uInt1Vector == null) {
            int vectorCount = this.internalStruct.size();
            this.uInt1Vector = this.addOrGet(name, Types.MinorType.UINT1, UInt1Vector.class);
            if (this.internalStruct.size() > vectorCount) {
                this.uInt1Vector.allocateNew();
                if (this.callBack != null) {
                    this.callBack.doWork();
                }
            }
        }
        return this.uInt1Vector;
    }

    public UInt2Vector getUInt2Vector() {
        return this.getUInt2Vector(null);
    }

    public UInt2Vector getUInt2Vector(String name) {
        if (this.uInt2Vector == null) {
            int vectorCount = this.internalStruct.size();
            this.uInt2Vector = this.addOrGet(name, Types.MinorType.UINT2, UInt2Vector.class);
            if (this.internalStruct.size() > vectorCount) {
                this.uInt2Vector.allocateNew();
                if (this.callBack != null) {
                    this.callBack.doWork();
                }
            }
        }
        return this.uInt2Vector;
    }

    public SmallIntVector getSmallIntVector() {
        return this.getSmallIntVector(null);
    }

    public SmallIntVector getSmallIntVector(String name) {
        if (this.smallIntVector == null) {
            int vectorCount = this.internalStruct.size();
            this.smallIntVector = this.addOrGet(name, Types.MinorType.SMALLINT, SmallIntVector.class);
            if (this.internalStruct.size() > vectorCount) {
                this.smallIntVector.allocateNew();
                if (this.callBack != null) {
                    this.callBack.doWork();
                }
            }
        }
        return this.smallIntVector;
    }

    public Float2Vector getFloat2Vector() {
        return this.getFloat2Vector(null);
    }

    public Float2Vector getFloat2Vector(String name) {
        if (this.float2Vector == null) {
            int vectorCount = this.internalStruct.size();
            this.float2Vector = this.addOrGet(name, Types.MinorType.FLOAT2, Float2Vector.class);
            if (this.internalStruct.size() > vectorCount) {
                this.float2Vector.allocateNew();
                if (this.callBack != null) {
                    this.callBack.doWork();
                }
            }
        }
        return this.float2Vector;
    }

    public IntVector getIntVector() {
        return this.getIntVector(null);
    }

    public IntVector getIntVector(String name) {
        if (this.intVector == null) {
            int vectorCount = this.internalStruct.size();
            this.intVector = this.addOrGet(name, Types.MinorType.INT, IntVector.class);
            if (this.internalStruct.size() > vectorCount) {
                this.intVector.allocateNew();
                if (this.callBack != null) {
                    this.callBack.doWork();
                }
            }
        }
        return this.intVector;
    }

    public UInt4Vector getUInt4Vector() {
        return this.getUInt4Vector(null);
    }

    public UInt4Vector getUInt4Vector(String name) {
        if (this.uInt4Vector == null) {
            int vectorCount = this.internalStruct.size();
            this.uInt4Vector = this.addOrGet(name, Types.MinorType.UINT4, UInt4Vector.class);
            if (this.internalStruct.size() > vectorCount) {
                this.uInt4Vector.allocateNew();
                if (this.callBack != null) {
                    this.callBack.doWork();
                }
            }
        }
        return this.uInt4Vector;
    }

    public Float4Vector getFloat4Vector() {
        return this.getFloat4Vector(null);
    }

    public Float4Vector getFloat4Vector(String name) {
        if (this.float4Vector == null) {
            int vectorCount = this.internalStruct.size();
            this.float4Vector = this.addOrGet(name, Types.MinorType.FLOAT4, Float4Vector.class);
            if (this.internalStruct.size() > vectorCount) {
                this.float4Vector.allocateNew();
                if (this.callBack != null) {
                    this.callBack.doWork();
                }
            }
        }
        return this.float4Vector;
    }

    public DateDayVector getDateDayVector() {
        return this.getDateDayVector(null);
    }

    public DateDayVector getDateDayVector(String name) {
        if (this.dateDayVector == null) {
            int vectorCount = this.internalStruct.size();
            this.dateDayVector = this.addOrGet(name, Types.MinorType.DATEDAY, DateDayVector.class);
            if (this.internalStruct.size() > vectorCount) {
                this.dateDayVector.allocateNew();
                if (this.callBack != null) {
                    this.callBack.doWork();
                }
            }
        }
        return this.dateDayVector;
    }

    public IntervalYearVector getIntervalYearVector() {
        return this.getIntervalYearVector(null);
    }

    public IntervalYearVector getIntervalYearVector(String name) {
        if (this.intervalYearVector == null) {
            int vectorCount = this.internalStruct.size();
            this.intervalYearVector = this.addOrGet(name, Types.MinorType.INTERVALYEAR, IntervalYearVector.class);
            if (this.internalStruct.size() > vectorCount) {
                this.intervalYearVector.allocateNew();
                if (this.callBack != null) {
                    this.callBack.doWork();
                }
            }
        }
        return this.intervalYearVector;
    }

    public TimeSecVector getTimeSecVector() {
        return this.getTimeSecVector(null);
    }

    public TimeSecVector getTimeSecVector(String name) {
        if (this.timeSecVector == null) {
            int vectorCount = this.internalStruct.size();
            this.timeSecVector = this.addOrGet(name, Types.MinorType.TIMESEC, TimeSecVector.class);
            if (this.internalStruct.size() > vectorCount) {
                this.timeSecVector.allocateNew();
                if (this.callBack != null) {
                    this.callBack.doWork();
                }
            }
        }
        return this.timeSecVector;
    }

    public TimeMilliVector getTimeMilliVector() {
        return this.getTimeMilliVector(null);
    }

    public TimeMilliVector getTimeMilliVector(String name) {
        if (this.timeMilliVector == null) {
            int vectorCount = this.internalStruct.size();
            this.timeMilliVector = this.addOrGet(name, Types.MinorType.TIMEMILLI, TimeMilliVector.class);
            if (this.internalStruct.size() > vectorCount) {
                this.timeMilliVector.allocateNew();
                if (this.callBack != null) {
                    this.callBack.doWork();
                }
            }
        }
        return this.timeMilliVector;
    }

    public BigIntVector getBigIntVector() {
        return this.getBigIntVector(null);
    }

    public BigIntVector getBigIntVector(String name) {
        if (this.bigIntVector == null) {
            int vectorCount = this.internalStruct.size();
            this.bigIntVector = this.addOrGet(name, Types.MinorType.BIGINT, BigIntVector.class);
            if (this.internalStruct.size() > vectorCount) {
                this.bigIntVector.allocateNew();
                if (this.callBack != null) {
                    this.callBack.doWork();
                }
            }
        }
        return this.bigIntVector;
    }

    public UInt8Vector getUInt8Vector() {
        return this.getUInt8Vector(null);
    }

    public UInt8Vector getUInt8Vector(String name) {
        if (this.uInt8Vector == null) {
            int vectorCount = this.internalStruct.size();
            this.uInt8Vector = this.addOrGet(name, Types.MinorType.UINT8, UInt8Vector.class);
            if (this.internalStruct.size() > vectorCount) {
                this.uInt8Vector.allocateNew();
                if (this.callBack != null) {
                    this.callBack.doWork();
                }
            }
        }
        return this.uInt8Vector;
    }

    public Float8Vector getFloat8Vector() {
        return this.getFloat8Vector(null);
    }

    public Float8Vector getFloat8Vector(String name) {
        if (this.float8Vector == null) {
            int vectorCount = this.internalStruct.size();
            this.float8Vector = this.addOrGet(name, Types.MinorType.FLOAT8, Float8Vector.class);
            if (this.internalStruct.size() > vectorCount) {
                this.float8Vector.allocateNew();
                if (this.callBack != null) {
                    this.callBack.doWork();
                }
            }
        }
        return this.float8Vector;
    }

    public DateMilliVector getDateMilliVector() {
        return this.getDateMilliVector(null);
    }

    public DateMilliVector getDateMilliVector(String name) {
        if (this.dateMilliVector == null) {
            int vectorCount = this.internalStruct.size();
            this.dateMilliVector = this.addOrGet(name, Types.MinorType.DATEMILLI, DateMilliVector.class);
            if (this.internalStruct.size() > vectorCount) {
                this.dateMilliVector.allocateNew();
                if (this.callBack != null) {
                    this.callBack.doWork();
                }
            }
        }
        return this.dateMilliVector;
    }

    public DurationVector getDurationVector() {
        if (this.durationVector == null) {
            throw new IllegalArgumentException("No Duration present. Provide ArrowType argument to create a new vector");
        }
        return this.durationVector;
    }

    public DurationVector getDurationVector(ArrowType arrowType) {
        return this.getDurationVector(null, arrowType);
    }

    public DurationVector getDurationVector(String name, ArrowType arrowType) {
        if (this.durationVector == null) {
            int vectorCount = this.internalStruct.size();
            this.durationVector = this.addOrGet(name, Types.MinorType.DURATION, arrowType, DurationVector.class);
            if (this.internalStruct.size() > vectorCount) {
                this.durationVector.allocateNew();
                if (this.callBack != null) {
                    this.callBack.doWork();
                }
            }
        }
        return this.durationVector;
    }

    public TimeStampSecVector getTimeStampSecVector() {
        return this.getTimeStampSecVector(null);
    }

    public TimeStampSecVector getTimeStampSecVector(String name) {
        if (this.timeStampSecVector == null) {
            int vectorCount = this.internalStruct.size();
            this.timeStampSecVector = this.addOrGet(name, Types.MinorType.TIMESTAMPSEC, TimeStampSecVector.class);
            if (this.internalStruct.size() > vectorCount) {
                this.timeStampSecVector.allocateNew();
                if (this.callBack != null) {
                    this.callBack.doWork();
                }
            }
        }
        return this.timeStampSecVector;
    }

    public TimeStampMilliVector getTimeStampMilliVector() {
        return this.getTimeStampMilliVector(null);
    }

    public TimeStampMilliVector getTimeStampMilliVector(String name) {
        if (this.timeStampMilliVector == null) {
            int vectorCount = this.internalStruct.size();
            this.timeStampMilliVector = this.addOrGet(name, Types.MinorType.TIMESTAMPMILLI, TimeStampMilliVector.class);
            if (this.internalStruct.size() > vectorCount) {
                this.timeStampMilliVector.allocateNew();
                if (this.callBack != null) {
                    this.callBack.doWork();
                }
            }
        }
        return this.timeStampMilliVector;
    }

    public TimeStampMicroVector getTimeStampMicroVector() {
        return this.getTimeStampMicroVector(null);
    }

    public TimeStampMicroVector getTimeStampMicroVector(String name) {
        if (this.timeStampMicroVector == null) {
            int vectorCount = this.internalStruct.size();
            this.timeStampMicroVector = this.addOrGet(name, Types.MinorType.TIMESTAMPMICRO, TimeStampMicroVector.class);
            if (this.internalStruct.size() > vectorCount) {
                this.timeStampMicroVector.allocateNew();
                if (this.callBack != null) {
                    this.callBack.doWork();
                }
            }
        }
        return this.timeStampMicroVector;
    }

    public TimeStampNanoVector getTimeStampNanoVector() {
        return this.getTimeStampNanoVector(null);
    }

    public TimeStampNanoVector getTimeStampNanoVector(String name) {
        if (this.timeStampNanoVector == null) {
            int vectorCount = this.internalStruct.size();
            this.timeStampNanoVector = this.addOrGet(name, Types.MinorType.TIMESTAMPNANO, TimeStampNanoVector.class);
            if (this.internalStruct.size() > vectorCount) {
                this.timeStampNanoVector.allocateNew();
                if (this.callBack != null) {
                    this.callBack.doWork();
                }
            }
        }
        return this.timeStampNanoVector;
    }

    public TimeStampSecTZVector getTimeStampSecTZVector() {
        if (this.timeStampSecTZVector == null) {
            throw new IllegalArgumentException("No TimeStampSecTZ present. Provide ArrowType argument to create a new vector");
        }
        return this.timeStampSecTZVector;
    }

    public TimeStampSecTZVector getTimeStampSecTZVector(ArrowType arrowType) {
        return this.getTimeStampSecTZVector(null, arrowType);
    }

    public TimeStampSecTZVector getTimeStampSecTZVector(String name, ArrowType arrowType) {
        if (this.timeStampSecTZVector == null) {
            int vectorCount = this.internalStruct.size();
            this.timeStampSecTZVector = this.addOrGet(name, Types.MinorType.TIMESTAMPSECTZ, arrowType, TimeStampSecTZVector.class);
            if (this.internalStruct.size() > vectorCount) {
                this.timeStampSecTZVector.allocateNew();
                if (this.callBack != null) {
                    this.callBack.doWork();
                }
            }
        }
        return this.timeStampSecTZVector;
    }

    public TimeStampMilliTZVector getTimeStampMilliTZVector() {
        if (this.timeStampMilliTZVector == null) {
            throw new IllegalArgumentException("No TimeStampMilliTZ present. Provide ArrowType argument to create a new vector");
        }
        return this.timeStampMilliTZVector;
    }

    public TimeStampMilliTZVector getTimeStampMilliTZVector(ArrowType arrowType) {
        return this.getTimeStampMilliTZVector(null, arrowType);
    }

    public TimeStampMilliTZVector getTimeStampMilliTZVector(String name, ArrowType arrowType) {
        if (this.timeStampMilliTZVector == null) {
            int vectorCount = this.internalStruct.size();
            this.timeStampMilliTZVector = this.addOrGet(name, Types.MinorType.TIMESTAMPMILLITZ, arrowType, TimeStampMilliTZVector.class);
            if (this.internalStruct.size() > vectorCount) {
                this.timeStampMilliTZVector.allocateNew();
                if (this.callBack != null) {
                    this.callBack.doWork();
                }
            }
        }
        return this.timeStampMilliTZVector;
    }

    public TimeStampMicroTZVector getTimeStampMicroTZVector() {
        if (this.timeStampMicroTZVector == null) {
            throw new IllegalArgumentException("No TimeStampMicroTZ present. Provide ArrowType argument to create a new vector");
        }
        return this.timeStampMicroTZVector;
    }

    public TimeStampMicroTZVector getTimeStampMicroTZVector(ArrowType arrowType) {
        return this.getTimeStampMicroTZVector(null, arrowType);
    }

    public TimeStampMicroTZVector getTimeStampMicroTZVector(String name, ArrowType arrowType) {
        if (this.timeStampMicroTZVector == null) {
            int vectorCount = this.internalStruct.size();
            this.timeStampMicroTZVector = this.addOrGet(name, Types.MinorType.TIMESTAMPMICROTZ, arrowType, TimeStampMicroTZVector.class);
            if (this.internalStruct.size() > vectorCount) {
                this.timeStampMicroTZVector.allocateNew();
                if (this.callBack != null) {
                    this.callBack.doWork();
                }
            }
        }
        return this.timeStampMicroTZVector;
    }

    public TimeStampNanoTZVector getTimeStampNanoTZVector() {
        if (this.timeStampNanoTZVector == null) {
            throw new IllegalArgumentException("No TimeStampNanoTZ present. Provide ArrowType argument to create a new vector");
        }
        return this.timeStampNanoTZVector;
    }

    public TimeStampNanoTZVector getTimeStampNanoTZVector(ArrowType arrowType) {
        return this.getTimeStampNanoTZVector(null, arrowType);
    }

    public TimeStampNanoTZVector getTimeStampNanoTZVector(String name, ArrowType arrowType) {
        if (this.timeStampNanoTZVector == null) {
            int vectorCount = this.internalStruct.size();
            this.timeStampNanoTZVector = this.addOrGet(name, Types.MinorType.TIMESTAMPNANOTZ, arrowType, TimeStampNanoTZVector.class);
            if (this.internalStruct.size() > vectorCount) {
                this.timeStampNanoTZVector.allocateNew();
                if (this.callBack != null) {
                    this.callBack.doWork();
                }
            }
        }
        return this.timeStampNanoTZVector;
    }

    public TimeMicroVector getTimeMicroVector() {
        return this.getTimeMicroVector(null);
    }

    public TimeMicroVector getTimeMicroVector(String name) {
        if (this.timeMicroVector == null) {
            int vectorCount = this.internalStruct.size();
            this.timeMicroVector = this.addOrGet(name, Types.MinorType.TIMEMICRO, TimeMicroVector.class);
            if (this.internalStruct.size() > vectorCount) {
                this.timeMicroVector.allocateNew();
                if (this.callBack != null) {
                    this.callBack.doWork();
                }
            }
        }
        return this.timeMicroVector;
    }

    public TimeNanoVector getTimeNanoVector() {
        return this.getTimeNanoVector(null);
    }

    public TimeNanoVector getTimeNanoVector(String name) {
        if (this.timeNanoVector == null) {
            int vectorCount = this.internalStruct.size();
            this.timeNanoVector = this.addOrGet(name, Types.MinorType.TIMENANO, TimeNanoVector.class);
            if (this.internalStruct.size() > vectorCount) {
                this.timeNanoVector.allocateNew();
                if (this.callBack != null) {
                    this.callBack.doWork();
                }
            }
        }
        return this.timeNanoVector;
    }

    public IntervalDayVector getIntervalDayVector() {
        return this.getIntervalDayVector(null);
    }

    public IntervalDayVector getIntervalDayVector(String name) {
        if (this.intervalDayVector == null) {
            int vectorCount = this.internalStruct.size();
            this.intervalDayVector = this.addOrGet(name, Types.MinorType.INTERVALDAY, IntervalDayVector.class);
            if (this.internalStruct.size() > vectorCount) {
                this.intervalDayVector.allocateNew();
                if (this.callBack != null) {
                    this.callBack.doWork();
                }
            }
        }
        return this.intervalDayVector;
    }

    public IntervalMonthDayNanoVector getIntervalMonthDayNanoVector() {
        return this.getIntervalMonthDayNanoVector(null);
    }

    public IntervalMonthDayNanoVector getIntervalMonthDayNanoVector(String name) {
        if (this.intervalMonthDayNanoVector == null) {
            int vectorCount = this.internalStruct.size();
            this.intervalMonthDayNanoVector = this.addOrGet(name, Types.MinorType.INTERVALMONTHDAYNANO, IntervalMonthDayNanoVector.class);
            if (this.internalStruct.size() > vectorCount) {
                this.intervalMonthDayNanoVector.allocateNew();
                if (this.callBack != null) {
                    this.callBack.doWork();
                }
            }
        }
        return this.intervalMonthDayNanoVector;
    }

    public Decimal256Vector getDecimal256Vector() {
        if (this.decimal256Vector == null) {
            throw new IllegalArgumentException("No Decimal256 present. Provide ArrowType argument to create a new vector");
        }
        return this.decimal256Vector;
    }

    public Decimal256Vector getDecimal256Vector(ArrowType arrowType) {
        return this.getDecimal256Vector(null, arrowType);
    }

    public Decimal256Vector getDecimal256Vector(String name, ArrowType arrowType) {
        if (this.decimal256Vector == null) {
            int vectorCount = this.internalStruct.size();
            this.decimal256Vector = this.addOrGet(name, Types.MinorType.DECIMAL256, arrowType, Decimal256Vector.class);
            if (this.internalStruct.size() > vectorCount) {
                this.decimal256Vector.allocateNew();
                if (this.callBack != null) {
                    this.callBack.doWork();
                }
            }
        }
        return this.decimal256Vector;
    }

    public DecimalVector getDecimalVector() {
        if (this.decimalVector == null) {
            throw new IllegalArgumentException("No Decimal present. Provide ArrowType argument to create a new vector");
        }
        return this.decimalVector;
    }

    public DecimalVector getDecimalVector(ArrowType arrowType) {
        return this.getDecimalVector(null, arrowType);
    }

    public DecimalVector getDecimalVector(String name, ArrowType arrowType) {
        if (this.decimalVector == null) {
            int vectorCount = this.internalStruct.size();
            this.decimalVector = this.addOrGet(name, Types.MinorType.DECIMAL, arrowType, DecimalVector.class);
            if (this.internalStruct.size() > vectorCount) {
                this.decimalVector.allocateNew();
                if (this.callBack != null) {
                    this.callBack.doWork();
                }
            }
        }
        return this.decimalVector;
    }

    public FixedSizeBinaryVector getFixedSizeBinaryVector() {
        if (this.fixedSizeBinaryVector == null) {
            throw new IllegalArgumentException("No FixedSizeBinary present. Provide ArrowType argument to create a new vector");
        }
        return this.fixedSizeBinaryVector;
    }

    public FixedSizeBinaryVector getFixedSizeBinaryVector(ArrowType arrowType) {
        return this.getFixedSizeBinaryVector(null, arrowType);
    }

    public FixedSizeBinaryVector getFixedSizeBinaryVector(String name, ArrowType arrowType) {
        if (this.fixedSizeBinaryVector == null) {
            int vectorCount = this.internalStruct.size();
            this.fixedSizeBinaryVector = this.addOrGet(name, Types.MinorType.FIXEDSIZEBINARY, arrowType, FixedSizeBinaryVector.class);
            if (this.internalStruct.size() > vectorCount) {
                this.fixedSizeBinaryVector.allocateNew();
                if (this.callBack != null) {
                    this.callBack.doWork();
                }
            }
        }
        return this.fixedSizeBinaryVector;
    }

    public VarBinaryVector getVarBinaryVector() {
        return this.getVarBinaryVector(null);
    }

    public VarBinaryVector getVarBinaryVector(String name) {
        if (this.varBinaryVector == null) {
            int vectorCount = this.internalStruct.size();
            this.varBinaryVector = this.addOrGet(name, Types.MinorType.VARBINARY, VarBinaryVector.class);
            if (this.internalStruct.size() > vectorCount) {
                this.varBinaryVector.allocateNew();
                if (this.callBack != null) {
                    this.callBack.doWork();
                }
            }
        }
        return this.varBinaryVector;
    }

    public VarCharVector getVarCharVector() {
        return this.getVarCharVector(null);
    }

    public VarCharVector getVarCharVector(String name) {
        if (this.varCharVector == null) {
            int vectorCount = this.internalStruct.size();
            this.varCharVector = this.addOrGet(name, Types.MinorType.VARCHAR, VarCharVector.class);
            if (this.internalStruct.size() > vectorCount) {
                this.varCharVector.allocateNew();
                if (this.callBack != null) {
                    this.callBack.doWork();
                }
            }
        }
        return this.varCharVector;
    }

    public ViewVarBinaryVector getViewVarBinaryVector() {
        return this.getViewVarBinaryVector(null);
    }

    public ViewVarBinaryVector getViewVarBinaryVector(String name) {
        if (this.viewVarBinaryVector == null) {
            int vectorCount = this.internalStruct.size();
            this.viewVarBinaryVector = this.addOrGet(name, Types.MinorType.VIEWVARBINARY, ViewVarBinaryVector.class);
            if (this.internalStruct.size() > vectorCount) {
                this.viewVarBinaryVector.allocateNew();
                if (this.callBack != null) {
                    this.callBack.doWork();
                }
            }
        }
        return this.viewVarBinaryVector;
    }

    public ViewVarCharVector getViewVarCharVector() {
        return this.getViewVarCharVector(null);
    }

    public ViewVarCharVector getViewVarCharVector(String name) {
        if (this.viewVarCharVector == null) {
            int vectorCount = this.internalStruct.size();
            this.viewVarCharVector = this.addOrGet(name, Types.MinorType.VIEWVARCHAR, ViewVarCharVector.class);
            if (this.internalStruct.size() > vectorCount) {
                this.viewVarCharVector.allocateNew();
                if (this.callBack != null) {
                    this.callBack.doWork();
                }
            }
        }
        return this.viewVarCharVector;
    }

    public LargeVarCharVector getLargeVarCharVector() {
        return this.getLargeVarCharVector(null);
    }

    public LargeVarCharVector getLargeVarCharVector(String name) {
        if (this.largeVarCharVector == null) {
            int vectorCount = this.internalStruct.size();
            this.largeVarCharVector = this.addOrGet(name, Types.MinorType.LARGEVARCHAR, LargeVarCharVector.class);
            if (this.internalStruct.size() > vectorCount) {
                this.largeVarCharVector.allocateNew();
                if (this.callBack != null) {
                    this.callBack.doWork();
                }
            }
        }
        return this.largeVarCharVector;
    }

    public LargeVarBinaryVector getLargeVarBinaryVector() {
        return this.getLargeVarBinaryVector(null);
    }

    public LargeVarBinaryVector getLargeVarBinaryVector(String name) {
        if (this.largeVarBinaryVector == null) {
            int vectorCount = this.internalStruct.size();
            this.largeVarBinaryVector = this.addOrGet(name, Types.MinorType.LARGEVARBINARY, LargeVarBinaryVector.class);
            if (this.internalStruct.size() > vectorCount) {
                this.largeVarBinaryVector.allocateNew();
                if (this.callBack != null) {
                    this.callBack.doWork();
                }
            }
        }
        return this.largeVarBinaryVector;
    }

    public BitVector getBitVector() {
        return this.getBitVector(null);
    }

    public BitVector getBitVector(String name) {
        if (this.bitVector == null) {
            int vectorCount = this.internalStruct.size();
            this.bitVector = this.addOrGet(name, Types.MinorType.BIT, BitVector.class);
            if (this.internalStruct.size() > vectorCount) {
                this.bitVector.allocateNew();
                if (this.callBack != null) {
                    this.callBack.doWork();
                }
            }
        }
        return this.bitVector;
    }

    public ListVector getList() {
        if (this.listVector == null) {
            int vectorCount = this.internalStruct.size();
            this.listVector = this.addOrGet(Types.MinorType.LIST, ListVector.class);
            if (this.internalStruct.size() > vectorCount) {
                this.listVector.allocateNew();
                if (this.callBack != null) {
                    this.callBack.doWork();
                }
            }
        }
        return this.listVector;
    }

    public MapVector getMap() {
        if (this.mapVector == null) {
            throw new IllegalArgumentException("No map present. Provide ArrowType argument to create a new vector");
        }
        return this.mapVector;
    }

    public MapVector getMap(ArrowType arrowType) {
        return this.getMap(null, arrowType);
    }

    public MapVector getMap(String name, ArrowType arrowType) {
        if (this.mapVector == null) {
            int vectorCount = this.internalStruct.size();
            this.mapVector = this.addOrGet(name, Types.MinorType.MAP, arrowType, MapVector.class);
            if (this.internalStruct.size() > vectorCount) {
                this.mapVector.allocateNew();
                if (this.callBack != null) {
                    this.callBack.doWork();
                }
            }
        }
        return this.mapVector;
    }

    public int getTypeValue(int index) {
        return this.typeBuffer.getByte(index * 1);
    }

    @Override
    public void allocateNew() throws OutOfMemoryException {
        this.clear();
        this.internalStruct.allocateNew();
        try {
            this.allocateTypeBuffer();
        }
        catch (Exception e) {
            this.clear();
            throw e;
        }
    }

    @Override
    public boolean allocateNewSafe() {
        this.clear();
        boolean safe = this.internalStruct.allocateNewSafe();
        if (!safe) {
            return false;
        }
        try {
            this.allocateTypeBuffer();
        }
        catch (Exception e) {
            this.clear();
            return false;
        }
        return true;
    }

    private void allocateTypeBuffer() {
        this.typeBuffer = this.allocator.buffer(this.typeBufferAllocationSizeInBytes);
        this.typeBuffer.readerIndex(0L);
        this.typeBuffer.setZero(0L, this.typeBuffer.capacity());
    }

    @Override
    public void reAlloc() {
        this.internalStruct.reAlloc();
        this.reallocTypeBuffer();
    }

    private void reallocTypeBuffer() {
        long currentBufferCapacity = this.typeBuffer.capacity();
        long newAllocationSize = currentBufferCapacity * 2L;
        if (newAllocationSize == 0L) {
            newAllocationSize = this.typeBufferAllocationSizeInBytes > 0 ? (long)this.typeBufferAllocationSizeInBytes : 7940L;
        }
        newAllocationSize = CommonUtil.nextPowerOfTwo(newAllocationSize);
        assert (newAllocationSize >= 1L);
        if (newAllocationSize > BaseValueVector.MAX_ALLOCATION_SIZE) {
            throw new OversizedAllocationException("Unable to expand the buffer");
        }
        ArrowBuf newBuf = this.allocator.buffer(LargeMemoryUtil.checkedCastToInt(newAllocationSize));
        newBuf.setBytes(0L, this.typeBuffer, 0L, currentBufferCapacity);
        newBuf.setZero(currentBufferCapacity, newBuf.capacity() - currentBufferCapacity);
        this.typeBuffer.getReferenceManager().release(1);
        this.typeBuffer = newBuf;
        this.typeBufferAllocationSizeInBytes = (int)newAllocationSize;
    }

    @Override
    public void setInitialCapacity(int numRecords) {
    }

    @Override
    public int getValueCapacity() {
        return Math.min(this.getTypeBufferValueCapacity(), this.internalStruct.getValueCapacity());
    }

    @Override
    public void close() {
        this.clear();
    }

    @Override
    public void clear() {
        this.valueCount = 0;
        this.typeBuffer.getReferenceManager().release();
        this.typeBuffer = this.allocator.getEmpty();
        this.internalStruct.clear();
    }

    @Override
    public void reset() {
        this.valueCount = 0;
        this.typeBuffer.setZero(0L, this.typeBuffer.capacity());
        this.internalStruct.reset();
    }

    @Override
    public Field getField() {
        FieldType fieldType;
        ArrayList<Field> childFields = new ArrayList<Field>();
        List<FieldVector> children = this.internalStruct.getChildren();
        int[] typeIds = new int[children.size()];
        for (ValueVector valueVector : children) {
            typeIds[childFields.size()] = valueVector.getMinorType().ordinal();
            childFields.add(valueVector.getField());
        }
        if (this.fieldType == null) {
            fieldType = FieldType.nullable(new ArrowType.Union(UnionMode.Sparse, typeIds));
        } else {
            UnionMode unionMode = ((ArrowType.Union)this.fieldType.getType()).getMode();
            fieldType = new FieldType(this.fieldType.isNullable(), new ArrowType.Union(unionMode, typeIds), this.fieldType.getDictionary(), this.fieldType.getMetadata());
        }
        return new Field(this.name, fieldType, childFields);
    }

    @Override
    public TransferPair getTransferPair(BufferAllocator allocator) {
        return this.getTransferPair(this.name, allocator);
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        return this.getTransferPair(ref, allocator, null);
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator, CallBack callBack) {
        return new TransferImpl(ref, allocator, callBack);
    }

    @Override
    public TransferPair getTransferPair(Field field, BufferAllocator allocator) {
        return this.getTransferPair(field, allocator, null);
    }

    @Override
    public TransferPair getTransferPair(Field field, BufferAllocator allocator, CallBack callBack) {
        return new TransferImpl(field, allocator, callBack);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector target) {
        return new TransferImpl((UnionVector)target);
    }

    @Override
    public void copyFrom(int inIndex, int outIndex, ValueVector from) {
        Preconditions.checkArgument(this.getMinorType() == from.getMinorType());
        UnionVector fromCast = (UnionVector)from;
        fromCast.getReader().setPosition(inIndex);
        this.getWriter().setPosition(outIndex);
        ComplexCopier.copy(fromCast.reader, this.writer);
    }

    @Override
    public void copyFromSafe(int inIndex, int outIndex, ValueVector from) {
        this.copyFrom(inIndex, outIndex, from);
    }

    public FieldVector addVector(FieldVector v) {
        String name = v.getName().isEmpty() ? this.fieldName(v.getMinorType()) : v.getName();
        Preconditions.checkState(this.internalStruct.getChild(name) == null, String.format("%s vector already exists", name));
        Object newVector = this.internalStruct.addOrGet(name, v.getField().getFieldType(), v.getClass());
        v.makeTransferPair((ValueVector)newVector).transfer();
        this.internalStruct.putChild(name, (FieldVector)newVector);
        if (this.callBack != null) {
            this.callBack.doWork();
        }
        return newVector;
    }

    public void directAddVector(FieldVector v) {
        String name = this.fieldName(v.getMinorType());
        Preconditions.checkState(this.internalStruct.getChild(name) == null, String.format("%s vector already exists", name));
        this.internalStruct.putChild(name, v);
        if (this.callBack != null) {
            this.callBack.doWork();
        }
    }

    @Override
    public FieldReader getReader() {
        if (this.reader == null) {
            this.reader = new UnionReader(this);
        }
        return this.reader;
    }

    public FieldWriter getWriter() {
        if (this.writer == null) {
            this.writer = new UnionWriter(this);
        }
        return this.writer;
    }

    @Override
    public int getBufferSize() {
        if (this.valueCount == 0) {
            return 0;
        }
        return this.valueCount * 1 + this.internalStruct.getBufferSize();
    }

    @Override
    public int getBufferSizeFor(int valueCount) {
        if (valueCount == 0) {
            return 0;
        }
        long bufferSize = 0L;
        for (ValueVector v : this) {
            bufferSize += (long)v.getBufferSizeFor(valueCount);
        }
        return (int)bufferSize + valueCount * 1;
    }

    @Override
    public ArrowBuf[] getBuffers(boolean clear) {
        ArrayList<ArrowBuf> list = new ArrayList<ArrowBuf>();
        this.setReaderAndWriterIndex();
        if (this.getBufferSize() != 0) {
            list.add(this.typeBuffer);
            list.addAll(Arrays.asList(this.internalStruct.getBuffers(clear)));
        }
        if (clear) {
            this.valueCount = 0;
            this.typeBuffer.getReferenceManager().retain();
            this.typeBuffer.getReferenceManager().release();
            this.typeBuffer = this.allocator.getEmpty();
        }
        return list.toArray(new ArrowBuf[list.size()]);
    }

    @Override
    public Iterator<ValueVector> iterator() {
        return this.internalStruct.iterator();
    }

    public ValueVector getVector(int index) {
        return this.getVector(index, null);
    }

    public ValueVector getVector(int index, ArrowType arrowType) {
        byte type = this.typeBuffer.getByte(index * 1);
        return this.getVectorByType(type, arrowType);
    }

    public ValueVector getVectorByType(int typeId) {
        return this.getVectorByType(typeId, null);
    }

    public ValueVector getVectorByType(int typeId, ArrowType arrowType) {
        Types.MinorType minorType;
        Field type = this.typeIds[typeId];
        String name = null;
        if (type == null) {
            minorType = Types.MinorType.values()[typeId];
        } else {
            minorType = Types.getMinorTypeForArrowType(type.getType());
            name = type.getName();
        }
        switch (minorType) {
            case NULL: {
                return null;
            }
            case TINYINT: {
                return this.getTinyIntVector(name);
            }
            case UINT1: {
                return this.getUInt1Vector(name);
            }
            case UINT2: {
                return this.getUInt2Vector(name);
            }
            case SMALLINT: {
                return this.getSmallIntVector(name);
            }
            case FLOAT2: {
                return this.getFloat2Vector(name);
            }
            case INT: {
                return this.getIntVector(name);
            }
            case UINT4: {
                return this.getUInt4Vector(name);
            }
            case FLOAT4: {
                return this.getFloat4Vector(name);
            }
            case DATEDAY: {
                return this.getDateDayVector(name);
            }
            case INTERVALYEAR: {
                return this.getIntervalYearVector(name);
            }
            case TIMESEC: {
                return this.getTimeSecVector(name);
            }
            case TIMEMILLI: {
                return this.getTimeMilliVector(name);
            }
            case BIGINT: {
                return this.getBigIntVector(name);
            }
            case UINT8: {
                return this.getUInt8Vector(name);
            }
            case FLOAT8: {
                return this.getFloat8Vector(name);
            }
            case DATEMILLI: {
                return this.getDateMilliVector(name);
            }
            case DURATION: {
                return this.getDurationVector(name, arrowType);
            }
            case TIMESTAMPSEC: {
                return this.getTimeStampSecVector(name);
            }
            case TIMESTAMPMILLI: {
                return this.getTimeStampMilliVector(name);
            }
            case TIMESTAMPMICRO: {
                return this.getTimeStampMicroVector(name);
            }
            case TIMESTAMPNANO: {
                return this.getTimeStampNanoVector(name);
            }
            case TIMESTAMPSECTZ: {
                return this.getTimeStampSecTZVector(name, arrowType);
            }
            case TIMESTAMPMILLITZ: {
                return this.getTimeStampMilliTZVector(name, arrowType);
            }
            case TIMESTAMPMICROTZ: {
                return this.getTimeStampMicroTZVector(name, arrowType);
            }
            case TIMESTAMPNANOTZ: {
                return this.getTimeStampNanoTZVector(name, arrowType);
            }
            case TIMEMICRO: {
                return this.getTimeMicroVector(name);
            }
            case TIMENANO: {
                return this.getTimeNanoVector(name);
            }
            case INTERVALDAY: {
                return this.getIntervalDayVector(name);
            }
            case INTERVALMONTHDAYNANO: {
                return this.getIntervalMonthDayNanoVector(name);
            }
            case DECIMAL256: {
                return this.getDecimal256Vector(name, arrowType);
            }
            case DECIMAL: {
                return this.getDecimalVector(name, arrowType);
            }
            case FIXEDSIZEBINARY: {
                return this.getFixedSizeBinaryVector(name, arrowType);
            }
            case VARBINARY: {
                return this.getVarBinaryVector(name);
            }
            case VARCHAR: {
                return this.getVarCharVector(name);
            }
            case VIEWVARBINARY: {
                return this.getViewVarBinaryVector(name);
            }
            case VIEWVARCHAR: {
                return this.getViewVarCharVector(name);
            }
            case LARGEVARCHAR: {
                return this.getLargeVarCharVector(name);
            }
            case LARGEVARBINARY: {
                return this.getLargeVarBinaryVector(name);
            }
            case BIT: {
                return this.getBitVector(name);
            }
            case STRUCT: {
                return this.getStruct();
            }
            case LIST: {
                return this.getList();
            }
            case MAP: {
                return this.getMap(name, arrowType);
            }
        }
        throw new UnsupportedOperationException("Cannot support type: " + (Object)((Object)Types.MinorType.values()[typeId]));
    }

    @Override
    public Object getObject(int index) {
        ValueVector vector = this.getVector(index);
        if (vector != null) {
            return vector.isNull(index) ? null : vector.getObject(index);
        }
        return null;
    }

    public byte[] get(int index) {
        return null;
    }

    public void get(int index, ComplexHolder holder) {
    }

    public void get(int index, UnionHolder holder) {
        UnionReader reader = new UnionReader(this);
        reader.setPosition(index);
        holder.reader = reader;
    }

    @Override
    public int getValueCount() {
        return this.valueCount;
    }

    @Override
    public boolean isNull(int index) {
        return false;
    }

    @Override
    public int getNullCount() {
        return 0;
    }

    public int isSet(int index) {
        return this.isNull(index) ? 0 : 1;
    }

    @Override
    public void setValueCount(int valueCount) {
        this.valueCount = valueCount;
        while (valueCount > this.getTypeBufferValueCapacity()) {
            this.reallocTypeBuffer();
        }
        this.internalStruct.setValueCount(valueCount);
    }

    public void setSafe(int index, UnionHolder holder) {
        this.setSafe(index, holder, null);
    }

    public void setSafe(int index, UnionHolder holder, ArrowType arrowType) {
        FieldReader reader = holder.reader;
        if (this.writer == null) {
            this.writer = new UnionWriter(this);
        }
        this.writer.setPosition(index);
        Types.MinorType type = reader.getMinorType();
        switch (type) {
            case TINYINT: {
                NullableTinyIntHolder tinyIntHolder = new NullableTinyIntHolder();
                reader.read(tinyIntHolder);
                this.setSafe(index, tinyIntHolder);
                break;
            }
            case UINT1: {
                NullableUInt1Holder uInt1Holder = new NullableUInt1Holder();
                reader.read(uInt1Holder);
                this.setSafe(index, uInt1Holder);
                break;
            }
            case UINT2: {
                NullableUInt2Holder uInt2Holder = new NullableUInt2Holder();
                reader.read(uInt2Holder);
                this.setSafe(index, uInt2Holder);
                break;
            }
            case SMALLINT: {
                NullableSmallIntHolder smallIntHolder = new NullableSmallIntHolder();
                reader.read(smallIntHolder);
                this.setSafe(index, smallIntHolder);
                break;
            }
            case FLOAT2: {
                NullableFloat2Holder float2Holder = new NullableFloat2Holder();
                reader.read(float2Holder);
                this.setSafe(index, float2Holder);
                break;
            }
            case INT: {
                NullableIntHolder intHolder = new NullableIntHolder();
                reader.read(intHolder);
                this.setSafe(index, intHolder);
                break;
            }
            case UINT4: {
                NullableUInt4Holder uInt4Holder = new NullableUInt4Holder();
                reader.read(uInt4Holder);
                this.setSafe(index, uInt4Holder);
                break;
            }
            case FLOAT4: {
                NullableFloat4Holder float4Holder = new NullableFloat4Holder();
                reader.read(float4Holder);
                this.setSafe(index, float4Holder);
                break;
            }
            case DATEDAY: {
                NullableDateDayHolder dateDayHolder = new NullableDateDayHolder();
                reader.read(dateDayHolder);
                this.setSafe(index, dateDayHolder);
                break;
            }
            case INTERVALYEAR: {
                NullableIntervalYearHolder intervalYearHolder = new NullableIntervalYearHolder();
                reader.read(intervalYearHolder);
                this.setSafe(index, intervalYearHolder);
                break;
            }
            case TIMESEC: {
                NullableTimeSecHolder timeSecHolder = new NullableTimeSecHolder();
                reader.read(timeSecHolder);
                this.setSafe(index, timeSecHolder);
                break;
            }
            case TIMEMILLI: {
                NullableTimeMilliHolder timeMilliHolder = new NullableTimeMilliHolder();
                reader.read(timeMilliHolder);
                this.setSafe(index, timeMilliHolder);
                break;
            }
            case BIGINT: {
                NullableBigIntHolder bigIntHolder = new NullableBigIntHolder();
                reader.read(bigIntHolder);
                this.setSafe(index, bigIntHolder);
                break;
            }
            case UINT8: {
                NullableUInt8Holder uInt8Holder = new NullableUInt8Holder();
                reader.read(uInt8Holder);
                this.setSafe(index, uInt8Holder);
                break;
            }
            case FLOAT8: {
                NullableFloat8Holder float8Holder = new NullableFloat8Holder();
                reader.read(float8Holder);
                this.setSafe(index, float8Holder);
                break;
            }
            case DATEMILLI: {
                NullableDateMilliHolder dateMilliHolder = new NullableDateMilliHolder();
                reader.read(dateMilliHolder);
                this.setSafe(index, dateMilliHolder);
                break;
            }
            case DURATION: {
                NullableDurationHolder durationHolder = new NullableDurationHolder();
                reader.read(durationHolder);
                this.setSafe(index, durationHolder, arrowType);
                break;
            }
            case TIMESTAMPSEC: {
                NullableTimeStampSecHolder timeStampSecHolder = new NullableTimeStampSecHolder();
                reader.read(timeStampSecHolder);
                this.setSafe(index, timeStampSecHolder);
                break;
            }
            case TIMESTAMPMILLI: {
                NullableTimeStampMilliHolder timeStampMilliHolder = new NullableTimeStampMilliHolder();
                reader.read(timeStampMilliHolder);
                this.setSafe(index, timeStampMilliHolder);
                break;
            }
            case TIMESTAMPMICRO: {
                NullableTimeStampMicroHolder timeStampMicroHolder = new NullableTimeStampMicroHolder();
                reader.read(timeStampMicroHolder);
                this.setSafe(index, timeStampMicroHolder);
                break;
            }
            case TIMESTAMPNANO: {
                NullableTimeStampNanoHolder timeStampNanoHolder = new NullableTimeStampNanoHolder();
                reader.read(timeStampNanoHolder);
                this.setSafe(index, timeStampNanoHolder);
                break;
            }
            case TIMESTAMPSECTZ: {
                NullableTimeStampSecTZHolder timeStampSecTZHolder = new NullableTimeStampSecTZHolder();
                reader.read(timeStampSecTZHolder);
                this.setSafe(index, timeStampSecTZHolder, arrowType);
                break;
            }
            case TIMESTAMPMILLITZ: {
                NullableTimeStampMilliTZHolder timeStampMilliTZHolder = new NullableTimeStampMilliTZHolder();
                reader.read(timeStampMilliTZHolder);
                this.setSafe(index, timeStampMilliTZHolder, arrowType);
                break;
            }
            case TIMESTAMPMICROTZ: {
                NullableTimeStampMicroTZHolder timeStampMicroTZHolder = new NullableTimeStampMicroTZHolder();
                reader.read(timeStampMicroTZHolder);
                this.setSafe(index, timeStampMicroTZHolder, arrowType);
                break;
            }
            case TIMESTAMPNANOTZ: {
                NullableTimeStampNanoTZHolder timeStampNanoTZHolder = new NullableTimeStampNanoTZHolder();
                reader.read(timeStampNanoTZHolder);
                this.setSafe(index, timeStampNanoTZHolder, arrowType);
                break;
            }
            case TIMEMICRO: {
                NullableTimeMicroHolder timeMicroHolder = new NullableTimeMicroHolder();
                reader.read(timeMicroHolder);
                this.setSafe(index, timeMicroHolder);
                break;
            }
            case TIMENANO: {
                NullableTimeNanoHolder timeNanoHolder = new NullableTimeNanoHolder();
                reader.read(timeNanoHolder);
                this.setSafe(index, timeNanoHolder);
                break;
            }
            case INTERVALDAY: {
                NullableIntervalDayHolder intervalDayHolder = new NullableIntervalDayHolder();
                reader.read(intervalDayHolder);
                this.setSafe(index, intervalDayHolder);
                break;
            }
            case INTERVALMONTHDAYNANO: {
                NullableIntervalMonthDayNanoHolder intervalMonthDayNanoHolder = new NullableIntervalMonthDayNanoHolder();
                reader.read(intervalMonthDayNanoHolder);
                this.setSafe(index, intervalMonthDayNanoHolder);
                break;
            }
            case DECIMAL256: {
                NullableDecimal256Holder decimal256Holder = new NullableDecimal256Holder();
                reader.read(decimal256Holder);
                this.setSafe(index, decimal256Holder, arrowType);
                break;
            }
            case DECIMAL: {
                NullableDecimalHolder decimalHolder = new NullableDecimalHolder();
                reader.read(decimalHolder);
                this.setSafe(index, decimalHolder, arrowType);
                break;
            }
            case FIXEDSIZEBINARY: {
                NullableFixedSizeBinaryHolder fixedSizeBinaryHolder = new NullableFixedSizeBinaryHolder();
                reader.read(fixedSizeBinaryHolder);
                this.setSafe(index, fixedSizeBinaryHolder, arrowType);
                break;
            }
            case VARBINARY: {
                NullableVarBinaryHolder varBinaryHolder = new NullableVarBinaryHolder();
                reader.read(varBinaryHolder);
                this.setSafe(index, varBinaryHolder);
                break;
            }
            case VARCHAR: {
                NullableVarCharHolder varCharHolder = new NullableVarCharHolder();
                reader.read(varCharHolder);
                this.setSafe(index, varCharHolder);
                break;
            }
            case VIEWVARBINARY: {
                NullableViewVarBinaryHolder viewVarBinaryHolder = new NullableViewVarBinaryHolder();
                reader.read(viewVarBinaryHolder);
                this.setSafe(index, viewVarBinaryHolder);
                break;
            }
            case VIEWVARCHAR: {
                NullableViewVarCharHolder viewVarCharHolder = new NullableViewVarCharHolder();
                reader.read(viewVarCharHolder);
                this.setSafe(index, viewVarCharHolder);
                break;
            }
            case LARGEVARCHAR: {
                NullableLargeVarCharHolder largeVarCharHolder = new NullableLargeVarCharHolder();
                reader.read(largeVarCharHolder);
                this.setSafe(index, largeVarCharHolder);
                break;
            }
            case LARGEVARBINARY: {
                NullableLargeVarBinaryHolder largeVarBinaryHolder = new NullableLargeVarBinaryHolder();
                reader.read(largeVarBinaryHolder);
                this.setSafe(index, largeVarBinaryHolder);
                break;
            }
            case BIT: {
                NullableBitHolder bitHolder = new NullableBitHolder();
                reader.read(bitHolder);
                this.setSafe(index, bitHolder);
                break;
            }
            case STRUCT: {
                ComplexCopier.copy(reader, this.writer);
                break;
            }
            case LIST: {
                ComplexCopier.copy(reader, this.writer);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    public void setSafe(int index, NullableTinyIntHolder holder) {
        this.setType(index, Types.MinorType.TINYINT);
        this.getTinyIntVector(null).setSafe(index, holder);
    }

    public void setSafe(int index, NullableUInt1Holder holder) {
        this.setType(index, Types.MinorType.UINT1);
        this.getUInt1Vector(null).setSafe(index, holder);
    }

    public void setSafe(int index, NullableUInt2Holder holder) {
        this.setType(index, Types.MinorType.UINT2);
        this.getUInt2Vector(null).setSafe(index, holder);
    }

    public void setSafe(int index, NullableSmallIntHolder holder) {
        this.setType(index, Types.MinorType.SMALLINT);
        this.getSmallIntVector(null).setSafe(index, holder);
    }

    public void setSafe(int index, NullableFloat2Holder holder) {
        this.setType(index, Types.MinorType.FLOAT2);
        this.getFloat2Vector(null).setSafe(index, holder);
    }

    public void setSafe(int index, NullableIntHolder holder) {
        this.setType(index, Types.MinorType.INT);
        this.getIntVector(null).setSafe(index, holder);
    }

    public void setSafe(int index, NullableUInt4Holder holder) {
        this.setType(index, Types.MinorType.UINT4);
        this.getUInt4Vector(null).setSafe(index, holder);
    }

    public void setSafe(int index, NullableFloat4Holder holder) {
        this.setType(index, Types.MinorType.FLOAT4);
        this.getFloat4Vector(null).setSafe(index, holder);
    }

    public void setSafe(int index, NullableDateDayHolder holder) {
        this.setType(index, Types.MinorType.DATEDAY);
        this.getDateDayVector(null).setSafe(index, holder);
    }

    public void setSafe(int index, NullableIntervalYearHolder holder) {
        this.setType(index, Types.MinorType.INTERVALYEAR);
        this.getIntervalYearVector(null).setSafe(index, holder);
    }

    public void setSafe(int index, NullableTimeSecHolder holder) {
        this.setType(index, Types.MinorType.TIMESEC);
        this.getTimeSecVector(null).setSafe(index, holder);
    }

    public void setSafe(int index, NullableTimeMilliHolder holder) {
        this.setType(index, Types.MinorType.TIMEMILLI);
        this.getTimeMilliVector(null).setSafe(index, holder);
    }

    public void setSafe(int index, NullableBigIntHolder holder) {
        this.setType(index, Types.MinorType.BIGINT);
        this.getBigIntVector(null).setSafe(index, holder);
    }

    public void setSafe(int index, NullableUInt8Holder holder) {
        this.setType(index, Types.MinorType.UINT8);
        this.getUInt8Vector(null).setSafe(index, holder);
    }

    public void setSafe(int index, NullableFloat8Holder holder) {
        this.setType(index, Types.MinorType.FLOAT8);
        this.getFloat8Vector(null).setSafe(index, holder);
    }

    public void setSafe(int index, NullableDateMilliHolder holder) {
        this.setType(index, Types.MinorType.DATEMILLI);
        this.getDateMilliVector(null).setSafe(index, holder);
    }

    public void setSafe(int index, NullableDurationHolder holder, ArrowType arrowType) {
        this.setType(index, Types.MinorType.DURATION);
        this.getDurationVector(null, arrowType).setSafe(index, holder);
    }

    public void setSafe(int index, NullableTimeStampSecHolder holder) {
        this.setType(index, Types.MinorType.TIMESTAMPSEC);
        this.getTimeStampSecVector(null).setSafe(index, holder);
    }

    public void setSafe(int index, NullableTimeStampMilliHolder holder) {
        this.setType(index, Types.MinorType.TIMESTAMPMILLI);
        this.getTimeStampMilliVector(null).setSafe(index, holder);
    }

    public void setSafe(int index, NullableTimeStampMicroHolder holder) {
        this.setType(index, Types.MinorType.TIMESTAMPMICRO);
        this.getTimeStampMicroVector(null).setSafe(index, holder);
    }

    public void setSafe(int index, NullableTimeStampNanoHolder holder) {
        this.setType(index, Types.MinorType.TIMESTAMPNANO);
        this.getTimeStampNanoVector(null).setSafe(index, holder);
    }

    public void setSafe(int index, NullableTimeStampSecTZHolder holder, ArrowType arrowType) {
        this.setType(index, Types.MinorType.TIMESTAMPSECTZ);
        this.getTimeStampSecTZVector(null, arrowType).setSafe(index, holder);
    }

    public void setSafe(int index, NullableTimeStampMilliTZHolder holder, ArrowType arrowType) {
        this.setType(index, Types.MinorType.TIMESTAMPMILLITZ);
        this.getTimeStampMilliTZVector(null, arrowType).setSafe(index, holder);
    }

    public void setSafe(int index, NullableTimeStampMicroTZHolder holder, ArrowType arrowType) {
        this.setType(index, Types.MinorType.TIMESTAMPMICROTZ);
        this.getTimeStampMicroTZVector(null, arrowType).setSafe(index, holder);
    }

    public void setSafe(int index, NullableTimeStampNanoTZHolder holder, ArrowType arrowType) {
        this.setType(index, Types.MinorType.TIMESTAMPNANOTZ);
        this.getTimeStampNanoTZVector(null, arrowType).setSafe(index, holder);
    }

    public void setSafe(int index, NullableTimeMicroHolder holder) {
        this.setType(index, Types.MinorType.TIMEMICRO);
        this.getTimeMicroVector(null).setSafe(index, holder);
    }

    public void setSafe(int index, NullableTimeNanoHolder holder) {
        this.setType(index, Types.MinorType.TIMENANO);
        this.getTimeNanoVector(null).setSafe(index, holder);
    }

    public void setSafe(int index, NullableIntervalDayHolder holder) {
        this.setType(index, Types.MinorType.INTERVALDAY);
        this.getIntervalDayVector(null).setSafe(index, holder);
    }

    public void setSafe(int index, NullableIntervalMonthDayNanoHolder holder) {
        this.setType(index, Types.MinorType.INTERVALMONTHDAYNANO);
        this.getIntervalMonthDayNanoVector(null).setSafe(index, holder);
    }

    public void setSafe(int index, NullableDecimal256Holder holder, ArrowType arrowType) {
        this.setType(index, Types.MinorType.DECIMAL256);
        this.getDecimal256Vector(null, arrowType).setSafe(index, holder);
    }

    public void setSafe(int index, NullableDecimalHolder holder, ArrowType arrowType) {
        this.setType(index, Types.MinorType.DECIMAL);
        this.getDecimalVector(null, arrowType).setSafe(index, holder);
    }

    public void setSafe(int index, NullableFixedSizeBinaryHolder holder, ArrowType arrowType) {
        this.setType(index, Types.MinorType.FIXEDSIZEBINARY);
        this.getFixedSizeBinaryVector(null, arrowType).setSafe(index, holder);
    }

    public void setSafe(int index, NullableVarBinaryHolder holder) {
        this.setType(index, Types.MinorType.VARBINARY);
        this.getVarBinaryVector(null).setSafe(index, holder);
    }

    public void setSafe(int index, NullableVarCharHolder holder) {
        this.setType(index, Types.MinorType.VARCHAR);
        this.getVarCharVector(null).setSafe(index, holder);
    }

    public void setSafe(int index, NullableViewVarBinaryHolder holder) {
        this.setType(index, Types.MinorType.VIEWVARBINARY);
        this.getViewVarBinaryVector(null).setSafe(index, holder);
    }

    public void setSafe(int index, NullableViewVarCharHolder holder) {
        this.setType(index, Types.MinorType.VIEWVARCHAR);
        this.getViewVarCharVector(null).setSafe(index, holder);
    }

    public void setSafe(int index, NullableLargeVarCharHolder holder) {
        this.setType(index, Types.MinorType.LARGEVARCHAR);
        this.getLargeVarCharVector(null).setSafe(index, holder);
    }

    public void setSafe(int index, NullableLargeVarBinaryHolder holder) {
        this.setType(index, Types.MinorType.LARGEVARBINARY);
        this.getLargeVarBinaryVector(null).setSafe(index, holder);
    }

    public void setSafe(int index, NullableBitHolder holder) {
        this.setType(index, Types.MinorType.BIT);
        this.getBitVector(null).setSafe(index, holder);
    }

    public void setType(int index, Types.MinorType type) {
        while (index >= this.getTypeBufferValueCapacity()) {
            this.reallocTypeBuffer();
        }
        this.typeBuffer.setByte((long)(index * 1), (byte)type.ordinal());
    }

    private int getTypeBufferValueCapacity() {
        return LargeMemoryUtil.capAtMaxInt(this.typeBuffer.capacity() / 1L);
    }

    @Override
    public int hashCode(int index) {
        return this.hashCode(index, null);
    }

    @Override
    public int hashCode(int index, ArrowBufHasher hasher) {
        ValueVector vec = this.getVector(index);
        if (vec == null) {
            return 0;
        }
        return vec.hashCode(index, hasher);
    }

    @Override
    public <OUT, IN> OUT accept(VectorVisitor<OUT, IN> visitor, IN value) {
        return visitor.visit(this, value);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String toString() {
        return ValueVectorUtility.getToString(this, 0, this.getValueCount());
    }

    @Override
    public <T extends FieldVector> T addOrGet(String name, FieldType fieldType, Class<T> clazz) {
        return this.internalStruct.addOrGet(name, fieldType, clazz);
    }

    @Override
    public <T extends FieldVector> T getChild(String name, Class<T> clazz) {
        return this.internalStruct.getChild(name, clazz);
    }

    @Override
    public VectorWithOrdinal getChildVectorWithOrdinal(String name) {
        return this.internalStruct.getChildVectorWithOrdinal(name);
    }

    @Override
    public int size() {
        return this.internalStruct.size();
    }

    @Override
    public void setInitialCapacity(int valueCount, double density) {
        for (ValueVector vector : this.internalStruct) {
            if (vector instanceof DensityAwareVector) {
                ((DensityAwareVector)((Object)vector)).setInitialCapacity(valueCount, density);
                continue;
            }
            vector.setInitialCapacity(valueCount);
        }
    }

    @Override
    public void setNull(int index) {
        throw new UnsupportedOperationException("The method setNull() is not supported on UnionVector.");
    }

    private class TransferImpl
    implements TransferPair {
        private final TransferPair internalStructVectorTransferPair;
        private final UnionVector to;

        public TransferImpl(String name, BufferAllocator allocator, CallBack callBack) {
            this.to = new UnionVector(name, allocator, null, callBack);
            this.internalStructVectorTransferPair = UnionVector.this.internalStruct.makeTransferPair(this.to.internalStruct);
        }

        public TransferImpl(Field field, BufferAllocator allocator, CallBack callBack) {
            this.to = new UnionVector(field.getName(), allocator, null, callBack);
            this.internalStructVectorTransferPair = UnionVector.this.internalStruct.makeTransferPair(this.to.internalStruct);
        }

        public TransferImpl(UnionVector to) {
            this.to = to;
            this.internalStructVectorTransferPair = UnionVector.this.internalStruct.makeTransferPair(to.internalStruct);
        }

        @Override
        public void transfer() {
            this.to.clear();
            ReferenceManager refManager = UnionVector.this.typeBuffer.getReferenceManager();
            this.to.typeBuffer = refManager.transferOwnership(UnionVector.this.typeBuffer, this.to.allocator).getTransferredBuffer();
            this.internalStructVectorTransferPair.transfer();
            this.to.valueCount = UnionVector.this.valueCount;
            UnionVector.this.clear();
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
            Preconditions.checkArgument(startIndex >= 0 && length >= 0 && startIndex + length <= UnionVector.this.valueCount, "Invalid parameters startIndex: %s, length: %s for valueCount: %s", (Object)startIndex, (Object)length, (Object)UnionVector.this.valueCount);
            this.to.clear();
            this.internalStructVectorTransferPair.splitAndTransfer(startIndex, length);
            int startPoint = startIndex * 1;
            int sliceLength = length * 1;
            ArrowBuf slicedBuffer = UnionVector.this.typeBuffer.slice(startPoint, sliceLength);
            ReferenceManager refManager = slicedBuffer.getReferenceManager();
            this.to.typeBuffer = refManager.transferOwnership(slicedBuffer, this.to.allocator).getTransferredBuffer();
            this.to.setValueCount(length);
        }

        @Override
        public ValueVector getTo() {
            return this.to;
        }

        @Override
        public void copyValueSafe(int from, int to) {
            this.to.copyFrom(from, to, UnionVector.this);
        }
    }
}

