/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.transform;

import java.util.Date;
import net.snowflake.client.jdbc.internal.amazonaws.SdkClientException;
import net.snowflake.client.jdbc.internal.amazonaws.annotation.SdkInternalApi;
import net.snowflake.client.jdbc.internal.amazonaws.protocol.MarshallLocation;
import net.snowflake.client.jdbc.internal.amazonaws.protocol.MarshallingInfo;
import net.snowflake.client.jdbc.internal.amazonaws.protocol.MarshallingType;
import net.snowflake.client.jdbc.internal.amazonaws.protocol.ProtocolMarshaller;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.RotationsListEntry;

@SdkInternalApi
public class RotationsListEntryMarshaller {
    private static final MarshallingInfo<String> KEYID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KeyId").build();
    private static final MarshallingInfo<Date> ROTATIONDATE_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RotationDate").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> ROTATIONTYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RotationType").build();
    private static final RotationsListEntryMarshaller instance = new RotationsListEntryMarshaller();

    public static RotationsListEntryMarshaller getInstance() {
        return instance;
    }

    public void marshall(RotationsListEntry rotationsListEntry, ProtocolMarshaller protocolMarshaller) {
        if (rotationsListEntry == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(rotationsListEntry.getKeyId(), KEYID_BINDING);
            protocolMarshaller.marshall(rotationsListEntry.getRotationDate(), ROTATIONDATE_BINDING);
            protocolMarshaller.marshall(rotationsListEntry.getRotationType(), ROTATIONTYPE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

