/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.jsontype.impl;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import tools.jackson.core.JacksonException;
import tools.jackson.databind.DatabindContext;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.DeserializationFeature;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.jsontype.NamedType;
import tools.jackson.databind.jsontype.PolymorphicTypeValidator;
import tools.jackson.databind.jsontype.impl.TypeIdResolverBase;
import tools.jackson.databind.util.ClassUtil;

public class ClassNameIdResolver
extends TypeIdResolverBase
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String JAVA_UTIL_PKG = "java.util.";
    protected final PolymorphicTypeValidator _subTypeValidator;
    protected final Set<String> _allowedSubtypes;

    public ClassNameIdResolver(JavaType baseType, Collection<NamedType> subtypes, PolymorphicTypeValidator ptv) {
        super(baseType);
        this._subTypeValidator = ptv;
        HashSet<String> allowedSubtypes = null;
        if (subtypes != null) {
            for (NamedType t : subtypes) {
                if (allowedSubtypes == null) {
                    allowedSubtypes = new HashSet<String>();
                }
                allowedSubtypes.add(t.getType().getName());
            }
        }
        this._allowedSubtypes = allowedSubtypes == null ? Collections.emptySet() : allowedSubtypes;
    }

    public static ClassNameIdResolver construct(JavaType baseType, Collection<NamedType> subtypes, PolymorphicTypeValidator ptv) {
        return new ClassNameIdResolver(baseType, subtypes, ptv);
    }

    @Override
    public JsonTypeInfo.Id getMechanism() {
        return JsonTypeInfo.Id.CLASS;
    }

    @Override
    public String idFromValue(DatabindContext ctxt, Object value) {
        return this._idFrom(ctxt, value, value.getClass());
    }

    @Override
    public String idFromValueAndType(DatabindContext ctxt, Object value, Class<?> type) {
        return this._idFrom(ctxt, value, type);
    }

    @Override
    public JavaType typeFromId(DatabindContext ctxt, String id) throws JacksonException {
        return this._typeFromId(ctxt, id);
    }

    protected JavaType _typeFromId(DatabindContext ctxt, String id) throws JacksonException {
        DeserializationContext deserializationContext = null;
        if (ctxt instanceof DeserializationContext) {
            deserializationContext = (DeserializationContext)ctxt;
        }
        if (this._allowedSubtypes != null && deserializationContext != null && deserializationContext.isEnabled(DeserializationFeature.FAIL_ON_SUBTYPE_CLASS_NOT_REGISTERED) && !this._allowedSubtypes.contains(id)) {
            throw deserializationContext.invalidTypeIdException(this._baseType, id, "`DeserializationFeature.FAIL_ON_SUBTYPE_CLASS_NOT_REGISTERED` is enabled and the input class is not registered using `@JsonSubTypes` annotation");
        }
        JavaType t = ctxt.resolveAndValidateSubType(this._baseType, id, this._subTypeValidator);
        if (t == null && deserializationContext != null) {
            return deserializationContext.handleUnknownTypeId(this._baseType, id, this, "no such class found");
        }
        return t;
    }

    protected String _idFrom(DatabindContext ctxt, Object value, Class<?> cls) {
        String str = (cls = this._resolveToParentAsNecessary(cls)).getName();
        if (str.startsWith(JAVA_UTIL_PKG)) {
            if (value instanceof EnumSet) {
                Class<? extends Enum<?>> enumClass = ClassUtil.findEnumType((EnumSet)value);
                str = ctxt.getTypeFactory().constructCollectionType(EnumSet.class, enumClass).toCanonical();
            } else if (value instanceof EnumMap) {
                Class<? extends Enum<?>> enumClass = ClassUtil.findEnumType((EnumMap)value);
                Class<Object> valueClass = Object.class;
                str = ctxt.getTypeFactory().constructMapType(EnumMap.class, enumClass, valueClass).toCanonical();
            }
        }
        return str;
    }

    @Override
    public String getDescForKnownTypeIds() {
        return "{class name used as type id}";
    }
}

