/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.runtime.formatting;

import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.formatting.FormattingBuffer;
import com.oracle.graal.python.runtime.formatting.InternalFormat;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import java.math.BigInteger;
import java.text.NumberFormat;

public class IntegerFormatter
extends InternalFormat.Formatter {
    public static final BigInteger LIMIT_UNICODE = BigInteger.valueOf(0x110000L);
    private static final String LOOKUP = "0123456789abcdef";

    public IntegerFormatter(FormattingBuffer result, InternalFormat.Spec spec, Node raisingNode) {
        super(result, spec, raisingNode);
    }

    public IntegerFormatter(InternalFormat.Spec spec, Node raisingNode) {
        super(new FormattingBuffer.StringFormattingBuffer(32), spec, raisingNode);
    }

    @Override
    public IntegerFormatter append(char c) {
        super.append(c);
        return this;
    }

    @Override
    public IntegerFormatter append(CharSequence csq) {
        super.append(csq);
        return this;
    }

    @Override
    public IntegerFormatter append(CharSequence csq, int begin, int end) throws IndexOutOfBoundsException {
        super.append(csq, begin, end);
        return this;
    }

    public IntegerFormatter format(BigInteger value) {
        try {
            this.setStart();
            switch (this.spec.type) {
                case 'd': 
                case '\uffff': {
                    this.format_d(value);
                    break;
                }
                case 'i': 
                case 'u': {
                    this.format_i(value);
                    break;
                }
                case 'x': {
                    this.format_x(value, false);
                    break;
                }
                case 'X': {
                    this.format_x(value, true);
                    break;
                }
                case 'o': {
                    this.format_o(value);
                    break;
                }
                case 'b': {
                    this.format_b(value);
                    break;
                }
                case '%': 
                case 'c': {
                    this.format_c(value);
                    break;
                }
                case 'n': {
                    this.format_d(value);
                    this.setGroupingAndGroupSize(IntegerFormatter.getCurrentDecimalFormat());
                    break;
                }
                default: {
                    throw IntegerFormatter.unknownFormat(this.spec.type, "integer", this.raisingNode);
                }
            }
            this.groupWholePartIfRequired();
            return this;
        }
        catch (OutOfMemoryError eme) {
            throw this.precisionTooLarge("long");
        }
    }

    void format_i(BigInteger value) {
        throw IntegerFormatter.unknownFormat(this.spec.type, "integer", this.raisingNode);
    }

    void format_i(int value) {
        throw IntegerFormatter.unknownFormat(this.spec.type, "integer", this.raisingNode);
    }

    void format_d(BigInteger value) {
        String number;
        if (value.signum() < 0) {
            this.negativeSign(null);
            number = value.negate().toString();
        } else {
            this.positiveSign(null);
            number = value.toString();
        }
        this.appendNumber(number);
    }

    void format_n(BigInteger value) {
        String number;
        NumberFormat nf = NumberFormat.getNumberInstance();
        if (value.signum() < 0) {
            this.negativeSign(null);
            number = nf.format(value.negate());
        } else {
            this.positiveSign(null);
            number = nf.format(value);
        }
        this.appendNumber(number);
    }

    void format_n(int value) {
        String number;
        NumberFormat nf = NumberFormat.getNumberInstance();
        if (value < 0) {
            this.negativeSign(null);
            number = nf.format(-value);
        } else {
            this.positiveSign(null);
            number = nf.format(value);
        }
        this.appendNumber(number);
    }

    void format_x(BigInteger value, boolean upper) {
        String number;
        String base;
        String string = base = upper ? "0X" : "0x";
        if (value.signum() < 0) {
            this.negativeSign(base);
            number = IntegerFormatter.toHexString(value.negate());
        } else {
            this.positiveSign(base);
            number = IntegerFormatter.toHexString(value);
        }
        if (upper) {
            number = number.toUpperCase();
        }
        this.appendNumber(number);
    }

    void format_o(BigInteger value) {
        String number;
        String base = "0o";
        if (value.signum() < 0) {
            this.negativeSign(base);
            number = IntegerFormatter.toOctalString(value.negate());
        } else {
            this.positiveSign(base);
            number = IntegerFormatter.toOctalString(value);
        }
        this.appendNumber(number);
    }

    void format_b(BigInteger value) {
        String number;
        String base = "0b";
        if (value.signum() < 0) {
            this.negativeSign(base);
            number = IntegerFormatter.toBinaryString(value.negate());
        } else {
            this.positiveSign(base);
            number = IntegerFormatter.toBinaryString(value);
        }
        this.appendNumber(number);
    }

    final void format_c(BigInteger value) {
        assert (!this.bytes);
        if (value.signum() < 0 || value.compareTo(LIMIT_UNICODE) >= 0) {
            throw PRaiseNode.raiseStatic(this.raisingNode, PythonErrorType.OverflowError, ErrorMessages.C_ARG_NOT_IN_RANGE, IntegerFormatter.toHexString(LIMIT_UNICODE));
        }
        this.result.appendCodePoint(value.intValue());
    }

    @CompilerDirectives.TruffleBoundary
    public IntegerFormatter format(int value) {
        try {
            this.setStart();
            switch (this.spec.type) {
                case 'd': 
                case '\uffff': {
                    this.format_d(value);
                    break;
                }
                case 'i': 
                case 'u': {
                    this.format_i(value);
                    break;
                }
                case 'x': {
                    this.format_x(value, false);
                    break;
                }
                case 'X': {
                    this.format_x(value, true);
                    break;
                }
                case 'o': {
                    this.format_o(value);
                    break;
                }
                case 'b': {
                    this.format_b(value);
                    break;
                }
                case '%': 
                case 'c': {
                    this.format_c(value);
                    break;
                }
                case 'n': {
                    this.format_d(value);
                    this.setGroupingAndGroupSize(IntegerFormatter.getCurrentDecimalFormat());
                    break;
                }
                default: {
                    throw IntegerFormatter.unknownFormat(this.spec.type, "int", this.raisingNode);
                }
            }
            this.groupWholePartIfRequired();
            return this;
        }
        catch (OutOfMemoryError eme) {
            throw this.precisionTooLarge("integer");
        }
    }

    void format_d(int value) {
        String number;
        if (value < 0) {
            this.negativeSign(null);
            number = Integer.toString(-value);
        } else {
            this.positiveSign(null);
            number = Integer.toString(value);
        }
        this.appendNumber(number);
    }

    void format_x(int value, boolean upper) {
        String number;
        String base;
        String string = base = upper ? "0X" : "0x";
        if (value < 0) {
            this.negativeSign(base);
            number = Integer.toHexString(-value);
        } else {
            this.positiveSign(base);
            number = Integer.toHexString(value);
        }
        if (upper) {
            number = number.toUpperCase();
        }
        this.appendNumber(number);
    }

    void format_o(int value) {
        String number;
        String base = "0o";
        if (value < 0) {
            this.negativeSign(base);
            number = Integer.toOctalString(-value);
        } else {
            this.positiveSign(base);
            number = Integer.toOctalString(value);
        }
        this.appendNumber(number);
    }

    void format_b(int value) {
        String number;
        String base = "0b";
        if (value < 0) {
            this.negativeSign(base);
            number = Integer.toBinaryString(-value);
        } else {
            this.positiveSign(base);
            number = Integer.toBinaryString(value);
        }
        this.appendNumber(number);
    }

    final void format_c(int value) {
        assert (!this.bytes);
        if (value < 0 || value >= LIMIT_UNICODE.intValue()) {
            throw PRaiseNode.raiseStatic(this.raisingNode, PythonErrorType.OverflowError, ErrorMessages.C_ARG_NOT_IN_RANGE, IntegerFormatter.toHexString(LIMIT_UNICODE));
        }
        this.result.appendCodePoint(value);
    }

    final void positiveSign(String base) {
        char sign = this.spec.sign;
        if (InternalFormat.Spec.specified(sign) && sign != '-') {
            this.append(sign);
            this.lenSign = 1;
        }
        if (base != null && this.spec.alternate) {
            this.append(base);
            this.lenSign += base.length();
        }
    }

    final void negativeSign(String base) {
        this.append('-');
        this.lenSign = 1;
        if (base != null && this.spec.alternate) {
            this.append(base);
            this.lenSign += base.length();
        }
    }

    void appendNumber(String number) {
        this.lenWhole = number.length();
        this.append(number);
    }

    private static String toHexString(BigInteger value) {
        int signum = value.signum();
        if (signum == 0) {
            return "0";
        }
        byte[] input = value.abs().toByteArray();
        FormattingBuffer.StringFormattingBuffer sb = new FormattingBuffer.StringFormattingBuffer(input.length * 2);
        for (int i = 0; i < input.length; ++i) {
            int b = input[i] & 0xFF;
            sb.append(LOOKUP.charAt(b >> 4));
            sb.append(LOOKUP.charAt(b & 0xF));
        }
        String result = sb.toString().replaceFirst("^0+(?!$)", "");
        return signum < 0 ? "-" + result : result;
    }

    private static String toOctalString(BigInteger value) {
        int signum = value.signum();
        if (signum == 0) {
            return "0";
        }
        byte[] input = value.abs().toByteArray();
        if (input.length < 3) {
            return value.toString(8);
        }
        StringBuilder sb = new StringBuilder(input.length * 3);
        for (int i = input.length - 1; i >= 0; i -= 3) {
            int trip3 = input[i] & 0xFF;
            int trip2 = i - 1 >= 0 ? input[i - 1] & 0xFF : 0;
            int trip1 = i - 2 >= 0 ? input[i - 2] & 0xFF : 0;
            int threebytes = trip3 | trip2 << 8 | trip1 << 16;
            for (int j = 0; j < 8; ++j) {
                sb.append(LOOKUP.charAt(threebytes >> j * 3 & 7));
            }
        }
        String result = sb.reverse().toString().replaceFirst("^0+(?!%)", "");
        return signum < 0 ? "-" + result : result;
    }

    private static String toBinaryString(BigInteger value) {
        int signum = value.signum();
        if (signum == 0) {
            return "0";
        }
        byte[] input = value.abs().toByteArray();
        FormattingBuffer.StringFormattingBuffer sb = new FormattingBuffer.StringFormattingBuffer(value.bitCount());
        for (int i = 0; i < input.length; ++i) {
            int b = input[i] & 0xFF;
            for (int bit = 7; bit >= 0; --bit) {
                sb.append((b >> bit & 1) > 0 ? "1" : "0");
            }
        }
        String result = sb.toString().replaceFirst("^0+(?!$)", "");
        return signum < 0 ? "-" + result : result;
    }

    public static class Traditional
    extends IntegerFormatter {
        public Traditional(FormattingBuffer result, InternalFormat.Spec spec, Node raisingNode) {
            super(result, spec, raisingNode);
        }

        @Override
        void format_i(BigInteger value) {
            this.format_d(value);
        }

        @Override
        void format_i(int value) {
            this.format_d(value);
        }

        @Override
        void appendNumber(String number) {
            int n;
            int p = this.spec.getPrecision(0);
            this.result.ensureAdditionalCapacity(p);
            for (n = number.length(); n < p; ++n) {
                this.result.append('0');
            }
            this.lenWhole = n;
            this.append(number);
        }
    }
}

