/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.typing;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNotImplemented;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotRichCompare;
import com.oracle.graal.python.builtins.objects.typing.PParamSpec;
import com.oracle.graal.python.builtins.objects.typing.PParamSpecArgs;
import com.oracle.graal.python.builtins.objects.typing.ParamSpecArgsBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.typing.ParamSpecArgsBuiltinsSlotsGen;
import com.oracle.graal.python.lib.PyObjectReprAsTruffleStringNode;
import com.oracle.graal.python.lib.PyObjectRichCompareBool;
import com.oracle.graal.python.lib.RichCmpOp;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PParamSpecArgs})
public final class ParamSpecArgsBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = ParamSpecArgsBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return ParamSpecArgsBuiltinsFactory.getFactories();
    }

    @GenerateInline
    @GenerateCached(value=false)
    static abstract class GetOriginNameHelperNode
    extends Node {
        GetOriginNameHelperNode() {
        }

        abstract TruffleString execute(VirtualFrame var1, Node var2, Object var3);

        @Specialization
        static TruffleString doParamSpec(PParamSpec origin) {
            return origin.name;
        }

        @Fallback
        static TruffleString doGeneric(VirtualFrame frame, Node inliningTarget, Object origin, @Cached PyObjectReprAsTruffleStringNode reprNode) {
            return reprNode.execute((Frame)frame, inliningTarget, origin);
        }
    }

    @Slot(value=Slot.SlotKind.tp_richcompare, isComplex=true)
    @GenerateNodeFactory
    public static abstract class EqNode
    extends TpSlotRichCompare.RichCmpBuiltinNode {
        @Specialization
        static Object doIt(VirtualFrame frame, PParamSpecArgs self, PParamSpecArgs other, RichCmpOp op, @Bind Node inliningTarget, @Cached PyObjectRichCompareBool eqNode) {
            return eqNode.execute((Frame)frame, inliningTarget, self.origin, other.origin, op);
        }

        @Fallback
        static PNotImplemented wrongTypes(Object self, Object other, RichCmpOp op) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }
    }

    @Builtin(name="__mro_entries__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class MroEntriesNode
    extends PythonBinaryBuiltinNode {
        MroEntriesNode() {
        }

        @Specialization
        static Object mro(PParamSpecArgs self, Object bases, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.CANNOT_SUBCLASS_AN_INSTANCE_OF_PARAMSPEC_ARGS);
        }
    }

    @Slot(value=Slot.SlotKind.tp_repr, isComplex=true)
    @GenerateNodeFactory
    static abstract class ReprNode
    extends PythonUnaryBuiltinNode {
        private static final TruffleString T_ARGS = PythonUtils.tsLiteral(".args");

        ReprNode() {
        }

        @Specialization
        static TruffleString reprParamSpec(VirtualFrame frame, PParamSpecArgs self, @Bind Node inliningTarget, @Cached GetOriginNameHelperNode helper, @Cached TruffleString.ConcatNode concatNode) {
            return concatNode.execute((AbstractTruffleString)helper.execute(frame, inliningTarget, self.origin), (AbstractTruffleString)T_ARGS, PythonUtils.TS_ENCODING, true);
        }
    }

    @Builtin(name="__origin__", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class GetNameNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object doOrigin(PParamSpecArgs self) {
            return self.origin;
        }
    }

    @Slot(value=Slot.SlotKind.tp_new, isComplex=true)
    @Slot.SlotSignature(name="ParamSpecArgs", minNumOfPositionalArgs=2, parameterNames={"$cls", "origin"})
    @GenerateNodeFactory
    static abstract class ParamSpecArgsNode
    extends PythonBinaryBuiltinNode {
        ParamSpecArgsNode() {
        }

        @Specialization
        static PParamSpecArgs newParamSpecArgs(Object cls, Object origin, @Bind PythonLanguage language, @Cached TypeNodes.GetInstanceShape getInstanceShape) {
            return PFactory.createParamSpecArgs(language, cls, getInstanceShape.execute(cls), origin);
        }
    }
}

