/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.bz2;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.bz2.BZ2CompressorBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.modules.bz2.BZ2CompressorBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.bz2.BZ2CompressorBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.modules.bz2.BZ2Object;
import com.oracle.graal.python.builtins.modules.bz2.Bz2Nodes;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.bytes.BytesNodes;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.bytes.PBytesLike;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.runtime.GilNode;
import com.oracle.graal.python.runtime.NFIBz2Support;
import com.oracle.graal.python.runtime.NativeLibrary;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.BZ2Compressor})
public final class BZ2CompressorBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = BZ2CompressorBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return BZ2CompressorBuiltinsFactory.getFactories();
    }

    @Builtin(name="flush", minNumOfPositionalArgs=1, parameterNames={"$self"})
    @GenerateNodeFactory
    static abstract class FlushNode
    extends PythonUnaryBuiltinNode {
        FlushNode() {
        }

        @Specialization(guards={"!self.isFlushed()"})
        static PBytes doit(BZ2Object.BZ2Compressor self, @Bind Node inliningTarget, @Bind PythonContext context, @Cached Bz2Nodes.Bz2NativeCompress compress) {
            self.setFlushed();
            return PFactory.createBytes(context.getLanguage(inliningTarget), compress.flush(self, context));
        }

        @Specialization(guards={"self.isFlushed()"})
        static PNone error(BZ2Object.BZ2Compressor self, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.REPEATED_CALL_TO_FLUSH);
        }
    }

    @Builtin(name="compress", minNumOfPositionalArgs=2, parameterNames={"$self", "$data"})
    @GenerateNodeFactory
    static abstract class CompressNode
    extends PythonBinaryBuiltinNode {
        CompressNode() {
        }

        @Specialization(guards={"!self.isFlushed()"})
        static PBytes doNativeBytes(BZ2Object.BZ2Compressor self, PBytesLike data, @Bind Node inliningTarget, @Bind PythonContext context, @Cached SequenceStorageNodes.GetInternalByteArrayNode toBytes, @Cached.Shared(value="c") @Cached Bz2Nodes.Bz2NativeCompress compress) {
            byte[] bytes = toBytes.execute(inliningTarget, data.getSequenceStorage());
            int len = data.getSequenceStorage().length();
            return PFactory.createBytes(context.getLanguage(inliningTarget), compress.compress(self, context, bytes, len));
        }

        @Specialization(guards={"!self.isFlushed()"})
        static PBytes doNativeObject(VirtualFrame frame, BZ2Object.BZ2Compressor self, Object data, @Bind Node inliningTarget, @Bind PythonContext context, @Cached BytesNodes.ToBytesNode toBytes, @Cached.Shared(value="c") @Cached Bz2Nodes.Bz2NativeCompress compress) {
            byte[] bytes = toBytes.execute(frame, data);
            int len = bytes.length;
            return PFactory.createBytes(context.getLanguage(inliningTarget), compress.compress(self, context, bytes, len));
        }

        @Specialization(guards={"self.isFlushed()"})
        static PNone error(BZ2Object.BZ2Compressor self, Object data, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.COMPRESSOR_HAS_BEEN_FLUSHED);
        }
    }

    @Slot(value=Slot.SlotKind.tp_init, isComplex=true)
    @Slot.SlotSignature(name="BZ2Compressor", minNumOfPositionalArgs=1, parameterNames={"$self", "compresslevel"})
    @ArgumentClinic(name="compresslevel", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="9", useDefaultForNone=true)
    @GenerateNodeFactory
    public static abstract class InitNode
    extends PythonBinaryClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return BZ2CompressorBuiltinsClinicProviders.InitNodeClinicProviderGen.INSTANCE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"compresslevel >= 1", "compresslevel <= 9"})
        PNone init(BZ2Object.BZ2Compressor self, int compresslevel, @Bind Node inliningTarget, @Cached NativeLibrary.InvokeNativeFunction createStream, @Cached NativeLibrary.InvokeNativeFunction compressInit, @Cached GilNode gil, @Cached PRaiseNode raiseNode) {
            gil.release(true);
            try {
                NFIBz2Support bz2Support = PythonContext.get(this).getNFIBz2Support();
                Object bzst = bz2Support.createStream(createStream);
                int err = bz2Support.compressInit(bzst, compresslevel, compressInit);
                if (err != 0) {
                    Bz2Nodes.errorHandling(inliningTarget, err, raiseNode);
                }
                self.init(bzst, bz2Support);
                PNone pNone = PNone.NONE;
                return pNone;
            }
            finally {
                gil.acquire();
            }
        }

        @Fallback
        static Object err(Object self, Object compresslevel, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.COMPRESSLEVEL_MUST_BE_BETWEEN_1_AND_9);
        }
    }

    @Slot(value=Slot.SlotKind.tp_new, isComplex=true)
    @Slot.SlotSignature(name="BZ2Compressor", minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true)
    @GenerateNodeFactory
    public static abstract class BZ2CompressorNode
    extends PythonBuiltinNode {
        @Specialization
        static BZ2Object.BZ2Compressor doNew(Object cls, Object arg, @Bind PythonLanguage language) {
            return PFactory.createBZ2Compressor(language);
        }
    }
}

