/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules;

import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.NativeCAPISymbol;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.runtime.PosixConstants;
import com.oracle.truffle.api.dsl.NodeFactory;
import java.util.Collections;
import java.util.List;

@CoreFunctions(defineModule="mmap")
public final class MMapModuleBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return Collections.emptyList();
    }

    public MMapModuleBuiltins() {
        this.addBuiltinConstant("ACCESS_DEFAULT", (Object)0);
        this.addBuiltinConstant("ACCESS_READ", (Object)1);
        this.addBuiltinConstant("ACCESS_WRITE", (Object)2);
        this.addBuiltinConstant("ACCESS_COPY", (Object)3);
        this.addBuiltinConstant("ALLOCATIONGRANULARITY", (Object)4096);
        this.addBuiltinConstant("PAGESIZE", (Object)4096);
        for (PosixConstants.IntConstant c : PosixConstants.mmapFlags) {
            if (!c.defined) continue;
            this.addBuiltinConstant(c.name, (Object)c.getValueIfDefined());
        }
        for (PosixConstants.IntConstant c : PosixConstants.mmapProtection) {
            if (!c.defined) continue;
            this.addBuiltinConstant(c.name, (Object)c.getValueIfDefined());
        }
    }

    @Override
    public void postInitialize(Python3Core core) {
        super.postInitialize(core);
        core.getContext().registerCApiHook(() -> CExtNodes.PCallCapiFunction.callUncached(NativeCAPISymbol.FUN_MMAP_INIT_BUFFERPROTOCOL, CApiTransitions.PythonToNativeNode.executeUncached((Object)PythonBuiltinClassType.PMMap)));
    }
}

