/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins;

import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.strings.TruffleString;

public enum PythonOS {
    PLATFORM_JAVA("java", "Java"),
    PLATFORM_CYGWIN("cygwin", "CYGWIN"),
    PLATFORM_LINUX("linux", "Linux"),
    PLATFORM_DARWIN("darwin", "Darwin"),
    PLATFORM_WIN32("win32", "Windows"),
    PLATFORM_SUNOS("sunos", "SunOS"),
    PLATFORM_FREEBSD("freebsd", "FreeBSD"),
    PLATFORM_ANY(null, null);

    private final TruffleString name;
    private final TruffleString uname;
    private static final PythonOS current;

    private PythonOS(String name, String uname) {
        this.name = PythonUtils.toTruffleStringUncached(name);
        this.uname = PythonUtils.toTruffleStringUncached(uname);
    }

    public TruffleString getName() {
        return this.name;
    }

    public TruffleString getUname() {
        return this.uname;
    }

    public static PythonOS getPythonOS() {
        return current;
    }

    static {
        String property = System.getProperty("os.name");
        PythonOS os = PLATFORM_JAVA;
        if (property != null) {
            if ((property = property.toLowerCase()).contains("cygwin")) {
                os = PLATFORM_CYGWIN;
            } else if (property.contains("linux")) {
                os = PLATFORM_LINUX;
            } else if (property.contains("mac")) {
                os = PLATFORM_DARWIN;
            } else if (property.contains("windows")) {
                os = PLATFORM_WIN32;
            } else if (property.contains("sunos")) {
                os = PLATFORM_SUNOS;
            } else if (property.contains("freebsd")) {
                os = PLATFORM_FREEBSD;
            }
        }
        current = os;
    }
}

