/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.geometric;

import com.amazon.redshift.geometric.RedshiftPoint;
import com.amazon.redshift.util.GT;
import com.amazon.redshift.util.RedshiftException;
import com.amazon.redshift.util.RedshiftObject;
import com.amazon.redshift.util.RedshiftState;
import com.amazon.redshift.util.RedshiftTokenizer;
import java.io.Serializable;
import java.sql.SQLException;

public class RedshiftCircle
extends RedshiftObject
implements Serializable,
Cloneable {
    public RedshiftPoint center;
    public double radius;

    public RedshiftCircle(double x, double y, double r) {
        this(new RedshiftPoint(x, y), r);
    }

    public RedshiftCircle(RedshiftPoint c, double r) {
        this();
        this.center = c;
        this.radius = r;
    }

    public RedshiftCircle(String s) throws SQLException {
        this();
        this.setValue(s);
    }

    public RedshiftCircle() {
        this.setType("circle");
    }

    @Override
    public void setValue(String s) throws SQLException {
        RedshiftTokenizer t = new RedshiftTokenizer(RedshiftTokenizer.removeAngle(s), ',');
        if (t.getSize() != 2) {
            throw new RedshiftException(GT.tr("Conversion to type {0} failed: {1}.", this.type, s), RedshiftState.DATA_TYPE_MISMATCH);
        }
        try {
            this.center = new RedshiftPoint(t.getToken(0));
            this.radius = Double.parseDouble(t.getToken(1));
        }
        catch (NumberFormatException e) {
            throw new RedshiftException(GT.tr("Conversion to type {0} failed: {1}.", this.type, s), RedshiftState.DATA_TYPE_MISMATCH, (Throwable)e);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof RedshiftCircle) {
            RedshiftCircle p = (RedshiftCircle)obj;
            return p.center.equals(this.center) && p.radius == this.radius;
        }
        return false;
    }

    @Override
    public int hashCode() {
        long v = Double.doubleToLongBits(this.radius);
        return (int)((long)this.center.hashCode() ^ v ^ v >>> 32);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        RedshiftCircle newRScircle = (RedshiftCircle)super.clone();
        if (newRScircle.center != null) {
            newRScircle.center = (RedshiftPoint)newRScircle.center.clone();
        }
        return newRScircle;
    }

    @Override
    public String getValue() {
        return "<" + this.center + "," + this.radius + ">";
    }
}

