/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.internal.proxy;

import com.ibm.db2.cmx.client.ManageableProxy;
import com.ibm.db2.cmx.runtime.exception.ExceptionFactory;
import com.ibm.db2.cmx.runtime.internal.proxy.PDQProxy;
import com.ibm.db2.cmx.runtime.internal.proxy.ProxiedJdbcConnectionInvocationHandler;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.runtime.internal.trace.DataLogger;
import com.ibm.db2.cmx.runtime.internal.trace.Log;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;

public abstract class ProxiedXAResourceInvocationHandler
implements ManageableProxy,
InvocationHandler,
PDQProxy {
    XAResource target_;
    private static Logger logger__ = Log.getCMXClientLogger();
    ProxiedJdbcConnectionInvocationHandler proxiedConnection_ = null;
    private boolean proxiedConnectionOriginalAutoCommitValue_;

    public ProxiedXAResourceInvocationHandler(XAResource xAResource) {
        this.target_ = xAResource;
        if (logger__.isLoggable(Level.FINER)) {
            DataLogger.logMonitorMessage(logger__, this, "<init>", "XAResource proxy created for: " + xAResource);
        }
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        boolean bl2;
        Object object2 = null;
        String string = method.getName();
        if (logger__.isLoggable(Level.FINER) && !"toString".equals(string) && !"hashCode".equals(string) && !"equals".equals(string)) {
            DataLogger.logAtLevelFiner(logger__, this, "invoke: " + string, "ENTRY " + Arrays.deepToString(objectArray));
            bl2 = true;
        } else {
            bl2 = false;
        }
        try {
            if (string.equals("pushData")) {
                this.pushData((Integer)objectArray[0], (Object[])objectArray[1], true);
            } else if (string.equals("rollback")) {
                this.invokeMethodAndDoTransactionBoundryLogic(method, objectArray, true);
            } else if (string.equals("start")) {
                this.proxiedConnection_.applyDynamicPushDownProperties();
                object2 = method.invoke((Object)this.target_, objectArray);
                this.proxiedConnectionOriginalAutoCommitValue_ = this.proxiedConnection_.autoCommit_;
                this.proxiedConnection_.autoCommit_ = false;
            } else if (string.equals("end")) {
                this.proxiedConnection_.autoCommit_ = this.proxiedConnectionOriginalAutoCommitValue_;
                this.invokeMethodAndDoTransactionBoundryLogic(method, objectArray, false);
            } else {
                object2 = method.invoke((Object)this.target_, objectArray);
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof SQLException) {
                this.proxiedConnection_.proxiedDataSource_.checkAndReportApplnException((SQLException)throwable);
            }
            if (throwable instanceof XAException && this.proxiedConnection_ != null) {
                this.proxiedConnection_.doTransactionBoundaryLogic(true);
            }
            DataLogger.logThrowable(logger__, throwable);
            throw throwable;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(null, Messages.getText("ERR_PROFILER_ILLEGAL_ACCESS_EXCEPTION", method.getName(), illegalAccessException.getMessage()), illegalAccessException, 10644);
        }
        if (bl2) {
            DataLogger.exit(logger__, this, "invoke: " + string, object2);
        }
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeMethodAndDoTransactionBoundryLogic(Method method, Object[] objectArray, boolean bl2) throws IllegalAccessException, InvocationTargetException {
        try {
            method.invoke((Object)this.target_, objectArray);
        }
        finally {
            if (this.proxiedConnection_ != null) {
                this.proxiedConnection_.doTransactionBoundaryLogic(bl2);
            }
        }
    }

    @Override
    public void pushData(int n2, Object[] objectArray, boolean bl2) {
    }

    public void setProxiedConnection(ProxiedJdbcConnectionInvocationHandler proxiedJdbcConnectionInvocationHandler) {
        this.proxiedConnection_ = proxiedJdbcConnectionInvocationHandler;
    }
}

