/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.linter;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import schemacrawler.schema.Column;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.Identifiers;
import schemacrawler.schemacrawler.IdentifiersBuilder;
import schemacrawler.tools.lint.BaseLinter;
import schemacrawler.tools.lint.LintCollector;
import us.fatehi.utility.property.PropertyName;

class LinterTableWithQuotedNames
extends BaseLinter {
    LinterTableWithQuotedNames(PropertyName propertyName, LintCollector lintCollector) {
        super(propertyName, lintCollector);
    }

    @Override
    public String getSummary() {
        return "spaces in name, or reserved word";
    }

    @Override
    protected void lint(Table table, Connection connection) {
        Objects.requireNonNull(table, "No table provided");
        Identifiers identifiers = IdentifiersBuilder.builder().fromConnection(connection).toOptions();
        String tableName = table.getName();
        if (identifiers.isToBeQuoted(tableName)) {
            this.addTableLint(table, this.getSummary());
        }
        List<String> spacesInNamesList = this.findColumnsWithQuotedNames(this.getColumns(table), identifiers);
        for (String spacesInName : spacesInNamesList) {
            this.addTableLint(table, this.getSummary(), spacesInName);
        }
    }

    private List<String> findColumnsWithQuotedNames(List<Column> columns, Identifiers identifiers) {
        ArrayList<String> columnsWithQuotedNames = new ArrayList<String>();
        for (Column column : columns) {
            String columnName = column.getName();
            if (!identifiers.isToBeQuoted(columnName)) continue;
            columnsWithQuotedNames.add(columnName);
        }
        return columnsWithQuotedNames;
    }
}

