/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.binary;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.binary.JSConcatStringsNodeGen;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.Strings;

public abstract class JSConcatStringsNode
extends JavaScriptBaseNode {
    protected final int stringLengthLimit;

    protected JSConcatStringsNode(int stringLengthLimit) {
        this.stringLengthLimit = stringLengthLimit;
    }

    @NeverDefault
    public static JSConcatStringsNode create(int stringLengthLimit) {
        return JSConcatStringsNodeGen.create(stringLengthLimit);
    }

    @NeverDefault
    public static JSConcatStringsNode create() {
        return JSConcatStringsNode.create(JavaScriptLanguage.getCurrentLanguage().getJSContext().getStringLengthLimit());
    }

    public abstract TruffleString executeTString(TruffleString var1, TruffleString var2);

    @Specialization
    protected final TruffleString doConcat(TruffleString left, TruffleString right, @Cached InlinedBranchProfile errorBranch, @Cached TruffleString.ConcatNode concatNode) {
        this.validateStringLength(Strings.length(left) + Strings.length(right), errorBranch);
        return Strings.concat(concatNode, left, right);
    }

    private void validateStringLength(int resultLength, InlinedBranchProfile errorBranch) {
        if (CompilerDirectives.injectBranchProbability((double)1.0E-4, (resultLength < 0 || resultLength > this.stringLengthLimit ? 1 : 0) != 0)) {
            errorBranch.enter((Node)this);
            throw Errors.createRangeErrorInvalidStringLength(this);
        }
    }
}

