/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.intl;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.intl.PluralRulesPrototypeBuiltinsFactory;
import com.oracle.truffle.js.nodes.cast.JSToDoubleNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.intl.JSPluralRules;
import com.oracle.truffle.js.runtime.builtins.intl.JSPluralRulesObject;
import com.oracle.truffle.js.runtime.objects.Undefined;

public final class PluralRulesPrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<PluralRulesPrototype> {
    public static final JSBuiltinsContainer BUILTINS = new PluralRulesPrototypeBuiltins();

    protected PluralRulesPrototypeBuiltins() {
        super(JSPluralRules.PROTOTYPE_NAME, PluralRulesPrototype.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, PluralRulesPrototype builtinEnum) {
        switch (builtinEnum.ordinal()) {
            case 0: {
                return PluralRulesPrototypeBuiltinsFactory.JSPluralRulesResolvedOptionsNodeGen.create(context, builtin, PluralRulesPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 1: {
                return PluralRulesPrototypeBuiltinsFactory.JSPluralRulesSelectNodeGen.create(context, builtin, PluralRulesPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 2: {
                return PluralRulesPrototypeBuiltinsFactory.JSPluralRulesSelectRangeNodeGen.create(context, builtin, PluralRulesPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
        }
        return null;
    }

    public static enum PluralRulesPrototype implements BuiltinEnum<PluralRulesPrototype>
    {
        resolvedOptions(0),
        select(1),
        selectRange(2);

        private final int length;

        private PluralRulesPrototype(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public int getECMAScriptVersion() {
            return switch (this.ordinal()) {
                case 2 -> 14;
                default -> BuiltinEnum.super.getECMAScriptVersion();
            };
        }
    }

    public static abstract class JSPluralRulesResolvedOptionsNode
    extends JSBuiltinNode {
        public JSPluralRulesResolvedOptionsNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        public Object doResolvedOptions(JSPluralRulesObject pluralRules) {
            return JSPluralRules.resolvedOptions(this.getContext(), this.getRealm(), pluralRules);
        }

        @Fallback
        public Object throwTypeError(Object bummer) {
            throw Errors.createTypeErrorTypeXExpected(JSPluralRules.CLASS_NAME);
        }
    }

    public static abstract class JSPluralRulesSelectNode
    extends JSBuiltinNode {
        public JSPluralRulesSelectNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        public Object doSelect(JSPluralRulesObject pluralRules, Object value, @Cached JSToDoubleNode toDoubleNode) {
            return JSPluralRules.select(pluralRules, toDoubleNode.executeDouble(value));
        }

        @Fallback
        public Object throwTypeError(Object bummer, Object value) {
            throw Errors.createTypeErrorTypeXExpected(JSPluralRules.CLASS_NAME);
        }
    }

    public static abstract class JSPluralRulesSelectRangeNode
    extends JSBuiltinNode {
        public JSPluralRulesSelectRangeNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        public Object doSelectRange(JSPluralRulesObject pluralRules, Object start, Object end, @Cached JSToDoubleNode startToDouble, @Cached JSToDoubleNode endToDouble, @Cached InlinedBranchProfile errorBranch) {
            if (start == Undefined.instance || end == Undefined.instance) {
                errorBranch.enter((Node)this);
                throw Errors.createTypeError("invalid range");
            }
            double x = startToDouble.executeDouble(start);
            double y = endToDouble.executeDouble(end);
            if (Double.isNaN(x) || Double.isNaN(y)) {
                errorBranch.enter((Node)this);
                throw Errors.createRangeError("invalid range");
            }
            return JSPluralRules.selectRange(pluralRules, x, y);
        }

        @Fallback
        public Object throwTypeError(Object bummer, Object start, Object end) {
            throw Errors.createTypeErrorTypeXExpected(JSPluralRules.CLASS_NAME);
        }
    }
}

