/*
 * Decompiled with CFR 0.152.
 */
package us.fatehi.utility.ioresource;

import java.nio.file.Path;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import us.fatehi.utility.Utility;
import us.fatehi.utility.ioresource.BaseInputResource;
import us.fatehi.utility.ioresource.ClasspathInputResource;
import us.fatehi.utility.ioresource.FileInputResource;
import us.fatehi.utility.ioresource.InputResource;
import us.fatehi.utility.string.StringFormat;

public class InputResourceUtility {
    private static final Logger LOGGER = Logger.getLogger(InputResourceUtility.class.getName());

    public static Optional<InputResource> createInputResource(String inputResourceName) {
        BaseInputResource inputResource = null;
        if (!Utility.isBlank(inputResourceName)) {
            try {
                LOGGER.log(Level.FINE, new StringFormat("Attempting to read file <%s>", inputResourceName));
                Path filePath = Path.of(inputResourceName, new String[0]);
                inputResource = new FileInputResource(filePath);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (inputResource == null) {
                    LOGGER.log(Level.FINE, new StringFormat("Attempting to read classpath resource <%s>", inputResourceName));
                    inputResource = new ClasspathInputResource(inputResourceName);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (inputResource == null) {
                LOGGER.log(Level.INFO, new StringFormat("Could not locate input resource <%s>", inputResourceName));
            }
        }
        return Optional.ofNullable(inputResource);
    }

    private InputResourceUtility() {
    }
}

