/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.jdbc.nl;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Executable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Logger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.net.jdbc.nl.NLException;
import oracle.net.jdbc.nl.NVFactory;
import oracle.net.jdbc.nl.NVPair;

public class NLParamParser {
    private String filename;
    private Hashtable ht;
    private Vector linebuffer;
    private int filePermissions = 0;
    private int Commentcnt = 0;
    private int nvStringcnt = 0;
    private int Groupcnt = 0;
    private boolean hasComments = false;
    private boolean hasGroups = false;
    private String[] errstr;
    private int errstrcnt;
    private static final int MAX_ERRORS = 50;
    public static final byte IGNORE_NONE = 0;
    public static final byte IGNORE_NL_EXCEPTION = 1;
    public static final byte IGNORE_FILE_EXCEPTION = 2;
    public static final byte NLPASUCC = 1;
    public static final byte NLPAOVWR = 2;
    public static final byte NLPAFAIL = -1;
    private static boolean DEBUG;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;

    public static NLParamParser createEmptyParamParser() {
        return new NLParamParser();
    }

    private NLParamParser() {
        this.filename = null;
        this.ht = new Hashtable(128);
    }

    public NLParamParser(String filename) throws IOException, NLException {
        this(filename, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NLParamParser(String filename, byte ignore_exception) throws NLException, IOException {
        this.filename = filename;
        this.ht = new Hashtable(128);
        FileReader fr = null;
        BufferedReader br = null;
        try {
            fr = new FileReader(filename);
            br = new BufferedReader(fr);
            this.initializeNlpa(br, ignore_exception);
        }
        catch (FileNotFoundException e2) {
            if ((ignore_exception & 2) == 0) {
                throw new FileNotFoundException(filename);
            }
        }
        finally {
            if (fr != null) {
                fr.close();
            }
            if (br != null) {
                br.close();
            }
        }
    }

    public NLParamParser(Reader dataStream) throws IOException, NLException {
        this(dataStream, 0);
    }

    public NLParamParser(Reader dataStream, byte ignore_exception) throws IOException, NLException {
        BufferedReader br = new BufferedReader(dataStream);
        this.filename = null;
        this.ht = new Hashtable(128);
        this.initializeNlpa(br, ignore_exception);
    }

    private void initializeNlpa(BufferedReader br, byte ignore_exception) throws IOException, NLException {
        block28: {
            this.linebuffer = new Vector(100, 50);
            this.errstr = new String[50];
            try {
                String newline;
                while ((newline = br.readLine()) != null) {
                    this.linebuffer.addElement(newline);
                }
            }
            catch (IOException e2) {
                if ((ignore_exception & 2) != 0) break block28;
                throw new IOException("Unable to read a line from : " + this.filename);
            }
        }
        String nvElem = "";
        String linesep = NVPair.LINE_SEPARATOR;
        String commentKey = "";
        String commentValue = "";
        for (int i2 = 0; i2 < this.linebuffer.size(); ++i2) {
            block32: {
                String line;
                block31: {
                    line = (String)this.linebuffer.elementAt(i2);
                    if (line.length() == 0) continue;
                    if (line.charAt(0) == '#') {
                        if (line.indexOf(".ORA Configuration ") != -1 || line.indexOf(" Network Configuration File: ") != -1 || line.indexOf("Generated by") != -1) {
                            if (!DEBUG) continue;
                            System.out.println(line + ": this comment ignored");
                            continue;
                        }
                        if (commentKey.length() != 0) {
                            commentValue = commentValue + line + linesep;
                            continue;
                        }
                        commentKey = "COMMENT#" + this.Commentcnt;
                        commentValue = line + linesep;
                        if (this.hasComments) continue;
                        this.hasComments = true;
                        continue;
                    }
                    if (line.charAt(0) == ' ' || line.charAt(0) == '\t' || line.charAt(0) == ')' || line.charAt(0) == '(') {
                        if (commentValue.length() == 0) {
                            if (nvElem.length() == 0) {
                                line = this.eatNLPWS(line);
                            }
                            if ((line = this.checkNLPforComments(line)).length() == 0) continue;
                            nvElem = nvElem + line + linesep;
                            continue;
                        }
                        if (nvElem.length() == 0 && commentValue.length() != 0) {
                            line = this.eatNLPWS(line);
                            if ((line = this.checkNLPforComments(line)).length() == 0 || (ignore_exception & 1) != 0) continue;
                            throw new NLException("InvalidChar-04611", "");
                        }
                        if (nvElem.length() == 0 || commentValue.length() == 0) continue;
                        commentKey = "";
                        commentValue = "";
                        line = this.checkNLPforComments(line);
                        nvElem = nvElem + line + linesep;
                        continue;
                    }
                    if (nvElem.length() == 0 && commentValue.length() == 0) {
                        line = this.checkNLPforComments(line);
                        nvElem = nvElem + line + linesep;
                        continue;
                    }
                    if (nvElem.length() == 0 && commentValue.length() != 0) {
                        block29: {
                            commentValue = this.modifyCommentString(commentValue);
                            try {
                                this.addNLPListElement(commentKey + "=" + commentValue);
                            }
                            catch (NLException e3) {
                                this.storeError(nvElem, ignore_exception);
                                if ((ignore_exception & 1) != 0) break block29;
                                throw e3;
                            }
                        }
                        commentKey = "";
                        commentValue = "";
                        ++this.Commentcnt;
                        line = this.checkNLPforComments(line);
                        nvElem = nvElem + line + linesep;
                        continue;
                    }
                    if (nvElem.length() != 0 && commentValue.length() == 0) {
                        block30: {
                            try {
                                this.addNLPListElement(nvElem);
                            }
                            catch (NLException e4) {
                                this.storeError(nvElem, ignore_exception);
                                if ((ignore_exception & 1) != 0) break block30;
                                throw e4;
                            }
                        }
                        nvElem = "";
                        line = this.checkNLPforComments(line);
                        nvElem = nvElem + line + linesep;
                        continue;
                    }
                    if (nvElem.length() == 0 || commentValue.length() == 0) continue;
                    try {
                        this.addNLPListElement(nvElem);
                    }
                    catch (NLException e5) {
                        this.storeError(nvElem, ignore_exception);
                        if ((ignore_exception & 1) != 0) break block31;
                        throw e5;
                    }
                }
                nvElem = "";
                line = this.checkNLPforComments(line);
                nvElem = nvElem + line + linesep;
                commentValue = this.modifyCommentString(commentValue);
                try {
                    this.addNLPListElement(commentKey + "=" + commentValue);
                }
                catch (NLException e6) {
                    this.storeError(nvElem, ignore_exception);
                    if ((ignore_exception & 1) != 0) break block32;
                    throw e6;
                }
            }
            commentKey = "";
            commentValue = "";
            ++this.Commentcnt;
        }
        if (nvElem.length() != 0) {
            block33: {
                try {
                    this.addNLPListElement(nvElem);
                }
                catch (NLException e7) {
                    this.storeError(nvElem, ignore_exception);
                    if ((ignore_exception & 1) != 0) break block33;
                    throw e7;
                }
            }
            nvElem = "";
        }
        if (commentValue.length() != 0) {
            block34: {
                commentValue = this.modifyCommentString(commentValue);
                try {
                    this.addNLPListElement(commentKey + "=" + commentValue);
                }
                catch (NLException e8) {
                    this.storeError(nvElem, ignore_exception);
                    if ((ignore_exception & 1) != 0) break block34;
                    throw e8;
                }
            }
            commentKey = "";
            commentValue = "";
            ++this.Commentcnt;
        }
    }

    private String modifyCommentString(String str) {
        String str1 = "";
        boolean offset = false;
        block7: for (int i2 = 0; i2 < str.length(); ++i2) {
            char current_char = str.charAt(i2);
            switch (current_char) {
                case '(': {
                    str1 = str1 + "\\(";
                    continue block7;
                }
                case '=': {
                    str1 = str1 + "\\=";
                    continue block7;
                }
                case ')': {
                    str1 = str1 + "\\)";
                    continue block7;
                }
                case ',': {
                    str1 = str1 + "\\,";
                    continue block7;
                }
                case '\\': {
                    str1 = str1 + "\\\\";
                    continue block7;
                }
                default: {
                    str1 = str1 + str.charAt(i2);
                }
            }
        }
        return str1;
    }

    private String checkNLPforComments(String str) {
        StringBuffer str1 = new StringBuffer(str.length());
        boolean offset = false;
        for (int i2 = 0; i2 < str.length(); ++i2) {
            char current_char = str.charAt(i2);
            if (current_char == '#') {
                if (i2 != 0) {
                    if (str.charAt(i2 - 1) != '\\') break;
                    str1.append(current_char);
                    continue;
                }
                return "";
            }
            str1.append(current_char);
        }
        return str1.toString();
    }

    private String eatNLPWS(String str) {
        StringBuffer str1 = new StringBuffer(str.length());
        int offset = 0;
        boolean NWScharfound = false;
        while (!NWScharfound) {
            char current_char;
            if ((current_char = str.charAt(offset++)) != ' ' || current_char != '\t') {
                NWScharfound = true;
                int i2 = offset - 1;
                while (str.charAt(i2) == '\n') {
                    str1.append(str.charAt(i2));
                    ++i2;
                }
                continue;
            }
            if (current_char != '\n') continue;
            return "";
        }
        return str1.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveNLParams() throws IOException {
        if (this.filename == null) {
            return;
        }
        try (FileWriter fw = null;){
            fw = new FileWriter(this.filename);
            String orafileType = "unknown";
            StringTokenizer st = new StringTokenizer(this.filename, File.separator);
            while (st.hasMoreTokens()) {
                orafileType = st.nextToken();
            }
            this.writeToStream(fw, orafileType, this.filename);
        }
    }

    public void writeToStream(Writer out, String headerFileType, String headerFileName) {
        PrintWriter pw = null;
        pw = new PrintWriter(new BufferedWriter(out));
        pw.println("# " + headerFileType + " Network Configuration File: " + headerFileName + "");
        pw.println("# Generated by Oracle configuration tools.");
        pw.println("");
        if (this.hasGroups) {
            this.saveNLPGroups(pw);
        }
        Enumeration e2 = this.ht.elements();
        while (e2.hasMoreElements()) {
            NVPair nvp = (NVPair)e2.nextElement();
            String Value2 = nvp.toString(0, true);
            if (DEBUG) {
                System.out.println("The initial stringified NVPair is:\n" + Value2);
            }
            if (Value2.equals("")) continue;
            char[] chkstr = new char[Value2.length() - 2];
            Value2.getChars(1, Value2.length() - 1, chkstr, 0);
            String newValue = new String(chkstr);
            if (DEBUG) {
                System.out.println("The modified NV String is:\n" + newValue);
            }
            pw.println(newValue);
            pw.println("");
            chkstr = null;
        }
        pw.close();
    }

    public void saveNLParams(String filename) throws FileNotFoundException, IOException {
        String oldFilenameOrNullIfStream = this.filename;
        this.filename = filename;
        this.saveNLParams();
        this.filename = oldFilenameOrNullIfStream;
    }

    public String getFilename() {
        return this.filename;
    }

    public boolean configuredInFile() {
        return this.filename != null;
    }

    public int getNLPListSize() {
        this.nvStringcnt = 0;
        Enumeration e2 = this.ht.keys();
        while (e2.hasMoreElements()) {
            String paramName = (String)e2.nextElement();
            if (paramName.indexOf("COMMENT") != -1) continue;
            ++this.nvStringcnt;
        }
        return this.nvStringcnt;
    }

    public boolean inErrorList(String name) {
        boolean exists = false;
        if (DEBUG) {
            System.out.println("Entering inErrorList():");
        }
        for (int i2 = 0; !(exists && i2 >= this.errstrcnt || this.errstrcnt == 0); ++i2) {
            if (this.errstr[i2].indexOf(name) == -1) continue;
            exists = true;
        }
        return exists;
    }

    public NVPair getNLPListElement(String Name2) {
        String UName = Name2.toUpperCase();
        return (NVPair)this.ht.get(UName);
    }

    public String[] getNLPAllNames() {
        int size = this.getNLPListSize();
        String[] Names = new String[size];
        int count = 0;
        Enumeration e2 = this.ht.keys();
        while (e2.hasMoreElements()) {
            String paramName = (String)e2.nextElement();
            if (paramName.indexOf("COMMENT") != -1) continue;
            Names[count++] = paramName;
        }
        return Names;
    }

    public String[] getNLPAllElements() {
        int size = this.getNLPListSize();
        String[] nvstrings = new String[size];
        int count = 0;
        Enumeration e2 = this.ht.elements();
        while (e2.hasMoreElements()) {
            NVPair nvp = (NVPair)e2.nextElement();
            if (nvp.getName().indexOf("COMMENT") != -1) continue;
            String nvelem = nvp.toString();
            nvstrings[count++] = nvelem;
        }
        return nvstrings;
    }

    public byte addNLPListElement(String Name2, Object Value2) {
        try {
            Object retobj = this.ht.put(Name2, Value2);
            return retobj != null ? (byte)2 : 1;
        }
        catch (NullPointerException e2) {
            if (DEBUG) {
                System.out.println(e2.getMessage());
            }
            return -1;
        }
    }

    public void addNLPGroupProfile(String[] Names) {
        String GroupName = new String("GROUP#" + this.Groupcnt++);
        String[] GroupValue = Names;
        if (!this.hasGroups) {
            this.hasGroups = true;
        }
        this.addNLPListElement(GroupName, GroupValue);
    }

    private String[] getNLPGroupProfile(String Name2) {
        String UName = Name2.toUpperCase();
        return (String[])this.ht.get(UName);
    }

    private void saveNLPGroups(PrintWriter pw) {
        for (int i2 = 0; i2 < this.Groupcnt; ++i2) {
            String GroupName = new String("GROUP#" + i2);
            String[] Value2 = this.getNLPGroupProfile(GroupName);
            for (int j2 = 0; j2 < Value2.length; ++j2) {
                String paramValue = null;
                String newValue = null;
                NVPair nvp = null;
                if (DEBUG) {
                    System.out.println("Current Value in Group Profile: " + Value2[j2]);
                }
                if (Value2[j2] == null) continue;
                nvp = this.getNLPListElement(Value2[j2]);
                if (nvp != null) {
                    paramValue = nvp.toString(0, true);
                    if (DEBUG) {
                        System.out.println("Parameter Value = " + paramValue);
                    }
                    char[] chkstr = new char[paramValue.length() - 2];
                    paramValue.getChars(1, paramValue.length() - 1, chkstr, 0);
                    newValue = new String(chkstr);
                    pw.println(newValue);
                    pw.println("");
                    NVPair nvp_gone = this.removeNLPListElement(Value2[j2]);
                    if (nvp_gone == null && DEBUG) {
                        System.out.println("saveNLPGroups(): Could notremove param from Hashtable");
                    }
                    chkstr = null;
                    newValue = null;
                    continue;
                }
                if (!DEBUG) continue;
                System.out.println("No such Parameter in the Table");
            }
            this.removeNLPGroupProfile(GroupName);
        }
    }

    public void addNLPListElement(String nvString) throws NLException {
        String[] unames;
        char[] chkstr = new char[nvString.length() + 2];
        String newstr = "";
        if (DEBUG) {
            System.out.println("Entering Method addNLPListElement\n");
            System.out.println("String to add is: " + nvString + "");
        }
        nvString.getChars(0, nvString.length(), chkstr, 1);
        if (chkstr[1] == '(') {
            newstr = nvString;
        } else {
            chkstr[0] = 40;
            String os = System.getProperty("os.name");
            if (os != null && (os.equals("Windows NT") || os.equals("Windows 95"))) {
                if (chkstr[chkstr.length - 2] == '/' || chkstr[chkstr.length - 2] == '\\') {
                    chkstr[chkstr.length - 2] = 41;
                } else {
                    chkstr[chkstr.length - 1] = 41;
                }
            } else if (chkstr[chkstr.length - 2] == '\\') {
                chkstr[chkstr.length - 2] = 41;
            } else {
                chkstr[chkstr.length - 1] = 41;
            }
            newstr = new String(chkstr);
            if (DEBUG) {
                System.out.println("The modified NV String is: " + newstr + "");
            }
        }
        NVFactory nvf = new NVFactory();
        NVPair nvp = nvf.createNVPair(newstr);
        if (nvp.getRHSType() == NVPair.RHS_NONE) {
            throw new NLException("NullRHS-04612", nvp.getName());
        }
        String name = nvp.getName();
        String uname = name.toUpperCase();
        nvp.setName(uname);
        block4: for (String aliasUname : unames = uname.split(",")) {
            if (DEBUG) {
                System.out.println("The final NV String is: " + nvp.toString() + "");
            }
            byte retcode = this.addNLPListElement(aliasUname, nvp);
            switch (retcode) {
                case 2: {
                    if (!DEBUG) continue block4;
                    System.out.println("The value for the Name: " + aliasUname + " was overwritten\n");
                    continue block4;
                }
                case -1: {
                    if (!DEBUG) continue block4;
                    System.out.println("The value for the Name: " + aliasUname + " could not be inserted\n");
                }
            }
        }
    }

    public NVPair removeNLPListElement(String Name2) {
        Object retobj;
        String UName = Name2.toUpperCase();
        if (DEBUG) {
            System.out.println("Trying to remove: " + UName + " from Table");
        }
        return (retobj = this.ht.remove(UName)) != null ? (NVPair)retobj : null;
    }

    public void removeNLPGroupProfile(String Name2) {
        String UName = Name2.toUpperCase();
        if (DEBUG) {
            System.out.println("Trying to remove: " + UName + " GroupName from Table");
        }
        Object retobj = this.ht.remove(UName);
    }

    public void removeNLPAllElements() {
        this.ht.clear();
    }

    @DisableTrace
    public String toString() {
        String out = "";
        Enumeration e2 = this.ht.elements();
        while (e2.hasMoreElements()) {
            NVPair nvp = (NVPair)e2.nextElement();
            String Value2 = nvp.toString();
            out = out + Value2 + "\n";
        }
        return out;
    }

    public boolean fileHasComments() {
        return this.hasComments;
    }

    public void println() {
        System.out.println(this.toString());
    }

    public void setFilePermissions(int filePermissions) {
        this.filePermissions = filePermissions;
    }

    private void storeError(String nvElem, byte ignore_exception) throws NLException {
        if (this.errstrcnt < 50) {
            this.errstr[this.errstrcnt++] = nvElem;
        } else if ((ignore_exception & 1) == 0) {
            throw new NLException("Too many errors", "");
        }
    }

    static {
        try {
            $$$methodRef$$$31 = NLParamParser.class.getDeclaredConstructor(Reader.class, Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$30 = NLParamParser.class.getDeclaredConstructor(Reader.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$29 = NLParamParser.class.getDeclaredConstructor(String.class, Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$28 = NLParamParser.class.getDeclaredConstructor(String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$27 = NLParamParser.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$26 = NLParamParser.class.getDeclaredMethod("storeError", String.class, Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = NLParamParser.class.getDeclaredMethod("setFilePermissions", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = NLParamParser.class.getDeclaredMethod("println", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = NLParamParser.class.getDeclaredMethod("fileHasComments", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = NLParamParser.class.getDeclaredMethod("removeNLPAllElements", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = NLParamParser.class.getDeclaredMethod("removeNLPGroupProfile", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = NLParamParser.class.getDeclaredMethod("removeNLPListElement", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = NLParamParser.class.getDeclaredMethod("addNLPListElement", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = NLParamParser.class.getDeclaredMethod("saveNLPGroups", PrintWriter.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = NLParamParser.class.getDeclaredMethod("getNLPGroupProfile", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = NLParamParser.class.getDeclaredMethod("addNLPGroupProfile", String[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = NLParamParser.class.getDeclaredMethod("addNLPListElement", String.class, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = NLParamParser.class.getDeclaredMethod("getNLPAllElements", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = NLParamParser.class.getDeclaredMethod("getNLPAllNames", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = NLParamParser.class.getDeclaredMethod("getNLPListElement", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = NLParamParser.class.getDeclaredMethod("inErrorList", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = NLParamParser.class.getDeclaredMethod("getNLPListSize", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = NLParamParser.class.getDeclaredMethod("configuredInFile", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = NLParamParser.class.getDeclaredMethod("getFilename", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = NLParamParser.class.getDeclaredMethod("saveNLParams", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = NLParamParser.class.getDeclaredMethod("writeToStream", Writer.class, String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = NLParamParser.class.getDeclaredMethod("saveNLParams", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = NLParamParser.class.getDeclaredMethod("eatNLPWS", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = NLParamParser.class.getDeclaredMethod("checkNLPforComments", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = NLParamParser.class.getDeclaredMethod("modifyCommentString", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = NLParamParser.class.getDeclaredMethod("initializeNlpa", BufferedReader.class, Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = NLParamParser.class.getDeclaredMethod("createEmptyParamParser", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        DEBUG = false;
    }
}

