/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Executable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleConnectionWrapper;
import oracle.jdbc.OracleData;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.InternalFactory;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.jdbc.oracore.PickleContext;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.BFILE;
import oracle.sql.BINARY_DOUBLE;
import oracle.sql.BINARY_FLOAT;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CharacterSet;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.DatumWithConnection;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NCLOB;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.OpaqueDescriptor;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;
import oracle.sql.TypeDescriptor;
import oracle.xdb.XMLType;

@DefaultLogger(value="oracle.sql")
@Supports(value={Feature.OBJECT_DATUM})
public class ANYDATA
implements ORAData,
OracleData {
    static final byte KAD_VSN = 1;
    static final byte KAD_VSN2 = 2;
    boolean isNull;
    byte[] data;
    TypeDescriptor type;
    boolean isREF;
    short serverCharsetId;
    short serverNCharsetId;
    OracleConnection connection;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;

    ANYDATA(TypeDescriptor _type, boolean _isNull, byte[] _data, boolean _isREF) {
        boolean bl = (0x20000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, ANYDATA.class, $$$methodRef$$$14, null, _type, _isNull, _data, _isREF);
            }
            this.isREF = false;
            this.serverCharsetId = 0;
            this.serverNCharsetId = 0;
            this.type = _type;
            this.isNull = _isNull;
            this.data = _data;
            this.isREF = _isREF;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, ANYDATA.class, $$$methodRef$$$14, null);
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, ANYDATA.class, $$$methodRef$$$14, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, ANYDATA.class, $$$methodRef$$$14, null, throwable2);
            }
            throw throwable;
        }
    }

    public ANYDATA(OPAQUE datum) throws SQLException {
        boolean bl = (0x20000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$15, Level.FINEST, ANYDATA.class, $$$methodRef$$$15, null, datum);
            }
            this.isREF = false;
            this.serverCharsetId = 0;
            this.serverNCharsetId = 0;
            byte[] image = datum.getBytesValue();
            this.connection = datum.getPhysicalConnection();
            if (this.connection != null) {
                this.serverCharsetId = this.connection.getDbCsId();
                this.serverNCharsetId = this.connection.getNCharSet();
            }
            this.unpickle(image, 0);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, ANYDATA.class, $$$methodRef$$$15, null);
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, ANYDATA.class, $$$methodRef$$$15, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, ANYDATA.class, $$$methodRef$$$15, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    int unpickle(byte[] byArray, int n2) throws SQLException {
        boolean bl = (0x20000000000L & TraceControllerImpl.feature) != 0L;
        try {
            int ret;
            void offset;
            void pickledBytes;
            PickleContext context;
            byte version;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, ANYDATA.class, $$$methodRef$$$0, this, byArray, n2);
            }
            if ((version = (context = new PickleContext((byte[])pickledBytes, (long)offset)).readByte()) == 2) {
                context.skipBytes(4);
            }
            short[] rdbmsTypeCode = new short[1];
            this.type = TypeDescriptor.unpickleOpaqueTypeImage(context, this.connection, rdbmsTypeCode);
            this.isNull = context.readByte() != 0;
            if (!this.isNull) {
                int dataLength = (int)context.readUB4();
                this.data = context.readDataValue(dataLength);
            }
            this.isREF = rdbmsTypeCode[0] == 110;
            int n3 = ret = context.offset();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, ANYDATA.class, $$$methodRef$$$0, this, n3);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, ANYDATA.class, $$$methodRef$$$0, this, null);
            }
            return n3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, ANYDATA.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    int pickle(byte[] byArray, int n2) {
        boolean bl = (0x20000000000L & TraceControllerImpl.feature) != 0L;
        try {
            int offset;
            void buffer;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, ANYDATA.class, $$$methodRef$$$1, this, byArray, n2);
            }
            buffer[offset++] = true;
            offset = this.type.pickleOpaqueTypeImage((byte[])buffer, offset, this.isREF);
            buffer[offset++] = this.isNull;
            if (!this.isNull) {
                int dataLength = this.data.length;
                buffer[offset++] = (byte)((dataLength & 0xFF000000) >> 24 & 0xFF);
                buffer[offset++] = (byte)((dataLength & 0xFF0000) >> 16 & 0xFF);
                buffer[offset++] = (byte)((dataLength & 0xFF00) >> 8 & 0xFF);
                buffer[offset++] = (byte)(dataLength & 0xFF);
                System.arraycopy(this.data, 0, buffer, offset, dataLength);
                offset += dataLength;
            }
            int n3 = offset;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, ANYDATA.class, $$$methodRef$$$1, this, n3);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, ANYDATA.class, $$$methodRef$$$1, this, null);
            }
            return n3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, ANYDATA.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    int getImageSize() {
        boolean bl = (0x20000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, ANYDATA.class, $$$methodRef$$$2, this, new Object[0]);
            }
            int imageSize = this.type.getOpaqueImageTypeSize() + 1 + 1;
            if (!this.isNull) {
                imageSize += 4 + this.data.length;
            }
            int n2 = imageSize;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, ANYDATA.class, $$$methodRef$$$2, this, n2);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, ANYDATA.class, $$$methodRef$$$2, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, ANYDATA.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Datum toDatum(Connection connection) throws SQLException {
        boolean bl = (0x20000000000L & TraceControllerImpl.feature) != 0L;
        try {
            void c2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, ANYDATA.class, $$$methodRef$$$3, this, connection);
            }
            if (c2 instanceof OracleConnectionWrapper) {
                oracle.jdbc.OracleConnection oracleConnection = ((OracleConnectionWrapper)c2).unwrap();
                this.connection = (OracleConnection)oracleConnection;
            } else {
                this.connection = (OracleConnection)c2;
            }
            OpaqueDescriptor desc = OpaqueDescriptor.createDescriptor("SYS.ANYDATA", (Connection)c2);
            byte[] image = new byte[this.getImageSize()];
            this.pickle(image, 0);
            OPAQUE opq = new OPAQUE(desc, this.connection, image);
            opq.setShareBytes(opq.toBytes());
            OPAQUE oPAQUE = opq;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, ANYDATA.class, $$$methodRef$$$3, this, oPAQUE);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, ANYDATA.class, $$$methodRef$$$3, this, null);
            }
            return oPAQUE;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, ANYDATA.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object toJDBCObject(Connection connection) throws SQLException {
        boolean bl = (0x20000000000L & TraceControllerImpl.feature) != 0L;
        try {
            void c2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, ANYDATA.class, $$$methodRef$$$4, this, connection);
            }
            Datum datum = this.toDatum((Connection)c2);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, ANYDATA.class, $$$methodRef$$$4, this, datum);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, ANYDATA.class, $$$methodRef$$$4, this, null);
            }
            return datum;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, ANYDATA.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    public static ANYDATA convertDatum(Datum datum) throws SQLException {
        boolean bl = (0x20000000000L & TraceControllerImpl.feature) != 0L;
        try {
            Datum datum2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, ANYDATA.class, $$$methodRef$$$5, null, datum);
            }
            ANYDATA ret = null;
            if (datum2 != null) {
                if (datum2 instanceof STRUCT) {
                    ret = new ANYDATA(((STRUCT)datum2).getDescriptor(), false, ((STRUCT)datum2).toBytes(), false);
                } else if (datum2 instanceof ARRAY) {
                    ret = new ANYDATA(((ARRAY)datum2).getDescriptor(), false, ((ARRAY)datum2).toBytes(), false);
                } else if (datum2 instanceof REF) {
                    ret = new ANYDATA(((REF)datum2).getDescriptor(), false, ((REF)datum2).getBytes(), true);
                } else if (datum2 instanceof OPAQUE) {
                    ret = new ANYDATA(((OPAQUE)datum2).getDescriptor(), false, ((OPAQUE)datum2).toBytes(), false);
                } else {
                    TypeDescriptor type = null;
                    if (datum2 instanceof NUMBER) {
                        type = new TypeDescriptor(2);
                    } else if (datum2 instanceof DATE) {
                        type = new TypeDescriptor(12);
                    } else if (datum2 instanceof INTERVALDS) {
                        type = new TypeDescriptor(190);
                    } else if (datum2 instanceof INTERVALYM) {
                        type = new TypeDescriptor(189);
                    } else if (datum2 instanceof TIMESTAMPTZ) {
                        type = new TypeDescriptor(188);
                    } else if (datum2 instanceof TIMESTAMPLTZ) {
                        type = new TypeDescriptor(232);
                    } else if (datum2 instanceof TIMESTAMP) {
                        type = new TypeDescriptor(187);
                    } else if (datum2 instanceof NCLOB) {
                        type = new TypeDescriptor(288);
                    } else if (datum2 instanceof CLOB) {
                        type = new TypeDescriptor(112);
                    } else if (datum2 instanceof BLOB) {
                        type = new TypeDescriptor(113);
                    } else if (datum2 instanceof BFILE) {
                        type = new TypeDescriptor(114);
                    } else if (datum2 instanceof RAW) {
                        type = new TypeDescriptor(95);
                    } else if (datum2 instanceof BINARY_DOUBLE) {
                        type = new TypeDescriptor(101);
                    } else if (datum2 instanceof BINARY_FLOAT) {
                        type = new TypeDescriptor(100);
                    } else if (datum2 instanceof ROWID) {
                        type = new TypeDescriptor(104);
                    } else if (datum2 instanceof CHAR) {
                        type = ((CHAR)datum2).isVariableLength() ? new TypeDescriptor(9) : new TypeDescriptor(96);
                    }
                    if (datum2 instanceof ROWID) {
                        byte[] base64rowid = datum2.shareBytes();
                        long[] riddef = InternalFactory.rowid2urowid(base64rowid, 0, base64rowid.length);
                        byte[] riddefBytes = new byte[]{1, (byte)((riddef[0] & 0xFFFFFFFFFF000000L) >> 24), (byte)((riddef[0] & 0xFF0000L) >> 16), (byte)((riddef[0] & 0xFF00L) >> 8), (byte)(riddef[0] & 0xFFL), (byte)((riddef[1] & 0xFF00L) >> 8), (byte)(riddef[1] & 0xFFL), (byte)((riddef[2] & 0xFFFFFFFFFF000000L) >> 24), (byte)((riddef[2] & 0xFF0000L) >> 16), (byte)((riddef[2] & 0xFF00L) >> 8), (byte)(riddef[2] & 0xFFL), (byte)((riddef[3] & 0xFF00L) >> 8), (byte)(riddef[3] & 0xFFL)};
                        ret = new ANYDATA(type, false, riddefBytes, false);
                    } else {
                        ret = new ANYDATA(type, false, datum2.shareBytes(), false);
                    }
                }
                if (datum2 instanceof DatumWithConnection) {
                    ret.connection = ((DatumWithConnection)datum2).getInternalConnection();
                }
            }
            ANYDATA aNYDATA = ret;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, ANYDATA.class, $$$methodRef$$$5, null, aNYDATA);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, ANYDATA.class, $$$methodRef$$$5, null, null);
            }
            return aNYDATA;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, ANYDATA.class, $$$methodRef$$$5, null, throwable2);
            }
            throw throwable;
        }
    }

    public TypeDescriptor getTypeDescriptor() {
        boolean bl = (0x20000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, ANYDATA.class, $$$methodRef$$$6, this, new Object[0]);
            }
            TypeDescriptor typeDescriptor = this.type;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, ANYDATA.class, $$$methodRef$$$6, this, typeDescriptor);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, ANYDATA.class, $$$methodRef$$$6, this, null);
            }
            return typeDescriptor;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, ANYDATA.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    public boolean isNull() {
        boolean bl = (0x20000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, ANYDATA.class, $$$methodRef$$$7, this, new Object[0]);
            }
            boolean bl2 = this.isNull;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, ANYDATA.class, $$$methodRef$$$7, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, ANYDATA.class, $$$methodRef$$$7, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, ANYDATA.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    public byte[] getData() {
        boolean bl = (0x20000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, ANYDATA.class, $$$methodRef$$$8, this, new Object[0]);
            }
            byte[] byArray = this.data;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, ANYDATA.class, $$$methodRef$$$8, this, byArray);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, ANYDATA.class, $$$methodRef$$$8, this, null);
            }
            return this.data;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, ANYDATA.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    public boolean isREF() {
        boolean bl = (0x20000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, ANYDATA.class, $$$methodRef$$$9, this, new Object[0]);
            }
            boolean bl2 = this.isREF;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, ANYDATA.class, $$$methodRef$$$9, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, ANYDATA.class, $$$methodRef$$$9, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, ANYDATA.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    public String stringValue() throws SQLException {
        boolean bl = (0x20000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, ANYDATA.class, $$$methodRef$$$10, this, new Object[0]);
            }
            String string = this.stringValue(this.connection);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, ANYDATA.class, $$$methodRef$$$10, this, string);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, ANYDATA.class, $$$methodRef$$$10, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, ANYDATA.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     */
    public String stringValue(Connection connection) throws SQLException {
        boolean bl = (0x20000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, ANYDATA.class, $$$methodRef$$$11, this, connection);
            }
            String ret = null;
            ret = "ANYDATA TypeCode: \"" + this.getTypeDescriptor().getTypeCodeName();
            if (this.isREF) {
                ret = ret + "(REF)";
            }
            ret = ret + "\" - ANYDATA Value: \"";
            Datum dd = this.accessDatum();
            boolean gotStringValueFromDataum = false;
            try {
                ret = ret + dd.stringValue();
                gotStringValueFromDataum = true;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            if (!gotStringValueFromDataum) {
                if (!(this.type.getInternalTypeCode() != 108 && this.type.getInternalTypeCode() != 110 || this.type.isTransient())) {
                    ret = ret + ((StructDescriptor)this.type).getName() + "(...)";
                } else if (this.type.getInternalTypeCode() == 122 && !this.type.isTransient()) {
                    ret = ret + ((ArrayDescriptor)this.type).getName() + "(...)";
                } else {
                    switch (this.type.getInternalTypeCode()) {
                        case 113: {
                            int c2;
                            InputStream is = ((BLOB)dd).getBinaryStream();
                            String ret3232322322 = "";
                            while ((c2 = is.read()) != -1) {
                                ret3232322322 = ret3232322322 + Integer.toHexString(c2);
                            }
                            ret = ret + ret3232322322;
                            try {
                                is.close();
                            }
                            catch (IOException ret3232322322) {}
                            break;
                            catch (IOException ret3232322322) {
                                try {
                                    is.close();
                                }
                                catch (IOException ret3232322322) {}
                                break;
                                catch (Throwable throwable) {
                                    try {
                                        is.close();
                                    }
                                    catch (IOException iOException) {
                                        // empty catch block
                                    }
                                    Throwable throwable2 = throwable;
                                    if (bl) {
                                        ClioSupport.throwing($$$loggerRef$$$11, Level.FINEST, ANYDATA.class, $$$methodRef$$$11, this, throwable2);
                                    }
                                    throw throwable2;
                                }
                            }
                        }
                        case 188: {
                            void _connection;
                            if (_connection == null) {
                                ret = ret + "?";
                                break;
                            }
                            ret = ret + ((TIMESTAMPTZ)dd).stringValue((Connection)_connection);
                            break;
                        }
                        case 232: {
                            void _connection;
                            if (_connection == null) {
                                ret = ret + "?";
                                break;
                            }
                            ret = ret + ((TIMESTAMPLTZ)dd).stringValue((Connection)_connection);
                            break;
                        }
                        case 114: {
                            ret = ret + "bfile_dir=" + ((BFILE)dd).getDirAlias() + " bfile_name=" + ((BFILE)dd).getName();
                            break;
                        }
                        case 58: {
                            OPAQUE opaque = (OPAQUE)dd;
                            String typeName = opaque.getSQLTypeName();
                            ret = ret + "OPAQUE(" + typeName + ")";
                            if (typeName.compareTo("SYS.XMLTYPE") != 0) break;
                            ret = ret + ":";
                            XMLType xxmltype = XMLType.createXML((OPAQUE)opaque);
                            ret = ret + xxmltype.getStringVal();
                        }
                    }
                }
            }
            String string = ret = ret + "\"";
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, ANYDATA.class, $$$methodRef$$$11, this, string);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, ANYDATA.class, $$$methodRef$$$11, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, ANYDATA.class, $$$methodRef$$$11, this, throwable3);
            }
            throw throwable;
        }
    }

    public Datum accessDatum() throws SQLException {
        boolean bl = (0x20000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, ANYDATA.class, $$$methodRef$$$12, this, new Object[0]);
            }
            Datum o2 = null;
            if (!this.isNull) {
                short internalTypeCode = this.type.getInternalTypeCode();
                switch (internalTypeCode) {
                    case 58: {
                        o2 = new OPAQUE((OpaqueDescriptor)this.type, this.data, this.connection);
                        break;
                    }
                    case 108: {
                        if (this.type instanceof OpaqueDescriptor) {
                            o2 = new OPAQUE((OpaqueDescriptor)this.type, this.data, this.connection);
                            break;
                        }
                        if (!this.isREF) {
                            o2 = new STRUCT((StructDescriptor)this.type, this.data, this.connection);
                            break;
                        }
                        o2 = new REF((StructDescriptor)this.type, (Connection)this.connection, this.data);
                        break;
                    }
                    case 122: {
                        o2 = new ARRAY((ArrayDescriptor)this.type, this.data, this.connection);
                        break;
                    }
                    case 110: {
                        o2 = new REF((StructDescriptor)this.type, (Connection)this.connection, this.data);
                        break;
                    }
                    case 2: {
                        o2 = new NUMBER(this.data);
                        break;
                    }
                    case 12: {
                        o2 = new DATE(this.data);
                        break;
                    }
                    case 190: {
                        o2 = new INTERVALDS(this.data);
                        break;
                    }
                    case 189: {
                        o2 = new INTERVALYM(this.data);
                        break;
                    }
                    case 188: {
                        o2 = new TIMESTAMPTZ(this.data);
                        break;
                    }
                    case 232: {
                        o2 = new TIMESTAMPLTZ(this.data);
                        break;
                    }
                    case 187: {
                        o2 = new TIMESTAMP(this.data);
                        break;
                    }
                    case 112: {
                        o2 = new CLOB(this.connection, this.data);
                        break;
                    }
                    case 288: {
                        o2 = new NCLOB(this.connection, this.data);
                        break;
                    }
                    case 113: {
                        o2 = new BLOB(this.connection, this.data);
                        break;
                    }
                    case 114: {
                        o2 = new BFILE(this.connection, this.data);
                        break;
                    }
                    case 95: {
                        o2 = new RAW(this.data);
                        break;
                    }
                    case 101: {
                        o2 = new BINARY_DOUBLE(this.data);
                        break;
                    }
                    case 100: {
                        o2 = new BINARY_FLOAT(this.data);
                        break;
                    }
                    case 104: {
                        long rba = ((long)this.data[1] & 0xFFL) << 24 | ((long)this.data[2] & 0xFFL) << 16 | ((long)this.data[3] & 0xFFL) << 8 | (long)this.data[4] & 0xFFL;
                        long partitionId = ((long)this.data[5] & 0xFFL) << 8 | (long)this.data[6] & 0xFFL;
                        long blockNumber = ((long)this.data[7] & 0xFFL) << 24 | ((long)this.data[8] & 0xFFL) << 16 | ((long)this.data[9] & 0xFFL) << 8 | (long)this.data[10] & 0xFFL;
                        long slotNumber = ((long)this.data[11] & 0xFFL) << 8 | (long)this.data[12] & 0xFFL;
                        long[] urowid = new long[]{rba, partitionId, blockNumber, slotNumber};
                        byte[] rowidBase64 = InternalFactory.urowid2rowid(urowid);
                        o2 = new ROWID(rowidBase64);
                        break;
                    }
                    case 1: 
                    case 9: 
                    case 96: {
                        o2 = this.serverCharsetId != 0 ? new CHAR(this.data, CharacterSet.make(this.serverCharsetId)) : new CHAR(this.data, null);
                        if (internalTypeCode != 1 && internalTypeCode != 9) break;
                        ((CHAR)o2).setVariableLength(true);
                        break;
                    }
                    case 286: 
                    case 287: {
                        o2 = this.serverNCharsetId != 0 ? new CHAR(this.data, CharacterSet.make(this.serverNCharsetId)) : new CHAR(this.data, null);
                        if (internalTypeCode != 287) break;
                        ((CHAR)o2).setVariableLength(true);
                        break;
                    }
                    default: {
                        String messageXXX = "internal typecode: " + internalTypeCode;
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, messageXXX).fillInStackTrace();
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$12, Level.FINEST, ANYDATA.class, $$$methodRef$$$12, this, sQLException);
                        }
                        throw sQLException;
                    }
                }
            }
            NUMBER nUMBER = o2;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, ANYDATA.class, $$$methodRef$$$12, this, nUMBER);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, ANYDATA.class, $$$methodRef$$$12, this, null);
            }
            return nUMBER;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, ANYDATA.class, $$$methodRef$$$12, this, throwable2);
            }
            throw throwable;
        }
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        boolean bl = (0x20000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, ANYDATA.class, $$$methodRef$$$13, this, new Object[0]);
            }
            OracleConnection oracleConnection = this.connection;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, ANYDATA.class, $$$methodRef$$$13, this, oracleConnection);
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, ANYDATA.class, $$$methodRef$$$13, this, null);
            }
            return oracleConnection;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, ANYDATA.class, $$$methodRef$$$13, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$15 = ANYDATA.class.getDeclaredConstructor(OPAQUE.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$14 = ANYDATA.class.getDeclaredConstructor(TypeDescriptor.class, Boolean.TYPE, byte[].class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$13 = ANYDATA.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$12 = ANYDATA.class.getDeclaredMethod("accessDatum", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$11 = ANYDATA.class.getDeclaredMethod("stringValue", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$10 = ANYDATA.class.getDeclaredMethod("stringValue", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$9 = ANYDATA.class.getDeclaredMethod("isREF", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$8 = ANYDATA.class.getDeclaredMethod("getData", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$7 = ANYDATA.class.getDeclaredMethod("isNull", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$6 = ANYDATA.class.getDeclaredMethod("getTypeDescriptor", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$5 = ANYDATA.class.getDeclaredMethod("convertDatum", Datum.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$4 = ANYDATA.class.getDeclaredMethod("toJDBCObject", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$3 = ANYDATA.class.getDeclaredMethod("toDatum", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$2 = ANYDATA.class.getDeclaredMethod("getImageSize", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$1 = ANYDATA.class.getDeclaredMethod("pickle", byte[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$0 = ANYDATA.class.getDeclaredMethod("unpickle", byte[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
    }
}

