/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.rowset;

import java.io.Serializable;
import java.lang.reflect.Executable;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.RowSetMetaData;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.ROWSET})
public class OracleRowSetMetaData
implements RowSetMetaData,
Serializable {
    private int columnCount;
    private int[] nullable;
    private int[] columnDisplaySize;
    private int[] precision;
    private int[] scale;
    private int[] columnType;
    private boolean[] searchable;
    private boolean[] caseSensitive;
    private boolean[] readOnly;
    private boolean[] writable;
    private boolean[] definatelyWritable;
    private boolean[] currency;
    private boolean[] autoIncrement;
    private boolean[] signed;
    private String[] columnLabel;
    private String[] schemaName;
    private String[] columnName;
    private String[] tableName;
    private String[] columnTypeName;
    private String[] catalogName;
    private String[] columnClassName;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;
    private static Executable $$$methodRef$$$36;
    private static Logger $$$loggerRef$$$36;
    private static Executable $$$methodRef$$$37;
    private static Logger $$$loggerRef$$$37;
    private static Executable $$$methodRef$$$38;
    private static Logger $$$loggerRef$$$38;
    private static Executable $$$methodRef$$$39;
    private static Logger $$$loggerRef$$$39;
    private static Executable $$$methodRef$$$40;
    private static Logger $$$loggerRef$$$40;
    private static Executable $$$methodRef$$$41;
    private static Logger $$$loggerRef$$$41;
    private static Executable $$$methodRef$$$42;
    private static Logger $$$loggerRef$$$42;
    private static Executable $$$methodRef$$$43;
    private static Logger $$$loggerRef$$$43;

    OracleRowSetMetaData(int colCount) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$42, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$42, null, colCount);
            }
            this.columnCount = colCount;
            this.searchable = new boolean[this.columnCount];
            this.caseSensitive = new boolean[this.columnCount];
            this.readOnly = new boolean[this.columnCount];
            this.nullable = new int[this.columnCount];
            this.signed = new boolean[this.columnCount];
            this.columnDisplaySize = new int[this.columnCount];
            this.columnType = new int[this.columnCount];
            this.columnLabel = new String[this.columnCount];
            this.columnName = new String[this.columnCount];
            this.schemaName = new String[this.columnCount];
            this.precision = new int[this.columnCount];
            this.scale = new int[this.columnCount];
            this.tableName = new String[this.columnCount];
            this.columnTypeName = new String[this.columnCount];
            this.writable = new boolean[this.columnCount];
            this.definatelyWritable = new boolean[this.columnCount];
            this.currency = new boolean[this.columnCount];
            this.autoIncrement = new boolean[this.columnCount];
            this.catalogName = new String[this.columnCount];
            this.columnClassName = new String[this.columnCount];
            for (int i2 = 0; i2 < this.columnCount; ++i2) {
                this.searchable[i2] = false;
                this.caseSensitive[i2] = false;
                this.readOnly[i2] = false;
                this.nullable[i2] = 1;
                this.signed[i2] = false;
                this.columnDisplaySize[i2] = 0;
                this.columnType[i2] = 0;
                this.columnLabel[i2] = "";
                this.columnName[i2] = "";
                this.schemaName[i2] = "";
                this.precision[i2] = 0;
                this.scale[i2] = 0;
                this.tableName[i2] = "";
                this.columnTypeName[i2] = "";
                this.writable[i2] = false;
                this.definatelyWritable[i2] = false;
                this.currency[i2] = false;
                this.autoIncrement[i2] = true;
                this.catalogName[i2] = "";
                this.columnClassName[i2] = "";
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$42, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$42, null);
                ClioSupport.exiting($$$loggerRef$$$42, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$42, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$42, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$42, null, throwable2);
            }
            throw throwable;
        }
    }

    OracleRowSetMetaData(ResultSetMetaData rsmd) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$43, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$43, null, rsmd);
            }
            this.columnCount = rsmd.getColumnCount();
            this.searchable = new boolean[this.columnCount];
            this.caseSensitive = new boolean[this.columnCount];
            this.readOnly = new boolean[this.columnCount];
            this.nullable = new int[this.columnCount];
            this.signed = new boolean[this.columnCount];
            this.columnDisplaySize = new int[this.columnCount];
            this.columnType = new int[this.columnCount];
            this.columnLabel = new String[this.columnCount];
            this.columnName = new String[this.columnCount];
            this.schemaName = new String[this.columnCount];
            this.precision = new int[this.columnCount];
            this.scale = new int[this.columnCount];
            this.tableName = new String[this.columnCount];
            this.columnTypeName = new String[this.columnCount];
            this.writable = new boolean[this.columnCount];
            this.definatelyWritable = new boolean[this.columnCount];
            this.currency = new boolean[this.columnCount];
            this.autoIncrement = new boolean[this.columnCount];
            this.catalogName = new String[this.columnCount];
            this.columnClassName = new String[this.columnCount];
            for (int i2 = 0; i2 < this.columnCount; ++i2) {
                this.searchable[i2] = rsmd.isSearchable(i2 + 1);
                this.caseSensitive[i2] = rsmd.isCaseSensitive(i2 + 1);
                this.readOnly[i2] = rsmd.isReadOnly(i2 + 1);
                this.nullable[i2] = rsmd.isNullable(i2 + 1);
                this.signed[i2] = rsmd.isSigned(i2 + 1);
                this.columnDisplaySize[i2] = rsmd.getColumnDisplaySize(i2 + 1);
                this.columnType[i2] = rsmd.getColumnType(i2 + 1);
                this.columnLabel[i2] = rsmd.getColumnLabel(i2 + 1);
                this.columnName[i2] = rsmd.getColumnName(i2 + 1);
                this.schemaName[i2] = rsmd.getSchemaName(i2 + 1);
                if (this.columnType[i2] == 2 || this.columnType[i2] == 2 || this.columnType[i2] == -5 || this.columnType[i2] == 3 || this.columnType[i2] == 8 || this.columnType[i2] == 6 || this.columnType[i2] == 4) {
                    this.precision[i2] = rsmd.getPrecision(i2 + 1);
                    this.scale[i2] = rsmd.getScale(i2 + 1);
                } else {
                    this.precision[i2] = 0;
                    this.scale[i2] = 0;
                }
                this.tableName[i2] = rsmd.getTableName(i2 + 1);
                this.columnTypeName[i2] = rsmd.getColumnTypeName(i2 + 1);
                this.writable[i2] = rsmd.isWritable(i2 + 1);
                this.definatelyWritable[i2] = rsmd.isDefinitelyWritable(i2 + 1);
                this.currency[i2] = rsmd.isCurrency(i2 + 1);
                this.autoIncrement[i2] = rsmd.isAutoIncrement(i2 + 1);
                this.catalogName[i2] = rsmd.getCatalogName(i2 + 1);
                this.columnClassName[i2] = rsmd.getColumnClassName(i2 + 1);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$43, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$43, null);
                ClioSupport.exiting($$$loggerRef$$$43, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$43, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$43, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$43, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void validateColumnIndex(int n2) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void column;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$0, this, n2);
            }
            if (column < true || column > this.columnCount) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "" + (int)column).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$0, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$0, this, sQLException);
                }
                throw sQLException;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$0, this);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$0, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public int getColumnCount() throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$1, this, new Object[0]);
            }
            int n2 = this.columnCount;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$1, this, n2);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$1, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isAutoIncrement(int n2) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void column;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$2, this, n2);
            }
            this.validateColumnIndex((int)column);
            boolean bl2 = this.autoIncrement[column - true];
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$2, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$2, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isCaseSensitive(int n2) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void column;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$3, this, n2);
            }
            this.validateColumnIndex((int)column);
            boolean bl2 = this.caseSensitive[column - true];
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$3, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$3, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isSearchable(int n2) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void column;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$4, this, n2);
            }
            this.validateColumnIndex((int)column);
            boolean bl2 = this.searchable[column - true];
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$4, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$4, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isCurrency(int n2) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void column;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$5, this, n2);
            }
            this.validateColumnIndex((int)column);
            boolean bl2 = this.currency[column - true];
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$5, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$5, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int isNullable(int n2) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void column;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$6, this, n2);
            }
            this.validateColumnIndex((int)column);
            int n3 = this.nullable[column - true];
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$6, this, n3);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$6, this, null);
            }
            return n3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isSigned(int n2) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void column;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$7, this, n2);
            }
            this.validateColumnIndex((int)column);
            boolean bl2 = this.signed[column - true];
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$7, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$7, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getColumnDisplaySize(int n2) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void column;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$8, this, n2);
            }
            this.validateColumnIndex((int)column);
            int n3 = this.columnDisplaySize[column - true];
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$8, this, n3);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$8, this, null);
            }
            return n3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getColumnLabel(int n2) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void column;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$9, this, n2);
            }
            this.validateColumnIndex((int)column);
            String string = this.columnLabel[column - true];
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$9, this, string);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$9, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getColumnName(int n2) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void column;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$10, this, n2);
            }
            this.validateColumnIndex((int)column);
            String string = this.columnName[column - true];
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$10, this, string);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$10, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getSchemaName(int n2) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void column;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$11, this, n2);
            }
            this.validateColumnIndex((int)column);
            String string = this.schemaName[column - true];
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$11, this, string);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$11, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$11, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getPrecision(int n2) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void column;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$12, this, n2);
            }
            this.validateColumnIndex((int)column);
            int n3 = this.precision[column - true];
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$12, this, n3);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$12, this, null);
            }
            return n3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$12, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getScale(int n2) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void column;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$13, this, n2);
            }
            this.validateColumnIndex((int)column);
            int n3 = this.scale[column - true];
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$13, this, n3);
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$13, this, null);
            }
            return n3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$13, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getTableName(int n2) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void column;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$14, this, n2);
            }
            this.validateColumnIndex((int)column);
            String string = this.tableName[column - true];
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$14, this, string);
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$14, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$14, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getCatalogName(int n2) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void column;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$15, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$15, this, n2);
            }
            this.validateColumnIndex((int)column);
            String string = this.catalogName[column - true];
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$15, this, string);
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$15, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$15, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getColumnType(int n2) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void column;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$16, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$16, this, n2);
            }
            this.validateColumnIndex((int)column);
            int n3 = this.columnType[column - true];
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$16, this, n3);
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$16, this, null);
            }
            return n3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$16, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getColumnTypeName(int n2) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void column;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$17, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$17, this, n2);
            }
            this.validateColumnIndex((int)column);
            String string = this.columnTypeName[column - true];
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$17, this, string);
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$17, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$17, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isReadOnly(int n2) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void column;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$18, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$18, this, n2);
            }
            this.validateColumnIndex((int)column);
            boolean bl2 = this.readOnly[column - true];
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$18, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$18, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$18, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$18, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isWritable(int n2) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void column;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$19, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$19, this, n2);
            }
            this.validateColumnIndex((int)column);
            boolean bl2 = this.writable[column - true];
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$19, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$19, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$19, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$19, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isDefinitelyWritable(int n2) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void column;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$20, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$20, this, n2);
            }
            this.validateColumnIndex((int)column);
            boolean bl2 = this.definatelyWritable[column - true];
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$20, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$20, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$20, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$20, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getColumnClassName(int n2) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void column;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$21, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$21, this, n2);
            }
            this.validateColumnIndex((int)column);
            String string = this.columnClassName[column - true];
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$21, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$21, this, string);
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$21, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$21, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setAutoIncrement(int n2, boolean bl) throws SQLException {
        boolean bl2 = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void value;
            void columnIndex;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$22, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$22, this, n2, bl);
            }
            this.validateColumnIndex((int)columnIndex);
            this.autoIncrement[columnIndex - true] = value;
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$22, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$22, this);
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$22, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$22, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setCaseSensitive(int n2, boolean bl) throws SQLException {
        boolean bl2 = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void value;
            void columnIndex;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$23, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$23, this, n2, bl);
            }
            this.validateColumnIndex((int)columnIndex);
            this.caseSensitive[columnIndex - true] = value;
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$23, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$23, this);
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$23, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$23, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setCatalogName(int n2, String string) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void value;
            void columnIndex;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$24, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$24, this, n2, string);
            }
            this.validateColumnIndex((int)columnIndex);
            this.catalogName[columnIndex - true] = value;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$24, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$24, this);
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$24, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$24, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setColumnCount(int n2) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void value;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$25, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$25, this, n2);
            }
            this.columnCount = value;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$25, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$25, this);
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$25, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$25, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setColumnDisplaySize(int n2, int n3) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void value;
            void columnIndex;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$26, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$26, this, n2, n3);
            }
            this.validateColumnIndex((int)columnIndex);
            this.columnDisplaySize[columnIndex - true] = value;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$26, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$26, this);
                ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$26, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$26, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setColumnLabel(int n2, String string) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void value;
            void columnIndex;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$27, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$27, this, n2, string);
            }
            this.validateColumnIndex((int)columnIndex);
            this.columnLabel[columnIndex - true] = value;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$27, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$27, this);
                ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$27, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$27, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setColumnName(int n2, String string) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void value;
            void columnIndex;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$28, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$28, this, n2, string);
            }
            this.validateColumnIndex((int)columnIndex);
            this.columnName[columnIndex - true] = value;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$28, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$28, this);
                ClioSupport.exiting($$$loggerRef$$$28, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$28, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$28, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$28, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setColumnType(int n2, int n3) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void value;
            void columnIndex;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$29, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$29, this, n2, n3);
            }
            this.validateColumnIndex((int)columnIndex);
            this.columnType[columnIndex - true] = value;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$29, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$29, this);
                ClioSupport.exiting($$$loggerRef$$$29, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$29, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$29, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$29, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setColumnTypeName(int n2, String string) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void value;
            void columnIndex;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$30, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$30, this, n2, string);
            }
            this.validateColumnIndex((int)columnIndex);
            this.columnTypeName[columnIndex - true] = value;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$30, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$30, this);
                ClioSupport.exiting($$$loggerRef$$$30, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$30, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$30, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$30, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setCurrency(int n2, boolean bl) throws SQLException {
        boolean bl2 = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void value;
            void columnIndex;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$31, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$31, this, n2, bl);
            }
            this.validateColumnIndex((int)columnIndex);
            this.currency[columnIndex - true] = value;
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$31, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$31, this);
                ClioSupport.exiting($$$loggerRef$$$31, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$31, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$31, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$31, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setNullable(int n2, int n3) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void value;
            void columnIndex;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$32, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$32, this, n2, n3);
            }
            this.validateColumnIndex((int)columnIndex);
            this.nullable[columnIndex - true] = value;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$32, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$32, this);
                ClioSupport.exiting($$$loggerRef$$$32, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$32, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$32, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$32, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setPrecision(int n2, int n3) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void value;
            void columnIndex;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$33, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$33, this, n2, n3);
            }
            this.validateColumnIndex((int)columnIndex);
            this.precision[columnIndex - true] = value;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$33, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$33, this);
                ClioSupport.exiting($$$loggerRef$$$33, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$33, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$33, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$33, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setScale(int n2, int n3) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void value;
            void columnIndex;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$34, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$34, this, n2, n3);
            }
            this.validateColumnIndex((int)columnIndex);
            this.scale[columnIndex - true] = value;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$34, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$34, this);
                ClioSupport.exiting($$$loggerRef$$$34, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$34, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$34, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$34, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setSchemaName(int n2, String string) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void value;
            void columnIndex;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$35, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$35, this, n2, string);
            }
            this.validateColumnIndex((int)columnIndex);
            this.schemaName[columnIndex - true] = value;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$35, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$35, this);
                ClioSupport.exiting($$$loggerRef$$$35, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$35, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$35, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$35, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setSearchable(int n2, boolean bl) throws SQLException {
        boolean bl2 = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void value;
            void columnIndex;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$36, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$36, this, n2, bl);
            }
            this.validateColumnIndex((int)columnIndex);
            this.searchable[columnIndex - true] = value;
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$36, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$36, this);
                ClioSupport.exiting($$$loggerRef$$$36, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$36, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$36, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$36, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setSigned(int n2, boolean bl) throws SQLException {
        boolean bl2 = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void value;
            void columnIndex;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$37, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$37, this, n2, bl);
            }
            this.validateColumnIndex((int)columnIndex);
            this.signed[columnIndex - true] = value;
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$37, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$37, this);
                ClioSupport.exiting($$$loggerRef$$$37, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$37, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$37, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$37, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setTableName(int n2, String string) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void value;
            void columnIndex;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$38, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$38, this, n2, string);
            }
            this.validateColumnIndex((int)columnIndex);
            this.tableName[columnIndex - true] = value;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$38, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$38, this);
                ClioSupport.exiting($$$loggerRef$$$38, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$38, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$38, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$38, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void iface;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$39, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$39, this, clazz);
            }
            if (iface.isInterface()) {
                boolean bl2 = iface.isInstance(this);
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$39, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$39, this, bl2);
                    ClioSupport.exiting($$$loggerRef$$$39, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$39, this, null);
                }
                return bl2;
            }
            SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 177).fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$39, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$39, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$39, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$39, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void iface;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$40, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$40, this, clazz);
            }
            if (iface.isInterface() && iface.isInstance(this)) {
                OracleRowSetMetaData oracleRowSetMetaData = this;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$40, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$40, this, oracleRowSetMetaData);
                    ClioSupport.exiting($$$loggerRef$$$40, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$40, this, null);
                }
                return (T)oracleRowSetMetaData;
            }
            SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 177).fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$40, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$40, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$40, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$40, this, throwable2);
            }
            throw throwable;
        }
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$41, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$41, this, new Object[0]);
            }
            OracleConnection oracleConnection = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$41, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$41, this, oracleConnection);
                ClioSupport.exiting($$$loggerRef$$$41, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$41, this, null);
            }
            return null;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$41, Level.FINEST, OracleRowSetMetaData.class, $$$methodRef$$$41, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$43 = OracleRowSetMetaData.class.getDeclaredConstructor(ResultSetMetaData.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$43 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$42 = OracleRowSetMetaData.class.getDeclaredConstructor(Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$42 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$41 = OracleRowSetMetaData.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$41 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$40 = OracleRowSetMetaData.class.getDeclaredMethod("unwrap", Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$40 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$39 = OracleRowSetMetaData.class.getDeclaredMethod("isWrapperFor", Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$39 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$38 = OracleRowSetMetaData.class.getDeclaredMethod("setTableName", Integer.TYPE, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$38 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$37 = OracleRowSetMetaData.class.getDeclaredMethod("setSigned", Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$36 = OracleRowSetMetaData.class.getDeclaredMethod("setSearchable", Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$35 = OracleRowSetMetaData.class.getDeclaredMethod("setSchemaName", Integer.TYPE, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$34 = OracleRowSetMetaData.class.getDeclaredMethod("setScale", Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$33 = OracleRowSetMetaData.class.getDeclaredMethod("setPrecision", Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$32 = OracleRowSetMetaData.class.getDeclaredMethod("setNullable", Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$31 = OracleRowSetMetaData.class.getDeclaredMethod("setCurrency", Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$30 = OracleRowSetMetaData.class.getDeclaredMethod("setColumnTypeName", Integer.TYPE, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$29 = OracleRowSetMetaData.class.getDeclaredMethod("setColumnType", Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$28 = OracleRowSetMetaData.class.getDeclaredMethod("setColumnName", Integer.TYPE, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$27 = OracleRowSetMetaData.class.getDeclaredMethod("setColumnLabel", Integer.TYPE, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$26 = OracleRowSetMetaData.class.getDeclaredMethod("setColumnDisplaySize", Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = OracleRowSetMetaData.class.getDeclaredMethod("setColumnCount", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = OracleRowSetMetaData.class.getDeclaredMethod("setCatalogName", Integer.TYPE, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = OracleRowSetMetaData.class.getDeclaredMethod("setCaseSensitive", Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = OracleRowSetMetaData.class.getDeclaredMethod("setAutoIncrement", Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = OracleRowSetMetaData.class.getDeclaredMethod("getColumnClassName", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = OracleRowSetMetaData.class.getDeclaredMethod("isDefinitelyWritable", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = OracleRowSetMetaData.class.getDeclaredMethod("isWritable", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = OracleRowSetMetaData.class.getDeclaredMethod("isReadOnly", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = OracleRowSetMetaData.class.getDeclaredMethod("getColumnTypeName", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = OracleRowSetMetaData.class.getDeclaredMethod("getColumnType", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = OracleRowSetMetaData.class.getDeclaredMethod("getCatalogName", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = OracleRowSetMetaData.class.getDeclaredMethod("getTableName", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = OracleRowSetMetaData.class.getDeclaredMethod("getScale", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = OracleRowSetMetaData.class.getDeclaredMethod("getPrecision", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = OracleRowSetMetaData.class.getDeclaredMethod("getSchemaName", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = OracleRowSetMetaData.class.getDeclaredMethod("getColumnName", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = OracleRowSetMetaData.class.getDeclaredMethod("getColumnLabel", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = OracleRowSetMetaData.class.getDeclaredMethod("getColumnDisplaySize", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = OracleRowSetMetaData.class.getDeclaredMethod("isSigned", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = OracleRowSetMetaData.class.getDeclaredMethod("isNullable", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OracleRowSetMetaData.class.getDeclaredMethod("isCurrency", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OracleRowSetMetaData.class.getDeclaredMethod("isSearchable", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OracleRowSetMetaData.class.getDeclaredMethod("isCaseSensitive", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleRowSetMetaData.class.getDeclaredMethod("isAutoIncrement", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleRowSetMetaData.class.getDeclaredMethod("getColumnCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleRowSetMetaData.class.getDeclaredMethod("validateColumnIndex", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

