/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.proxy;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import oracle.jdbc.logging.annotations.DisableTrace;

@DisableTrace
public class WeakIdentityHashMap<K, V>
implements Map<K, V> {
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    Entry<K, V>[] table;
    private int size;
    private int threshold;
    private final float loadFactor;
    private final ReferenceQueue<Object> queue = new ReferenceQueue();
    private final ReentrantLock lock = new ReentrantLock();
    private static final int CALLS_BEFORE_NEXT_EXPUNGE = 10;
    private int callsBeforeNextExpunge = 10;
    volatile int modCount;
    private static final Object NULL_KEY = new Object();
    private transient Set<Map.Entry<K, V>> entrySet = null;
    volatile transient Set<K> keySet = null;
    volatile transient Collection<V> values = null;

    private Entry<K, V>[] newTable(int n2) {
        return new Entry[n2];
    }

    public WeakIdentityHashMap(int initialCapacity, float loadFactor) {
        int capacity;
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Initial Capacity: " + initialCapacity);
        }
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Illegal Load factor: " + loadFactor);
        }
        for (capacity = 1; capacity < initialCapacity; capacity <<= 1) {
        }
        this.table = this.newTable(capacity);
        this.loadFactor = loadFactor;
        this.threshold = (int)((float)capacity * loadFactor);
    }

    public WeakIdentityHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public WeakIdentityHashMap() {
        this.loadFactor = 0.75f;
        this.threshold = 16;
        this.table = this.newTable(16);
    }

    public WeakIdentityHashMap(Map<? extends K, ? extends V> m2) {
        this(Math.max((int)((float)m2.size() / 0.75f) + 1, 16), 0.75f);
        this.putAll(m2);
    }

    private static Object maskNull(Object key) {
        return key == null ? NULL_KEY : key;
    }

    static Object unmaskNull(Object key) {
        return key == NULL_KEY ? null : key;
    }

    private static boolean eq(Object x2, Object y2) {
        return x2 == y2;
    }

    private static int indexFor(int h2, int length) {
        return h2 & length - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expungeStaleEntries() {
        Reference<Object> x2;
        block3: while ((x2 = this.queue.poll()) != null) {
            this.lock.lock();
            try {
                Entry<K, V> prev;
                Entry e2 = (Entry)x2;
                int i2 = WeakIdentityHashMap.indexFor(e2.hash, this.table.length);
                Entry<K, V> p2 = prev = this.table[i2];
                while (p2 != null) {
                    Entry next = p2.next;
                    if (p2 == e2) {
                        if (prev == e2) {
                            this.table[i2] = next;
                        } else {
                            prev.next = next;
                        }
                        e2.value = null;
                        --this.size;
                        continue block3;
                    }
                    prev = p2;
                    p2 = next;
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private Entry<K, V>[] getTable() {
        this.expungeStaleEntries();
        return this.table;
    }

    @Override
    public int size() {
        if (this.size == 0) {
            return 0;
        }
        this.expungeStaleEntries();
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public V get(Object key) {
        if (this.callsBeforeNextExpunge-- < 0) {
            this.expungeStaleEntries();
            this.callsBeforeNextExpunge = 10;
        }
        Object k2 = WeakIdentityHashMap.maskNull(key);
        int h2 = System.identityHashCode(k2);
        Entry<K, V>[] tab = this.getTable();
        int index = WeakIdentityHashMap.indexFor(h2, tab.length);
        Entry<K, V> e2 = tab[index];
        while (e2 != null) {
            if (e2.hash == h2 && WeakIdentityHashMap.eq(k2, e2.get())) {
                return e2.value;
            }
            e2 = e2.next;
        }
        return null;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getEntry(key) != null;
    }

    Entry<K, V> getEntry(Object key) {
        Object k2 = WeakIdentityHashMap.maskNull(key);
        int h2 = System.identityHashCode(k2);
        Entry<K, V>[] tab = this.getTable();
        int index = WeakIdentityHashMap.indexFor(h2, tab.length);
        Entry<K, V> e2 = tab[index];
        while (!(e2 == null || e2.hash == h2 && WeakIdentityHashMap.eq(k2, e2.get()))) {
            e2 = e2.next;
        }
        return e2;
    }

    @Override
    public V put(K key, V value) {
        if (this.callsBeforeNextExpunge-- < 0) {
            this.expungeStaleEntries();
            this.callsBeforeNextExpunge = 10;
        }
        Object k2 = WeakIdentityHashMap.maskNull(key);
        int h2 = System.identityHashCode(k2);
        Entry<K, V>[] tab = this.getTable();
        int i2 = WeakIdentityHashMap.indexFor(h2, tab.length);
        Entry<K, V> e2 = tab[i2];
        while (e2 != null) {
            if (h2 == e2.hash && WeakIdentityHashMap.eq(k2, e2.get())) {
                Object oldValue = e2.value;
                if (value != oldValue) {
                    e2.value = value;
                }
                return oldValue;
            }
            e2 = e2.next;
        }
        ++this.modCount;
        e2 = tab[i2];
        tab[i2] = new Entry<K, V>(k2, value, this.queue, h2, e2);
        if (++this.size >= this.threshold) {
            this.resize(tab.length * 2);
        }
        return null;
    }

    void resize(int newCapacity) {
        Entry<K, V>[] oldTable = this.getTable();
        int oldCapacity = oldTable.length;
        if (oldCapacity == 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        Entry<K, V>[] newTable = this.newTable(newCapacity);
        this.transfer(oldTable, newTable);
        this.table = newTable;
        if (this.size >= this.threshold / 2) {
            this.threshold = (int)((float)newCapacity * this.loadFactor);
        } else {
            this.expungeStaleEntries();
            this.transfer(newTable, oldTable);
            this.table = oldTable;
        }
    }

    private void transfer(Entry<K, V>[] src, Entry<K, V>[] dest) {
        for (int j2 = 0; j2 < src.length; ++j2) {
            Entry<K, V> e2 = src[j2];
            src[j2] = null;
            while (e2 != null) {
                Entry next = e2.next;
                Object key = e2.get();
                if (key == null) {
                    e2.next = null;
                    e2.value = null;
                    --this.size;
                } else {
                    int i2 = WeakIdentityHashMap.indexFor(e2.hash, dest.length);
                    e2.next = dest[i2];
                    dest[i2] = e2;
                }
                e2 = next;
            }
        }
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m2) {
        int numKeysToBeAdded = m2.size();
        if (numKeysToBeAdded == 0) {
            return;
        }
        if (numKeysToBeAdded > this.threshold) {
            int newCapacity;
            int targetCapacity = (int)((float)numKeysToBeAdded / this.loadFactor + 1.0f);
            if (targetCapacity > 0x40000000) {
                targetCapacity = 0x40000000;
            }
            for (newCapacity = this.table.length; newCapacity < targetCapacity; newCapacity <<= 1) {
            }
            if (newCapacity > this.table.length) {
                this.resize(newCapacity);
            }
        }
        for (Map.Entry<K, V> e2 : m2.entrySet()) {
            this.put(e2.getKey(), e2.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        Entry<K, V> prev;
        Object k2 = WeakIdentityHashMap.maskNull(key);
        int h2 = System.identityHashCode(k2);
        Entry<K, V>[] tab = this.getTable();
        int i2 = WeakIdentityHashMap.indexFor(h2, tab.length);
        Entry<K, V> e2 = prev = tab[i2];
        while (e2 != null) {
            Entry next = e2.next;
            if (h2 == e2.hash && WeakIdentityHashMap.eq(k2, e2.get())) {
                ++this.modCount;
                --this.size;
                if (prev == e2) {
                    tab[i2] = next;
                } else {
                    prev.next = next;
                }
                return e2.value;
            }
            prev = e2;
            e2 = next;
        }
        return null;
    }

    boolean removeMapping(Object o2) {
        Entry<K, V> prev;
        if (!(o2 instanceof Map.Entry)) {
            return false;
        }
        Entry<K, V>[] tab = this.getTable();
        Map.Entry entry = (Map.Entry)o2;
        Object k2 = WeakIdentityHashMap.maskNull(entry.getKey());
        int h2 = System.identityHashCode(k2);
        int i2 = WeakIdentityHashMap.indexFor(h2, tab.length);
        Entry<K, V> e2 = prev = tab[i2];
        while (e2 != null) {
            Entry next = e2.next;
            if (h2 == e2.hash && e2.equals(entry)) {
                ++this.modCount;
                --this.size;
                if (prev == e2) {
                    tab[i2] = next;
                } else {
                    prev.next = next;
                }
                return true;
            }
            prev = e2;
            e2 = next;
        }
        return false;
    }

    @Override
    public void clear() {
        while (this.queue.poll() != null) {
        }
        ++this.modCount;
        Arrays.fill(this.table, null);
        this.size = 0;
        while (this.queue.poll() != null) {
        }
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            return this.containsNullValue();
        }
        Entry<K, V>[] tab = this.getTable();
        int i2 = tab.length;
        while (i2-- > 0) {
            Entry<K, V> e2 = tab[i2];
            while (e2 != null) {
                if (value.equals(e2.value)) {
                    return true;
                }
                e2 = e2.next;
            }
        }
        return false;
    }

    private boolean containsNullValue() {
        Entry<K, V>[] tab = this.getTable();
        int i2 = tab.length;
        while (i2-- > 0) {
            Entry<K, V> e2 = tab[i2];
            while (e2 != null) {
                if (e2.value == null) {
                    return true;
                }
                e2 = e2.next;
            }
        }
        return false;
    }

    @Override
    public Set<K> keySet() {
        KeySet ks = this.keySet;
        return ks != null ? ks : (this.keySet = new KeySet());
    }

    @Override
    public Collection<V> values() {
        Values vs = this.values;
        return vs != null ? vs : (this.values = new Values());
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet es = this.entrySet;
        return es != null ? es : (this.entrySet = new EntrySet());
    }

    @Override
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof Map)) {
            return false;
        }
        assert (o2 instanceof Map) : "wrong type";
        Map m2 = (Map)o2;
        if (m2.size() != this.size()) {
            return false;
        }
        try {
            for (Map.Entry<K, V> e2 : this.entrySet()) {
                K key = e2.getKey();
                V value = e2.getValue();
                if (!(value == null ? m2.get(key) != null || !m2.containsKey(key) : !value.equals(m2.get(key)))) continue;
                return false;
            }
        }
        catch (ClassCastException unused) {
            return false;
        }
        catch (NullPointerException unused) {
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int h2 = 0;
        Iterator<Map.Entry<K, V>> i2 = this.entrySet().iterator();
        while (i2.hasNext()) {
            h2 += i2.next().hashCode();
        }
        return h2;
    }

    public String toString() {
        Iterator<Map.Entry<K, V>> i2 = this.entrySet().iterator();
        if (!i2.hasNext()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        while (true) {
            Map.Entry<K, V> e2 = i2.next();
            K key = e2.getKey();
            V value = e2.getValue();
            sb.append((Object)(key == this ? "(this Map)" : key));
            sb.append('=');
            sb.append((Object)(value == this ? "(this Map)" : value));
            if (!i2.hasNext()) {
                return sb.append('}').toString();
            }
            sb.append(", ");
        }
    }

    protected Object clone() throws CloneNotSupportedException {
        Object clone = super.clone();
        assert (clone instanceof WeakIdentityHashMap) : "wrong type";
        WeakIdentityHashMap result = (WeakIdentityHashMap)super.clone();
        result.keySet = null;
        result.values = null;
        return result;
    }

    @DisableTrace
    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean contains(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e2 = (Map.Entry)o2;
            Entry candidate = WeakIdentityHashMap.this.getEntry(e2.getKey());
            return candidate != null && candidate.equals(e2);
        }

        @Override
        public boolean remove(Object o2) {
            return WeakIdentityHashMap.this.removeMapping(o2);
        }

        @Override
        public int size() {
            return WeakIdentityHashMap.this.size();
        }

        @Override
        public void clear() {
            WeakIdentityHashMap.this.clear();
        }

        private List<Map.Entry<K, V>> deepCopy() {
            ArrayList list = new ArrayList(this.size());
            for (Map.Entry e2 : this) {
                list.add(new AbstractMap.SimpleEntry(e2));
            }
            return list;
        }

        @Override
        public Object[] toArray() {
            return this.deepCopy().toArray();
        }

        @Override
        public <T> T[] toArray(T[] a2) {
            return this.deepCopy().toArray(a2);
        }
    }

    @DisableTrace
    private class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            return WeakIdentityHashMap.this.size();
        }

        @Override
        public boolean contains(Object o2) {
            return WeakIdentityHashMap.this.containsValue(o2);
        }

        @Override
        public void clear() {
            WeakIdentityHashMap.this.clear();
        }
    }

    @DisableTrace
    private class KeySet
    extends AbstractSet<K> {
        private KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return WeakIdentityHashMap.this.size();
        }

        @Override
        public boolean contains(Object o2) {
            return WeakIdentityHashMap.this.containsKey(o2);
        }

        @Override
        public boolean remove(Object o2) {
            if (WeakIdentityHashMap.this.containsKey(o2)) {
                WeakIdentityHashMap.this.remove(o2);
                return true;
            }
            return false;
        }

        @Override
        public void clear() {
            WeakIdentityHashMap.this.clear();
        }
    }

    @DisableTrace
    private class EntryIterator
    extends HashIterator<Map.Entry<K, V>> {
        private EntryIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            return this.nextEntry();
        }
    }

    @DisableTrace
    private class KeyIterator
    extends HashIterator<K> {
        private KeyIterator() {
        }

        @Override
        public K next() {
            return this.nextEntry().getKey();
        }
    }

    @DisableTrace
    private class ValueIterator
    extends HashIterator<V> {
        private ValueIterator() {
        }

        @Override
        public V next() {
            return this.nextEntry().value;
        }
    }

    @DisableTrace
    private abstract class HashIterator<T>
    implements Iterator<T> {
        private int index;
        private Entry<K, V> entry = null;
        private Entry<K, V> lastReturned = null;
        private int expectedModCount;
        private Object nextKey;
        private Object currentKey;

        HashIterator() {
            this.expectedModCount = WeakIdentityHashMap.this.modCount;
            this.nextKey = null;
            this.currentKey = null;
            this.index = WeakIdentityHashMap.this.isEmpty() ? 0 : WeakIdentityHashMap.this.table.length;
        }

        @Override
        public boolean hasNext() {
            Entry<K, V>[] t2 = WeakIdentityHashMap.this.table;
            while (this.nextKey == null) {
                Entry e2 = this.entry;
                int i2 = this.index;
                while (e2 == null && i2 > 0) {
                    e2 = t2[--i2];
                }
                this.entry = e2;
                this.index = i2;
                if (e2 == null) {
                    this.currentKey = null;
                    return false;
                }
                this.nextKey = e2.get();
                if (this.nextKey != null) continue;
                this.entry = this.entry.next;
            }
            return true;
        }

        protected Entry<K, V> nextEntry() {
            if (WeakIdentityHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.nextKey == null && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.entry;
            this.entry = this.entry.next;
            this.currentKey = this.nextKey;
            this.nextKey = null;
            return this.lastReturned;
        }

        @Override
        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            if (WeakIdentityHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            WeakIdentityHashMap.this.remove(this.currentKey);
            this.expectedModCount = WeakIdentityHashMap.this.modCount;
            this.lastReturned = null;
            this.currentKey = null;
        }
    }

    @DisableTrace
    private static class Entry<K, V>
    extends WeakReference<Object>
    implements Map.Entry<K, V> {
        V value;
        final int hash;
        Entry<K, V> next;

        Entry(Object key, V value, ReferenceQueue<Object> queue, int hash, Entry<K, V> next) {
            super(key, queue);
            this.value = value;
            this.hash = hash;
            this.next = next;
        }

        @Override
        public K getKey() {
            return (K)WeakIdentityHashMap.unmaskNull(this.get());
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V newValue) {
            V oldValue = this.value;
            this.value = newValue;
            return oldValue;
        }

        @Override
        public boolean equals(Object o2) {
            Object v2;
            V v1;
            Object k2;
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e2 = (Map.Entry)o2;
            K k1 = this.getKey();
            return k1 == (k2 = e2.getKey()) && ((v1 = this.getValue()) == (v2 = e2.getValue()) || v1 != null && v1.equals(v2));
        }

        @Override
        public int hashCode() {
            K k2 = this.getKey();
            V v2 = this.getValue();
            return (k2 == null ? 0 : System.identityHashCode(k2)) ^ (v2 == null ? 0 : v2.hashCode());
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }
}

