/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc.udt;

import com.informix.jdbc.IfxUDTInput;
import java.io.ByteArrayInputStream;
import java.nio.charset.Charset;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.SQLOutput;

public class BinaryVar
extends ByteArrayInputStream
implements SQLData {
    private Charset defaultCharset = Charset.defaultCharset();

    public BinaryVar() {
        super(new byte[0]);
    }

    public BinaryVar(byte[] bytes) {
        super(bytes);
    }

    @Override
    public String getSQLTypeName() throws SQLException {
        return "binaryvar";
    }

    @Override
    public void readSQL(SQLInput stream, String typeName) throws SQLException {
        IfxUDTInput input = (IfxUDTInput)stream;
        this.buf = input.readBytes(input.length());
        this.pos = 0;
        this.count = this.buf.length;
    }

    @Override
    public void writeSQL(SQLOutput stream) throws SQLException {
        stream.writeBytes(this.buf);
    }

    public byte[] getBytes() {
        return this.buf;
    }

    public String toString() {
        return new String(this.buf, this.defaultCharset);
    }

    public String toString(Charset cs) {
        return new String(this.buf, cs);
    }
}

