/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.core.base;

import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import tools.jackson.core.Base64Variant;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.core.JsonToken;
import tools.jackson.core.ObjectReadContext;
import tools.jackson.core.SerializableString;
import tools.jackson.core.StreamReadCapability;
import tools.jackson.core.StreamReadConstraints;
import tools.jackson.core.StreamReadFeature;
import tools.jackson.core.TokenStreamLocation;
import tools.jackson.core.TreeNode;
import tools.jackson.core.exc.InputCoercionException;
import tools.jackson.core.exc.JacksonIOException;
import tools.jackson.core.exc.StreamConstraintsException;
import tools.jackson.core.exc.StreamReadException;
import tools.jackson.core.exc.UnexpectedEndOfInputException;
import tools.jackson.core.io.IOContext;
import tools.jackson.core.io.NumberInput;
import tools.jackson.core.sym.PropertyNameMatcher;
import tools.jackson.core.type.ResolvedType;
import tools.jackson.core.type.TypeReference;
import tools.jackson.core.util.ByteArrayBuilder;
import tools.jackson.core.util.JacksonFeatureSet;
import tools.jackson.core.util.VersionUtil;

public abstract class ParserMinimalBase
extends JsonParser {
    protected static final int INT_TAB = 9;
    protected static final int INT_LF = 10;
    protected static final int INT_CR = 13;
    protected static final int INT_RS = 30;
    protected static final int INT_SPACE = 32;
    protected static final int INT_LBRACKET = 91;
    protected static final int INT_RBRACKET = 93;
    protected static final int INT_LCURLY = 123;
    protected static final int INT_RCURLY = 125;
    protected static final int INT_QUOTE = 34;
    protected static final int INT_APOS = 39;
    protected static final int INT_BACKSLASH = 92;
    protected static final int INT_SLASH = 47;
    protected static final int INT_ASTERISK = 42;
    protected static final int INT_COLON = 58;
    protected static final int INT_COMMA = 44;
    protected static final int INT_HASH = 35;
    protected static final int INT_0 = 48;
    protected static final int INT_9 = 57;
    protected static final int INT_MINUS = 45;
    protected static final int INT_PLUS = 43;
    protected static final int INT_PERIOD = 46;
    protected static final int INT_e = 101;
    protected static final int INT_E = 69;
    protected static final char CHAR_NULL = '\u0000';
    protected static final byte[] NO_BYTES = new byte[0];
    protected static final int[] NO_INTS = new int[0];
    protected static final int NR_UNKNOWN = 0;
    protected static final int NR_INT = 1;
    protected static final int NR_LONG = 2;
    protected static final int NR_BIGINT = 4;
    protected static final int NR_DOUBLE = 8;
    protected static final int NR_BIGDECIMAL = 16;
    protected static final int NR_FLOAT = 32;
    protected static final BigInteger BI_MIN_INT = BigInteger.valueOf(Integer.MIN_VALUE);
    protected static final BigInteger BI_MAX_INT = BigInteger.valueOf(Integer.MAX_VALUE);
    protected static final BigInteger BI_MIN_LONG = BigInteger.valueOf(Long.MIN_VALUE);
    protected static final BigInteger BI_MAX_LONG = BigInteger.valueOf(Long.MAX_VALUE);
    protected static final BigDecimal BD_MIN_LONG = new BigDecimal(BI_MIN_LONG);
    protected static final BigDecimal BD_MAX_LONG = new BigDecimal(BI_MAX_LONG);
    protected static final BigDecimal BD_MIN_INT = new BigDecimal(BI_MIN_INT);
    protected static final BigDecimal BD_MAX_INT = new BigDecimal(BI_MAX_INT);
    protected static final int MIN_BYTE_I = -128;
    protected static final int MAX_BYTE_I = 255;
    protected static final int MIN_SHORT_I = Short.MIN_VALUE;
    protected static final int MAX_SHORT_I = Short.MAX_VALUE;
    protected static final long MIN_INT_L = Integer.MIN_VALUE;
    protected static final long MAX_INT_L = Integer.MAX_VALUE;
    protected static final double MIN_LONG_D = -9.223372036854776E18;
    protected static final double MAX_LONG_D = 9.223372036854776E18;
    protected static final double MIN_INT_D = -2.147483648E9;
    protected static final double MAX_INT_D = 2.147483647E9;
    protected static final int STREAM_READ_FEATURE_DEFAULTS = StreamReadFeature.collectDefaults();
    protected final int _streamReadFeatures;
    protected final StreamReadConstraints _streamReadConstraints;
    protected final ObjectReadContext _objectReadContext;
    protected final IOContext _ioContext;
    protected boolean _closed;
    protected JsonToken _currToken;
    protected JsonToken _lastClearedToken;
    protected long _tokenCount;
    protected final boolean _trackMaxTokenCount;

    protected ParserMinimalBase(ObjectReadContext readCtxt, IOContext ioCtxt, int streamReadFeatures) {
        this._objectReadContext = readCtxt;
        this._ioContext = ioCtxt;
        this._streamReadFeatures = streamReadFeatures;
        this._streamReadConstraints = ioCtxt.streamReadConstraints();
        this._trackMaxTokenCount = this._streamReadConstraints.hasMaxTokenCount();
    }

    protected ParserMinimalBase(ObjectReadContext readCtxt) {
        this._objectReadContext = readCtxt;
        this._ioContext = null;
        this._streamReadFeatures = readCtxt.getStreamReadFeatures(STREAM_READ_FEATURE_DEFAULTS);
        this._streamReadConstraints = readCtxt.streamReadConstraints();
        this._trackMaxTokenCount = this._streamReadConstraints.hasMaxTokenCount();
    }

    @Override
    public boolean isEnabled(StreamReadFeature f) {
        return f.enabledIn(this._streamReadFeatures);
    }

    @Override
    public JacksonFeatureSet<StreamReadCapability> streamReadCapabilities() {
        return DEFAULT_READ_CAPABILITIES;
    }

    @Override
    public int streamReadFeatures() {
        return this._streamReadFeatures;
    }

    @Override
    public StreamReadConstraints streamReadConstraints() {
        return this._streamReadConstraints;
    }

    @Override
    public boolean isClosed() {
        return this._closed;
    }

    @Override
    public void close() throws JacksonException {
        if (this._closed) {
            return;
        }
        this._closed = true;
        if (StreamReadFeature.CLEAR_CURRENT_TOKEN_ON_CLOSE.enabledIn(this._streamReadFeatures)) {
            this._currToken = null;
        }
        try {
            this._closeInput();
        }
        catch (IOException e) {
            throw this._wrapIOFailure(e);
        }
        finally {
            this._releaseBuffers();
            if (this._ioContext != null) {
                this._ioContext.close();
            }
        }
    }

    protected abstract void _closeInput() throws IOException;

    protected abstract void _releaseBuffers();

    @Override
    public ObjectReadContext objectReadContext() {
        return this._objectReadContext;
    }

    protected abstract void _handleEOF() throws JacksonException;

    @Override
    public void finishToken() throws JacksonException {
    }

    @Override
    public JsonToken currentToken() {
        return this._currToken;
    }

    @Override
    public int currentTokenId() {
        JsonToken t = this._currToken;
        return t == null ? 0 : t.id();
    }

    @Override
    public boolean hasCurrentToken() {
        return this._currToken != null;
    }

    @Override
    public boolean hasTokenId(int id) {
        JsonToken t = this._currToken;
        if (t == null) {
            return 0 == id;
        }
        return t.id() == id;
    }

    @Override
    public boolean hasToken(JsonToken t) {
        return this._currToken == t;
    }

    @Override
    public long currentTokenCount() {
        return this._tokenCount;
    }

    @Override
    public boolean isExpectedStartArrayToken() {
        return this._currToken == JsonToken.START_ARRAY;
    }

    @Override
    public boolean isExpectedStartObjectToken() {
        return this._currToken == JsonToken.START_OBJECT;
    }

    @Override
    public boolean isExpectedNumberIntToken() {
        return this._currToken == JsonToken.VALUE_NUMBER_INT;
    }

    @Override
    public JsonToken nextValue() throws JacksonException {
        JsonToken t = this.nextToken();
        if (t == JsonToken.PROPERTY_NAME) {
            t = this.nextToken();
        }
        return t;
    }

    @Override
    public JsonParser skipChildren() throws JacksonException {
        if (this._currToken != JsonToken.START_OBJECT && this._currToken != JsonToken.START_ARRAY) {
            return this;
        }
        int open = 1;
        while (true) {
            JsonToken t;
            if ((t = this.nextToken()) == null) {
                this._handleEOF();
                return this;
            }
            if (t.isStructStart()) {
                ++open;
                continue;
            }
            if (t.isStructEnd()) {
                if (--open != 0) continue;
                return this;
            }
            if (t != JsonToken.NOT_AVAILABLE) continue;
            this._reportError("Not enough content available for `skipChildren()`: non-blocking parser? (%s)", this.getClass().getName());
        }
    }

    @Override
    public String nextName() throws JacksonException {
        return this.nextToken() == JsonToken.PROPERTY_NAME ? this.currentName() : null;
    }

    @Override
    public boolean nextName(SerializableString str) throws JacksonException {
        return this.nextToken() == JsonToken.PROPERTY_NAME && str.getValue().equals(this.currentName());
    }

    @Override
    public int nextNameMatch(PropertyNameMatcher matcher) throws JacksonException {
        String str = this.nextName();
        if (str != null) {
            return matcher.matchName(str);
        }
        if (this._currToken == JsonToken.END_OBJECT) {
            return -1;
        }
        return -3;
    }

    @Override
    public int currentNameMatch(PropertyNameMatcher matcher) {
        if (this._currToken == JsonToken.PROPERTY_NAME) {
            return matcher.matchName(this.currentName());
        }
        if (this._currToken == JsonToken.END_OBJECT) {
            return -1;
        }
        return -3;
    }

    @Override
    public void clearCurrentToken() {
        if (this._currToken != null) {
            this._lastClearedToken = this._currToken;
            this._currToken = null;
        }
    }

    @Override
    public JsonToken getLastClearedToken() {
        return this._lastClearedToken;
    }

    @Override
    public int getString(Writer writer) throws JacksonException {
        String str = this.getString();
        if (str == null) {
            return 0;
        }
        try {
            writer.write(str);
        }
        catch (IOException e) {
            throw this._wrapIOFailure(e);
        }
        return str.length();
    }

    @Override
    public JsonParser.NumberTypeFP getNumberTypeFP() {
        return JsonParser.NumberTypeFP.UNKNOWN;
    }

    @Override
    public Number getNumberValueExact() throws InputCoercionException {
        return this.getNumberValue();
    }

    @Override
    public Object getNumberValueDeferred() throws InputCoercionException {
        return this.getNumberValue();
    }

    @Override
    public byte getByteValue() throws InputCoercionException {
        int value = this.getIntValue();
        if (value < -128 || value > 255) {
            this._reportOverflowByte(this.getString(), this.currentToken());
        }
        return (byte)value;
    }

    @Override
    public short getShortValue() throws InputCoercionException {
        int value = this.getIntValue();
        if (value < Short.MIN_VALUE || value > Short.MAX_VALUE) {
            this._reportOverflowShort(this.getString(), this.currentToken());
        }
        return (short)value;
    }

    @Override
    public boolean getBooleanValue() throws InputCoercionException {
        JsonToken t = this.currentToken();
        if (t == JsonToken.VALUE_TRUE) {
            return true;
        }
        if (t == JsonToken.VALUE_FALSE) {
            return false;
        }
        throw this._constructInputCoercion(String.format("Current token (%s) not of boolean type", new Object[]{t}), t, Boolean.TYPE);
    }

    @Override
    public Object getEmbeddedObject() {
        return null;
    }

    @Override
    public boolean getValueAsBoolean(boolean defaultValue) {
        JsonToken t = this._currToken;
        if (t != null) {
            switch (t.id()) {
                case 6: {
                    String str = this.getString().trim();
                    if ("true".equals(str)) {
                        return true;
                    }
                    if ("false".equals(str)) {
                        return false;
                    }
                    if (!this._hasTextualNull(str)) break;
                    return false;
                }
                case 7: {
                    return this.getIntValue() != 0;
                }
                case 9: {
                    return true;
                }
                case 10: 
                case 11: {
                    return false;
                }
                case 12: {
                    Object value = this.getEmbeddedObject();
                    if (!(value instanceof Boolean)) break;
                    return (Boolean)value;
                }
            }
        }
        return defaultValue;
    }

    @Override
    public int getValueAsInt() {
        JsonToken t = this._currToken;
        if (t == JsonToken.VALUE_NUMBER_INT || t == JsonToken.VALUE_NUMBER_FLOAT) {
            return this.getIntValue();
        }
        return this.getValueAsInt(0);
    }

    @Override
    public int getValueAsInt(int defaultValue) {
        JsonToken t = this._currToken;
        if (t == JsonToken.VALUE_NUMBER_INT || t == JsonToken.VALUE_NUMBER_FLOAT) {
            return this.getIntValue();
        }
        if (t != null) {
            switch (t.id()) {
                case 6: {
                    String str = this.getString();
                    if (this._hasTextualNull(str)) {
                        return 0;
                    }
                    return NumberInput.parseAsInt(str, defaultValue);
                }
                case 9: {
                    return 1;
                }
                case 10: {
                    return 0;
                }
                case 11: {
                    return 0;
                }
                case 12: {
                    Object value = this.getEmbeddedObject();
                    if (!(value instanceof Number)) break;
                    return ((Number)value).intValue();
                }
            }
        }
        return defaultValue;
    }

    @Override
    public long getValueAsLong() {
        JsonToken t = this._currToken;
        if (t == JsonToken.VALUE_NUMBER_INT || t == JsonToken.VALUE_NUMBER_FLOAT) {
            return this.getLongValue();
        }
        return this.getValueAsLong(0L);
    }

    @Override
    public long getValueAsLong(long defaultValue) {
        JsonToken t = this._currToken;
        if (t == JsonToken.VALUE_NUMBER_INT || t == JsonToken.VALUE_NUMBER_FLOAT) {
            return this.getLongValue();
        }
        if (t != null) {
            switch (t.id()) {
                case 6: {
                    String str = this.getString();
                    if (this._hasTextualNull(str)) {
                        return 0L;
                    }
                    return NumberInput.parseAsLong(str, defaultValue);
                }
                case 9: {
                    return 1L;
                }
                case 10: 
                case 11: {
                    return 0L;
                }
                case 12: {
                    Object value = this.getEmbeddedObject();
                    if (!(value instanceof Number)) break;
                    return ((Number)value).longValue();
                }
            }
        }
        return defaultValue;
    }

    @Override
    public double getValueAsDouble(double defaultValue) {
        JsonToken t = this._currToken;
        if (t != null) {
            switch (t.id()) {
                case 6: {
                    String str = this.getString();
                    if (this._hasTextualNull(str)) {
                        return 0.0;
                    }
                    return NumberInput.parseAsDouble(str, defaultValue, this.isEnabled(StreamReadFeature.USE_FAST_DOUBLE_PARSER));
                }
                case 7: 
                case 8: {
                    return this.getDoubleValue();
                }
                case 9: {
                    return 1.0;
                }
                case 10: 
                case 11: {
                    return 0.0;
                }
                case 12: {
                    Object value = this.getEmbeddedObject();
                    if (!(value instanceof Number)) break;
                    return ((Number)value).doubleValue();
                }
            }
        }
        return defaultValue;
    }

    @Override
    public String getValueAsString() {
        return this.getValueAsString(null);
    }

    @Override
    public String getValueAsString(String defaultValue) {
        if (this._currToken == JsonToken.VALUE_STRING) {
            return this.getString();
        }
        if (this._currToken == JsonToken.PROPERTY_NAME) {
            return this.currentName();
        }
        if (this._currToken == null || this._currToken == JsonToken.VALUE_NULL || !this._currToken.isScalarValue()) {
            return defaultValue;
        }
        return this.getString();
    }

    @Override
    public <T> T readValueAs(Class<T> valueType) throws JacksonException {
        return this._objectReadContext.readValue((JsonParser)this, valueType);
    }

    @Override
    public <T> T readValueAs(TypeReference<T> valueTypeRef) throws JacksonException {
        return this._objectReadContext.readValue((JsonParser)this, valueTypeRef);
    }

    @Override
    public <T> T readValueAs(ResolvedType type) throws JacksonException {
        return this._objectReadContext.readValue((JsonParser)this, type);
    }

    @Override
    public <T extends TreeNode> T readValueAsTree() throws JacksonException {
        return this._objectReadContext.readTree(this);
    }

    protected void _decodeBase64(String str, ByteArrayBuilder builder, Base64Variant b64variant) throws JacksonException {
        try {
            b64variant.decode(str, builder);
        }
        catch (IllegalArgumentException e) {
            this._reportError(e.getMessage());
        }
    }

    protected boolean _hasTextualNull(String value) {
        return "null".equals(value);
    }

    protected <T> T _reportInvalidNumber(String msg) throws StreamReadException {
        return this._reportError("Invalid numeric value: " + msg);
    }

    protected void _reportOverflowByte(String numDesc, JsonToken inputType) throws InputCoercionException {
        throw this._constructInputCoercion(String.format("Numeric value (%s) out of range of `byte` (%d - %s)", this._longIntegerDesc(numDesc), -128, 255), inputType, Byte.TYPE);
    }

    protected void _reportOverflowShort(String numDesc, JsonToken inputType) throws InputCoercionException {
        throw this._constructInputCoercion(String.format("Numeric value (%s) out of range of `short` (%d - %s)", this._longIntegerDesc(numDesc), Short.MIN_VALUE, Short.MAX_VALUE), inputType, Short.TYPE);
    }

    protected void _reportOverflowInt() throws InputCoercionException {
        this._reportOverflowInt(this.getString());
    }

    protected void _reportOverflowInt(String numDesc) throws InputCoercionException {
        this._reportOverflowInt(numDesc, this.currentToken());
    }

    protected void _reportOverflowInt(String numDesc, JsonToken inputType) throws InputCoercionException {
        throw this._constructInputCoercion(String.format("Numeric value (%s) out of range of `int` (%d - %s)", this._longIntegerDesc(numDesc), Integer.MIN_VALUE, Integer.MAX_VALUE), inputType, Integer.TYPE);
    }

    protected void _reportOverflowLong() throws InputCoercionException {
        this._reportOverflowLong(this.getString());
    }

    protected void _reportOverflowLong(String numDesc) throws InputCoercionException {
        this._reportOverflowLong(numDesc, this.currentToken());
    }

    protected void _reportOverflowLong(String numDesc, JsonToken inputType) throws InputCoercionException {
        throw this._constructInputCoercion(String.format("Numeric value (%s) out of range of `long` (%d - %s)", this._longIntegerDesc(numDesc), Long.MIN_VALUE, Long.MAX_VALUE), inputType, Long.TYPE);
    }

    protected String _longIntegerDesc(String rawNum) {
        int rawLen = rawNum.length();
        if (rawLen < 1000) {
            return rawNum;
        }
        if (rawNum.startsWith("-")) {
            --rawLen;
        }
        return String.format("[Integer with %d digits]", rawLen);
    }

    protected String _longNumberDesc(String rawNum) {
        int rawLen = rawNum.length();
        if (rawLen < 1000) {
            return rawNum;
        }
        if (rawNum.startsWith("-")) {
            --rawLen;
        }
        return String.format("[number with %d characters]", rawLen);
    }

    protected <T> T _reportBadInputStream(int readLen) throws StreamReadException {
        throw this._wrapIOFailure(new IOException("Bad input source: InputStream.read() returned 0 bytes when trying to read " + readLen + " bytes"));
    }

    protected <T> T _reportBadReader(int readLen) throws StreamReadException {
        throw this._wrapIOFailure(new IOException("Bad input source: Reader.read() returned 0 bytes when trying to read " + readLen + " bytes"));
    }

    protected <T> T _reportInvalidEOF() throws StreamReadException {
        return this._reportInvalidEOF(" in " + String.valueOf((Object)this._currToken), this._currToken);
    }

    protected <T> T _reportInvalidEOFInValue(JsonToken type) throws StreamReadException {
        String msg = type == JsonToken.VALUE_STRING ? " in a String value" : (type == JsonToken.VALUE_NUMBER_INT || type == JsonToken.VALUE_NUMBER_FLOAT ? " in a Number value" : " in a value");
        return this._reportInvalidEOF(msg, type);
    }

    protected <T> T _reportInvalidEOF(String msg, JsonToken currToken) throws StreamReadException {
        throw new UnexpectedEndOfInputException((JsonParser)this, currToken, "Unexpected end-of-input" + msg);
    }

    protected <T> T _reportInvalidSpace(int i) throws StreamReadException {
        char c = (char)i;
        String msg = "Illegal character (" + ParserMinimalBase._getCharDesc(c) + "): only regular white space (\\r, \\n, \\t) is allowed between tokens";
        if (i == 30) {
            msg = msg + " (consider enabling `JsonReadFeature.ALLOW_RS_CONTROL_CHAR` to allow use of Record Separators (\\u001E))";
        }
        throw this._constructReadException(msg, this._currentLocationMinusOne());
    }

    protected <T> T _reportMissingRootWS(int ch) throws StreamReadException {
        return this._reportUnexpectedChar(ch, "Expected space separating root-level values");
    }

    protected <T> T _reportUnexpectedChar(int ch, String comment) throws StreamReadException {
        if (ch < 0) {
            this._reportInvalidEOF();
        }
        Object msg = String.format("Unexpected character (%s)", ParserMinimalBase._getCharDesc(ch));
        if (comment != null) {
            msg = (String)msg + ": " + comment;
        }
        throw this._constructReadException((String)msg, this._currentLocationMinusOne());
    }

    protected <T> T _reportUnexpectedNumberChar(int ch, String comment) throws StreamReadException {
        Object msg = String.format("Unexpected character (%s) in numeric value", ParserMinimalBase._getCharDesc(ch));
        if (comment != null) {
            msg = (String)msg + ": " + comment;
        }
        throw this._constructReadException((String)msg, this._currentLocationMinusOne());
    }

    protected void _reportInvalidUTF8Surrogate(int ch) throws StreamReadException {
        throw this._constructReadException("Invalid UTF-8: Illegal surrogate character 0x" + Integer.toHexString(ch));
    }

    protected TokenStreamLocation _currentLocationMinusOne() {
        return this.currentLocation();
    }

    protected static final String _getCharDesc(int ch) {
        char c = (char)ch;
        if (Character.isISOControl(c)) {
            return "(CTRL-CHAR, code " + ch + ")";
        }
        if (ch > 255) {
            return "'" + c + "' (code " + ch + " / 0x" + Integer.toHexString(ch) + ")";
        }
        return "'" + c + "' (code " + ch + ")";
    }

    protected InputCoercionException _constructNotNumericType(JsonToken actualToken, int expNumericType) {
        String msg = String.format("Current token (%s) not numeric, cannot use numeric value accessors", new Object[]{actualToken});
        return this._constructInputCoercion(msg, actualToken, switch (expNumericType) {
            case 1 -> Integer.TYPE;
            case 2 -> Long.TYPE;
            case 4 -> BigInteger.class;
            case 32 -> Float.TYPE;
            case 8 -> Double.TYPE;
            case 16 -> BigDecimal.class;
            default -> Number.class;
        });
    }

    protected InputCoercionException _constructInputCoercion(String msg, JsonToken inputType, Class<?> targetType) {
        return new InputCoercionException((JsonParser)this, msg, inputType, targetType);
    }

    protected <T> T _reportError(String msg) throws StreamReadException {
        throw this._constructReadException(msg);
    }

    protected <T> T _reportError(String msg, Object arg) throws StreamReadException {
        throw this._constructReadException(String.format(msg, arg));
    }

    protected <T> T _reportError(String msg, Object arg1, Object arg2) throws StreamReadException {
        throw this._constructReadException(String.format(msg, arg1, arg2));
    }

    protected <T> T _reportError(String msg, Object arg1, Object arg2, Object arg3) throws StreamReadException {
        throw this._constructReadException(String.format(msg, arg1, arg2, arg3));
    }

    protected JacksonException _wrapIOFailure(IOException e) {
        return JacksonIOException.construct(e, this);
    }

    protected <T> T _throwInternal() {
        return VersionUtil.throwInternalReturnAny();
    }

    protected final JsonToken _updateToken(JsonToken token) throws StreamConstraintsException {
        this._currToken = token;
        if (this._trackMaxTokenCount) {
            this._streamReadConstraints.validateTokenCount(++this._tokenCount);
        }
        return token;
    }

    protected final JsonToken _nullSafeUpdateToken(JsonToken token) throws StreamConstraintsException {
        this._currToken = token;
        if (this._trackMaxTokenCount && token != null) {
            this._streamReadConstraints.validateTokenCount(++this._tokenCount);
        }
        return token;
    }

    protected final JsonToken _updateTokenToNull() {
        this._currToken = null;
        return null;
    }

    protected final JsonToken _updateTokenToNA() {
        this._currToken = JsonToken.NOT_AVAILABLE;
        return this._currToken;
    }
}

