// Code generated by Microsoft Kiota - DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package models

import (
    i336074805fc853987abe6f7fe3ad97a6a6f3077a16391fec744f671a015fbd7e "time"
    i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91 "github.com/microsoft/kiota-abstractions-go/serialization"
)

type ReadingAssignmentSubmission struct {
    Entity
}
// NewReadingAssignmentSubmission instantiates a new ReadingAssignmentSubmission and sets the default values.
func NewReadingAssignmentSubmission()(*ReadingAssignmentSubmission) {
    m := &ReadingAssignmentSubmission{
        Entity: *NewEntity(),
    }
    return m
}
// CreateReadingAssignmentSubmissionFromDiscriminatorValue creates a new instance of the appropriate class based on discriminator value
// returns a Parsable when successful
func CreateReadingAssignmentSubmissionFromDiscriminatorValue(parseNode i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode)(i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.Parsable, error) {
    return NewReadingAssignmentSubmission(), nil
}
// GetAccuracyScore gets the accuracyScore property value. Accuracy score of the reading progress.
// returns a *float64 when successful
func (m *ReadingAssignmentSubmission) GetAccuracyScore()(*float64) {
    val, err := m.GetBackingStore().Get("accuracyScore")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(*float64)
    }
    return nil
}
// GetAction gets the action property value. Indicates whether the submission is an attempt by the student or a miscue edit done by the educator. The possible values are Attempt and EditMiscue.
// returns a *string when successful
func (m *ReadingAssignmentSubmission) GetAction()(*string) {
    val, err := m.GetBackingStore().Get("action")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(*string)
    }
    return nil
}
// GetAssignmentId gets the assignmentId property value. ID of the assignment with which this submission is associated.
// returns a *string when successful
func (m *ReadingAssignmentSubmission) GetAssignmentId()(*string) {
    val, err := m.GetBackingStore().Get("assignmentId")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(*string)
    }
    return nil
}
// GetChallengingWords gets the challengingWords property value. List of words that the student found challenging during the reading session.
// returns a []ChallengingWordable when successful
func (m *ReadingAssignmentSubmission) GetChallengingWords()([]ChallengingWordable) {
    val, err := m.GetBackingStore().Get("challengingWords")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.([]ChallengingWordable)
    }
    return nil
}
// GetClassId gets the classId property value. ID of the class this reading progress is associated with.
// returns a *string when successful
func (m *ReadingAssignmentSubmission) GetClassId()(*string) {
    val, err := m.GetBackingStore().Get("classId")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(*string)
    }
    return nil
}
// GetFieldDeserializers the deserialization information for the current model
// returns a map[string]func(i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode)(error) when successful
func (m *ReadingAssignmentSubmission) GetFieldDeserializers()(map[string]func(i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode)(error)) {
    res := m.Entity.GetFieldDeserializers()
    res["accuracyScore"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetFloat64Value()
        if err != nil {
            return err
        }
        if val != nil {
            m.SetAccuracyScore(val)
        }
        return nil
    }
    res["action"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetStringValue()
        if err != nil {
            return err
        }
        if val != nil {
            m.SetAction(val)
        }
        return nil
    }
    res["assignmentId"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetStringValue()
        if err != nil {
            return err
        }
        if val != nil {
            m.SetAssignmentId(val)
        }
        return nil
    }
    res["challengingWords"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetCollectionOfObjectValues(CreateChallengingWordFromDiscriminatorValue)
        if err != nil {
            return err
        }
        if val != nil {
            res := make([]ChallengingWordable, len(val))
            for i, v := range val {
                if v != nil {
                    res[i] = v.(ChallengingWordable)
                }
            }
            m.SetChallengingWords(res)
        }
        return nil
    }
    res["classId"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetStringValue()
        if err != nil {
            return err
        }
        if val != nil {
            m.SetClassId(val)
        }
        return nil
    }
    res["insertions"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetInt64Value()
        if err != nil {
            return err
        }
        if val != nil {
            m.SetInsertions(val)
        }
        return nil
    }
    res["mispronunciations"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetInt64Value()
        if err != nil {
            return err
        }
        if val != nil {
            m.SetMispronunciations(val)
        }
        return nil
    }
    res["missedExclamationMarks"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetInt64Value()
        if err != nil {
            return err
        }
        if val != nil {
            m.SetMissedExclamationMarks(val)
        }
        return nil
    }
    res["missedPeriods"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetInt64Value()
        if err != nil {
            return err
        }
        if val != nil {
            m.SetMissedPeriods(val)
        }
        return nil
    }
    res["missedQuestionMarks"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetInt64Value()
        if err != nil {
            return err
        }
        if val != nil {
            m.SetMissedQuestionMarks(val)
        }
        return nil
    }
    res["missedShorts"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetInt64Value()
        if err != nil {
            return err
        }
        if val != nil {
            m.SetMissedShorts(val)
        }
        return nil
    }
    res["monotoneScore"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetFloat64Value()
        if err != nil {
            return err
        }
        if val != nil {
            m.SetMonotoneScore(val)
        }
        return nil
    }
    res["omissions"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetInt64Value()
        if err != nil {
            return err
        }
        if val != nil {
            m.SetOmissions(val)
        }
        return nil
    }
    res["repetitions"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetInt64Value()
        if err != nil {
            return err
        }
        if val != nil {
            m.SetRepetitions(val)
        }
        return nil
    }
    res["selfCorrections"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetInt64Value()
        if err != nil {
            return err
        }
        if val != nil {
            m.SetSelfCorrections(val)
        }
        return nil
    }
    res["studentId"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetStringValue()
        if err != nil {
            return err
        }
        if val != nil {
            m.SetStudentId(val)
        }
        return nil
    }
    res["submissionDateTime"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetTimeValue()
        if err != nil {
            return err
        }
        if val != nil {
            m.SetSubmissionDateTime(val)
        }
        return nil
    }
    res["submissionId"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetStringValue()
        if err != nil {
            return err
        }
        if val != nil {
            m.SetSubmissionId(val)
        }
        return nil
    }
    res["unexpectedPauses"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetInt64Value()
        if err != nil {
            return err
        }
        if val != nil {
            m.SetUnexpectedPauses(val)
        }
        return nil
    }
    res["wordCount"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetInt64Value()
        if err != nil {
            return err
        }
        if val != nil {
            m.SetWordCount(val)
        }
        return nil
    }
    res["wordsPerMinute"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetFloat64Value()
        if err != nil {
            return err
        }
        if val != nil {
            m.SetWordsPerMinute(val)
        }
        return nil
    }
    return res
}
// GetInsertions gets the insertions property value. Insertions of the reading progress.
// returns a *int64 when successful
func (m *ReadingAssignmentSubmission) GetInsertions()(*int64) {
    val, err := m.GetBackingStore().Get("insertions")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(*int64)
    }
    return nil
}
// GetMispronunciations gets the mispronunciations property value. Mispronunciations of the reading progress.
// returns a *int64 when successful
func (m *ReadingAssignmentSubmission) GetMispronunciations()(*int64) {
    val, err := m.GetBackingStore().Get("mispronunciations")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(*int64)
    }
    return nil
}
// GetMissedExclamationMarks gets the missedExclamationMarks property value. Number of exclamation marks missed in the reading passage.
// returns a *int64 when successful
func (m *ReadingAssignmentSubmission) GetMissedExclamationMarks()(*int64) {
    val, err := m.GetBackingStore().Get("missedExclamationMarks")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(*int64)
    }
    return nil
}
// GetMissedPeriods gets the missedPeriods property value. Number of periods missed in the reading passage.
// returns a *int64 when successful
func (m *ReadingAssignmentSubmission) GetMissedPeriods()(*int64) {
    val, err := m.GetBackingStore().Get("missedPeriods")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(*int64)
    }
    return nil
}
// GetMissedQuestionMarks gets the missedQuestionMarks property value. Number of question marks missed in the reading passage.
// returns a *int64 when successful
func (m *ReadingAssignmentSubmission) GetMissedQuestionMarks()(*int64) {
    val, err := m.GetBackingStore().Get("missedQuestionMarks")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(*int64)
    }
    return nil
}
// GetMissedShorts gets the missedShorts property value. Number of short words missed during the reading session.
// returns a *int64 when successful
func (m *ReadingAssignmentSubmission) GetMissedShorts()(*int64) {
    val, err := m.GetBackingStore().Get("missedShorts")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(*int64)
    }
    return nil
}
// GetMonotoneScore gets the monotoneScore property value. Score that reflects the student's use of intonation and expression. Lower scores indicate more monotone reading.
// returns a *float64 when successful
func (m *ReadingAssignmentSubmission) GetMonotoneScore()(*float64) {
    val, err := m.GetBackingStore().Get("monotoneScore")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(*float64)
    }
    return nil
}
// GetOmissions gets the omissions property value. Omissions of the reading progress.
// returns a *int64 when successful
func (m *ReadingAssignmentSubmission) GetOmissions()(*int64) {
    val, err := m.GetBackingStore().Get("omissions")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(*int64)
    }
    return nil
}
// GetRepetitions gets the repetitions property value. Number of times the student repeated words or phrases during the reading session.
// returns a *int64 when successful
func (m *ReadingAssignmentSubmission) GetRepetitions()(*int64) {
    val, err := m.GetBackingStore().Get("repetitions")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(*int64)
    }
    return nil
}
// GetSelfCorrections gets the selfCorrections property value. Number of times the student self-corrected their reading errors.
// returns a *int64 when successful
func (m *ReadingAssignmentSubmission) GetSelfCorrections()(*int64) {
    val, err := m.GetBackingStore().Get("selfCorrections")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(*int64)
    }
    return nil
}
// GetStudentId gets the studentId property value. ID of the user this reading progress is associated with.
// returns a *string when successful
func (m *ReadingAssignmentSubmission) GetStudentId()(*string) {
    val, err := m.GetBackingStore().Get("studentId")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(*string)
    }
    return nil
}
// GetSubmissionDateTime gets the submissionDateTime property value. Date and time of the submission this reading progress is associated with. The timestamp type represents date and time information using ISO 8601 format and is always in UTC. For example, midnight UTC on Jan 1, 2014 is 2014-01-01T00:00:00Z.
// returns a *Time when successful
func (m *ReadingAssignmentSubmission) GetSubmissionDateTime()(*i336074805fc853987abe6f7fe3ad97a6a6f3077a16391fec744f671a015fbd7e.Time) {
    val, err := m.GetBackingStore().Get("submissionDateTime")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(*i336074805fc853987abe6f7fe3ad97a6a6f3077a16391fec744f671a015fbd7e.Time)
    }
    return nil
}
// GetSubmissionId gets the submissionId property value. ID of the submission this reading progress is associated with.
// returns a *string when successful
func (m *ReadingAssignmentSubmission) GetSubmissionId()(*string) {
    val, err := m.GetBackingStore().Get("submissionId")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(*string)
    }
    return nil
}
// GetUnexpectedPauses gets the unexpectedPauses property value. Number of unexpected pauses made during the reading session.
// returns a *int64 when successful
func (m *ReadingAssignmentSubmission) GetUnexpectedPauses()(*int64) {
    val, err := m.GetBackingStore().Get("unexpectedPauses")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(*int64)
    }
    return nil
}
// GetWordCount gets the wordCount property value. Words count of the reading progress.
// returns a *int64 when successful
func (m *ReadingAssignmentSubmission) GetWordCount()(*int64) {
    val, err := m.GetBackingStore().Get("wordCount")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(*int64)
    }
    return nil
}
// GetWordsPerMinute gets the wordsPerMinute property value. Words per minute of the reading progress.
// returns a *float64 when successful
func (m *ReadingAssignmentSubmission) GetWordsPerMinute()(*float64) {
    val, err := m.GetBackingStore().Get("wordsPerMinute")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(*float64)
    }
    return nil
}
// Serialize serializes information the current object
func (m *ReadingAssignmentSubmission) Serialize(writer i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.SerializationWriter)(error) {
    err := m.Entity.Serialize(writer)
    if err != nil {
        return err
    }
    {
        err = writer.WriteFloat64Value("accuracyScore", m.GetAccuracyScore())
        if err != nil {
            return err
        }
    }
    {
        err = writer.WriteStringValue("action", m.GetAction())
        if err != nil {
            return err
        }
    }
    {
        err = writer.WriteStringValue("assignmentId", m.GetAssignmentId())
        if err != nil {
            return err
        }
    }
    if m.GetChallengingWords() != nil {
        cast := make([]i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.Parsable, len(m.GetChallengingWords()))
        for i, v := range m.GetChallengingWords() {
            if v != nil {
                cast[i] = v.(i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.Parsable)
            }
        }
        err = writer.WriteCollectionOfObjectValues("challengingWords", cast)
        if err != nil {
            return err
        }
    }
    {
        err = writer.WriteStringValue("classId", m.GetClassId())
        if err != nil {
            return err
        }
    }
    {
        err = writer.WriteInt64Value("insertions", m.GetInsertions())
        if err != nil {
            return err
        }
    }
    {
        err = writer.WriteInt64Value("mispronunciations", m.GetMispronunciations())
        if err != nil {
            return err
        }
    }
    {
        err = writer.WriteInt64Value("missedExclamationMarks", m.GetMissedExclamationMarks())
        if err != nil {
            return err
        }
    }
    {
        err = writer.WriteInt64Value("missedPeriods", m.GetMissedPeriods())
        if err != nil {
            return err
        }
    }
    {
        err = writer.WriteInt64Value("missedQuestionMarks", m.GetMissedQuestionMarks())
        if err != nil {
            return err
        }
    }
    {
        err = writer.WriteInt64Value("missedShorts", m.GetMissedShorts())
        if err != nil {
            return err
        }
    }
    {
        err = writer.WriteFloat64Value("monotoneScore", m.GetMonotoneScore())
        if err != nil {
            return err
        }
    }
    {
        err = writer.WriteInt64Value("omissions", m.GetOmissions())
        if err != nil {
            return err
        }
    }
    {
        err = writer.WriteInt64Value("repetitions", m.GetRepetitions())
        if err != nil {
            return err
        }
    }
    {
        err = writer.WriteInt64Value("selfCorrections", m.GetSelfCorrections())
        if err != nil {
            return err
        }
    }
    {
        err = writer.WriteStringValue("studentId", m.GetStudentId())
        if err != nil {
            return err
        }
    }
    {
        err = writer.WriteTimeValue("submissionDateTime", m.GetSubmissionDateTime())
        if err != nil {
            return err
        }
    }
    {
        err = writer.WriteStringValue("submissionId", m.GetSubmissionId())
        if err != nil {
            return err
        }
    }
    {
        err = writer.WriteInt64Value("unexpectedPauses", m.GetUnexpectedPauses())
        if err != nil {
            return err
        }
    }
    {
        err = writer.WriteInt64Value("wordCount", m.GetWordCount())
        if err != nil {
            return err
        }
    }
    {
        err = writer.WriteFloat64Value("wordsPerMinute", m.GetWordsPerMinute())
        if err != nil {
            return err
        }
    }
    return nil
}
// SetAccuracyScore sets the accuracyScore property value. Accuracy score of the reading progress.
func (m *ReadingAssignmentSubmission) SetAccuracyScore(value *float64)() {
    err := m.GetBackingStore().Set("accuracyScore", value)
    if err != nil {
        panic(err)
    }
}
// SetAction sets the action property value. Indicates whether the submission is an attempt by the student or a miscue edit done by the educator. The possible values are Attempt and EditMiscue.
func (m *ReadingAssignmentSubmission) SetAction(value *string)() {
    err := m.GetBackingStore().Set("action", value)
    if err != nil {
        panic(err)
    }
}
// SetAssignmentId sets the assignmentId property value. ID of the assignment with which this submission is associated.
func (m *ReadingAssignmentSubmission) SetAssignmentId(value *string)() {
    err := m.GetBackingStore().Set("assignmentId", value)
    if err != nil {
        panic(err)
    }
}
// SetChallengingWords sets the challengingWords property value. List of words that the student found challenging during the reading session.
func (m *ReadingAssignmentSubmission) SetChallengingWords(value []ChallengingWordable)() {
    err := m.GetBackingStore().Set("challengingWords", value)
    if err != nil {
        panic(err)
    }
}
// SetClassId sets the classId property value. ID of the class this reading progress is associated with.
func (m *ReadingAssignmentSubmission) SetClassId(value *string)() {
    err := m.GetBackingStore().Set("classId", value)
    if err != nil {
        panic(err)
    }
}
// SetInsertions sets the insertions property value. Insertions of the reading progress.
func (m *ReadingAssignmentSubmission) SetInsertions(value *int64)() {
    err := m.GetBackingStore().Set("insertions", value)
    if err != nil {
        panic(err)
    }
}
// SetMispronunciations sets the mispronunciations property value. Mispronunciations of the reading progress.
func (m *ReadingAssignmentSubmission) SetMispronunciations(value *int64)() {
    err := m.GetBackingStore().Set("mispronunciations", value)
    if err != nil {
        panic(err)
    }
}
// SetMissedExclamationMarks sets the missedExclamationMarks property value. Number of exclamation marks missed in the reading passage.
func (m *ReadingAssignmentSubmission) SetMissedExclamationMarks(value *int64)() {
    err := m.GetBackingStore().Set("missedExclamationMarks", value)
    if err != nil {
        panic(err)
    }
}
// SetMissedPeriods sets the missedPeriods property value. Number of periods missed in the reading passage.
func (m *ReadingAssignmentSubmission) SetMissedPeriods(value *int64)() {
    err := m.GetBackingStore().Set("missedPeriods", value)
    if err != nil {
        panic(err)
    }
}
// SetMissedQuestionMarks sets the missedQuestionMarks property value. Number of question marks missed in the reading passage.
func (m *ReadingAssignmentSubmission) SetMissedQuestionMarks(value *int64)() {
    err := m.GetBackingStore().Set("missedQuestionMarks", value)
    if err != nil {
        panic(err)
    }
}
// SetMissedShorts sets the missedShorts property value. Number of short words missed during the reading session.
func (m *ReadingAssignmentSubmission) SetMissedShorts(value *int64)() {
    err := m.GetBackingStore().Set("missedShorts", value)
    if err != nil {
        panic(err)
    }
}
// SetMonotoneScore sets the monotoneScore property value. Score that reflects the student's use of intonation and expression. Lower scores indicate more monotone reading.
func (m *ReadingAssignmentSubmission) SetMonotoneScore(value *float64)() {
    err := m.GetBackingStore().Set("monotoneScore", value)
    if err != nil {
        panic(err)
    }
}
// SetOmissions sets the omissions property value. Omissions of the reading progress.
func (m *ReadingAssignmentSubmission) SetOmissions(value *int64)() {
    err := m.GetBackingStore().Set("omissions", value)
    if err != nil {
        panic(err)
    }
}
// SetRepetitions sets the repetitions property value. Number of times the student repeated words or phrases during the reading session.
func (m *ReadingAssignmentSubmission) SetRepetitions(value *int64)() {
    err := m.GetBackingStore().Set("repetitions", value)
    if err != nil {
        panic(err)
    }
}
// SetSelfCorrections sets the selfCorrections property value. Number of times the student self-corrected their reading errors.
func (m *ReadingAssignmentSubmission) SetSelfCorrections(value *int64)() {
    err := m.GetBackingStore().Set("selfCorrections", value)
    if err != nil {
        panic(err)
    }
}
// SetStudentId sets the studentId property value. ID of the user this reading progress is associated with.
func (m *ReadingAssignmentSubmission) SetStudentId(value *string)() {
    err := m.GetBackingStore().Set("studentId", value)
    if err != nil {
        panic(err)
    }
}
// SetSubmissionDateTime sets the submissionDateTime property value. Date and time of the submission this reading progress is associated with. The timestamp type represents date and time information using ISO 8601 format and is always in UTC. For example, midnight UTC on Jan 1, 2014 is 2014-01-01T00:00:00Z.
func (m *ReadingAssignmentSubmission) SetSubmissionDateTime(value *i336074805fc853987abe6f7fe3ad97a6a6f3077a16391fec744f671a015fbd7e.Time)() {
    err := m.GetBackingStore().Set("submissionDateTime", value)
    if err != nil {
        panic(err)
    }
}
// SetSubmissionId sets the submissionId property value. ID of the submission this reading progress is associated with.
func (m *ReadingAssignmentSubmission) SetSubmissionId(value *string)() {
    err := m.GetBackingStore().Set("submissionId", value)
    if err != nil {
        panic(err)
    }
}
// SetUnexpectedPauses sets the unexpectedPauses property value. Number of unexpected pauses made during the reading session.
func (m *ReadingAssignmentSubmission) SetUnexpectedPauses(value *int64)() {
    err := m.GetBackingStore().Set("unexpectedPauses", value)
    if err != nil {
        panic(err)
    }
}
// SetWordCount sets the wordCount property value. Words count of the reading progress.
func (m *ReadingAssignmentSubmission) SetWordCount(value *int64)() {
    err := m.GetBackingStore().Set("wordCount", value)
    if err != nil {
        panic(err)
    }
}
// SetWordsPerMinute sets the wordsPerMinute property value. Words per minute of the reading progress.
func (m *ReadingAssignmentSubmission) SetWordsPerMinute(value *float64)() {
    err := m.GetBackingStore().Set("wordsPerMinute", value)
    if err != nil {
        panic(err)
    }
}
type ReadingAssignmentSubmissionable interface {
    Entityable
    i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.Parsable
    GetAccuracyScore()(*float64)
    GetAction()(*string)
    GetAssignmentId()(*string)
    GetChallengingWords()([]ChallengingWordable)
    GetClassId()(*string)
    GetInsertions()(*int64)
    GetMispronunciations()(*int64)
    GetMissedExclamationMarks()(*int64)
    GetMissedPeriods()(*int64)
    GetMissedQuestionMarks()(*int64)
    GetMissedShorts()(*int64)
    GetMonotoneScore()(*float64)
    GetOmissions()(*int64)
    GetRepetitions()(*int64)
    GetSelfCorrections()(*int64)
    GetStudentId()(*string)
    GetSubmissionDateTime()(*i336074805fc853987abe6f7fe3ad97a6a6f3077a16391fec744f671a015fbd7e.Time)
    GetSubmissionId()(*string)
    GetUnexpectedPauses()(*int64)
    GetWordCount()(*int64)
    GetWordsPerMinute()(*float64)
    SetAccuracyScore(value *float64)()
    SetAction(value *string)()
    SetAssignmentId(value *string)()
    SetChallengingWords(value []ChallengingWordable)()
    SetClassId(value *string)()
    SetInsertions(value *int64)()
    SetMispronunciations(value *int64)()
    SetMissedExclamationMarks(value *int64)()
    SetMissedPeriods(value *int64)()
    SetMissedQuestionMarks(value *int64)()
    SetMissedShorts(value *int64)()
    SetMonotoneScore(value *float64)()
    SetOmissions(value *int64)()
    SetRepetitions(value *int64)()
    SetSelfCorrections(value *int64)()
    SetStudentId(value *string)()
    SetSubmissionDateTime(value *i336074805fc853987abe6f7fe3ad97a6a6f3077a16391fec744f671a015fbd7e.Time)()
    SetSubmissionId(value *string)()
    SetUnexpectedPauses(value *int64)()
    SetWordCount(value *int64)()
    SetWordsPerMinute(value *float64)()
}
