// Code generated by Microsoft Kiota - DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package models

import (
    i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91 "github.com/microsoft/kiota-abstractions-go/serialization"
    ie8677ce2c7e1b4c22e9c3827ecd078d41185424dd9eeb92b7d971ed2d49a392e "github.com/microsoft/kiota-abstractions-go/store"
)

type PolicyScopeBase struct {
    // Stores model information.
    backingStore ie8677ce2c7e1b4c22e9c3827ecd078d41185424dd9eeb92b7d971ed2d49a392e.BackingStore
}
// NewPolicyScopeBase instantiates a new PolicyScopeBase and sets the default values.
func NewPolicyScopeBase()(*PolicyScopeBase) {
    m := &PolicyScopeBase{
    }
    m.backingStore = ie8677ce2c7e1b4c22e9c3827ecd078d41185424dd9eeb92b7d971ed2d49a392e.BackingStoreFactoryInstance();
    m.SetAdditionalData(make(map[string]any))
    return m
}
// CreatePolicyScopeBaseFromDiscriminatorValue creates a new instance of the appropriate class based on discriminator value
// returns a Parsable when successful
func CreatePolicyScopeBaseFromDiscriminatorValue(parseNode i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode)(i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.Parsable, error) {
    if parseNode != nil {
        mappingValueNode, err := parseNode.GetChildNode("@odata.type")
        if err != nil {
            return nil, err
        }
        if mappingValueNode != nil {
            mappingValue, err := mappingValueNode.GetStringValue()
            if err != nil {
                return nil, err
            }
            if mappingValue != nil {
                switch *mappingValue {
                    case "#microsoft.graph.policyTenantScope":
                        return NewPolicyTenantScope(), nil
                    case "#microsoft.graph.policyUserScope":
                        return NewPolicyUserScope(), nil
                }
            }
        }
    }
    return NewPolicyScopeBase(), nil
}
// GetActivities gets the activities property value. The activities property
// returns a *UserActivityTypes when successful
func (m *PolicyScopeBase) GetActivities()(*UserActivityTypes) {
    val, err := m.GetBackingStore().Get("activities")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(*UserActivityTypes)
    }
    return nil
}
// GetAdditionalData gets the AdditionalData property value. Stores additional data not described in the OpenAPI description found when deserializing. Can be used for serialization as well.
// returns a map[string]any when successful
func (m *PolicyScopeBase) GetAdditionalData()(map[string]any) {
    val , err :=  m.backingStore.Get("additionalData")
    if err != nil {
        panic(err)
    }
    if val == nil {
        var value = make(map[string]any);
        m.SetAdditionalData(value);
    }
    return val.(map[string]any)
}
// GetBackingStore gets the BackingStore property value. Stores model information.
// returns a BackingStore when successful
func (m *PolicyScopeBase) GetBackingStore()(ie8677ce2c7e1b4c22e9c3827ecd078d41185424dd9eeb92b7d971ed2d49a392e.BackingStore) {
    return m.backingStore
}
// GetExecutionMode gets the executionMode property value. The executionMode property
// returns a *ExecutionMode when successful
func (m *PolicyScopeBase) GetExecutionMode()(*ExecutionMode) {
    val, err := m.GetBackingStore().Get("executionMode")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(*ExecutionMode)
    }
    return nil
}
// GetFieldDeserializers the deserialization information for the current model
// returns a map[string]func(i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode)(error) when successful
func (m *PolicyScopeBase) GetFieldDeserializers()(map[string]func(i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode)(error)) {
    res := make(map[string]func(i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode)(error))
    res["activities"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetEnumValue(ParseUserActivityTypes)
        if err != nil {
            return err
        }
        if val != nil {
            m.SetActivities(val.(*UserActivityTypes))
        }
        return nil
    }
    res["executionMode"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetEnumValue(ParseExecutionMode)
        if err != nil {
            return err
        }
        if val != nil {
            m.SetExecutionMode(val.(*ExecutionMode))
        }
        return nil
    }
    res["locations"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetCollectionOfObjectValues(CreatePolicyLocationFromDiscriminatorValue)
        if err != nil {
            return err
        }
        if val != nil {
            res := make([]PolicyLocationable, len(val))
            for i, v := range val {
                if v != nil {
                    res[i] = v.(PolicyLocationable)
                }
            }
            m.SetLocations(res)
        }
        return nil
    }
    res["@odata.type"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetStringValue()
        if err != nil {
            return err
        }
        if val != nil {
            m.SetOdataType(val)
        }
        return nil
    }
    res["policyActions"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetCollectionOfObjectValues(CreateDlpActionInfoFromDiscriminatorValue)
        if err != nil {
            return err
        }
        if val != nil {
            res := make([]DlpActionInfoable, len(val))
            for i, v := range val {
                if v != nil {
                    res[i] = v.(DlpActionInfoable)
                }
            }
            m.SetPolicyActions(res)
        }
        return nil
    }
    return res
}
// GetLocations gets the locations property value. The locations (like domains or URLs) to be protected. Required.
// returns a []PolicyLocationable when successful
func (m *PolicyScopeBase) GetLocations()([]PolicyLocationable) {
    val, err := m.GetBackingStore().Get("locations")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.([]PolicyLocationable)
    }
    return nil
}
// GetOdataType gets the @odata.type property value. The OdataType property
// returns a *string when successful
func (m *PolicyScopeBase) GetOdataType()(*string) {
    val, err := m.GetBackingStore().Get("odataType")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(*string)
    }
    return nil
}
// GetPolicyActions gets the policyActions property value. The enforcement actions to take if the policy conditions are met within this scope. Required.
// returns a []DlpActionInfoable when successful
func (m *PolicyScopeBase) GetPolicyActions()([]DlpActionInfoable) {
    val, err := m.GetBackingStore().Get("policyActions")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.([]DlpActionInfoable)
    }
    return nil
}
// Serialize serializes information the current object
func (m *PolicyScopeBase) Serialize(writer i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.SerializationWriter)(error) {
    if m.GetActivities() != nil {
        cast := (*m.GetActivities()).String()
        err := writer.WriteStringValue("activities", &cast)
        if err != nil {
            return err
        }
    }
    if m.GetExecutionMode() != nil {
        cast := (*m.GetExecutionMode()).String()
        err := writer.WriteStringValue("executionMode", &cast)
        if err != nil {
            return err
        }
    }
    if m.GetLocations() != nil {
        cast := make([]i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.Parsable, len(m.GetLocations()))
        for i, v := range m.GetLocations() {
            if v != nil {
                cast[i] = v.(i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.Parsable)
            }
        }
        err := writer.WriteCollectionOfObjectValues("locations", cast)
        if err != nil {
            return err
        }
    }
    {
        err := writer.WriteStringValue("@odata.type", m.GetOdataType())
        if err != nil {
            return err
        }
    }
    if m.GetPolicyActions() != nil {
        cast := make([]i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.Parsable, len(m.GetPolicyActions()))
        for i, v := range m.GetPolicyActions() {
            if v != nil {
                cast[i] = v.(i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.Parsable)
            }
        }
        err := writer.WriteCollectionOfObjectValues("policyActions", cast)
        if err != nil {
            return err
        }
    }
    {
        err := writer.WriteAdditionalData(m.GetAdditionalData())
        if err != nil {
            return err
        }
    }
    return nil
}
// SetActivities sets the activities property value. The activities property
func (m *PolicyScopeBase) SetActivities(value *UserActivityTypes)() {
    err := m.GetBackingStore().Set("activities", value)
    if err != nil {
        panic(err)
    }
}
// SetAdditionalData sets the AdditionalData property value. Stores additional data not described in the OpenAPI description found when deserializing. Can be used for serialization as well.
func (m *PolicyScopeBase) SetAdditionalData(value map[string]any)() {
    err := m.GetBackingStore().Set("additionalData", value)
    if err != nil {
        panic(err)
    }
}
// SetBackingStore sets the BackingStore property value. Stores model information.
func (m *PolicyScopeBase) SetBackingStore(value ie8677ce2c7e1b4c22e9c3827ecd078d41185424dd9eeb92b7d971ed2d49a392e.BackingStore)() {
    m.backingStore = value
}
// SetExecutionMode sets the executionMode property value. The executionMode property
func (m *PolicyScopeBase) SetExecutionMode(value *ExecutionMode)() {
    err := m.GetBackingStore().Set("executionMode", value)
    if err != nil {
        panic(err)
    }
}
// SetLocations sets the locations property value. The locations (like domains or URLs) to be protected. Required.
func (m *PolicyScopeBase) SetLocations(value []PolicyLocationable)() {
    err := m.GetBackingStore().Set("locations", value)
    if err != nil {
        panic(err)
    }
}
// SetOdataType sets the @odata.type property value. The OdataType property
func (m *PolicyScopeBase) SetOdataType(value *string)() {
    err := m.GetBackingStore().Set("odataType", value)
    if err != nil {
        panic(err)
    }
}
// SetPolicyActions sets the policyActions property value. The enforcement actions to take if the policy conditions are met within this scope. Required.
func (m *PolicyScopeBase) SetPolicyActions(value []DlpActionInfoable)() {
    err := m.GetBackingStore().Set("policyActions", value)
    if err != nil {
        panic(err)
    }
}
type PolicyScopeBaseable interface {
    i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.AdditionalDataHolder
    ie8677ce2c7e1b4c22e9c3827ecd078d41185424dd9eeb92b7d971ed2d49a392e.BackedModel
    i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.Parsable
    GetActivities()(*UserActivityTypes)
    GetBackingStore()(ie8677ce2c7e1b4c22e9c3827ecd078d41185424dd9eeb92b7d971ed2d49a392e.BackingStore)
    GetExecutionMode()(*ExecutionMode)
    GetLocations()([]PolicyLocationable)
    GetOdataType()(*string)
    GetPolicyActions()([]DlpActionInfoable)
    SetActivities(value *UserActivityTypes)()
    SetBackingStore(value ie8677ce2c7e1b4c22e9c3827ecd078d41185424dd9eeb92b7d971ed2d49a392e.BackingStore)()
    SetExecutionMode(value *ExecutionMode)()
    SetLocations(value []PolicyLocationable)()
    SetOdataType(value *string)()
    SetPolicyActions(value []DlpActionInfoable)()
}
