// Code generated by go-swagger; DO NOT EDIT.

package vault_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-service/stable/2020-11-25/models"
)

// ListAllClustersReader is a Reader for the ListAllClusters structure.
type ListAllClustersReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ListAllClustersReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewListAllClustersOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewListAllClustersDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewListAllClustersOK creates a ListAllClustersOK with default headers values
func NewListAllClustersOK() *ListAllClustersOK {
	return &ListAllClustersOK{}
}

/*
ListAllClustersOK describes a response with status code 200, with default header values.

A successful response.
*/
type ListAllClustersOK struct {
	Payload *models.HashicorpCloudVault20201125ListAllClustersResponse
}

// IsSuccess returns true when this list all clusters o k response has a 2xx status code
func (o *ListAllClustersOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this list all clusters o k response has a 3xx status code
func (o *ListAllClustersOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this list all clusters o k response has a 4xx status code
func (o *ListAllClustersOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this list all clusters o k response has a 5xx status code
func (o *ListAllClustersOK) IsServerError() bool {
	return false
}

// IsCode returns true when this list all clusters o k response a status code equal to that given
func (o *ListAllClustersOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the list all clusters o k response
func (o *ListAllClustersOK) Code() int {
	return 200
}

func (o *ListAllClustersOK) Error() string {
	return fmt.Sprintf("[GET /vault/2020-11-25/organizations/{location.organization_id}/projects/{location.project_id}/vault-clusters][%d] listAllClustersOK  %+v", 200, o.Payload)
}

func (o *ListAllClustersOK) String() string {
	return fmt.Sprintf("[GET /vault/2020-11-25/organizations/{location.organization_id}/projects/{location.project_id}/vault-clusters][%d] listAllClustersOK  %+v", 200, o.Payload)
}

func (o *ListAllClustersOK) GetPayload() *models.HashicorpCloudVault20201125ListAllClustersResponse {
	return o.Payload
}

func (o *ListAllClustersOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudVault20201125ListAllClustersResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewListAllClustersDefault creates a ListAllClustersDefault with default headers values
func NewListAllClustersDefault(code int) *ListAllClustersDefault {
	return &ListAllClustersDefault{
		_statusCode: code,
	}
}

/*
ListAllClustersDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type ListAllClustersDefault struct {
	_statusCode int

	Payload *cloud.GrpcGatewayRuntimeError
}

// IsSuccess returns true when this list all clusters default response has a 2xx status code
func (o *ListAllClustersDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this list all clusters default response has a 3xx status code
func (o *ListAllClustersDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this list all clusters default response has a 4xx status code
func (o *ListAllClustersDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this list all clusters default response has a 5xx status code
func (o *ListAllClustersDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this list all clusters default response a status code equal to that given
func (o *ListAllClustersDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the list all clusters default response
func (o *ListAllClustersDefault) Code() int {
	return o._statusCode
}

func (o *ListAllClustersDefault) Error() string {
	return fmt.Sprintf("[GET /vault/2020-11-25/organizations/{location.organization_id}/projects/{location.project_id}/vault-clusters][%d] ListAllClusters default  %+v", o._statusCode, o.Payload)
}

func (o *ListAllClustersDefault) String() string {
	return fmt.Sprintf("[GET /vault/2020-11-25/organizations/{location.organization_id}/projects/{location.project_id}/vault-clusters][%d] ListAllClusters default  %+v", o._statusCode, o.Payload)
}

func (o *ListAllClustersDefault) GetPayload() *cloud.GrpcGatewayRuntimeError {
	return o.Payload
}

func (o *ListAllClustersDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GrpcGatewayRuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
