package kms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SetDeletionProtection invokes the kms.SetDeletionProtection API synchronously
func (client *Client) SetDeletionProtection(request *SetDeletionProtectionRequest) (response *SetDeletionProtectionResponse, err error) {
	response = CreateSetDeletionProtectionResponse()
	err = client.DoAction(request, response)
	return
}

// SetDeletionProtectionWithChan invokes the kms.SetDeletionProtection API asynchronously
func (client *Client) SetDeletionProtectionWithChan(request *SetDeletionProtectionRequest) (<-chan *SetDeletionProtectionResponse, <-chan error) {
	responseChan := make(chan *SetDeletionProtectionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SetDeletionProtection(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SetDeletionProtectionWithCallback invokes the kms.SetDeletionProtection API asynchronously
func (client *Client) SetDeletionProtectionWithCallback(request *SetDeletionProtectionRequest, callback func(response *SetDeletionProtectionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SetDeletionProtectionResponse
		var err error
		defer close(result)
		response, err = client.SetDeletionProtection(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SetDeletionProtectionRequest is the request struct for api SetDeletionProtection
type SetDeletionProtectionRequest struct {
	*requests.RpcRequest
	DeletionProtectionDescription string           `position:"Query" name:"DeletionProtectionDescription"`
	EnableDeletionProtection      requests.Boolean `position:"Query" name:"EnableDeletionProtection"`
	ProtectedResourceArn          string           `position:"Query" name:"ProtectedResourceArn"`
}

// SetDeletionProtectionResponse is the response struct for api SetDeletionProtection
type SetDeletionProtectionResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateSetDeletionProtectionRequest creates a request to invoke SetDeletionProtection API
func CreateSetDeletionProtectionRequest() (request *SetDeletionProtectionRequest) {
	request = &SetDeletionProtectionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Kms", "2016-01-20", "SetDeletionProtection", "kms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSetDeletionProtectionResponse creates a response to parse from SetDeletionProtection response
func CreateSetDeletionProtectionResponse() (response *SetDeletionProtectionResponse) {
	response = &SetDeletionProtectionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
