/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	context "context"

	certificatesv1alpha1 "k8s.io/api/certificates/v1alpha1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	applyconfigurationscertificatesv1alpha1 "k8s.io/client-go/applyconfigurations/certificates/v1alpha1"
	gentype "k8s.io/client-go/gentype"
	scheme "k8s.io/client-go/kubernetes/scheme"
)

// ClusterTrustBundlesGetter has a method to return a ClusterTrustBundleInterface.
// A group's client should implement this interface.
type ClusterTrustBundlesGetter interface {
	ClusterTrustBundles() ClusterTrustBundleInterface
}

// ClusterTrustBundleInterface has methods to work with ClusterTrustBundle resources.
type ClusterTrustBundleInterface interface {
	Create(ctx context.Context, clusterTrustBundle *certificatesv1alpha1.ClusterTrustBundle, opts v1.CreateOptions) (*certificatesv1alpha1.ClusterTrustBundle, error)
	Update(ctx context.Context, clusterTrustBundle *certificatesv1alpha1.ClusterTrustBundle, opts v1.UpdateOptions) (*certificatesv1alpha1.ClusterTrustBundle, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*certificatesv1alpha1.ClusterTrustBundle, error)
	List(ctx context.Context, opts v1.ListOptions) (*certificatesv1alpha1.ClusterTrustBundleList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *certificatesv1alpha1.ClusterTrustBundle, err error)
	Apply(ctx context.Context, clusterTrustBundle *applyconfigurationscertificatesv1alpha1.ClusterTrustBundleApplyConfiguration, opts v1.ApplyOptions) (result *certificatesv1alpha1.ClusterTrustBundle, err error)
	ClusterTrustBundleExpansion
}

// clusterTrustBundles implements ClusterTrustBundleInterface
type clusterTrustBundles struct {
	*gentype.ClientWithListAndApply[*certificatesv1alpha1.ClusterTrustBundle, *certificatesv1alpha1.ClusterTrustBundleList, *applyconfigurationscertificatesv1alpha1.ClusterTrustBundleApplyConfiguration]
}

// newClusterTrustBundles returns a ClusterTrustBundles
func newClusterTrustBundles(c *CertificatesV1alpha1Client) *clusterTrustBundles {
	return &clusterTrustBundles{
		gentype.NewClientWithListAndApply[*certificatesv1alpha1.ClusterTrustBundle, *certificatesv1alpha1.ClusterTrustBundleList, *applyconfigurationscertificatesv1alpha1.ClusterTrustBundleApplyConfiguration](
			"clustertrustbundles",
			c.RESTClient(),
			scheme.ParameterCodec,
			"",
			func() *certificatesv1alpha1.ClusterTrustBundle { return &certificatesv1alpha1.ClusterTrustBundle{} },
			func() *certificatesv1alpha1.ClusterTrustBundleList {
				return &certificatesv1alpha1.ClusterTrustBundleList{}
			},
			gentype.PrefersProtobuf[*certificatesv1alpha1.ClusterTrustBundle](),
		),
	}
}
