/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1alpha2

import (
	labels "k8s.io/apimachinery/pkg/labels"
	listers "k8s.io/client-go/listers"
	cache "k8s.io/client-go/tools/cache"
	apisv1alpha2 "sigs.k8s.io/gateway-api/apis/v1alpha2"
)

// UDPRouteLister helps list UDPRoutes.
// All objects returned here must be treated as read-only.
type UDPRouteLister interface {
	// List lists all UDPRoutes in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*apisv1alpha2.UDPRoute, err error)
	// UDPRoutes returns an object that can list and get UDPRoutes.
	UDPRoutes(namespace string) UDPRouteNamespaceLister
	UDPRouteListerExpansion
}

// uDPRouteLister implements the UDPRouteLister interface.
type uDPRouteLister struct {
	listers.ResourceIndexer[*apisv1alpha2.UDPRoute]
}

// NewUDPRouteLister returns a new UDPRouteLister.
func NewUDPRouteLister(indexer cache.Indexer) UDPRouteLister {
	return &uDPRouteLister{listers.New[*apisv1alpha2.UDPRoute](indexer, apisv1alpha2.Resource("udproute"))}
}

// UDPRoutes returns an object that can list and get UDPRoutes.
func (s *uDPRouteLister) UDPRoutes(namespace string) UDPRouteNamespaceLister {
	return uDPRouteNamespaceLister{listers.NewNamespaced[*apisv1alpha2.UDPRoute](s.ResourceIndexer, namespace)}
}

// UDPRouteNamespaceLister helps list and get UDPRoutes.
// All objects returned here must be treated as read-only.
type UDPRouteNamespaceLister interface {
	// List lists all UDPRoutes in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*apisv1alpha2.UDPRoute, err error)
	// Get retrieves the UDPRoute from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*apisv1alpha2.UDPRoute, error)
	UDPRouteNamespaceListerExpansion
}

// uDPRouteNamespaceLister implements the UDPRouteNamespaceLister
// interface.
type uDPRouteNamespaceLister struct {
	listers.ResourceIndexer[*apisv1alpha2.UDPRoute]
}
