// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
)

// AWS credentials structure containing temporary access credentials
//
// The scoped-down, 15 minute duration AWS credentials. Scoping down will be based
// on CLI policy (CLI team needs to create it). Similar to cloud shell
// implementation.
type AccessToken struct {

	// AWS access key ID for temporary credentials
	//
	// This member is required.
	AccessKeyId *string

	// AWS secret access key for temporary credentials
	//
	// This member is required.
	SecretAccessKey *string

	// AWS session token for temporary credentials
	//
	// This member is required.
	SessionToken *string

	noSmithyDocumentSerde
}

// Request body payload for CreateOAuth2Token operation
//
// The operation type is determined by the grant_type parameter:
//
//   - grant_type=authorization_code: Requires code, redirect_uri, code_verifier
//   - grant_type=refresh_token: Requires refresh_token
type CreateOAuth2TokenRequestBody struct {

	// The client identifier (ARN) used during Sign-In onboarding Required for both
	// authorization code and refresh token flows
	//
	// This member is required.
	ClientId *string

	// OAuth 2.0 grant type - determines which flow is used Must be
	// "authorization_code" or "refresh_token"
	//
	// This member is required.
	GrantType *string

	// The authorization code received from /v1/authorize Required only when
	// grant_type=authorization_code
	Code *string

	// PKCE code verifier to prove possession of the original code challenge Required
	// only when grant_type=authorization_code
	CodeVerifier *string

	// The redirect URI that must match the original authorization request Required
	// only when grant_type=authorization_code
	RedirectUri *string

	// The refresh token returned from auth_code redemption Required only when
	// grant_type=refresh_token
	RefreshToken *string

	noSmithyDocumentSerde
}

// Response body payload for CreateOAuth2Token operation
//
// The response content depends on the grant_type from the request:
//
//   - grant_type=authorization_code: Returns all fields including refresh_token
//     and id_token
//   - grant_type=refresh_token: Returns access_token, token_type, expires_in,
//     refresh_token (no id_token)
type CreateOAuth2TokenResponseBody struct {

	// Scoped-down AWS credentials (15 minute duration) Present for both authorization
	// code redemption and token refresh
	//
	// This member is required.
	AccessToken *AccessToken

	// Time to expiry in seconds (maximum 900) Present for both authorization code
	// redemption and token refresh
	//
	// This member is required.
	ExpiresIn *int32

	// Encrypted refresh token with cnf.jkt (SHA-256 thumbprint of presented jwk)
	// Always present in responses (required for both flows)
	//
	// This member is required.
	RefreshToken *string

	// Token type indicating this is AWS SigV4 credentials Value is "aws_sigv4" for
	// both flows
	//
	// This member is required.
	TokenType *string

	// ID token containing user identity information Present only in authorization
	// code redemption response (grant_type=authorization_code) Not included in token
	// refresh responses
	IdToken *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
