/* BackupBox.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from BackupBox.vala, do not modify */

/*
 * BackupBox.vala
 *
 * Copyright 2012-2018 Tony George <teejeetech@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 *
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <pango/pango.h>
#include <float.h>
#include <math.h>
#include <gee.h>
#include <libxapp/xapp-gtk-window.h>
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_BACKUP_BOX (backup_box_get_type ())
#define BACKUP_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BACKUP_BOX, BackupBox))
#define BACKUP_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BACKUP_BOX, BackupBoxClass))
#define IS_BACKUP_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BACKUP_BOX))
#define IS_BACKUP_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BACKUP_BOX))
#define BACKUP_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BACKUP_BOX, BackupBoxClass))

typedef struct _BackupBox BackupBox;
typedef struct _BackupBoxClass BackupBoxClass;
typedef struct _BackupBoxPrivate BackupBoxPrivate;
enum  {
	BACKUP_BOX_0_PROPERTY,
	BACKUP_BOX_NUM_PROPERTIES
};
static GParamSpec* backup_box_properties[BACKUP_BOX_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block2Data Block2Data;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_thread_unref0(var) ((var == NULL) ? NULL : (var = (g_thread_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_MAIN (main_get_type ())
#define MAIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN, Main))
#define MAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN, MainClass))
#define IS_MAIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN))
#define IS_MAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN))
#define MAIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN, MainClass))

typedef struct _Main Main;
typedef struct _MainClass MainClass;
typedef struct _MainPrivate MainPrivate;

#define TYPE_DEVICE (device_get_type ())
#define DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DEVICE, Device))
#define DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DEVICE, DeviceClass))
#define IS_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DEVICE))
#define IS_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DEVICE))
#define DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DEVICE, DeviceClass))

typedef struct _Device Device;
typedef struct _DeviceClass DeviceClass;

#define TYPE_APP_EXCLUDE_ENTRY (app_exclude_entry_get_type ())
#define APP_EXCLUDE_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_EXCLUDE_ENTRY, AppExcludeEntry))
#define APP_EXCLUDE_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_EXCLUDE_ENTRY, AppExcludeEntryClass))
#define IS_APP_EXCLUDE_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_EXCLUDE_ENTRY))
#define IS_APP_EXCLUDE_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_EXCLUDE_ENTRY))
#define APP_EXCLUDE_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_EXCLUDE_ENTRY, AppExcludeEntryClass))

typedef struct _AppExcludeEntry AppExcludeEntry;
typedef struct _AppExcludeEntryClass AppExcludeEntryClass;

#define TYPE_MOUNT_ENTRY (mount_entry_get_type ())
#define MOUNT_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MOUNT_ENTRY, MountEntry))
#define MOUNT_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MOUNT_ENTRY, MountEntryClass))
#define IS_MOUNT_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MOUNT_ENTRY))
#define IS_MOUNT_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MOUNT_ENTRY))
#define MOUNT_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MOUNT_ENTRY, MountEntryClass))

typedef struct _MountEntry MountEntry;
typedef struct _MountEntryClass MountEntryClass;

#define TYPE_SNAPSHOT_REPO (snapshot_repo_get_type ())
#define SNAPSHOT_REPO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SNAPSHOT_REPO, SnapshotRepo))
#define SNAPSHOT_REPO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SNAPSHOT_REPO, SnapshotRepoClass))
#define IS_SNAPSHOT_REPO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SNAPSHOT_REPO))
#define IS_SNAPSHOT_REPO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SNAPSHOT_REPO))
#define SNAPSHOT_REPO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SNAPSHOT_REPO, SnapshotRepoClass))

typedef struct _SnapshotRepo SnapshotRepo;
typedef struct _SnapshotRepoClass SnapshotRepoClass;

#define TYPE_SUBVOLUME (subvolume_get_type ())
#define SUBVOLUME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUBVOLUME, Subvolume))
#define SUBVOLUME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUBVOLUME, SubvolumeClass))
#define IS_SUBVOLUME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUBVOLUME))
#define IS_SUBVOLUME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUBVOLUME))
#define SUBVOLUME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUBVOLUME, SubvolumeClass))

typedef struct _Subvolume Subvolume;
typedef struct _SubvolumeClass SubvolumeClass;

#define TYPE_LINUX_DISTRO (linux_distro_get_type ())
#define LINUX_DISTRO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LINUX_DISTRO, LinuxDistro))
#define LINUX_DISTRO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LINUX_DISTRO, LinuxDistroClass))
#define IS_LINUX_DISTRO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LINUX_DISTRO))
#define IS_LINUX_DISTRO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LINUX_DISTRO))
#define LINUX_DISTRO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LINUX_DISTRO, LinuxDistroClass))

typedef struct _LinuxDistro LinuxDistro;
typedef struct _LinuxDistroClass LinuxDistroClass;

#define TYPE_APP_LOCK (app_lock_get_type ())
#define APP_LOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_LOCK, AppLock))
#define APP_LOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_LOCK, AppLockClass))
#define IS_APP_LOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_LOCK))
#define IS_APP_LOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_LOCK))
#define APP_LOCK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_LOCK, AppLockClass))

typedef struct _AppLock AppLock;
typedef struct _AppLockClass AppLockClass;

#define TYPE_SNAPSHOT (snapshot_get_type ())
#define SNAPSHOT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SNAPSHOT, Snapshot))
#define SNAPSHOT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SNAPSHOT, SnapshotClass))
#define IS_SNAPSHOT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SNAPSHOT))
#define IS_SNAPSHOT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SNAPSHOT))
#define SNAPSHOT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SNAPSHOT, SnapshotClass))

typedef struct _Snapshot Snapshot;
typedef struct _SnapshotClass SnapshotClass;

#define TYPE_ASYNC_TASK (async_task_get_type ())
#define ASYNC_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ASYNC_TASK, AsyncTask))
#define ASYNC_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ASYNC_TASK, AsyncTaskClass))
#define IS_ASYNC_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ASYNC_TASK))
#define IS_ASYNC_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ASYNC_TASK))
#define ASYNC_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ASYNC_TASK, AsyncTaskClass))

typedef struct _AsyncTask AsyncTask;
typedef struct _AsyncTaskClass AsyncTaskClass;

#define TYPE_RSYNC_TASK (rsync_task_get_type ())
#define RSYNC_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RSYNC_TASK, RsyncTask))
#define RSYNC_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RSYNC_TASK, RsyncTaskClass))
#define IS_RSYNC_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RSYNC_TASK))
#define IS_RSYNC_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RSYNC_TASK))
#define RSYNC_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RSYNC_TASK, RsyncTaskClass))

typedef struct _RsyncTask RsyncTask;
typedef struct _RsyncTaskClass RsyncTaskClass;

#define TYPE_DELETE_FILE_TASK (delete_file_task_get_type ())
#define DELETE_FILE_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DELETE_FILE_TASK, DeleteFileTask))
#define DELETE_FILE_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DELETE_FILE_TASK, DeleteFileTaskClass))
#define IS_DELETE_FILE_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DELETE_FILE_TASK))
#define IS_DELETE_FILE_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DELETE_FILE_TASK))
#define DELETE_FILE_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DELETE_FILE_TASK, DeleteFileTaskClass))

typedef struct _DeleteFileTask DeleteFileTask;
typedef struct _DeleteFileTaskClass DeleteFileTaskClass;

#define TYPE_RSYNC_SPACE_CHECK_TASK (rsync_space_check_task_get_type ())
#define RSYNC_SPACE_CHECK_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RSYNC_SPACE_CHECK_TASK, RsyncSpaceCheckTask))
#define RSYNC_SPACE_CHECK_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RSYNC_SPACE_CHECK_TASK, RsyncSpaceCheckTaskClass))
#define IS_RSYNC_SPACE_CHECK_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RSYNC_SPACE_CHECK_TASK))
#define IS_RSYNC_SPACE_CHECK_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RSYNC_SPACE_CHECK_TASK))
#define RSYNC_SPACE_CHECK_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RSYNC_SPACE_CHECK_TASK, RsyncSpaceCheckTaskClass))

typedef struct _RsyncSpaceCheckTask RsyncSpaceCheckTask;
typedef struct _RsyncSpaceCheckTaskClass RsyncSpaceCheckTaskClass;

#define TYPE_SYSTEM_USER (system_user_get_type ())
#define SYSTEM_USER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SYSTEM_USER, SystemUser))
#define SYSTEM_USER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SYSTEM_USER, SystemUserClass))
#define IS_SYSTEM_USER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SYSTEM_USER))
#define IS_SYSTEM_USER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SYSTEM_USER))
#define SYSTEM_USER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SYSTEM_USER, SystemUserClass))

typedef struct _SystemUser SystemUser;
typedef struct _SystemUserClass SystemUserClass;
typedef struct _AsyncTaskPrivate AsyncTaskPrivate;
typedef enum  {
	APP_STATUS_NOT_STARTED,
	APP_STATUS_RUNNING,
	APP_STATUS_PAUSED,
	APP_STATUS_FINISHED,
	APP_STATUS_CANCELLED,
	APP_STATUS_PASSWORD_REQUIRED
} AppStatus;

#define TYPE_APP_STATUS (app_status_get_type ())
typedef struct _RsyncTaskPrivate RsyncTaskPrivate;

struct _BackupBox {
	GtkBox parent_instance;
	BackupBoxPrivate * priv;
	GtkLabel* lbl_msg;
	GtkLabel* lbl_status;
	GtkLabel* lbl_remaining;
	GtkProgressBar* progressbar;
	GtkLabel* lbl_unchanged;
	GtkLabel* lbl_created;
	GtkLabel* lbl_deleted;
	GtkLabel* lbl_modified;
	GtkLabel* lbl_checksum;
	GtkLabel* lbl_size;
	GtkLabel* lbl_timestamp;
	GtkLabel* lbl_permissions;
	GtkLabel* lbl_owner;
	GtkLabel* lbl_group;
};

struct _BackupBoxClass {
	GtkBoxClass parent_class;
};

struct _BackupBoxPrivate {
	GtkBox* details_box;
	GtkSpinner* spinner;
	GtkWindow* parent_window;
	gboolean thread_is_running;
	gboolean thread_status_success;
};

struct _Block2Data {
	int _ref_count_;
	BackupBox* self;
	GtkLabel* label;
	GtkLabel* text_label;
};

struct _Main {
	GObject parent_instance;
	MainPrivate * priv;
	gchar* app_path;
	gchar* share_folder;
	gchar* rsnapshot_conf_path;
	gchar* app_conf_path;
	gchar* app_conf_path_old;
	gchar* app_conf_path_default;
	gboolean first_run;
	gchar* backup_uuid;
	gchar* backup_parent_uuid;
	gboolean btrfs_mode;
	gboolean include_btrfs_home_for_backup;
	gboolean include_btrfs_home_for_restore;
	gboolean stop_cron_emails;
	GeeArrayList* partitions;
	GeeArrayList* exclude_list_user;
	GeeArrayList* exclude_list_default;
	GeeArrayList* exclude_list_default_extra;
	GeeArrayList* exclude_list_home;
	GeeArrayList* exclude_list_restore;
	GeeArrayList* exclude_list_apps;
	GeeArrayList* mount_list;
	GeeArrayList* exclude_app_names;
	SnapshotRepo* repo;
	Device* sys_root;
	Device* sys_boot;
	Device* sys_efi;
	Device* sys_home;
	GeeHashMap* sys_subvolumes;
	gchar* mount_point_restore;
	gchar* mount_point_app;
	LinuxDistro* current_distro;
	gboolean mirror_system;
	gboolean schedule_monthly;
	gboolean schedule_weekly;
	gboolean schedule_daily;
	gboolean schedule_hourly;
	gboolean schedule_boot;
	gint count_monthly;
	gint count_weekly;
	gint count_daily;
	gint count_hourly;
	gint count_boot;
	gchar* app_mode;
	gboolean dry_run;
	gboolean thr_success;
	gboolean thread_restore_running;
	gboolean thread_restore_success;
	gboolean thread_delete_running;
	gboolean thread_delete_success;
	gboolean thread_subvol_info_running;
	gboolean thread_subvol_info_success;
	gint thr_retval;
	gchar* thr_arg1;
	gboolean thr_timeout_active;
	gchar* thr_timeout_cmd;
	gint startup_delay_interval_mins;
	gint retain_snapshots_max_days;
	gchar* log_dir;
	gchar* log_file;
	AppLock* app_lock;
	gchar* date_format;
	GeeArrayList* delete_list;
	Snapshot* snapshot_to_delete;
	Snapshot* snapshot_to_restore;
	gboolean reinstall_grub2;
	gboolean update_initramfs;
	gboolean update_grub;
	gchar* grub_device;
	gboolean use_option_raw;
	gboolean cmd_skip_grub;
	gchar* cmd_grub_device;
	gchar* cmd_target_device;
	gchar* cmd_backup_device;
	gchar* cmd_snapshot;
	gboolean cmd_confirm;
	gboolean cmd_verbose;
	gboolean cmd_scripted;
	gchar* cmd_comments;
	gchar* cmd_tags;
	gboolean* cmd_btrfs_mode;
	gchar* progress_text;
	GtkWindow* parent_window;
	RsyncTask* task;
	DeleteFileTask* delete_file_task;
	RsyncSpaceCheckTask* space_check_task;
	GeeHashMap* current_system_users;
	gchar* users_with_encrypted_home;
	gchar* encrypted_home_dirs;
	gboolean encrypted_home_warning_shown;
	gchar* encrypted_private_dirs;
	gboolean encrypted_private_warning_shown;
};

struct _MainClass {
	GObjectClass parent_class;
};

struct _AsyncTask {
	GObject parent_instance;
	AsyncTaskPrivate * priv;
	GDataOutputStream* dos_log;
	GPid child_pid;
	gchar* script_file;
	gchar* working_dir;
	AppStatus status;
	GMutex status_line_mutex;
	gint exit_code;
	GTimer* timer;
	gdouble progress;
	gdouble percent;
	gint64 prg_count;
	gint64 prg_count_total;
};

struct _AsyncTaskClass {
	GObjectClass parent_class;
	void (*prepare) (AsyncTask* self);
	gchar* (*build_script) (AsyncTask* self);
	gboolean (*begin) (AsyncTask* self);
	void (*execute) (AsyncTask* self);
	void (*parse_stdout_line) (AsyncTask* self, const gchar* out_line);
	void (*parse_stderr_line) (AsyncTask* self, const gchar* err_line);
	void (*finish_task) (AsyncTask* self);
};

struct _RsyncTask {
	AsyncTask parent_instance;
	RsyncTaskPrivate * priv;
	gboolean delete_extra;
	gboolean delete_after;
	gboolean delete_excluded;
	gboolean relative;
	gchar* rsync_log_file;
	gchar* exclude_from_file;
	gchar* link_from_path;
	gchar* source_path;
	gchar* dest_path;
	gboolean verbose;
	gboolean io_nice;
	gboolean dry_run;
	GQueue* status_lines;
	gint64 status_line_count;
	gint64 total_size;
	gint64 count_created;
	gint64 count_deleted;
	gint64 count_modified;
	gint64 count_checksum;
	gint64 count_size;
	gint64 count_timestamp;
	gint64 count_permissions;
	gint64 count_owner;
	gint64 count_group;
	gint64 count_unchanged;
	GString* log;
};

struct _RsyncTaskClass {
	AsyncTaskClass parent_class;
};

static gint BackupBox_private_offset;
static gpointer backup_box_parent_class = NULL;
VALA_EXTERN Main* App;

VALA_EXTERN GType backup_box_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BackupBox, g_object_unref)
VALA_EXTERN BackupBox* backup_box_new (GtkWindow* _parent_window);
VALA_EXTERN BackupBox* backup_box_construct (GType object_type,
                                 GtkWindow* _parent_window);
VALA_EXTERN void tee_jee_logging_log_debug (const gchar* message);
VALA_EXTERN GtkLabel* tee_jee_gtk_helper_add_label_header (GtkBox* box,
                                               const gchar* text,
                                               gboolean large_heading);
static void backup_box_add_progress_area (BackupBox* self);
VALA_EXTERN GtkLabel* tee_jee_gtk_helper_add_label (GtkBox* box,
                                        const gchar* text,
                                        gboolean bold,
                                        gboolean italic,
                                        gboolean large);
static GtkLabel* backup_box_add_count_label (BackupBox* self,
                                      GtkBox* box,
                                      const gchar* text,
                                      GtkSizeGroup** sg_label,
                                      GtkSizeGroup** sg_value,
                                      gint add_margin_bottom);
VALA_EXTERN void backup_box_pause (BackupBox* self);
VALA_EXTERN void backup_box_resume (BackupBox* self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda93_ (Block2Data* _data2_);
static void ___lambda93__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
VALA_EXTERN gboolean backup_box_take_snapshot (BackupBox* self);
static void ___lambda94_ (BackupBox* self);
static void backup_box_take_snapshot_thread (BackupBox* self);
static gpointer ____lambda94__gthread_func (gpointer self);
VALA_EXTERN void tee_jee_logging_log_error (const gchar* message,
                                gboolean highlight,
                                gboolean is_warning);
VALA_EXTERN GType main_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Main, g_object_unref)
VALA_EXTERN GType device_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Device, g_object_unref)
VALA_EXTERN GType app_exclude_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AppExcludeEntry, g_object_unref)
VALA_EXTERN GType mount_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MountEntry, g_object_unref)
VALA_EXTERN GType snapshot_repo_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SnapshotRepo, g_object_unref)
VALA_EXTERN GType subvolume_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Subvolume, g_object_unref)
VALA_EXTERN GType linux_distro_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LinuxDistro, g_object_unref)
VALA_EXTERN GType app_lock_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AppLock, g_object_unref)
VALA_EXTERN GType snapshot_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Snapshot, g_object_unref)
VALA_EXTERN GType async_task_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AsyncTask, g_object_unref)
VALA_EXTERN GType rsync_task_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RsyncTask, g_object_unref)
VALA_EXTERN GType delete_file_task_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DeleteFileTask, g_object_unref)
VALA_EXTERN GType rsync_space_check_task_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RsyncSpaceCheckTask, g_object_unref)
VALA_EXTERN GType system_user_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SystemUser, g_object_unref)
VALA_EXTERN void tee_jee_gtk_helper_gtk_do_events (void);
VALA_EXTERN void tee_jee_system_sleep (gint milliseconds);
VALA_EXTERN gchar* async_task_get_status_line (AsyncTask* self);
VALA_EXTERN GType app_status_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gchar* async_task_get_stat_time_remaining (AsyncTask* self);
VALA_EXTERN gchar* tee_jee_misc_escape_html (const gchar* html);
VALA_EXTERN gboolean main_create_snapshot (Main* self,
                               gboolean is_ondemand,
                               GtkWindow* parent_win);
static void backup_box_finalize (GObject * obj);
static GType backup_box_get_type_once (void);

static inline gpointer
backup_box_get_instance_private (BackupBox* self)
{
	return G_STRUCT_MEMBER_P (self, BackupBox_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

BackupBox*
backup_box_construct (GType object_type,
                      GtkWindow* _parent_window)
{
	BackupBox * self = NULL;
	GtkWindow* _tmp0_;
	GtkLabel* _tmp1_;
	GtkLabel* _tmp2_;
	GtkSizeGroup* sg_label = NULL;
	GtkSizeGroup* sg_value = NULL;
	GtkBox* _tmp3_;
	GtkBox* _tmp4_;
	GtkLabel* label = NULL;
	GtkBox* _tmp5_;
	GtkLabel* _tmp6_;
	GtkLabel* _tmp7_;
	GtkLabel* _tmp8_;
	GtkBox* _tmp9_;
	GtkLabel* _tmp10_;
	GtkBox* _tmp11_;
	GtkLabel* _tmp12_;
	GtkBox* _tmp13_;
	GtkLabel* _tmp14_;
	GtkBox* _tmp15_;
	GtkLabel* _tmp16_;
	GtkBox* _tmp17_;
	GtkLabel* _tmp18_;
	GtkLabel* _tmp19_;
	GtkBox* _tmp20_;
	GtkLabel* _tmp21_;
	GtkBox* _tmp22_;
	GtkLabel* _tmp23_;
	GtkBox* _tmp24_;
	GtkLabel* _tmp25_;
	GtkBox* _tmp26_;
	GtkLabel* _tmp27_;
	GtkBox* _tmp28_;
	GtkLabel* _tmp29_;
	GtkBox* _tmp30_;
	GtkLabel* _tmp31_;
	GtkLabel* _tmp32_;
	g_return_val_if_fail (_parent_window != NULL, NULL);
	tee_jee_logging_log_debug ("BackupBox: BackupBox()");
	self = (BackupBox*) g_object_new (object_type, "orientation", GTK_ORIENTATION_VERTICAL, "spacing", 6, NULL);
	_tmp0_ = _g_object_ref0 (_parent_window);
	_g_object_unref0 (self->priv->parent_window);
	self->priv->parent_window = _tmp0_;
	g_object_set ((GtkWidget*) self, "margin", 12, NULL);
	_tmp1_ = tee_jee_gtk_helper_add_label_header ((GtkBox*) self, _ ("Creating Snapshot..."), TRUE);
	_tmp2_ = _tmp1_;
	_g_object_unref0 (_tmp2_);
	backup_box_add_progress_area (self);
	sg_label = NULL;
	sg_value = NULL;
	gtk_orientable_set_orientation ((GtkOrientable*) self, GTK_ORIENTATION_VERTICAL);
	gtk_box_set_spacing ((GtkBox*) self, 6);
	_tmp3_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 6);
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->details_box);
	self->priv->details_box = _tmp3_;
	_tmp4_ = self->priv->details_box;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp4_);
	_tmp5_ = self->priv->details_box;
	_tmp6_ = tee_jee_gtk_helper_add_label (_tmp5_, _ ("File and directory counts:"), TRUE, FALSE, FALSE);
	label = _tmp6_;
	_tmp7_ = label;
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp7_, 6);
	_tmp8_ = label;
	gtk_widget_set_margin_top ((GtkWidget*) _tmp8_, 12);
	_tmp9_ = self->priv->details_box;
	_tmp10_ = backup_box_add_count_label (self, _tmp9_, _ ("No Change"), &sg_label, &sg_value, 0);
	_g_object_unref0 (self->lbl_unchanged);
	self->lbl_unchanged = _tmp10_;
	_tmp11_ = self->priv->details_box;
	_tmp12_ = backup_box_add_count_label (self, _tmp11_, _ ("Created"), &sg_label, &sg_value, 0);
	_g_object_unref0 (self->lbl_created);
	self->lbl_created = _tmp12_;
	_tmp13_ = self->priv->details_box;
	_tmp14_ = backup_box_add_count_label (self, _tmp13_, _ ("Deleted"), &sg_label, &sg_value, 0);
	_g_object_unref0 (self->lbl_deleted);
	self->lbl_deleted = _tmp14_;
	_tmp15_ = self->priv->details_box;
	_tmp16_ = backup_box_add_count_label (self, _tmp15_, _ ("Changed"), &sg_label, &sg_value, 12);
	_g_object_unref0 (self->lbl_modified);
	self->lbl_modified = _tmp16_;
	_tmp17_ = self->priv->details_box;
	_tmp18_ = tee_jee_gtk_helper_add_label (_tmp17_, _ ("Changed items:"), TRUE, FALSE, FALSE);
	_g_object_unref0 (label);
	label = _tmp18_;
	_tmp19_ = label;
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp19_, 6);
	_tmp20_ = self->priv->details_box;
	_tmp21_ = backup_box_add_count_label (self, _tmp20_, _ ("Checksum"), &sg_label, &sg_value, 0);
	_g_object_unref0 (self->lbl_checksum);
	self->lbl_checksum = _tmp21_;
	_tmp22_ = self->priv->details_box;
	_tmp23_ = backup_box_add_count_label (self, _tmp22_, _ ("Size"), &sg_label, &sg_value, 0);
	_g_object_unref0 (self->lbl_size);
	self->lbl_size = _tmp23_;
	_tmp24_ = self->priv->details_box;
	_tmp25_ = backup_box_add_count_label (self, _tmp24_, _ ("Timestamp"), &sg_label, &sg_value, 0);
	_g_object_unref0 (self->lbl_timestamp);
	self->lbl_timestamp = _tmp25_;
	_tmp26_ = self->priv->details_box;
	_tmp27_ = backup_box_add_count_label (self, _tmp26_, _ ("Permissions"), &sg_label, &sg_value, 0);
	_g_object_unref0 (self->lbl_permissions);
	self->lbl_permissions = _tmp27_;
	_tmp28_ = self->priv->details_box;
	_tmp29_ = backup_box_add_count_label (self, _tmp28_, _ ("Owner"), &sg_label, &sg_value, 0);
	_g_object_unref0 (self->lbl_owner);
	self->lbl_owner = _tmp29_;
	_tmp30_ = self->priv->details_box;
	_tmp31_ = backup_box_add_count_label (self, _tmp30_, _ ("Group"), &sg_label, &sg_value, 24);
	_g_object_unref0 (self->lbl_group);
	self->lbl_group = _tmp31_;
	_tmp32_ = self->lbl_deleted;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp32_, FALSE);
	tee_jee_logging_log_debug ("BackupBox: BackupBox(): exit");
	_g_object_unref0 (label);
	_g_object_unref0 (sg_value);
	_g_object_unref0 (sg_label);
	return self;
}

BackupBox*
backup_box_new (GtkWindow* _parent_window)
{
	return backup_box_construct (TYPE_BACKUP_BOX, _parent_window);
}

static void
backup_box_add_progress_area (BackupBox* self)
{
	GtkBox* hbox_status = NULL;
	GtkBox* _tmp0_;
	GtkSpinner* _tmp1_;
	GtkSpinner* _tmp2_;
	GtkSpinner* _tmp3_;
	GtkLabel* _tmp4_;
	GtkLabel* _tmp5_;
	GtkLabel* _tmp6_;
	GtkLabel* _tmp7_;
	GtkLabel* _tmp8_;
	GtkProgressBar* _tmp9_;
	GtkProgressBar* _tmp10_;
	GtkLabel* _tmp11_;
	GtkLabel* _tmp12_;
	GtkLabel* _tmp13_;
	GtkLabel* _tmp14_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	g_object_ref_sink (_tmp0_);
	hbox_status = _tmp0_;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) hbox_status);
	_tmp1_ = (GtkSpinner*) gtk_spinner_new ();
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->spinner);
	self->priv->spinner = _tmp1_;
	_tmp2_ = self->priv->spinner;
	g_object_set (_tmp2_, "active", TRUE, NULL);
	_tmp3_ = self->priv->spinner;
	gtk_container_add ((GtkContainer*) hbox_status, (GtkWidget*) _tmp3_);
	_tmp4_ = tee_jee_gtk_helper_add_label (hbox_status, _ ("Preparing..."), FALSE, FALSE, FALSE);
	_g_object_unref0 (self->lbl_msg);
	self->lbl_msg = _tmp4_;
	_tmp5_ = self->lbl_msg;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp5_, TRUE);
	_tmp6_ = self->lbl_msg;
	gtk_label_set_ellipsize (_tmp6_, PANGO_ELLIPSIZE_END);
	_tmp7_ = self->lbl_msg;
	gtk_label_set_max_width_chars (_tmp7_, 50);
	_tmp8_ = tee_jee_gtk_helper_add_label (hbox_status, "", FALSE, FALSE, FALSE);
	_g_object_unref0 (self->lbl_remaining);
	self->lbl_remaining = _tmp8_;
	_tmp9_ = (GtkProgressBar*) gtk_progress_bar_new ();
	g_object_ref_sink (_tmp9_);
	_g_object_unref0 (self->progressbar);
	self->progressbar = _tmp9_;
	_tmp10_ = self->progressbar;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp10_);
	_tmp11_ = tee_jee_gtk_helper_add_label ((GtkBox*) self, "", FALSE, FALSE, FALSE);
	_g_object_unref0 (self->lbl_status);
	self->lbl_status = _tmp11_;
	_tmp12_ = self->lbl_status;
	gtk_label_set_ellipsize (_tmp12_, PANGO_ELLIPSIZE_MIDDLE);
	_tmp13_ = self->lbl_status;
	gtk_label_set_max_width_chars (_tmp13_, 45);
	_tmp14_ = self->lbl_status;
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp14_, 6);
	_g_object_unref0 (hbox_status);
}

void
backup_box_pause (BackupBox* self)
{
	GtkSpinner* _tmp0_;
	GtkLabel* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->spinner;
	g_object_set (_tmp0_, "active", FALSE, NULL);
	_tmp1_ = self->lbl_msg;
	gtk_label_set_label (_tmp1_, _ ("Paused"));
}

void
backup_box_resume (BackupBox* self)
{
	GtkSpinner* _tmp0_;
	GtkLabel* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->spinner;
	g_object_set (_tmp0_, "active", TRUE, NULL);
	_tmp1_ = self->lbl_msg;
	gtk_label_set_label (_tmp1_, "");
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		BackupBox* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->text_label);
		_g_object_unref0 (_data2_->label);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static void
__lambda93_ (Block2Data* _data2_)
{
	BackupBox* self;
	GtkLabel* _tmp0_;
	GtkLabel* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	self = _data2_->self;
	_tmp0_ = _data2_->text_label;
	_tmp1_ = _data2_->label;
	_tmp2_ = gtk_widget_get_sensitive ((GtkWidget*) _tmp1_);
	_tmp3_ = _tmp2_;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, _tmp3_);
}

static void
___lambda93__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda93_ (self);
}

static GtkLabel*
backup_box_add_count_label (BackupBox* self,
                            GtkBox* box,
                            const gchar* text,
                            GtkSizeGroup** sg_label,
                            GtkSizeGroup** sg_value,
                            gint add_margin_bottom)
{
	Block2Data* _data2_;
	GtkBox* hbox = NULL;
	GtkBox* _tmp0_;
	GtkBox* _tmp1_;
	GtkBox* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GtkLabel* _tmp5_;
	GtkLabel* _tmp6_;
	GtkLabel* _tmp7_;
	GtkLabel* _tmp8_;
	GtkLabel* _tmp9_;
	GtkLabel* _tmp10_;
	GtkLabel* _tmp11_;
	GtkLabel* _tmp14_;
	GtkBox* _tmp15_;
	GtkLabel* _tmp16_;
	GtkLabel* _tmp17_;
	GtkLabel* _tmp20_;
	GtkLabel* _tmp21_;
	GtkLabel* _tmp22_;
	GtkLabel* _tmp23_;
	GtkLabel* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (box != NULL, NULL);
	g_return_val_if_fail (text != NULL, NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	g_object_ref_sink (_tmp0_);
	hbox = _tmp0_;
	_tmp1_ = hbox;
	gtk_container_add ((GtkContainer*) box, (GtkWidget*) _tmp1_);
	_tmp2_ = hbox;
	_tmp3_ = g_strconcat (text, ":", NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = tee_jee_gtk_helper_add_label (_tmp2_, _tmp4_, FALSE, FALSE, FALSE);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	_data2_->label = _tmp6_;
	_tmp7_ = _data2_->label;
	gtk_label_set_xalign (_tmp7_, (gfloat) 1.0);
	_tmp8_ = _data2_->label;
	gtk_widget_set_margin_start ((GtkWidget*) _tmp8_, 12);
	_tmp9_ = _data2_->label;
	gtk_widget_set_margin_end ((GtkWidget*) _tmp9_, 6);
	_tmp10_ = _data2_->label;
	_tmp11_ = _g_object_ref0 (_tmp10_);
	_data2_->text_label = _tmp11_;
	if (add_margin_bottom > 0) {
		GtkLabel* _tmp12_;
		_tmp12_ = _data2_->label;
		gtk_widget_set_margin_bottom ((GtkWidget*) _tmp12_, add_margin_bottom);
	}
	if ((*sg_label) == NULL) {
		GtkSizeGroup* _tmp13_;
		_tmp13_ = gtk_size_group_new (GTK_SIZE_GROUP_HORIZONTAL);
		_g_object_unref0 (*sg_label);
		*sg_label = _tmp13_;
	}
	_tmp14_ = _data2_->label;
	gtk_size_group_add_widget (*sg_label, (GtkWidget*) _tmp14_);
	_tmp15_ = hbox;
	_tmp16_ = tee_jee_gtk_helper_add_label (_tmp15_, "", FALSE, FALSE, FALSE);
	_g_object_unref0 (_data2_->label);
	_data2_->label = _tmp16_;
	_tmp17_ = _data2_->label;
	gtk_label_set_xalign (_tmp17_, (gfloat) 0.0);
	if (add_margin_bottom > 0) {
		GtkLabel* _tmp18_;
		_tmp18_ = _data2_->label;
		gtk_widget_set_margin_bottom ((GtkWidget*) _tmp18_, add_margin_bottom);
	}
	if ((*sg_value) == NULL) {
		GtkSizeGroup* _tmp19_;
		_tmp19_ = gtk_size_group_new (GTK_SIZE_GROUP_HORIZONTAL);
		_g_object_unref0 (*sg_value);
		*sg_value = _tmp19_;
	}
	_tmp20_ = _data2_->label;
	gtk_size_group_add_widget (*sg_value, (GtkWidget*) _tmp20_);
	_tmp21_ = _data2_->label;
	g_signal_connect_data ((GObject*) _tmp21_, "notify::sensitive", (GCallback) ___lambda93__g_object_notify, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	_tmp22_ = _data2_->label;
	_tmp23_ = _g_object_ref0 (_tmp22_);
	result = _tmp23_;
	_g_object_unref0 (hbox);
	block2_data_unref (_data2_);
	_data2_ = NULL;
	return result;
}

static void
___lambda94_ (BackupBox* self)
{
	backup_box_take_snapshot_thread (self);
}

static gpointer
____lambda94__gthread_func (gpointer self)
{
	gpointer result;
	___lambda94_ ((BackupBox*) self);
	result = NULL;
	g_object_unref (self);
	return result;
}

gboolean
backup_box_take_snapshot (BackupBox* self)
{
	Main* _tmp5_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		GThread* _tmp0_;
		GThread* _tmp1_;
		self->priv->thread_is_running = TRUE;
		_tmp0_ = g_thread_try_new ("snapshot-taker", ____lambda94__gthread_func, g_object_ref (self), &_inner_error0_);
		_tmp1_ = _tmp0_;
		_g_thread_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		tee_jee_logging_log_error (_tmp3_, FALSE, FALSE);
		result = FALSE;
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp4_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp4_;
	}
	_tmp5_ = App;
	if (_tmp5_->btrfs_mode) {
		GtkWindow* _tmp7_;
		while (TRUE) {
			GtkWindow* _tmp6_;
			if (!self->priv->thread_is_running) {
				break;
			}
			tee_jee_gtk_helper_gtk_do_events ();
			tee_jee_system_sleep (200);
			_tmp6_ = self->priv->parent_window;
			xapp_set_window_progress_pulse (_tmp6_, TRUE);
		}
		_tmp7_ = self->priv->parent_window;
		xapp_set_window_progress_pulse (_tmp7_, FALSE);
	} else {
		gint wait_interval_millis = 0;
		gint status_line_counter = 0;
		gint status_line_counter_default = 0;
		gchar* status_line = NULL;
		gchar* _tmp8_;
		gchar* last_status_line = NULL;
		gchar* _tmp9_;
		gint remaining_counter = 0;
		GtkWindow* _tmp110_;
		wait_interval_millis = 100;
		status_line_counter = 0;
		status_line_counter_default = 1000 / wait_interval_millis;
		_tmp8_ = g_strdup ("");
		status_line = _tmp8_;
		_tmp9_ = g_strdup ("");
		last_status_line = _tmp9_;
		remaining_counter = 10;
		while (TRUE) {
			gchar* task_status_line = NULL;
			gdouble fraction = 0.0;
			gchar* task_stat_time_remaining = NULL;
			gboolean checking = FALSE;
			Main* _tmp10_;
			RsyncSpaceCheckTask* _tmp11_;
			GtkBox* _tmp12_;
			const gchar* _tmp33_;
			gchar* _tmp34_;
			const gchar* _tmp35_;
			const gchar* _tmp36_;
			gint _tmp43_;
			Main* _tmp52_;
			RsyncTask* _tmp53_;
			if (!self->priv->thread_is_running) {
				break;
			}
			_tmp10_ = App;
			_tmp11_ = _tmp10_->space_check_task;
			checking = _tmp11_ != NULL;
			_tmp12_ = self->priv->details_box;
			gtk_widget_set_visible ((GtkWidget*) _tmp12_, !checking);
			if (checking) {
				Main* _tmp13_;
				RsyncSpaceCheckTask* _tmp14_;
				gchar* _tmp15_;
				gchar* _tmp16_;
				Main* _tmp17_;
				RsyncSpaceCheckTask* _tmp18_;
				Main* _tmp19_;
				RsyncSpaceCheckTask* _tmp20_;
				gchar* _tmp21_;
				gchar* _tmp22_;
				_tmp13_ = App;
				_tmp14_ = _tmp13_->space_check_task;
				_tmp15_ = async_task_get_status_line ((AsyncTask*) _tmp14_);
				_tmp16_ = _tmp15_;
				_g_free0 (task_status_line);
				task_status_line = _tmp16_;
				_tmp17_ = App;
				_tmp18_ = _tmp17_->space_check_task;
				fraction = ((AsyncTask*) _tmp18_)->progress;
				_tmp19_ = App;
				_tmp20_ = _tmp19_->space_check_task;
				_tmp21_ = async_task_get_stat_time_remaining ((AsyncTask*) _tmp20_);
				_tmp22_ = _tmp21_;
				_g_free0 (task_stat_time_remaining);
				task_stat_time_remaining = _tmp22_;
			} else {
				Main* _tmp23_;
				RsyncTask* _tmp24_;
				gchar* _tmp25_;
				gchar* _tmp26_;
				Main* _tmp27_;
				RsyncTask* _tmp28_;
				Main* _tmp29_;
				RsyncTask* _tmp30_;
				gchar* _tmp31_;
				gchar* _tmp32_;
				_tmp23_ = App;
				_tmp24_ = _tmp23_->task;
				_tmp25_ = async_task_get_status_line ((AsyncTask*) _tmp24_);
				_tmp26_ = _tmp25_;
				_g_free0 (task_status_line);
				task_status_line = _tmp26_;
				_tmp27_ = App;
				_tmp28_ = _tmp27_->task;
				fraction = ((AsyncTask*) _tmp28_)->progress;
				_tmp29_ = App;
				_tmp30_ = _tmp29_->task;
				_tmp31_ = async_task_get_stat_time_remaining ((AsyncTask*) _tmp30_);
				_tmp32_ = _tmp31_;
				_g_free0 (task_stat_time_remaining);
				task_stat_time_remaining = _tmp32_;
			}
			_tmp33_ = task_status_line;
			_tmp34_ = tee_jee_misc_escape_html (_tmp33_);
			_g_free0 (status_line);
			status_line = _tmp34_;
			_tmp35_ = status_line;
			_tmp36_ = last_status_line;
			if (g_strcmp0 (_tmp35_, _tmp36_) != 0) {
				GtkLabel* _tmp37_;
				const gchar* _tmp38_;
				const gchar* _tmp39_;
				gchar* _tmp40_;
				_tmp37_ = self->lbl_status;
				_tmp38_ = status_line;
				gtk_label_set_label (_tmp37_, _tmp38_);
				_tmp39_ = status_line;
				_tmp40_ = g_strdup (_tmp39_);
				_g_free0 (last_status_line);
				last_status_line = _tmp40_;
				status_line_counter = status_line_counter_default;
			} else {
				gint _tmp41_;
				_tmp41_ = status_line_counter;
				status_line_counter = _tmp41_ - 1;
				if (status_line_counter < 0) {
					GtkLabel* _tmp42_;
					status_line_counter = status_line_counter_default;
					_tmp42_ = self->lbl_status;
					gtk_label_set_label (_tmp42_, "");
				}
			}
			_tmp43_ = remaining_counter;
			remaining_counter = _tmp43_ - 1;
			if (remaining_counter == 0) {
				GtkLabel* _tmp44_;
				const gchar* _tmp45_;
				gchar* _tmp46_;
				gchar* _tmp47_;
				gchar* _tmp48_;
				gchar* _tmp49_;
				_tmp44_ = self->lbl_remaining;
				_tmp45_ = task_stat_time_remaining;
				_tmp46_ = g_strconcat (_tmp45_, " ", NULL);
				_tmp47_ = _tmp46_;
				_tmp48_ = g_strconcat (_tmp47_, _ ("remaining"), NULL);
				_tmp49_ = _tmp48_;
				gtk_label_set_label (_tmp44_, _tmp49_);
				_g_free0 (_tmp49_);
				_g_free0 (_tmp47_);
				remaining_counter = 10;
			}
			if (fraction < 0.99) {
				GtkProgressBar* _tmp50_;
				GtkWindow* _tmp51_;
				_tmp50_ = self->progressbar;
				gtk_progress_bar_set_fraction (_tmp50_, fraction);
				_tmp51_ = self->priv->parent_window;
				xapp_set_window_progress (_tmp51_, (gint) (fraction * 100.0));
			}
			_tmp52_ = App;
			_tmp53_ = _tmp52_->task;
			if (((AsyncTask*) _tmp53_)->status == APP_STATUS_PAUSED) {
				GtkLabel* _tmp54_;
				_tmp54_ = self->lbl_msg;
				gtk_label_set_label (_tmp54_, _ ("Paused"));
			} else {
				GtkLabel* _tmp55_;
				Main* _tmp56_;
				const gchar* _tmp57_;
				gchar* _tmp58_;
				gchar* _tmp59_;
				_tmp55_ = self->lbl_msg;
				_tmp56_ = App;
				_tmp57_ = _tmp56_->progress_text;
				_tmp58_ = tee_jee_misc_escape_html (_tmp57_);
				_tmp59_ = _tmp58_;
				gtk_label_set_label (_tmp55_, _tmp59_);
				_g_free0 (_tmp59_);
			}
			if (!checking) {
				GtkLabel* _tmp60_;
				Main* _tmp61_;
				RsyncTask* _tmp62_;
				gchar* _tmp63_;
				gchar* _tmp64_;
				GtkLabel* _tmp65_;
				Main* _tmp66_;
				RsyncTask* _tmp67_;
				gchar* _tmp68_;
				gchar* _tmp69_;
				GtkLabel* _tmp70_;
				Main* _tmp71_;
				RsyncTask* _tmp72_;
				gchar* _tmp73_;
				gchar* _tmp74_;
				GtkLabel* _tmp75_;
				Main* _tmp76_;
				RsyncTask* _tmp77_;
				gchar* _tmp78_;
				gchar* _tmp79_;
				GtkLabel* _tmp80_;
				Main* _tmp81_;
				RsyncTask* _tmp82_;
				gchar* _tmp83_;
				gchar* _tmp84_;
				GtkLabel* _tmp85_;
				Main* _tmp86_;
				RsyncTask* _tmp87_;
				gchar* _tmp88_;
				gchar* _tmp89_;
				GtkLabel* _tmp90_;
				Main* _tmp91_;
				RsyncTask* _tmp92_;
				gchar* _tmp93_;
				gchar* _tmp94_;
				GtkLabel* _tmp95_;
				Main* _tmp96_;
				RsyncTask* _tmp97_;
				gchar* _tmp98_;
				gchar* _tmp99_;
				GtkLabel* _tmp100_;
				Main* _tmp101_;
				RsyncTask* _tmp102_;
				gchar* _tmp103_;
				gchar* _tmp104_;
				GtkLabel* _tmp105_;
				Main* _tmp106_;
				RsyncTask* _tmp107_;
				gchar* _tmp108_;
				gchar* _tmp109_;
				_tmp60_ = self->lbl_unchanged;
				_tmp61_ = App;
				_tmp62_ = _tmp61_->task;
				_tmp63_ = g_strdup_printf ("%'d", _tmp62_->count_unchanged);
				_tmp64_ = _tmp63_;
				gtk_label_set_label (_tmp60_, _tmp64_);
				_g_free0 (_tmp64_);
				_tmp65_ = self->lbl_created;
				_tmp66_ = App;
				_tmp67_ = _tmp66_->task;
				_tmp68_ = g_strdup_printf ("%'d", _tmp67_->count_created);
				_tmp69_ = _tmp68_;
				gtk_label_set_label (_tmp65_, _tmp69_);
				_g_free0 (_tmp69_);
				_tmp70_ = self->lbl_deleted;
				_tmp71_ = App;
				_tmp72_ = _tmp71_->task;
				_tmp73_ = g_strdup_printf ("%'d", _tmp72_->count_deleted);
				_tmp74_ = _tmp73_;
				gtk_label_set_label (_tmp70_, _tmp74_);
				_g_free0 (_tmp74_);
				_tmp75_ = self->lbl_modified;
				_tmp76_ = App;
				_tmp77_ = _tmp76_->task;
				_tmp78_ = g_strdup_printf ("%'d", _tmp77_->count_modified);
				_tmp79_ = _tmp78_;
				gtk_label_set_label (_tmp75_, _tmp79_);
				_g_free0 (_tmp79_);
				_tmp80_ = self->lbl_checksum;
				_tmp81_ = App;
				_tmp82_ = _tmp81_->task;
				_tmp83_ = g_strdup_printf ("%'d", _tmp82_->count_checksum);
				_tmp84_ = _tmp83_;
				gtk_label_set_label (_tmp80_, _tmp84_);
				_g_free0 (_tmp84_);
				_tmp85_ = self->lbl_size;
				_tmp86_ = App;
				_tmp87_ = _tmp86_->task;
				_tmp88_ = g_strdup_printf ("%'d", _tmp87_->count_size);
				_tmp89_ = _tmp88_;
				gtk_label_set_label (_tmp85_, _tmp89_);
				_g_free0 (_tmp89_);
				_tmp90_ = self->lbl_timestamp;
				_tmp91_ = App;
				_tmp92_ = _tmp91_->task;
				_tmp93_ = g_strdup_printf ("%'d", _tmp92_->count_timestamp);
				_tmp94_ = _tmp93_;
				gtk_label_set_label (_tmp90_, _tmp94_);
				_g_free0 (_tmp94_);
				_tmp95_ = self->lbl_permissions;
				_tmp96_ = App;
				_tmp97_ = _tmp96_->task;
				_tmp98_ = g_strdup_printf ("%'d", _tmp97_->count_permissions);
				_tmp99_ = _tmp98_;
				gtk_label_set_label (_tmp95_, _tmp99_);
				_g_free0 (_tmp99_);
				_tmp100_ = self->lbl_owner;
				_tmp101_ = App;
				_tmp102_ = _tmp101_->task;
				_tmp103_ = g_strdup_printf ("%'d", _tmp102_->count_owner);
				_tmp104_ = _tmp103_;
				gtk_label_set_label (_tmp100_, _tmp104_);
				_g_free0 (_tmp104_);
				_tmp105_ = self->lbl_group;
				_tmp106_ = App;
				_tmp107_ = _tmp106_->task;
				_tmp108_ = g_strdup_printf ("%'d", _tmp107_->count_group);
				_tmp109_ = _tmp108_;
				gtk_label_set_label (_tmp105_, _tmp109_);
				_g_free0 (_tmp109_);
			}
			tee_jee_gtk_helper_gtk_do_events ();
			tee_jee_system_sleep (100);
			_g_free0 (task_stat_time_remaining);
			_g_free0 (task_status_line);
		}
		_tmp110_ = self->priv->parent_window;
		xapp_set_window_progress (_tmp110_, 0);
		_g_free0 (last_status_line);
		_g_free0 (status_line);
	}
	result = self->priv->thread_status_success;
	return result;
}

static void
backup_box_take_snapshot_thread (BackupBox* self)
{
	Main* _tmp0_;
	GtkWindow* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = App;
	_tmp1_ = self->priv->parent_window;
	self->priv->thread_status_success = main_create_snapshot (_tmp0_, TRUE, _tmp1_);
	self->priv->thread_is_running = FALSE;
}

static void
backup_box_class_init (BackupBoxClass * klass,
                       gpointer klass_data)
{
	backup_box_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BackupBox_private_offset);
	G_OBJECT_CLASS (klass)->finalize = backup_box_finalize;
}

static void
backup_box_instance_init (BackupBox * self,
                          gpointer klass)
{
	self->priv = backup_box_get_instance_private (self);
	self->priv->thread_is_running = FALSE;
	self->priv->thread_status_success = FALSE;
}

static void
backup_box_finalize (GObject * obj)
{
	BackupBox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BACKUP_BOX, BackupBox);
	_g_object_unref0 (self->priv->details_box);
	_g_object_unref0 (self->priv->spinner);
	_g_object_unref0 (self->lbl_msg);
	_g_object_unref0 (self->lbl_status);
	_g_object_unref0 (self->lbl_remaining);
	_g_object_unref0 (self->progressbar);
	_g_object_unref0 (self->lbl_unchanged);
	_g_object_unref0 (self->lbl_created);
	_g_object_unref0 (self->lbl_deleted);
	_g_object_unref0 (self->lbl_modified);
	_g_object_unref0 (self->lbl_checksum);
	_g_object_unref0 (self->lbl_size);
	_g_object_unref0 (self->lbl_timestamp);
	_g_object_unref0 (self->lbl_permissions);
	_g_object_unref0 (self->lbl_owner);
	_g_object_unref0 (self->lbl_group);
	_g_object_unref0 (self->priv->parent_window);
	G_OBJECT_CLASS (backup_box_parent_class)->finalize (obj);
}

static GType
backup_box_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BackupBoxClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) backup_box_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BackupBox), 0, (GInstanceInitFunc) backup_box_instance_init, NULL };
	GType backup_box_type_id;
	backup_box_type_id = g_type_register_static (gtk_box_get_type (), "BackupBox", &g_define_type_info, 0);
	BackupBox_private_offset = g_type_add_instance_private (backup_box_type_id, sizeof (BackupBoxPrivate));
	return backup_box_type_id;
}

GType
backup_box_get_type (void)
{
	static volatile gsize backup_box_type_id__once = 0;
	if (g_once_init_enter (&backup_box_type_id__once)) {
		GType backup_box_type_id;
		backup_box_type_id = backup_box_get_type_once ();
		g_once_init_leave (&backup_box_type_id__once, backup_box_type_id);
	}
	return backup_box_type_id__once;
}

